/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ioteventsdata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The new state, variable values, and timer settings of the detector (instance).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectorStateDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<DetectorStateDefinition.Builder, DetectorStateDefinition> {
    private static final SdkField<String> STATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stateName").getter(getter(DetectorStateDefinition::stateName)).setter(setter(Builder::stateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateName").build()).build();

    private static final SdkField<List<VariableDefinition>> VARIABLES_FIELD = SdkField
            .<List<VariableDefinition>> builder(MarshallingType.LIST)
            .memberName("variables")
            .getter(getter(DetectorStateDefinition::variables))
            .setter(setter(Builder::variables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variables").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VariableDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(VariableDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<TimerDefinition>> TIMERS_FIELD = SdkField
            .<List<TimerDefinition>> builder(MarshallingType.LIST)
            .memberName("timers")
            .getter(getter(DetectorStateDefinition::timers))
            .setter(setter(Builder::timers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TimerDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(TimerDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_NAME_FIELD,
            VARIABLES_FIELD, TIMERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String stateName;

    private final List<VariableDefinition> variables;

    private final List<TimerDefinition> timers;

    private DetectorStateDefinition(BuilderImpl builder) {
        this.stateName = builder.stateName;
        this.variables = builder.variables;
        this.timers = builder.timers;
    }

    /**
     * <p>
     * The name of the new state of the detector (instance).
     * </p>
     * 
     * @return The name of the new state of the detector (instance).
     */
    public final String stateName() {
        return stateName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Variables property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasVariables() {
        return variables != null && !(variables instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The new values of the detector's variables. Any variable whose value isn't specified is cleared.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVariables} method.
     * </p>
     * 
     * @return The new values of the detector's variables. Any variable whose value isn't specified is cleared.
     */
    public final List<VariableDefinition> variables() {
        return variables;
    }

    /**
     * For responses, this returns true if the service returned a value for the Timers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTimers() {
        return timers != null && !(timers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The new values of the detector's timers. Any timer whose value isn't specified is cleared, and its timeout event
     * won't occur.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTimers} method.
     * </p>
     * 
     * @return The new values of the detector's timers. Any timer whose value isn't specified is cleared, and its
     *         timeout event won't occur.
     */
    public final List<TimerDefinition> timers() {
        return timers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stateName());
        hashCode = 31 * hashCode + Objects.hashCode(hasVariables() ? variables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTimers() ? timers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectorStateDefinition)) {
            return false;
        }
        DetectorStateDefinition other = (DetectorStateDefinition) obj;
        return Objects.equals(stateName(), other.stateName()) && hasVariables() == other.hasVariables()
                && Objects.equals(variables(), other.variables()) && hasTimers() == other.hasTimers()
                && Objects.equals(timers(), other.timers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DetectorStateDefinition").add("StateName", stateName())
                .add("Variables", hasVariables() ? variables() : null).add("Timers", hasTimers() ? timers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stateName":
            return Optional.ofNullable(clazz.cast(stateName()));
        case "variables":
            return Optional.ofNullable(clazz.cast(variables()));
        case "timers":
            return Optional.ofNullable(clazz.cast(timers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("stateName", STATE_NAME_FIELD);
        map.put("variables", VARIABLES_FIELD);
        map.put("timers", TIMERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DetectorStateDefinition, T> g) {
        return obj -> g.apply((DetectorStateDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DetectorStateDefinition> {
        /**
         * <p>
         * The name of the new state of the detector (instance).
         * </p>
         * 
         * @param stateName
         *        The name of the new state of the detector (instance).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateName(String stateName);

        /**
         * <p>
         * The new values of the detector's variables. Any variable whose value isn't specified is cleared.
         * </p>
         * 
         * @param variables
         *        The new values of the detector's variables. Any variable whose value isn't specified is cleared.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variables(Collection<VariableDefinition> variables);

        /**
         * <p>
         * The new values of the detector's variables. Any variable whose value isn't specified is cleared.
         * </p>
         * 
         * @param variables
         *        The new values of the detector's variables. Any variable whose value isn't specified is cleared.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variables(VariableDefinition... variables);

        /**
         * <p>
         * The new values of the detector's variables. Any variable whose value isn't specified is cleared.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ioteventsdata.model.VariableDefinition.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.ioteventsdata.model.VariableDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ioteventsdata.model.VariableDefinition.Builder#build()} is called
         * immediately and its result is passed to {@link #variables(List<VariableDefinition>)}.
         * 
         * @param variables
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ioteventsdata.model.VariableDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #variables(java.util.Collection<VariableDefinition>)
         */
        Builder variables(Consumer<VariableDefinition.Builder>... variables);

        /**
         * <p>
         * The new values of the detector's timers. Any timer whose value isn't specified is cleared, and its timeout
         * event won't occur.
         * </p>
         * 
         * @param timers
         *        The new values of the detector's timers. Any timer whose value isn't specified is cleared, and its
         *        timeout event won't occur.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timers(Collection<TimerDefinition> timers);

        /**
         * <p>
         * The new values of the detector's timers. Any timer whose value isn't specified is cleared, and its timeout
         * event won't occur.
         * </p>
         * 
         * @param timers
         *        The new values of the detector's timers. Any timer whose value isn't specified is cleared, and its
         *        timeout event won't occur.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timers(TimerDefinition... timers);

        /**
         * <p>
         * The new values of the detector's timers. Any timer whose value isn't specified is cleared, and its timeout
         * event won't occur.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ioteventsdata.model.TimerDefinition.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.ioteventsdata.model.TimerDefinition#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ioteventsdata.model.TimerDefinition.Builder#build()} is called
         * immediately and its result is passed to {@link #timers(List<TimerDefinition>)}.
         * 
         * @param timers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ioteventsdata.model.TimerDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timers(java.util.Collection<TimerDefinition>)
         */
        Builder timers(Consumer<TimerDefinition.Builder>... timers);
    }

    static final class BuilderImpl implements Builder {
        private String stateName;

        private List<VariableDefinition> variables = DefaultSdkAutoConstructList.getInstance();

        private List<TimerDefinition> timers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DetectorStateDefinition model) {
            stateName(model.stateName);
            variables(model.variables);
            timers(model.timers);
        }

        public final String getStateName() {
            return stateName;
        }

        public final void setStateName(String stateName) {
            this.stateName = stateName;
        }

        @Override
        public final Builder stateName(String stateName) {
            this.stateName = stateName;
            return this;
        }

        public final List<VariableDefinition.Builder> getVariables() {
            List<VariableDefinition.Builder> result = VariableDefinitionsCopier.copyToBuilder(this.variables);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVariables(Collection<VariableDefinition.BuilderImpl> variables) {
            this.variables = VariableDefinitionsCopier.copyFromBuilder(variables);
        }

        @Override
        public final Builder variables(Collection<VariableDefinition> variables) {
            this.variables = VariableDefinitionsCopier.copy(variables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variables(VariableDefinition... variables) {
            variables(Arrays.asList(variables));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variables(Consumer<VariableDefinition.Builder>... variables) {
            variables(Stream.of(variables).map(c -> VariableDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<TimerDefinition.Builder> getTimers() {
            List<TimerDefinition.Builder> result = TimerDefinitionsCopier.copyToBuilder(this.timers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTimers(Collection<TimerDefinition.BuilderImpl> timers) {
            this.timers = TimerDefinitionsCopier.copyFromBuilder(timers);
        }

        @Override
        public final Builder timers(Collection<TimerDefinition> timers) {
            this.timers = TimerDefinitionsCopier.copy(timers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timers(TimerDefinition... timers) {
            timers(Arrays.asList(timers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timers(Consumer<TimerDefinition.Builder>... timers) {
            timers(Stream.of(timers).map(c -> TimerDefinition.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DetectorStateDefinition build() {
            return new DetectorStateDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
