/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ioteventsdata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information needed to compare two values with a comparison operator.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SimpleRuleEvaluation implements SdkPojo, Serializable,
        ToCopyableBuilder<SimpleRuleEvaluation.Builder, SimpleRuleEvaluation> {
    private static final SdkField<String> INPUT_PROPERTY_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inputPropertyValue").getter(getter(SimpleRuleEvaluation::inputPropertyValue))
            .setter(setter(Builder::inputPropertyValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputPropertyValue").build())
            .build();

    private static final SdkField<String> OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("operator").getter(getter(SimpleRuleEvaluation::operatorAsString)).setter(setter(Builder::operator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operator").build()).build();

    private static final SdkField<String> THRESHOLD_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thresholdValue").getter(getter(SimpleRuleEvaluation::thresholdValue))
            .setter(setter(Builder::thresholdValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thresholdValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_PROPERTY_VALUE_FIELD,
            OPERATOR_FIELD, THRESHOLD_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String inputPropertyValue;

    private final String operator;

    private final String thresholdValue;

    private SimpleRuleEvaluation(BuilderImpl builder) {
        this.inputPropertyValue = builder.inputPropertyValue;
        this.operator = builder.operator;
        this.thresholdValue = builder.thresholdValue;
    }

    /**
     * <p>
     * The value of the input property, on the left side of the comparison operator.
     * </p>
     * 
     * @return The value of the input property, on the left side of the comparison operator.
     */
    public final String inputPropertyValue() {
        return inputPropertyValue;
    }

    /**
     * <p>
     * The comparison operator.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link ComparisonOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operatorAsString}.
     * </p>
     * 
     * @return The comparison operator.
     * @see ComparisonOperator
     */
    public final ComparisonOperator operator() {
        return ComparisonOperator.fromValue(operator);
    }

    /**
     * <p>
     * The comparison operator.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link ComparisonOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operatorAsString}.
     * </p>
     * 
     * @return The comparison operator.
     * @see ComparisonOperator
     */
    public final String operatorAsString() {
        return operator;
    }

    /**
     * <p>
     * The threshold value, on the right side of the comparison operator.
     * </p>
     * 
     * @return The threshold value, on the right side of the comparison operator.
     */
    public final String thresholdValue() {
        return thresholdValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputPropertyValue());
        hashCode = 31 * hashCode + Objects.hashCode(operatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(thresholdValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimpleRuleEvaluation)) {
            return false;
        }
        SimpleRuleEvaluation other = (SimpleRuleEvaluation) obj;
        return Objects.equals(inputPropertyValue(), other.inputPropertyValue())
                && Objects.equals(operatorAsString(), other.operatorAsString())
                && Objects.equals(thresholdValue(), other.thresholdValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SimpleRuleEvaluation").add("InputPropertyValue", inputPropertyValue())
                .add("Operator", operatorAsString()).add("ThresholdValue", thresholdValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "inputPropertyValue":
            return Optional.ofNullable(clazz.cast(inputPropertyValue()));
        case "operator":
            return Optional.ofNullable(clazz.cast(operatorAsString()));
        case "thresholdValue":
            return Optional.ofNullable(clazz.cast(thresholdValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("inputPropertyValue", INPUT_PROPERTY_VALUE_FIELD);
        map.put("operator", OPERATOR_FIELD);
        map.put("thresholdValue", THRESHOLD_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SimpleRuleEvaluation, T> g) {
        return obj -> g.apply((SimpleRuleEvaluation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SimpleRuleEvaluation> {
        /**
         * <p>
         * The value of the input property, on the left side of the comparison operator.
         * </p>
         * 
         * @param inputPropertyValue
         *        The value of the input property, on the left side of the comparison operator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputPropertyValue(String inputPropertyValue);

        /**
         * <p>
         * The comparison operator.
         * </p>
         * 
         * @param operator
         *        The comparison operator.
         * @see ComparisonOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComparisonOperator
         */
        Builder operator(String operator);

        /**
         * <p>
         * The comparison operator.
         * </p>
         * 
         * @param operator
         *        The comparison operator.
         * @see ComparisonOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComparisonOperator
         */
        Builder operator(ComparisonOperator operator);

        /**
         * <p>
         * The threshold value, on the right side of the comparison operator.
         * </p>
         * 
         * @param thresholdValue
         *        The threshold value, on the right side of the comparison operator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thresholdValue(String thresholdValue);
    }

    static final class BuilderImpl implements Builder {
        private String inputPropertyValue;

        private String operator;

        private String thresholdValue;

        private BuilderImpl() {
        }

        private BuilderImpl(SimpleRuleEvaluation model) {
            inputPropertyValue(model.inputPropertyValue);
            operator(model.operator);
            thresholdValue(model.thresholdValue);
        }

        public final String getInputPropertyValue() {
            return inputPropertyValue;
        }

        public final void setInputPropertyValue(String inputPropertyValue) {
            this.inputPropertyValue = inputPropertyValue;
        }

        @Override
        public final Builder inputPropertyValue(String inputPropertyValue) {
            this.inputPropertyValue = inputPropertyValue;
            return this;
        }

        public final String getOperator() {
            return operator;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(ComparisonOperator operator) {
            this.operator(operator == null ? null : operator.toString());
            return this;
        }

        public final String getThresholdValue() {
            return thresholdValue;
        }

        public final void setThresholdValue(String thresholdValue) {
            this.thresholdValue = thresholdValue;
        }

        @Override
        public final Builder thresholdValue(String thresholdValue) {
            this.thresholdValue = thresholdValue;
            return this;
        }

        @Override
        public SimpleRuleEvaluation build() {
            return new SimpleRuleEvaluation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
