/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ioteventsdata.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ioteventsdata.model.AlarmState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Alarm
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Alarm> {
    private static final SdkField<String> ALARM_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("alarmModelName").getter(Alarm.getter(Alarm::alarmModelName)).setter(Alarm.setter(Builder::alarmModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmModelName").build()}).build();
    private static final SdkField<String> ALARM_MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("alarmModelVersion").getter(Alarm.getter(Alarm::alarmModelVersion)).setter(Alarm.setter(Builder::alarmModelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmModelVersion").build()}).build();
    private static final SdkField<String> KEY_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("keyValue").getter(Alarm.getter(Alarm::keyValue)).setter(Alarm.setter(Builder::keyValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyValue").build()}).build();
    private static final SdkField<AlarmState> ALARM_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("alarmState").getter(Alarm.getter(Alarm::alarmState)).setter(Alarm.setter(Builder::alarmState)).constructor(AlarmState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmState").build()}).build();
    private static final SdkField<Integer> SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("severity").getter(Alarm.getter(Alarm::severity)).setter(Alarm.setter(Builder::severity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severity").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(Alarm.getter(Alarm::creationTime)).setter(Alarm.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdateTime").getter(Alarm.getter(Alarm::lastUpdateTime)).setter(Alarm.setter(Builder::lastUpdateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALARM_MODEL_NAME_FIELD, ALARM_MODEL_VERSION_FIELD, KEY_VALUE_FIELD, ALARM_STATE_FIELD, SEVERITY_FIELD, CREATION_TIME_FIELD, LAST_UPDATE_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Alarm.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String alarmModelName;
    private final String alarmModelVersion;
    private final String keyValue;
    private final AlarmState alarmState;
    private final Integer severity;
    private final Instant creationTime;
    private final Instant lastUpdateTime;

    private Alarm(BuilderImpl builder) {
        this.alarmModelName = builder.alarmModelName;
        this.alarmModelVersion = builder.alarmModelVersion;
        this.keyValue = builder.keyValue;
        this.alarmState = builder.alarmState;
        this.severity = builder.severity;
        this.creationTime = builder.creationTime;
        this.lastUpdateTime = builder.lastUpdateTime;
    }

    public final String alarmModelName() {
        return this.alarmModelName;
    }

    public final String alarmModelVersion() {
        return this.alarmModelVersion;
    }

    public final String keyValue() {
        return this.keyValue;
    }

    public final AlarmState alarmState() {
        return this.alarmState;
    }

    public final Integer severity() {
        return this.severity;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastUpdateTime() {
        return this.lastUpdateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmModelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmModelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmState());
        hashCode = 31 * hashCode + Objects.hashCode(this.severity());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Alarm)) {
            return false;
        }
        Alarm other = (Alarm)obj;
        return Objects.equals(this.alarmModelName(), other.alarmModelName()) && Objects.equals(this.alarmModelVersion(), other.alarmModelVersion()) && Objects.equals(this.keyValue(), other.keyValue()) && Objects.equals(this.alarmState(), other.alarmState()) && Objects.equals(this.severity(), other.severity()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastUpdateTime(), other.lastUpdateTime());
    }

    public final String toString() {
        return ToString.builder((String)"Alarm").add("AlarmModelName", (Object)this.alarmModelName()).add("AlarmModelVersion", (Object)this.alarmModelVersion()).add("KeyValue", (Object)this.keyValue()).add("AlarmState", (Object)this.alarmState()).add("Severity", (Object)this.severity()).add("CreationTime", (Object)this.creationTime()).add("LastUpdateTime", (Object)this.lastUpdateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "alarmModelName": {
                return Optional.ofNullable(clazz.cast(this.alarmModelName()));
            }
            case "alarmModelVersion": {
                return Optional.ofNullable(clazz.cast(this.alarmModelVersion()));
            }
            case "keyValue": {
                return Optional.ofNullable(clazz.cast(this.keyValue()));
            }
            case "alarmState": {
                return Optional.ofNullable(clazz.cast(this.alarmState()));
            }
            case "severity": {
                return Optional.ofNullable(clazz.cast(this.severity()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "lastUpdateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("alarmModelName", ALARM_MODEL_NAME_FIELD);
        map.put("alarmModelVersion", ALARM_MODEL_VERSION_FIELD);
        map.put("keyValue", KEY_VALUE_FIELD);
        map.put("alarmState", ALARM_STATE_FIELD);
        map.put("severity", SEVERITY_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("lastUpdateTime", LAST_UPDATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Alarm, T> g) {
        return obj -> g.apply((Alarm)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String alarmModelName;
        private String alarmModelVersion;
        private String keyValue;
        private AlarmState alarmState;
        private Integer severity;
        private Instant creationTime;
        private Instant lastUpdateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Alarm model) {
            this.alarmModelName(model.alarmModelName);
            this.alarmModelVersion(model.alarmModelVersion);
            this.keyValue(model.keyValue);
            this.alarmState(model.alarmState);
            this.severity(model.severity);
            this.creationTime(model.creationTime);
            this.lastUpdateTime(model.lastUpdateTime);
        }

        public final String getAlarmModelName() {
            return this.alarmModelName;
        }

        public final void setAlarmModelName(String alarmModelName) {
            this.alarmModelName = alarmModelName;
        }

        @Override
        public final Builder alarmModelName(String alarmModelName) {
            this.alarmModelName = alarmModelName;
            return this;
        }

        public final String getAlarmModelVersion() {
            return this.alarmModelVersion;
        }

        public final void setAlarmModelVersion(String alarmModelVersion) {
            this.alarmModelVersion = alarmModelVersion;
        }

        @Override
        public final Builder alarmModelVersion(String alarmModelVersion) {
            this.alarmModelVersion = alarmModelVersion;
            return this;
        }

        public final String getKeyValue() {
            return this.keyValue;
        }

        public final void setKeyValue(String keyValue) {
            this.keyValue = keyValue;
        }

        @Override
        public final Builder keyValue(String keyValue) {
            this.keyValue = keyValue;
            return this;
        }

        public final AlarmState.Builder getAlarmState() {
            return this.alarmState != null ? this.alarmState.toBuilder() : null;
        }

        public final void setAlarmState(AlarmState.BuilderImpl alarmState) {
            this.alarmState = alarmState != null ? alarmState.build() : null;
        }

        @Override
        public final Builder alarmState(AlarmState alarmState) {
            this.alarmState = alarmState;
            return this;
        }

        public final Integer getSeverity() {
            return this.severity;
        }

        public final void setSeverity(Integer severity) {
            this.severity = severity;
        }

        @Override
        public final Builder severity(Integer severity) {
            this.severity = severity;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public Alarm build() {
            return new Alarm(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Alarm> {
        public Builder alarmModelName(String var1);

        public Builder alarmModelVersion(String var1);

        public Builder keyValue(String var1);

        public Builder alarmState(AlarmState var1);

        default public Builder alarmState(Consumer<AlarmState.Builder> alarmState) {
            return this.alarmState((AlarmState)((AlarmState.Builder)AlarmState.builder().applyMutation(alarmState)).build());
        }

        public Builder severity(Integer var1);

        public Builder creationTime(Instant var1);

        public Builder lastUpdateTime(Instant var1);
    }
}

