/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ioteventsdata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchResetAlarmRequest extends IotEventsDataRequest implements
        ToCopyableBuilder<BatchResetAlarmRequest.Builder, BatchResetAlarmRequest> {
    private static final SdkField<List<ResetAlarmActionRequest>> RESET_ACTION_REQUESTS_FIELD = SdkField
            .<List<ResetAlarmActionRequest>> builder(MarshallingType.LIST)
            .memberName("resetActionRequests")
            .getter(getter(BatchResetAlarmRequest::resetActionRequests))
            .setter(setter(Builder::resetActionRequests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resetActionRequests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResetAlarmActionRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResetAlarmActionRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESET_ACTION_REQUESTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ResetAlarmActionRequest> resetActionRequests;

    private BatchResetAlarmRequest(BuilderImpl builder) {
        super(builder);
        this.resetActionRequests = builder.resetActionRequests;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResetActionRequests property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResetActionRequests() {
        return resetActionRequests != null && !(resetActionRequests instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of reset action requests. You can specify up to 10 requests per operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResetActionRequests} method.
     * </p>
     * 
     * @return The list of reset action requests. You can specify up to 10 requests per operation.
     */
    public final List<ResetAlarmActionRequest> resetActionRequests() {
        return resetActionRequests;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasResetActionRequests() ? resetActionRequests() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchResetAlarmRequest)) {
            return false;
        }
        BatchResetAlarmRequest other = (BatchResetAlarmRequest) obj;
        return hasResetActionRequests() == other.hasResetActionRequests()
                && Objects.equals(resetActionRequests(), other.resetActionRequests());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchResetAlarmRequest")
                .add("ResetActionRequests", hasResetActionRequests() ? resetActionRequests() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resetActionRequests":
            return Optional.ofNullable(clazz.cast(resetActionRequests()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("resetActionRequests", RESET_ACTION_REQUESTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchResetAlarmRequest, T> g) {
        return obj -> g.apply((BatchResetAlarmRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotEventsDataRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchResetAlarmRequest> {
        /**
         * <p>
         * The list of reset action requests. You can specify up to 10 requests per operation.
         * </p>
         * 
         * @param resetActionRequests
         *        The list of reset action requests. You can specify up to 10 requests per operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resetActionRequests(Collection<ResetAlarmActionRequest> resetActionRequests);

        /**
         * <p>
         * The list of reset action requests. You can specify up to 10 requests per operation.
         * </p>
         * 
         * @param resetActionRequests
         *        The list of reset action requests. You can specify up to 10 requests per operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resetActionRequests(ResetAlarmActionRequest... resetActionRequests);

        /**
         * <p>
         * The list of reset action requests. You can specify up to 10 requests per operation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ioteventsdata.model.ResetAlarmActionRequest.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.ioteventsdata.model.ResetAlarmActionRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ioteventsdata.model.ResetAlarmActionRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #resetActionRequests(List<ResetAlarmActionRequest>)}.
         * 
         * @param resetActionRequests
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ioteventsdata.model.ResetAlarmActionRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resetActionRequests(java.util.Collection<ResetAlarmActionRequest>)
         */
        Builder resetActionRequests(Consumer<ResetAlarmActionRequest.Builder>... resetActionRequests);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotEventsDataRequest.BuilderImpl implements Builder {
        private List<ResetAlarmActionRequest> resetActionRequests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchResetAlarmRequest model) {
            super(model);
            resetActionRequests(model.resetActionRequests);
        }

        public final List<ResetAlarmActionRequest.Builder> getResetActionRequests() {
            List<ResetAlarmActionRequest.Builder> result = ResetAlarmActionRequestsCopier.copyToBuilder(this.resetActionRequests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResetActionRequests(Collection<ResetAlarmActionRequest.BuilderImpl> resetActionRequests) {
            this.resetActionRequests = ResetAlarmActionRequestsCopier.copyFromBuilder(resetActionRequests);
        }

        @Override
        public final Builder resetActionRequests(Collection<ResetAlarmActionRequest> resetActionRequests) {
            this.resetActionRequests = ResetAlarmActionRequestsCopier.copy(resetActionRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resetActionRequests(ResetAlarmActionRequest... resetActionRequests) {
            resetActionRequests(Arrays.asList(resetActionRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resetActionRequests(Consumer<ResetAlarmActionRequest.Builder>... resetActionRequests) {
            resetActionRequests(Stream.of(resetActionRequests)
                    .map(c -> ResetAlarmActionRequest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchResetAlarmRequest build() {
            return new BatchResetAlarmRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
