/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ioteventsdata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ioteventsdata.model.AlarmSummariesCopier;
import software.amazon.awssdk.services.ioteventsdata.model.AlarmSummary;
import software.amazon.awssdk.services.ioteventsdata.model.IotEventsDataResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAlarmsResponse
extends IotEventsDataResponse
implements ToCopyableBuilder<Builder, ListAlarmsResponse> {
    private static final SdkField<List<AlarmSummary>> ALARM_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("alarmSummaries").getter(ListAlarmsResponse.getter(ListAlarmsResponse::alarmSummaries)).setter(ListAlarmsResponse.setter(Builder::alarmSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AlarmSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAlarmsResponse.getter(ListAlarmsResponse::nextToken)).setter(ListAlarmsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALARM_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAlarmsResponse.memberNameToFieldInitializer();
    private final List<AlarmSummary> alarmSummaries;
    private final String nextToken;

    private ListAlarmsResponse(BuilderImpl builder) {
        super(builder);
        this.alarmSummaries = builder.alarmSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAlarmSummaries() {
        return this.alarmSummaries != null && !(this.alarmSummaries instanceof SdkAutoConstructList);
    }

    public final List<AlarmSummary> alarmSummaries() {
        return this.alarmSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAlarmSummaries() ? this.alarmSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAlarmsResponse)) {
            return false;
        }
        ListAlarmsResponse other = (ListAlarmsResponse)((Object)obj);
        return this.hasAlarmSummaries() == other.hasAlarmSummaries() && Objects.equals(this.alarmSummaries(), other.alarmSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAlarmsResponse").add("AlarmSummaries", this.hasAlarmSummaries() ? this.alarmSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "alarmSummaries": {
                return Optional.ofNullable(clazz.cast(this.alarmSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("alarmSummaries", ALARM_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAlarmsResponse, T> g) {
        return obj -> g.apply((ListAlarmsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotEventsDataResponse.BuilderImpl
    implements Builder {
        private List<AlarmSummary> alarmSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAlarmsResponse model) {
            super(model);
            this.alarmSummaries(model.alarmSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<AlarmSummary.Builder> getAlarmSummaries() {
            List<AlarmSummary.Builder> result = AlarmSummariesCopier.copyToBuilder(this.alarmSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAlarmSummaries(Collection<AlarmSummary.BuilderImpl> alarmSummaries) {
            this.alarmSummaries = AlarmSummariesCopier.copyFromBuilder(alarmSummaries);
        }

        @Override
        public final Builder alarmSummaries(Collection<AlarmSummary> alarmSummaries) {
            this.alarmSummaries = AlarmSummariesCopier.copy(alarmSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarmSummaries(AlarmSummary ... alarmSummaries) {
            this.alarmSummaries(Arrays.asList(alarmSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarmSummaries(Consumer<AlarmSummary.Builder> ... alarmSummaries) {
            this.alarmSummaries(Stream.of(alarmSummaries).map(c -> (AlarmSummary)((AlarmSummary.Builder)AlarmSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAlarmsResponse build() {
            return new ListAlarmsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotEventsDataResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAlarmsResponse> {
        public Builder alarmSummaries(Collection<AlarmSummary> var1);

        public Builder alarmSummaries(AlarmSummary ... var1);

        public Builder alarmSummaries(Consumer<AlarmSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

