/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleethub.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeApplicationResponse extends IoTFleetHubResponse implements
        ToCopyableBuilder<DescribeApplicationResponse.Builder, DescribeApplicationResponse> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(DescribeApplicationResponse::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()).build();

    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationArn").getter(getter(DescribeApplicationResponse::applicationArn))
            .setter(setter(Builder::applicationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationArn").build()).build();

    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationName").getter(getter(DescribeApplicationResponse::applicationName))
            .setter(setter(Builder::applicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationName").build()).build();

    private static final SdkField<String> APPLICATION_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationDescription").getter(getter(DescribeApplicationResponse::applicationDescription))
            .setter(setter(Builder::applicationDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationDescription").build())
            .build();

    private static final SdkField<String> APPLICATION_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationUrl").getter(getter(DescribeApplicationResponse::applicationUrl))
            .setter(setter(Builder::applicationUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationUrl").build()).build();

    private static final SdkField<String> APPLICATION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationState").getter(getter(DescribeApplicationResponse::applicationStateAsString))
            .setter(setter(Builder::applicationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationState").build()).build();

    private static final SdkField<Long> APPLICATION_CREATION_DATE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("applicationCreationDate").getter(getter(DescribeApplicationResponse::applicationCreationDate))
            .setter(setter(Builder::applicationCreationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationCreationDate").build())
            .build();

    private static final SdkField<Long> APPLICATION_LAST_UPDATE_DATE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("applicationLastUpdateDate").getter(getter(DescribeApplicationResponse::applicationLastUpdateDate))
            .setter(setter(Builder::applicationLastUpdateDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationLastUpdateDate").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(DescribeApplicationResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> SSO_CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ssoClientId").getter(getter(DescribeApplicationResponse::ssoClientId))
            .setter(setter(Builder::ssoClientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ssoClientId").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorMessage").getter(getter(DescribeApplicationResponse::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(DescribeApplicationResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            APPLICATION_ARN_FIELD, APPLICATION_NAME_FIELD, APPLICATION_DESCRIPTION_FIELD, APPLICATION_URL_FIELD,
            APPLICATION_STATE_FIELD, APPLICATION_CREATION_DATE_FIELD, APPLICATION_LAST_UPDATE_DATE_FIELD, ROLE_ARN_FIELD,
            SSO_CLIENT_ID_FIELD, ERROR_MESSAGE_FIELD, TAGS_FIELD));

    private final String applicationId;

    private final String applicationArn;

    private final String applicationName;

    private final String applicationDescription;

    private final String applicationUrl;

    private final String applicationState;

    private final Long applicationCreationDate;

    private final Long applicationLastUpdateDate;

    private final String roleArn;

    private final String ssoClientId;

    private final String errorMessage;

    private final Map<String, String> tags;

    private DescribeApplicationResponse(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.applicationArn = builder.applicationArn;
        this.applicationName = builder.applicationName;
        this.applicationDescription = builder.applicationDescription;
        this.applicationUrl = builder.applicationUrl;
        this.applicationState = builder.applicationState;
        this.applicationCreationDate = builder.applicationCreationDate;
        this.applicationLastUpdateDate = builder.applicationLastUpdateDate;
        this.roleArn = builder.roleArn;
        this.ssoClientId = builder.ssoClientId;
        this.errorMessage = builder.errorMessage;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The unique Id of the web application.
     * </p>
     * 
     * @return The unique Id of the web application.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The ARN of the web application.
     * </p>
     * 
     * @return The ARN of the web application.
     */
    public final String applicationArn() {
        return applicationArn;
    }

    /**
     * <p>
     * The name of the web application.
     * </p>
     * 
     * @return The name of the web application.
     */
    public final String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * An optional description of the web application.
     * </p>
     * 
     * @return An optional description of the web application.
     */
    public final String applicationDescription() {
        return applicationDescription;
    }

    /**
     * <p>
     * The URL of the web application.
     * </p>
     * 
     * @return The URL of the web application.
     */
    public final String applicationUrl() {
        return applicationUrl;
    }

    /**
     * <p>
     * The current state of the web application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #applicationState}
     * will return {@link ApplicationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #applicationStateAsString}.
     * </p>
     * 
     * @return The current state of the web application.
     * @see ApplicationState
     */
    public final ApplicationState applicationState() {
        return ApplicationState.fromValue(applicationState);
    }

    /**
     * <p>
     * The current state of the web application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #applicationState}
     * will return {@link ApplicationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #applicationStateAsString}.
     * </p>
     * 
     * @return The current state of the web application.
     * @see ApplicationState
     */
    public final String applicationStateAsString() {
        return applicationState;
    }

    /**
     * <p>
     * The date (in Unix epoch time) when the application was created.
     * </p>
     * 
     * @return The date (in Unix epoch time) when the application was created.
     */
    public final Long applicationCreationDate() {
        return applicationCreationDate;
    }

    /**
     * <p>
     * The date (in Unix epoch time) when the application was last updated.
     * </p>
     * 
     * @return The date (in Unix epoch time) when the application was last updated.
     */
    public final Long applicationLastUpdateDate() {
        return applicationLastUpdateDate;
    }

    /**
     * <p>
     * The ARN of the role that the web application assumes when it interacts with AWS IoT Core.
     * </p>
     * 
     * @return The ARN of the role that the web application assumes when it interacts with AWS IoT Core.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The Id of the single sign-on client that you use to authenticate and authorize users on the web application.
     * </p>
     * 
     * @return The Id of the single sign-on client that you use to authenticate and authorize users on the web
     *         application.
     */
    public final String ssoClientId() {
        return ssoClientId;
    }

    /**
     * <p>
     * A message indicating why the <code>DescribeApplication</code> API failed.
     * </p>
     * 
     * @return A message indicating why the <code>DescribeApplication</code> API failed.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A set of key/value pairs that you can use to manage the web application resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A set of key/value pairs that you can use to manage the web application resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(applicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(applicationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(applicationUrl());
        hashCode = 31 * hashCode + Objects.hashCode(applicationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(applicationCreationDate());
        hashCode = 31 * hashCode + Objects.hashCode(applicationLastUpdateDate());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(ssoClientId());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeApplicationResponse)) {
            return false;
        }
        DescribeApplicationResponse other = (DescribeApplicationResponse) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(applicationArn(), other.applicationArn())
                && Objects.equals(applicationName(), other.applicationName())
                && Objects.equals(applicationDescription(), other.applicationDescription())
                && Objects.equals(applicationUrl(), other.applicationUrl())
                && Objects.equals(applicationStateAsString(), other.applicationStateAsString())
                && Objects.equals(applicationCreationDate(), other.applicationCreationDate())
                && Objects.equals(applicationLastUpdateDate(), other.applicationLastUpdateDate())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(ssoClientId(), other.ssoClientId())
                && Objects.equals(errorMessage(), other.errorMessage()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeApplicationResponse").add("ApplicationId", applicationId())
                .add("ApplicationArn", applicationArn()).add("ApplicationName", applicationName())
                .add("ApplicationDescription", applicationDescription()).add("ApplicationUrl", applicationUrl())
                .add("ApplicationState", applicationStateAsString()).add("ApplicationCreationDate", applicationCreationDate())
                .add("ApplicationLastUpdateDate", applicationLastUpdateDate()).add("RoleArn", roleArn())
                .add("SsoClientId", ssoClientId()).add("ErrorMessage", errorMessage()).add("Tags", hasTags() ? tags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "applicationArn":
            return Optional.ofNullable(clazz.cast(applicationArn()));
        case "applicationName":
            return Optional.ofNullable(clazz.cast(applicationName()));
        case "applicationDescription":
            return Optional.ofNullable(clazz.cast(applicationDescription()));
        case "applicationUrl":
            return Optional.ofNullable(clazz.cast(applicationUrl()));
        case "applicationState":
            return Optional.ofNullable(clazz.cast(applicationStateAsString()));
        case "applicationCreationDate":
            return Optional.ofNullable(clazz.cast(applicationCreationDate()));
        case "applicationLastUpdateDate":
            return Optional.ofNullable(clazz.cast(applicationLastUpdateDate()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "ssoClientId":
            return Optional.ofNullable(clazz.cast(ssoClientId()));
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeApplicationResponse, T> g) {
        return obj -> g.apply((DescribeApplicationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTFleetHubResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeApplicationResponse> {
        /**
         * <p>
         * The unique Id of the web application.
         * </p>
         * 
         * @param applicationId
         *        The unique Id of the web application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The ARN of the web application.
         * </p>
         * 
         * @param applicationArn
         *        The ARN of the web application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationArn(String applicationArn);

        /**
         * <p>
         * The name of the web application.
         * </p>
         * 
         * @param applicationName
         *        The name of the web application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * An optional description of the web application.
         * </p>
         * 
         * @param applicationDescription
         *        An optional description of the web application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationDescription(String applicationDescription);

        /**
         * <p>
         * The URL of the web application.
         * </p>
         * 
         * @param applicationUrl
         *        The URL of the web application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationUrl(String applicationUrl);

        /**
         * <p>
         * The current state of the web application.
         * </p>
         * 
         * @param applicationState
         *        The current state of the web application.
         * @see ApplicationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationState
         */
        Builder applicationState(String applicationState);

        /**
         * <p>
         * The current state of the web application.
         * </p>
         * 
         * @param applicationState
         *        The current state of the web application.
         * @see ApplicationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationState
         */
        Builder applicationState(ApplicationState applicationState);

        /**
         * <p>
         * The date (in Unix epoch time) when the application was created.
         * </p>
         * 
         * @param applicationCreationDate
         *        The date (in Unix epoch time) when the application was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationCreationDate(Long applicationCreationDate);

        /**
         * <p>
         * The date (in Unix epoch time) when the application was last updated.
         * </p>
         * 
         * @param applicationLastUpdateDate
         *        The date (in Unix epoch time) when the application was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationLastUpdateDate(Long applicationLastUpdateDate);

        /**
         * <p>
         * The ARN of the role that the web application assumes when it interacts with AWS IoT Core.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the role that the web application assumes when it interacts with AWS IoT Core.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The Id of the single sign-on client that you use to authenticate and authorize users on the web application.
         * </p>
         * 
         * @param ssoClientId
         *        The Id of the single sign-on client that you use to authenticate and authorize users on the web
         *        application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ssoClientId(String ssoClientId);

        /**
         * <p>
         * A message indicating why the <code>DescribeApplication</code> API failed.
         * </p>
         * 
         * @param errorMessage
         *        A message indicating why the <code>DescribeApplication</code> API failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * A set of key/value pairs that you can use to manage the web application resource.
         * </p>
         * 
         * @param tags
         *        A set of key/value pairs that you can use to manage the web application resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends IoTFleetHubResponse.BuilderImpl implements Builder {
        private String applicationId;

        private String applicationArn;

        private String applicationName;

        private String applicationDescription;

        private String applicationUrl;

        private String applicationState;

        private Long applicationCreationDate;

        private Long applicationLastUpdateDate;

        private String roleArn;

        private String ssoClientId;

        private String errorMessage;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeApplicationResponse model) {
            super(model);
            applicationId(model.applicationId);
            applicationArn(model.applicationArn);
            applicationName(model.applicationName);
            applicationDescription(model.applicationDescription);
            applicationUrl(model.applicationUrl);
            applicationState(model.applicationState);
            applicationCreationDate(model.applicationCreationDate);
            applicationLastUpdateDate(model.applicationLastUpdateDate);
            roleArn(model.roleArn);
            ssoClientId(model.ssoClientId);
            errorMessage(model.errorMessage);
            tags(model.tags);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        @Transient
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getApplicationArn() {
            return applicationArn;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        @Override
        @Transient
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        public final String getApplicationName() {
            return applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        @Transient
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final String getApplicationDescription() {
            return applicationDescription;
        }

        public final void setApplicationDescription(String applicationDescription) {
            this.applicationDescription = applicationDescription;
        }

        @Override
        @Transient
        public final Builder applicationDescription(String applicationDescription) {
            this.applicationDescription = applicationDescription;
            return this;
        }

        public final String getApplicationUrl() {
            return applicationUrl;
        }

        public final void setApplicationUrl(String applicationUrl) {
            this.applicationUrl = applicationUrl;
        }

        @Override
        @Transient
        public final Builder applicationUrl(String applicationUrl) {
            this.applicationUrl = applicationUrl;
            return this;
        }

        public final String getApplicationState() {
            return applicationState;
        }

        public final void setApplicationState(String applicationState) {
            this.applicationState = applicationState;
        }

        @Override
        @Transient
        public final Builder applicationState(String applicationState) {
            this.applicationState = applicationState;
            return this;
        }

        @Override
        @Transient
        public final Builder applicationState(ApplicationState applicationState) {
            this.applicationState(applicationState == null ? null : applicationState.toString());
            return this;
        }

        public final Long getApplicationCreationDate() {
            return applicationCreationDate;
        }

        public final void setApplicationCreationDate(Long applicationCreationDate) {
            this.applicationCreationDate = applicationCreationDate;
        }

        @Override
        @Transient
        public final Builder applicationCreationDate(Long applicationCreationDate) {
            this.applicationCreationDate = applicationCreationDate;
            return this;
        }

        public final Long getApplicationLastUpdateDate() {
            return applicationLastUpdateDate;
        }

        public final void setApplicationLastUpdateDate(Long applicationLastUpdateDate) {
            this.applicationLastUpdateDate = applicationLastUpdateDate;
        }

        @Override
        @Transient
        public final Builder applicationLastUpdateDate(Long applicationLastUpdateDate) {
            this.applicationLastUpdateDate = applicationLastUpdateDate;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getSsoClientId() {
            return ssoClientId;
        }

        public final void setSsoClientId(String ssoClientId) {
            this.ssoClientId = ssoClientId;
        }

        @Override
        @Transient
        public final Builder ssoClientId(String ssoClientId) {
            this.ssoClientId = ssoClientId;
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        @Transient
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public DescribeApplicationResponse build() {
            return new DescribeApplicationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
