/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.iotfleetwise.model.AccessDeniedException;
import software.amazon.awssdk.services.iotfleetwise.model.AssociateVehicleFleetRequest;
import software.amazon.awssdk.services.iotfleetwise.model.AssociateVehicleFleetResponse;
import software.amazon.awssdk.services.iotfleetwise.model.BatchCreateVehicleRequest;
import software.amazon.awssdk.services.iotfleetwise.model.BatchCreateVehicleResponse;
import software.amazon.awssdk.services.iotfleetwise.model.BatchUpdateVehicleRequest;
import software.amazon.awssdk.services.iotfleetwise.model.BatchUpdateVehicleResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ConflictException;
import software.amazon.awssdk.services.iotfleetwise.model.CreateCampaignRequest;
import software.amazon.awssdk.services.iotfleetwise.model.CreateCampaignResponse;
import software.amazon.awssdk.services.iotfleetwise.model.CreateDecoderManifestRequest;
import software.amazon.awssdk.services.iotfleetwise.model.CreateDecoderManifestResponse;
import software.amazon.awssdk.services.iotfleetwise.model.CreateFleetRequest;
import software.amazon.awssdk.services.iotfleetwise.model.CreateFleetResponse;
import software.amazon.awssdk.services.iotfleetwise.model.CreateModelManifestRequest;
import software.amazon.awssdk.services.iotfleetwise.model.CreateModelManifestResponse;
import software.amazon.awssdk.services.iotfleetwise.model.CreateSignalCatalogRequest;
import software.amazon.awssdk.services.iotfleetwise.model.CreateSignalCatalogResponse;
import software.amazon.awssdk.services.iotfleetwise.model.CreateVehicleRequest;
import software.amazon.awssdk.services.iotfleetwise.model.CreateVehicleResponse;
import software.amazon.awssdk.services.iotfleetwise.model.DecoderManifestValidationException;
import software.amazon.awssdk.services.iotfleetwise.model.DeleteCampaignRequest;
import software.amazon.awssdk.services.iotfleetwise.model.DeleteCampaignResponse;
import software.amazon.awssdk.services.iotfleetwise.model.DeleteDecoderManifestRequest;
import software.amazon.awssdk.services.iotfleetwise.model.DeleteDecoderManifestResponse;
import software.amazon.awssdk.services.iotfleetwise.model.DeleteFleetRequest;
import software.amazon.awssdk.services.iotfleetwise.model.DeleteFleetResponse;
import software.amazon.awssdk.services.iotfleetwise.model.DeleteModelManifestRequest;
import software.amazon.awssdk.services.iotfleetwise.model.DeleteModelManifestResponse;
import software.amazon.awssdk.services.iotfleetwise.model.DeleteSignalCatalogRequest;
import software.amazon.awssdk.services.iotfleetwise.model.DeleteSignalCatalogResponse;
import software.amazon.awssdk.services.iotfleetwise.model.DeleteVehicleRequest;
import software.amazon.awssdk.services.iotfleetwise.model.DeleteVehicleResponse;
import software.amazon.awssdk.services.iotfleetwise.model.DisassociateVehicleFleetRequest;
import software.amazon.awssdk.services.iotfleetwise.model.DisassociateVehicleFleetResponse;
import software.amazon.awssdk.services.iotfleetwise.model.GetCampaignRequest;
import software.amazon.awssdk.services.iotfleetwise.model.GetCampaignResponse;
import software.amazon.awssdk.services.iotfleetwise.model.GetDecoderManifestRequest;
import software.amazon.awssdk.services.iotfleetwise.model.GetDecoderManifestResponse;
import software.amazon.awssdk.services.iotfleetwise.model.GetFleetRequest;
import software.amazon.awssdk.services.iotfleetwise.model.GetFleetResponse;
import software.amazon.awssdk.services.iotfleetwise.model.GetLoggingOptionsRequest;
import software.amazon.awssdk.services.iotfleetwise.model.GetLoggingOptionsResponse;
import software.amazon.awssdk.services.iotfleetwise.model.GetModelManifestRequest;
import software.amazon.awssdk.services.iotfleetwise.model.GetModelManifestResponse;
import software.amazon.awssdk.services.iotfleetwise.model.GetRegisterAccountStatusRequest;
import software.amazon.awssdk.services.iotfleetwise.model.GetRegisterAccountStatusResponse;
import software.amazon.awssdk.services.iotfleetwise.model.GetSignalCatalogRequest;
import software.amazon.awssdk.services.iotfleetwise.model.GetSignalCatalogResponse;
import software.amazon.awssdk.services.iotfleetwise.model.GetVehicleRequest;
import software.amazon.awssdk.services.iotfleetwise.model.GetVehicleResponse;
import software.amazon.awssdk.services.iotfleetwise.model.GetVehicleStatusRequest;
import software.amazon.awssdk.services.iotfleetwise.model.GetVehicleStatusResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ImportDecoderManifestRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ImportDecoderManifestResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ImportSignalCatalogRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ImportSignalCatalogResponse;
import software.amazon.awssdk.services.iotfleetwise.model.InternalServerException;
import software.amazon.awssdk.services.iotfleetwise.model.InvalidNodeException;
import software.amazon.awssdk.services.iotfleetwise.model.InvalidSignalsException;
import software.amazon.awssdk.services.iotfleetwise.model.IoTFleetWiseException;
import software.amazon.awssdk.services.iotfleetwise.model.IoTFleetWiseRequest;
import software.amazon.awssdk.services.iotfleetwise.model.LimitExceededException;
import software.amazon.awssdk.services.iotfleetwise.model.ListCampaignsRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListCampaignsResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestNetworkInterfacesRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestNetworkInterfacesResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestSignalsRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestSignalsResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestsRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestsResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ListFleetsForVehicleRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListFleetsForVehicleResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ListFleetsRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListFleetsResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestNodesRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestNodesResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestsRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestsResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogNodesRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogNodesResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogsRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogsResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesInFleetRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesInFleetResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesResponse;
import software.amazon.awssdk.services.iotfleetwise.model.PutLoggingOptionsRequest;
import software.amazon.awssdk.services.iotfleetwise.model.PutLoggingOptionsResponse;
import software.amazon.awssdk.services.iotfleetwise.model.RegisterAccountRequest;
import software.amazon.awssdk.services.iotfleetwise.model.RegisterAccountResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ResourceNotFoundException;
import software.amazon.awssdk.services.iotfleetwise.model.TagResourceRequest;
import software.amazon.awssdk.services.iotfleetwise.model.TagResourceResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ThrottlingException;
import software.amazon.awssdk.services.iotfleetwise.model.UntagResourceRequest;
import software.amazon.awssdk.services.iotfleetwise.model.UntagResourceResponse;
import software.amazon.awssdk.services.iotfleetwise.model.UpdateCampaignRequest;
import software.amazon.awssdk.services.iotfleetwise.model.UpdateCampaignResponse;
import software.amazon.awssdk.services.iotfleetwise.model.UpdateDecoderManifestRequest;
import software.amazon.awssdk.services.iotfleetwise.model.UpdateDecoderManifestResponse;
import software.amazon.awssdk.services.iotfleetwise.model.UpdateFleetRequest;
import software.amazon.awssdk.services.iotfleetwise.model.UpdateFleetResponse;
import software.amazon.awssdk.services.iotfleetwise.model.UpdateModelManifestRequest;
import software.amazon.awssdk.services.iotfleetwise.model.UpdateModelManifestResponse;
import software.amazon.awssdk.services.iotfleetwise.model.UpdateSignalCatalogRequest;
import software.amazon.awssdk.services.iotfleetwise.model.UpdateSignalCatalogResponse;
import software.amazon.awssdk.services.iotfleetwise.model.UpdateVehicleRequest;
import software.amazon.awssdk.services.iotfleetwise.model.UpdateVehicleResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ValidationException;
import software.amazon.awssdk.services.iotfleetwise.paginators.GetVehicleStatusPublisher;
import software.amazon.awssdk.services.iotfleetwise.paginators.ListCampaignsPublisher;
import software.amazon.awssdk.services.iotfleetwise.paginators.ListDecoderManifestNetworkInterfacesPublisher;
import software.amazon.awssdk.services.iotfleetwise.paginators.ListDecoderManifestSignalsPublisher;
import software.amazon.awssdk.services.iotfleetwise.paginators.ListDecoderManifestsPublisher;
import software.amazon.awssdk.services.iotfleetwise.paginators.ListFleetsForVehiclePublisher;
import software.amazon.awssdk.services.iotfleetwise.paginators.ListFleetsPublisher;
import software.amazon.awssdk.services.iotfleetwise.paginators.ListModelManifestNodesPublisher;
import software.amazon.awssdk.services.iotfleetwise.paginators.ListModelManifestsPublisher;
import software.amazon.awssdk.services.iotfleetwise.paginators.ListSignalCatalogNodesPublisher;
import software.amazon.awssdk.services.iotfleetwise.paginators.ListSignalCatalogsPublisher;
import software.amazon.awssdk.services.iotfleetwise.paginators.ListVehiclesInFleetPublisher;
import software.amazon.awssdk.services.iotfleetwise.paginators.ListVehiclesPublisher;
import software.amazon.awssdk.services.iotfleetwise.transform.AssociateVehicleFleetRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.BatchCreateVehicleRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.BatchUpdateVehicleRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.CreateCampaignRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.CreateDecoderManifestRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.CreateFleetRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.CreateModelManifestRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.CreateSignalCatalogRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.CreateVehicleRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.DeleteCampaignRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.DeleteDecoderManifestRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.DeleteFleetRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.DeleteModelManifestRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.DeleteSignalCatalogRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.DeleteVehicleRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.DisassociateVehicleFleetRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.GetCampaignRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.GetDecoderManifestRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.GetFleetRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.GetLoggingOptionsRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.GetModelManifestRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.GetRegisterAccountStatusRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.GetSignalCatalogRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.GetVehicleRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.GetVehicleStatusRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.ImportDecoderManifestRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.ImportSignalCatalogRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.ListCampaignsRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.ListDecoderManifestNetworkInterfacesRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.ListDecoderManifestSignalsRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.ListDecoderManifestsRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.ListFleetsForVehicleRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.ListFleetsRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.ListModelManifestNodesRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.ListModelManifestsRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.ListSignalCatalogNodesRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.ListSignalCatalogsRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.ListVehiclesInFleetRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.ListVehiclesRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.PutLoggingOptionsRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.RegisterAccountRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.UpdateCampaignRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.UpdateDecoderManifestRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.UpdateFleetRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.UpdateModelManifestRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.UpdateSignalCatalogRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.UpdateVehicleRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link IoTFleetWiseAsyncClient}.
 *
 * @see IoTFleetWiseAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultIoTFleetWiseAsyncClient implements IoTFleetWiseAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultIoTFleetWiseAsyncClient.class);

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultIoTFleetWiseAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Adds, or associates, a vehicle with a fleet.
     * </p>
     *
     * @param associateVehicleFleetRequest
     * @return A Java Future containing the result of the AssociateVehicleFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.AssociateVehicleFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/AssociateVehicleFleet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateVehicleFleetResponse> associateVehicleFleet(
            AssociateVehicleFleetRequest associateVehicleFleetRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateVehicleFleetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateVehicleFleet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateVehicleFleetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociateVehicleFleetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociateVehicleFleetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateVehicleFleetRequest, AssociateVehicleFleetResponse>()
                            .withOperationName("AssociateVehicleFleet")
                            .withMarshaller(new AssociateVehicleFleetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(associateVehicleFleetRequest));
            CompletableFuture<AssociateVehicleFleetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a group, or batch, of vehicles.
     * </p>
     * <note>
     * <p>
     * You must specify a decoder manifest and a vehicle model (model manifest) for each vehicle.
     * </p>
     * </note>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/create-vehicles-cli.html">Create multiple
     * vehicles (AWS CLI)</a> in the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.
     * </p>
     *
     * @param batchCreateVehicleRequest
     * @return A Java Future containing the result of the BatchCreateVehicle operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>LimitExceededException A service quota was exceeded.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.BatchCreateVehicle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/BatchCreateVehicle"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchCreateVehicleResponse> batchCreateVehicle(BatchCreateVehicleRequest batchCreateVehicleRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchCreateVehicleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchCreateVehicle");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchCreateVehicleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchCreateVehicleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchCreateVehicleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchCreateVehicleRequest, BatchCreateVehicleResponse>()
                            .withOperationName("BatchCreateVehicle")
                            .withMarshaller(new BatchCreateVehicleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(batchCreateVehicleRequest));
            CompletableFuture<BatchCreateVehicleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a group, or batch, of vehicles.
     * </p>
     * <note>
     * <p>
     * You must specify a decoder manifest and a vehicle model (model manifest) for each vehicle.
     * </p>
     * </note>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/update-vehicles-cli.html">Update multiple
     * vehicles (AWS CLI)</a> in the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.
     * </p>
     *
     * @param batchUpdateVehicleRequest
     * @return A Java Future containing the result of the BatchUpdateVehicle operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.BatchUpdateVehicle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/BatchUpdateVehicle"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchUpdateVehicleResponse> batchUpdateVehicle(BatchUpdateVehicleRequest batchUpdateVehicleRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchUpdateVehicleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchUpdateVehicle");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchUpdateVehicleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchUpdateVehicleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchUpdateVehicleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchUpdateVehicleRequest, BatchUpdateVehicleResponse>()
                            .withOperationName("BatchUpdateVehicle")
                            .withMarshaller(new BatchUpdateVehicleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(batchUpdateVehicleRequest));
            CompletableFuture<BatchUpdateVehicleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an orchestration of data collection rules. The Amazon Web Services IoT FleetWise Edge Agent software
     * running in vehicles uses campaigns to decide how to collect and transfer data to the cloud. You create campaigns
     * in the cloud. After you or your team approve campaigns, Amazon Web Services IoT FleetWise automatically deploys
     * them to vehicles.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/campaigns.html">Collect and transfer data
     * with campaigns</a> in the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.
     * </p>
     *
     * @param createCampaignRequest
     * @return A Java Future containing the result of the CreateCampaign operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>LimitExceededException A service quota was exceeded.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.CreateCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/CreateCampaign" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateCampaignResponse> createCampaign(CreateCampaignRequest createCampaignRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCampaignRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCampaign");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateCampaignResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateCampaignResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateCampaignResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateCampaignRequest, CreateCampaignResponse>()
                            .withOperationName("CreateCampaign")
                            .withMarshaller(new CreateCampaignRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createCampaignRequest));
            CompletableFuture<CreateCampaignResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates the decoder manifest associated with a model manifest. To create a decoder manifest, the following must
     * be true:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Every signal decoder has a unique name.
     * </p>
     * </li>
     * <li>
     * <p>
     * Each signal decoder is associated with a network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * Each network interface has a unique ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * The signal decoders are specified in the model manifest.
     * </p>
     * </li>
     * </ul>
     *
     * @param createDecoderManifestRequest
     * @return A Java Future containing the result of the CreateDecoderManifest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>LimitExceededException A service quota was exceeded.</li>
     *         <li>DecoderManifestValidationException The request couldn't be completed because it contains signal
     *         decoders with one or more validation errors.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.CreateDecoderManifest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/CreateDecoderManifest"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDecoderManifestResponse> createDecoderManifest(
            CreateDecoderManifestRequest createDecoderManifestRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDecoderManifestRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDecoderManifest");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDecoderManifestResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDecoderManifestResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDecoderManifestResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDecoderManifestRequest, CreateDecoderManifestResponse>()
                            .withOperationName("CreateDecoderManifest")
                            .withMarshaller(new CreateDecoderManifestRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createDecoderManifestRequest));
            CompletableFuture<CreateDecoderManifestResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a fleet that represents a group of vehicles.
     * </p>
     * <note>
     * <p>
     * You must create both a signal catalog and vehicles before you can create a fleet.
     * </p>
     * </note>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/fleets.html">Fleets</a> in the <i>Amazon
     * Web Services IoT FleetWise Developer Guide</i>.
     * </p>
     *
     * @param createFleetRequest
     * @return A Java Future containing the result of the CreateFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>LimitExceededException A service quota was exceeded.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.CreateFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/CreateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateFleetResponse> createFleet(CreateFleetRequest createFleetRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFleetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFleet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateFleetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateFleetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateFleetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateFleetRequest, CreateFleetResponse>()
                            .withOperationName("CreateFleet").withMarshaller(new CreateFleetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createFleetRequest));
            CompletableFuture<CreateFleetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a vehicle model (model manifest) that specifies signals (attributes, branches, sensors, and actuators).
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/vehicle-models.html">Vehicle models</a> in
     * the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.
     * </p>
     *
     * @param createModelManifestRequest
     * @return A Java Future containing the result of the CreateModelManifest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>LimitExceededException A service quota was exceeded.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InvalidSignalsException The request couldn't be completed because it contains signals that aren't
     *         valid.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.CreateModelManifest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/CreateModelManifest"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateModelManifestResponse> createModelManifest(
            CreateModelManifestRequest createModelManifestRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createModelManifestRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateModelManifest");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateModelManifestResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateModelManifestResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateModelManifestResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateModelManifestRequest, CreateModelManifestResponse>()
                            .withOperationName("CreateModelManifest")
                            .withMarshaller(new CreateModelManifestRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createModelManifestRequest));
            CompletableFuture<CreateModelManifestResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a collection of standardized signals that can be reused to create vehicle models.
     * </p>
     *
     * @param createSignalCatalogRequest
     * @return A Java Future containing the result of the CreateSignalCatalog operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>LimitExceededException A service quota was exceeded.</li>
     *         <li>InvalidNodeException The specified node type doesn't match the expected node type for a node. You can
     *         specify the node type as branch, sensor, actuator, or attribute.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InvalidSignalsException The request couldn't be completed because it contains signals that aren't
     *         valid.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.CreateSignalCatalog
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/CreateSignalCatalog"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSignalCatalogResponse> createSignalCatalog(
            CreateSignalCatalogRequest createSignalCatalogRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSignalCatalogRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSignalCatalog");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateSignalCatalogResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateSignalCatalogResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateSignalCatalogResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSignalCatalogRequest, CreateSignalCatalogResponse>()
                            .withOperationName("CreateSignalCatalog")
                            .withMarshaller(new CreateSignalCatalogRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createSignalCatalogRequest));
            CompletableFuture<CreateSignalCatalogResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a vehicle, which is an instance of a vehicle model (model manifest). Vehicles created from the same
     * vehicle model consist of the same signals inherited from the vehicle model.
     * </p>
     * <note>
     * <p>
     * If you have an existing Amazon Web Services IoT Thing, you can use Amazon Web Services IoT FleetWise to create a
     * vehicle and collect data from your thing.
     * </p>
     * </note>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/create-vehicle-cli.html">Create a vehicle
     * (AWS CLI)</a> in the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.
     * </p>
     *
     * @param createVehicleRequest
     * @return A Java Future containing the result of the CreateVehicle operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>LimitExceededException A service quota was exceeded.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.CreateVehicle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/CreateVehicle" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateVehicleResponse> createVehicle(CreateVehicleRequest createVehicleRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createVehicleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVehicle");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateVehicleResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateVehicleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateVehicleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateVehicleRequest, CreateVehicleResponse>()
                            .withOperationName("CreateVehicle")
                            .withMarshaller(new CreateVehicleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createVehicleRequest));
            CompletableFuture<CreateVehicleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a data collection campaign. Deleting a campaign suspends all data collection and removes it from any
     * vehicles.
     * </p>
     *
     * @param deleteCampaignRequest
     * @return A Java Future containing the result of the DeleteCampaign operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.DeleteCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/DeleteCampaign" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteCampaignResponse> deleteCampaign(DeleteCampaignRequest deleteCampaignRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCampaignRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCampaign");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteCampaignResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteCampaignResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteCampaignResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteCampaignRequest, DeleteCampaignResponse>()
                            .withOperationName("DeleteCampaign")
                            .withMarshaller(new DeleteCampaignRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteCampaignRequest));
            CompletableFuture<DeleteCampaignResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a decoder manifest. You can't delete a decoder manifest if it has vehicles associated with it.
     * </p>
     * <note>
     * <p>
     * If the decoder manifest is successfully deleted, Amazon Web Services IoT FleetWise sends back an HTTP 200
     * response with an empty body.
     * </p>
     * </note>
     *
     * @param deleteDecoderManifestRequest
     * @return A Java Future containing the result of the DeleteDecoderManifest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.DeleteDecoderManifest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/DeleteDecoderManifest"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDecoderManifestResponse> deleteDecoderManifest(
            DeleteDecoderManifestRequest deleteDecoderManifestRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDecoderManifestRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDecoderManifest");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDecoderManifestResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDecoderManifestResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteDecoderManifestResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDecoderManifestRequest, DeleteDecoderManifestResponse>()
                            .withOperationName("DeleteDecoderManifest")
                            .withMarshaller(new DeleteDecoderManifestRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteDecoderManifestRequest));
            CompletableFuture<DeleteDecoderManifestResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a fleet. Before you delete a fleet, all vehicles must be dissociated from the fleet. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/delete-fleet-cli.html">Delete a fleet (AWS
     * CLI)</a> in the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.
     * </p>
     * <note>
     * <p>
     * If the fleet is successfully deleted, Amazon Web Services IoT FleetWise sends back an HTTP 200 response with an
     * empty body.
     * </p>
     * </note>
     *
     * @param deleteFleetRequest
     * @return A Java Future containing the result of the DeleteFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.DeleteFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/DeleteFleet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteFleetResponse> deleteFleet(DeleteFleetRequest deleteFleetRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFleetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFleet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteFleetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteFleetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteFleetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteFleetRequest, DeleteFleetResponse>()
                            .withOperationName("DeleteFleet").withMarshaller(new DeleteFleetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteFleetRequest));
            CompletableFuture<DeleteFleetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a vehicle model (model manifest).
     * </p>
     * <note>
     * <p>
     * If the vehicle model is successfully deleted, Amazon Web Services IoT FleetWise sends back an HTTP 200 response
     * with an empty body.
     * </p>
     * </note>
     *
     * @param deleteModelManifestRequest
     * @return A Java Future containing the result of the DeleteModelManifest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.DeleteModelManifest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/DeleteModelManifest"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteModelManifestResponse> deleteModelManifest(
            DeleteModelManifestRequest deleteModelManifestRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteModelManifestRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteModelManifest");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteModelManifestResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteModelManifestResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteModelManifestResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteModelManifestRequest, DeleteModelManifestResponse>()
                            .withOperationName("DeleteModelManifest")
                            .withMarshaller(new DeleteModelManifestRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteModelManifestRequest));
            CompletableFuture<DeleteModelManifestResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a signal catalog.
     * </p>
     * <note>
     * <p>
     * If the signal catalog is successfully deleted, Amazon Web Services IoT FleetWise sends back an HTTP 200 response
     * with an empty body.
     * </p>
     * </note>
     *
     * @param deleteSignalCatalogRequest
     * @return A Java Future containing the result of the DeleteSignalCatalog operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.DeleteSignalCatalog
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/DeleteSignalCatalog"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSignalCatalogResponse> deleteSignalCatalog(
            DeleteSignalCatalogRequest deleteSignalCatalogRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSignalCatalogRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSignalCatalog");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteSignalCatalogResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteSignalCatalogResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteSignalCatalogResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteSignalCatalogRequest, DeleteSignalCatalogResponse>()
                            .withOperationName("DeleteSignalCatalog")
                            .withMarshaller(new DeleteSignalCatalogRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteSignalCatalogRequest));
            CompletableFuture<DeleteSignalCatalogResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a vehicle and removes it from any campaigns.
     * </p>
     * <note>
     * <p>
     * If the vehicle is successfully deleted, Amazon Web Services IoT FleetWise sends back an HTTP 200 response with an
     * empty body.
     * </p>
     * </note>
     *
     * @param deleteVehicleRequest
     * @return A Java Future containing the result of the DeleteVehicle operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.DeleteVehicle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/DeleteVehicle" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteVehicleResponse> deleteVehicle(DeleteVehicleRequest deleteVehicleRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteVehicleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVehicle");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteVehicleResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteVehicleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteVehicleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteVehicleRequest, DeleteVehicleResponse>()
                            .withOperationName("DeleteVehicle")
                            .withMarshaller(new DeleteVehicleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteVehicleRequest));
            CompletableFuture<DeleteVehicleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes, or disassociates, a vehicle from a fleet. Disassociating a vehicle from a fleet doesn't delete the
     * vehicle.
     * </p>
     * <note>
     * <p>
     * If the vehicle is successfully dissociated from a fleet, Amazon Web Services IoT FleetWise sends back an HTTP 200
     * response with an empty body.
     * </p>
     * </note>
     *
     * @param disassociateVehicleFleetRequest
     * @return A Java Future containing the result of the DisassociateVehicleFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.DisassociateVehicleFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/DisassociateVehicleFleet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateVehicleFleetResponse> disassociateVehicleFleet(
            DisassociateVehicleFleetRequest disassociateVehicleFleetRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateVehicleFleetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateVehicleFleet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateVehicleFleetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DisassociateVehicleFleetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociateVehicleFleetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateVehicleFleetRequest, DisassociateVehicleFleetResponse>()
                            .withOperationName("DisassociateVehicleFleet")
                            .withMarshaller(new DisassociateVehicleFleetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(disassociateVehicleFleetRequest));
            CompletableFuture<DisassociateVehicleFleetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about a campaign.
     * </p>
     *
     * @param getCampaignRequest
     * @return A Java Future containing the result of the GetCampaign operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.GetCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetCampaign" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetCampaignResponse> getCampaign(GetCampaignRequest getCampaignRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCampaignRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCampaign");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCampaignResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetCampaignResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetCampaignResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCampaignRequest, GetCampaignResponse>()
                            .withOperationName("GetCampaign").withMarshaller(new GetCampaignRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getCampaignRequest));
            CompletableFuture<GetCampaignResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about a created decoder manifest.
     * </p>
     *
     * @param getDecoderManifestRequest
     * @return A Java Future containing the result of the GetDecoderManifest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.GetDecoderManifest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetDecoderManifest"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetDecoderManifestResponse> getDecoderManifest(GetDecoderManifestRequest getDecoderManifestRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDecoderManifestRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDecoderManifest");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDecoderManifestResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDecoderManifestResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDecoderManifestResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDecoderManifestRequest, GetDecoderManifestResponse>()
                            .withOperationName("GetDecoderManifest")
                            .withMarshaller(new GetDecoderManifestRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getDecoderManifestRequest));
            CompletableFuture<GetDecoderManifestResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about a fleet.
     * </p>
     *
     * @param getFleetRequest
     * @return A Java Future containing the result of the GetFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.GetFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetFleet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetFleetResponse> getFleet(GetFleetRequest getFleetRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getFleetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetFleet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetFleetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetFleetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetFleetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetFleetRequest, GetFleetResponse>().withOperationName("GetFleet")
                            .withMarshaller(new GetFleetRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getFleetRequest));
            CompletableFuture<GetFleetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the logging options.
     * </p>
     *
     * @param getLoggingOptionsRequest
     * @return A Java Future containing the result of the GetLoggingOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.GetLoggingOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetLoggingOptions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetLoggingOptionsResponse> getLoggingOptions(GetLoggingOptionsRequest getLoggingOptionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getLoggingOptionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetLoggingOptions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetLoggingOptionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetLoggingOptionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetLoggingOptionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetLoggingOptionsRequest, GetLoggingOptionsResponse>()
                            .withOperationName("GetLoggingOptions")
                            .withMarshaller(new GetLoggingOptionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getLoggingOptionsRequest));
            CompletableFuture<GetLoggingOptionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about a vehicle model (model manifest).
     * </p>
     *
     * @param getModelManifestRequest
     * @return A Java Future containing the result of the GetModelManifest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.GetModelManifest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetModelManifest" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetModelManifestResponse> getModelManifest(GetModelManifestRequest getModelManifestRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getModelManifestRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetModelManifest");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetModelManifestResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetModelManifestResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetModelManifestResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetModelManifestRequest, GetModelManifestResponse>()
                            .withOperationName("GetModelManifest")
                            .withMarshaller(new GetModelManifestRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getModelManifestRequest));
            CompletableFuture<GetModelManifestResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the status of registering your Amazon Web Services account, IAM, and Amazon
     * Timestream resources so that Amazon Web Services IoT FleetWise can transfer your vehicle data to the Amazon Web
     * Services Cloud.
     * </p>
     * <p>
     * For more information, including step-by-step procedures, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/setting-up.html">Setting up Amazon Web
     * Services IoT FleetWise</a>.
     * </p>
     * <note>
     * <p>
     * This API operation doesn't require input parameters.
     * </p>
     * </note>
     *
     * @param getRegisterAccountStatusRequest
     * @return A Java Future containing the result of the GetRegisterAccountStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.GetRegisterAccountStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetRegisterAccountStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetRegisterAccountStatusResponse> getRegisterAccountStatus(
            GetRegisterAccountStatusRequest getRegisterAccountStatusRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRegisterAccountStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRegisterAccountStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRegisterAccountStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetRegisterAccountStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetRegisterAccountStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRegisterAccountStatusRequest, GetRegisterAccountStatusResponse>()
                            .withOperationName("GetRegisterAccountStatus")
                            .withMarshaller(new GetRegisterAccountStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getRegisterAccountStatusRequest));
            CompletableFuture<GetRegisterAccountStatusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about a signal catalog.
     * </p>
     *
     * @param getSignalCatalogRequest
     * @return A Java Future containing the result of the GetSignalCatalog operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.GetSignalCatalog
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetSignalCatalog" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetSignalCatalogResponse> getSignalCatalog(GetSignalCatalogRequest getSignalCatalogRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSignalCatalogRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSignalCatalog");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSignalCatalogResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetSignalCatalogResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSignalCatalogResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSignalCatalogRequest, GetSignalCatalogResponse>()
                            .withOperationName("GetSignalCatalog")
                            .withMarshaller(new GetSignalCatalogRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getSignalCatalogRequest));
            CompletableFuture<GetSignalCatalogResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about a vehicle.
     * </p>
     *
     * @param getVehicleRequest
     * @return A Java Future containing the result of the GetVehicle operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.GetVehicle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetVehicle" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetVehicleResponse> getVehicle(GetVehicleRequest getVehicleRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getVehicleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetVehicle");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetVehicleResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetVehicleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetVehicleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetVehicleRequest, GetVehicleResponse>().withOperationName("GetVehicle")
                            .withMarshaller(new GetVehicleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getVehicleRequest));
            CompletableFuture<GetVehicleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the status of a vehicle with any associated campaigns.
     * </p>
     *
     * @param getVehicleStatusRequest
     * @return A Java Future containing the result of the GetVehicleStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.GetVehicleStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetVehicleStatus" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetVehicleStatusResponse> getVehicleStatus(GetVehicleStatusRequest getVehicleStatusRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getVehicleStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetVehicleStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetVehicleStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetVehicleStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetVehicleStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetVehicleStatusRequest, GetVehicleStatusResponse>()
                            .withOperationName("GetVehicleStatus")
                            .withMarshaller(new GetVehicleStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getVehicleStatusRequest));
            CompletableFuture<GetVehicleStatusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the status of a vehicle with any associated campaigns.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getVehicleStatus(software.amazon.awssdk.services.iotfleetwise.model.GetVehicleStatusRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.GetVehicleStatusPublisher publisher = client.getVehicleStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.GetVehicleStatusPublisher publisher = client.getVehicleStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotfleetwise.model.GetVehicleStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotfleetwise.model.GetVehicleStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getVehicleStatus(software.amazon.awssdk.services.iotfleetwise.model.GetVehicleStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param getVehicleStatusRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.GetVehicleStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetVehicleStatus" target="_top">AWS
     *      API Documentation</a>
     */
    public GetVehicleStatusPublisher getVehicleStatusPaginator(GetVehicleStatusRequest getVehicleStatusRequest) {
        return new GetVehicleStatusPublisher(this, applyPaginatorUserAgent(getVehicleStatusRequest));
    }

    /**
     * <p>
     * Creates a decoder manifest using your existing CAN DBC file from your local device.
     * </p>
     *
     * @param importDecoderManifestRequest
     * @return A Java Future containing the result of the ImportDecoderManifest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>DecoderManifestValidationException The request couldn't be completed because it contains signal
     *         decoders with one or more validation errors.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InvalidSignalsException The request couldn't be completed because it contains signals that aren't
     *         valid.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ImportDecoderManifest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ImportDecoderManifest"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ImportDecoderManifestResponse> importDecoderManifest(
            ImportDecoderManifestRequest importDecoderManifestRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, importDecoderManifestRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ImportDecoderManifest");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ImportDecoderManifestResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ImportDecoderManifestResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ImportDecoderManifestResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ImportDecoderManifestRequest, ImportDecoderManifestResponse>()
                            .withOperationName("ImportDecoderManifest")
                            .withMarshaller(new ImportDecoderManifestRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(importDecoderManifestRequest));
            CompletableFuture<ImportDecoderManifestResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a signal catalog using your existing VSS formatted content from your local device.
     * </p>
     *
     * @param importSignalCatalogRequest
     * @return A Java Future containing the result of the ImportSignalCatalog operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>LimitExceededException A service quota was exceeded.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InvalidSignalsException The request couldn't be completed because it contains signals that aren't
     *         valid.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ImportSignalCatalog
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ImportSignalCatalog"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ImportSignalCatalogResponse> importSignalCatalog(
            ImportSignalCatalogRequest importSignalCatalogRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, importSignalCatalogRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ImportSignalCatalog");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ImportSignalCatalogResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ImportSignalCatalogResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ImportSignalCatalogResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ImportSignalCatalogRequest, ImportSignalCatalogResponse>()
                            .withOperationName("ImportSignalCatalog")
                            .withMarshaller(new ImportSignalCatalogRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(importSignalCatalogRequest));
            CompletableFuture<ImportSignalCatalogResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists information about created campaigns.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note>
     *
     * @param listCampaignsRequest
     * @return A Java Future containing the result of the ListCampaigns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListCampaigns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListCampaigns" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListCampaignsResponse> listCampaigns(ListCampaignsRequest listCampaignsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCampaignsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCampaigns");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCampaignsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListCampaignsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListCampaignsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCampaignsRequest, ListCampaignsResponse>()
                            .withOperationName("ListCampaigns")
                            .withMarshaller(new ListCampaignsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listCampaignsRequest));
            CompletableFuture<ListCampaignsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists information about created campaigns.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listCampaigns(software.amazon.awssdk.services.iotfleetwise.model.ListCampaignsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListCampaignsPublisher publisher = client.listCampaignsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListCampaignsPublisher publisher = client.listCampaignsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotfleetwise.model.ListCampaignsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotfleetwise.model.ListCampaignsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCampaigns(software.amazon.awssdk.services.iotfleetwise.model.ListCampaignsRequest)} operation.</b>
     * </p>
     *
     * @param listCampaignsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListCampaigns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListCampaigns" target="_top">AWS
     *      API Documentation</a>
     */
    public ListCampaignsPublisher listCampaignsPaginator(ListCampaignsRequest listCampaignsRequest) {
        return new ListCampaignsPublisher(this, applyPaginatorUserAgent(listCampaignsRequest));
    }

    /**
     * <p>
     * Lists the network interfaces specified in a decoder manifest.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note>
     *
     * @param listDecoderManifestNetworkInterfacesRequest
     * @return A Java Future containing the result of the ListDecoderManifestNetworkInterfaces operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListDecoderManifestNetworkInterfaces
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListDecoderManifestNetworkInterfaces"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListDecoderManifestNetworkInterfacesResponse> listDecoderManifestNetworkInterfaces(
            ListDecoderManifestNetworkInterfacesRequest listDecoderManifestNetworkInterfacesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listDecoderManifestNetworkInterfacesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDecoderManifestNetworkInterfaces");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDecoderManifestNetworkInterfacesResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListDecoderManifestNetworkInterfacesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDecoderManifestNetworkInterfacesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDecoderManifestNetworkInterfacesRequest, ListDecoderManifestNetworkInterfacesResponse>()
                            .withOperationName("ListDecoderManifestNetworkInterfaces")
                            .withMarshaller(new ListDecoderManifestNetworkInterfacesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listDecoderManifestNetworkInterfacesRequest));
            CompletableFuture<ListDecoderManifestNetworkInterfacesResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the network interfaces specified in a decoder manifest.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listDecoderManifestNetworkInterfaces(software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestNetworkInterfacesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListDecoderManifestNetworkInterfacesPublisher publisher = client.listDecoderManifestNetworkInterfacesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListDecoderManifestNetworkInterfacesPublisher publisher = client.listDecoderManifestNetworkInterfacesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestNetworkInterfacesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestNetworkInterfacesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDecoderManifestNetworkInterfaces(software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestNetworkInterfacesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDecoderManifestNetworkInterfacesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListDecoderManifestNetworkInterfaces
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListDecoderManifestNetworkInterfaces"
     *      target="_top">AWS API Documentation</a>
     */
    public ListDecoderManifestNetworkInterfacesPublisher listDecoderManifestNetworkInterfacesPaginator(
            ListDecoderManifestNetworkInterfacesRequest listDecoderManifestNetworkInterfacesRequest) {
        return new ListDecoderManifestNetworkInterfacesPublisher(this,
                applyPaginatorUserAgent(listDecoderManifestNetworkInterfacesRequest));
    }

    /**
     * <p>
     * A list of information about signal decoders specified in a decoder manifest.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note>
     *
     * @param listDecoderManifestSignalsRequest
     * @return A Java Future containing the result of the ListDecoderManifestSignals operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListDecoderManifestSignals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListDecoderManifestSignals"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListDecoderManifestSignalsResponse> listDecoderManifestSignals(
            ListDecoderManifestSignalsRequest listDecoderManifestSignalsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDecoderManifestSignalsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDecoderManifestSignals");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDecoderManifestSignalsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListDecoderManifestSignalsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDecoderManifestSignalsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDecoderManifestSignalsRequest, ListDecoderManifestSignalsResponse>()
                            .withOperationName("ListDecoderManifestSignals")
                            .withMarshaller(new ListDecoderManifestSignalsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listDecoderManifestSignalsRequest));
            CompletableFuture<ListDecoderManifestSignalsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * A list of information about signal decoders specified in a decoder manifest.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listDecoderManifestSignals(software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestSignalsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListDecoderManifestSignalsPublisher publisher = client.listDecoderManifestSignalsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListDecoderManifestSignalsPublisher publisher = client.listDecoderManifestSignalsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestSignalsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestSignalsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDecoderManifestSignals(software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestSignalsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDecoderManifestSignalsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListDecoderManifestSignals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListDecoderManifestSignals"
     *      target="_top">AWS API Documentation</a>
     */
    public ListDecoderManifestSignalsPublisher listDecoderManifestSignalsPaginator(
            ListDecoderManifestSignalsRequest listDecoderManifestSignalsRequest) {
        return new ListDecoderManifestSignalsPublisher(this, applyPaginatorUserAgent(listDecoderManifestSignalsRequest));
    }

    /**
     * <p>
     * Lists decoder manifests.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note>
     *
     * @param listDecoderManifestsRequest
     * @return A Java Future containing the result of the ListDecoderManifests operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListDecoderManifests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListDecoderManifests"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListDecoderManifestsResponse> listDecoderManifests(
            ListDecoderManifestsRequest listDecoderManifestsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDecoderManifestsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDecoderManifests");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDecoderManifestsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListDecoderManifestsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDecoderManifestsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDecoderManifestsRequest, ListDecoderManifestsResponse>()
                            .withOperationName("ListDecoderManifests")
                            .withMarshaller(new ListDecoderManifestsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listDecoderManifestsRequest));
            CompletableFuture<ListDecoderManifestsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists decoder manifests.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listDecoderManifests(software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListDecoderManifestsPublisher publisher = client.listDecoderManifestsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListDecoderManifestsPublisher publisher = client.listDecoderManifestsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDecoderManifests(software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDecoderManifestsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListDecoderManifests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListDecoderManifests"
     *      target="_top">AWS API Documentation</a>
     */
    public ListDecoderManifestsPublisher listDecoderManifestsPaginator(ListDecoderManifestsRequest listDecoderManifestsRequest) {
        return new ListDecoderManifestsPublisher(this, applyPaginatorUserAgent(listDecoderManifestsRequest));
    }

    /**
     * <p>
     * Retrieves information for each created fleet in an Amazon Web Services account.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note>
     *
     * @param listFleetsRequest
     * @return A Java Future containing the result of the ListFleets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListFleets" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListFleetsResponse> listFleets(ListFleetsRequest listFleetsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFleetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFleets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListFleetsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListFleetsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListFleetsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListFleetsRequest, ListFleetsResponse>().withOperationName("ListFleets")
                            .withMarshaller(new ListFleetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listFleetsRequest));
            CompletableFuture<ListFleetsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a list of IDs for all fleets that the vehicle is associated with.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note>
     *
     * @param listFleetsForVehicleRequest
     * @return A Java Future containing the result of the ListFleetsForVehicle operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListFleetsForVehicle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListFleetsForVehicle"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListFleetsForVehicleResponse> listFleetsForVehicle(
            ListFleetsForVehicleRequest listFleetsForVehicleRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFleetsForVehicleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFleetsForVehicle");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListFleetsForVehicleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListFleetsForVehicleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListFleetsForVehicleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListFleetsForVehicleRequest, ListFleetsForVehicleResponse>()
                            .withOperationName("ListFleetsForVehicle")
                            .withMarshaller(new ListFleetsForVehicleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listFleetsForVehicleRequest));
            CompletableFuture<ListFleetsForVehicleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a list of IDs for all fleets that the vehicle is associated with.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listFleetsForVehicle(software.amazon.awssdk.services.iotfleetwise.model.ListFleetsForVehicleRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListFleetsForVehiclePublisher publisher = client.listFleetsForVehiclePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListFleetsForVehiclePublisher publisher = client.listFleetsForVehiclePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotfleetwise.model.ListFleetsForVehicleResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotfleetwise.model.ListFleetsForVehicleResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFleetsForVehicle(software.amazon.awssdk.services.iotfleetwise.model.ListFleetsForVehicleRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFleetsForVehicleRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListFleetsForVehicle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListFleetsForVehicle"
     *      target="_top">AWS API Documentation</a>
     */
    public ListFleetsForVehiclePublisher listFleetsForVehiclePaginator(ListFleetsForVehicleRequest listFleetsForVehicleRequest) {
        return new ListFleetsForVehiclePublisher(this, applyPaginatorUserAgent(listFleetsForVehicleRequest));
    }

    /**
     * <p>
     * Retrieves information for each created fleet in an Amazon Web Services account.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of {@link #listFleets(software.amazon.awssdk.services.iotfleetwise.model.ListFleetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListFleetsPublisher publisher = client.listFleetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListFleetsPublisher publisher = client.listFleetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotfleetwise.model.ListFleetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotfleetwise.model.ListFleetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFleets(software.amazon.awssdk.services.iotfleetwise.model.ListFleetsRequest)} operation.</b>
     * </p>
     *
     * @param listFleetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListFleets" target="_top">AWS API
     *      Documentation</a>
     */
    public ListFleetsPublisher listFleetsPaginator(ListFleetsRequest listFleetsRequest) {
        return new ListFleetsPublisher(this, applyPaginatorUserAgent(listFleetsRequest));
    }

    /**
     * <p>
     * Lists information about nodes specified in a vehicle model (model manifest).
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note>
     *
     * @param listModelManifestNodesRequest
     * @return A Java Future containing the result of the ListModelManifestNodes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>LimitExceededException A service quota was exceeded.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListModelManifestNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListModelManifestNodes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListModelManifestNodesResponse> listModelManifestNodes(
            ListModelManifestNodesRequest listModelManifestNodesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listModelManifestNodesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListModelManifestNodes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListModelManifestNodesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListModelManifestNodesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListModelManifestNodesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListModelManifestNodesRequest, ListModelManifestNodesResponse>()
                            .withOperationName("ListModelManifestNodes")
                            .withMarshaller(new ListModelManifestNodesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listModelManifestNodesRequest));
            CompletableFuture<ListModelManifestNodesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists information about nodes specified in a vehicle model (model manifest).
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listModelManifestNodes(software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestNodesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListModelManifestNodesPublisher publisher = client.listModelManifestNodesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListModelManifestNodesPublisher publisher = client.listModelManifestNodesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestNodesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestNodesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listModelManifestNodes(software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestNodesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listModelManifestNodesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>LimitExceededException A service quota was exceeded.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListModelManifestNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListModelManifestNodes"
     *      target="_top">AWS API Documentation</a>
     */
    public ListModelManifestNodesPublisher listModelManifestNodesPaginator(
            ListModelManifestNodesRequest listModelManifestNodesRequest) {
        return new ListModelManifestNodesPublisher(this, applyPaginatorUserAgent(listModelManifestNodesRequest));
    }

    /**
     * <p>
     * Retrieves a list of vehicle models (model manifests).
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note>
     *
     * @param listModelManifestsRequest
     * @return A Java Future containing the result of the ListModelManifests operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListModelManifests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListModelManifests"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListModelManifestsResponse> listModelManifests(ListModelManifestsRequest listModelManifestsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listModelManifestsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListModelManifests");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListModelManifestsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListModelManifestsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListModelManifestsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListModelManifestsRequest, ListModelManifestsResponse>()
                            .withOperationName("ListModelManifests")
                            .withMarshaller(new ListModelManifestsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listModelManifestsRequest));
            CompletableFuture<ListModelManifestsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a list of vehicle models (model manifests).
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listModelManifests(software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListModelManifestsPublisher publisher = client.listModelManifestsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListModelManifestsPublisher publisher = client.listModelManifestsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listModelManifests(software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listModelManifestsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListModelManifests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListModelManifests"
     *      target="_top">AWS API Documentation</a>
     */
    public ListModelManifestsPublisher listModelManifestsPaginator(ListModelManifestsRequest listModelManifestsRequest) {
        return new ListModelManifestsPublisher(this, applyPaginatorUserAgent(listModelManifestsRequest));
    }

    /**
     * <p>
     * Lists of information about the signals (nodes) specified in a signal catalog.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note>
     *
     * @param listSignalCatalogNodesRequest
     * @return A Java Future containing the result of the ListSignalCatalogNodes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>LimitExceededException A service quota was exceeded.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListSignalCatalogNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListSignalCatalogNodes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListSignalCatalogNodesResponse> listSignalCatalogNodes(
            ListSignalCatalogNodesRequest listSignalCatalogNodesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSignalCatalogNodesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSignalCatalogNodes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListSignalCatalogNodesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListSignalCatalogNodesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListSignalCatalogNodesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListSignalCatalogNodesRequest, ListSignalCatalogNodesResponse>()
                            .withOperationName("ListSignalCatalogNodes")
                            .withMarshaller(new ListSignalCatalogNodesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listSignalCatalogNodesRequest));
            CompletableFuture<ListSignalCatalogNodesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists of information about the signals (nodes) specified in a signal catalog.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listSignalCatalogNodes(software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogNodesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListSignalCatalogNodesPublisher publisher = client.listSignalCatalogNodesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListSignalCatalogNodesPublisher publisher = client.listSignalCatalogNodesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogNodesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogNodesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSignalCatalogNodes(software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogNodesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSignalCatalogNodesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>LimitExceededException A service quota was exceeded.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListSignalCatalogNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListSignalCatalogNodes"
     *      target="_top">AWS API Documentation</a>
     */
    public ListSignalCatalogNodesPublisher listSignalCatalogNodesPaginator(
            ListSignalCatalogNodesRequest listSignalCatalogNodesRequest) {
        return new ListSignalCatalogNodesPublisher(this, applyPaginatorUserAgent(listSignalCatalogNodesRequest));
    }

    /**
     * <p>
     * Lists all the created signal catalogs in an Amazon Web Services account.
     * </p>
     * <p>
     * You can use to list information about each signal (node) specified in a signal catalog.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note>
     *
     * @param listSignalCatalogsRequest
     * @return A Java Future containing the result of the ListSignalCatalogs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListSignalCatalogs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListSignalCatalogs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListSignalCatalogsResponse> listSignalCatalogs(ListSignalCatalogsRequest listSignalCatalogsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSignalCatalogsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSignalCatalogs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListSignalCatalogsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListSignalCatalogsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListSignalCatalogsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListSignalCatalogsRequest, ListSignalCatalogsResponse>()
                            .withOperationName("ListSignalCatalogs")
                            .withMarshaller(new ListSignalCatalogsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listSignalCatalogsRequest));
            CompletableFuture<ListSignalCatalogsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all the created signal catalogs in an Amazon Web Services account.
     * </p>
     * <p>
     * You can use to list information about each signal (node) specified in a signal catalog.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listSignalCatalogs(software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListSignalCatalogsPublisher publisher = client.listSignalCatalogsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListSignalCatalogsPublisher publisher = client.listSignalCatalogsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSignalCatalogs(software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSignalCatalogsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListSignalCatalogs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListSignalCatalogs"
     *      target="_top">AWS API Documentation</a>
     */
    public ListSignalCatalogsPublisher listSignalCatalogsPaginator(ListSignalCatalogsRequest listSignalCatalogsRequest) {
        return new ListSignalCatalogsPublisher(this, applyPaginatorUserAgent(listSignalCatalogsRequest));
    }

    /**
     * <p>
     * Lists the tags (metadata) you have assigned to the resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource")
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a list of summaries of created vehicles.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note>
     *
     * @param listVehiclesRequest
     * @return A Java Future containing the result of the ListVehicles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListVehicles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListVehicles" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListVehiclesResponse> listVehicles(ListVehiclesRequest listVehiclesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listVehiclesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListVehicles");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListVehiclesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListVehiclesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListVehiclesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListVehiclesRequest, ListVehiclesResponse>()
                            .withOperationName("ListVehicles").withMarshaller(new ListVehiclesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listVehiclesRequest));
            CompletableFuture<ListVehiclesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a list of summaries of all vehicles associated with a fleet.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note>
     *
     * @param listVehiclesInFleetRequest
     * @return A Java Future containing the result of the ListVehiclesInFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListVehiclesInFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListVehiclesInFleet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListVehiclesInFleetResponse> listVehiclesInFleet(
            ListVehiclesInFleetRequest listVehiclesInFleetRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listVehiclesInFleetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListVehiclesInFleet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListVehiclesInFleetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListVehiclesInFleetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListVehiclesInFleetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListVehiclesInFleetRequest, ListVehiclesInFleetResponse>()
                            .withOperationName("ListVehiclesInFleet")
                            .withMarshaller(new ListVehiclesInFleetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listVehiclesInFleetRequest));
            CompletableFuture<ListVehiclesInFleetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a list of summaries of all vehicles associated with a fleet.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listVehiclesInFleet(software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesInFleetRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListVehiclesInFleetPublisher publisher = client.listVehiclesInFleetPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListVehiclesInFleetPublisher publisher = client.listVehiclesInFleetPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesInFleetResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesInFleetResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVehiclesInFleet(software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesInFleetRequest)}
     * operation.</b>
     * </p>
     *
     * @param listVehiclesInFleetRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListVehiclesInFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListVehiclesInFleet"
     *      target="_top">AWS API Documentation</a>
     */
    public ListVehiclesInFleetPublisher listVehiclesInFleetPaginator(ListVehiclesInFleetRequest listVehiclesInFleetRequest) {
        return new ListVehiclesInFleetPublisher(this, applyPaginatorUserAgent(listVehiclesInFleetRequest));
    }

    /**
     * <p>
     * Retrieves a list of summaries of created vehicles.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listVehicles(software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListVehiclesPublisher publisher = client.listVehiclesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListVehiclesPublisher publisher = client.listVehiclesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVehicles(software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesRequest)} operation.</b>
     * </p>
     *
     * @param listVehiclesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListVehicles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListVehicles" target="_top">AWS API
     *      Documentation</a>
     */
    public ListVehiclesPublisher listVehiclesPaginator(ListVehiclesRequest listVehiclesRequest) {
        return new ListVehiclesPublisher(this, applyPaginatorUserAgent(listVehiclesRequest));
    }

    /**
     * <p>
     * Creates or updates the logging option.
     * </p>
     *
     * @param putLoggingOptionsRequest
     * @return A Java Future containing the result of the PutLoggingOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.PutLoggingOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/PutLoggingOptions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutLoggingOptionsResponse> putLoggingOptions(PutLoggingOptionsRequest putLoggingOptionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putLoggingOptionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutLoggingOptions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutLoggingOptionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutLoggingOptionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutLoggingOptionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutLoggingOptionsRequest, PutLoggingOptionsResponse>()
                            .withOperationName("PutLoggingOptions")
                            .withMarshaller(new PutLoggingOptionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(putLoggingOptionsRequest));
            CompletableFuture<PutLoggingOptionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Registers your Amazon Web Services account, IAM, and Amazon Timestream resources so Amazon Web Services IoT
     * FleetWise can transfer your vehicle data to the Amazon Web Services Cloud. For more information, including
     * step-by-step procedures, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/setting-up.html">Setting up Amazon Web
     * Services IoT FleetWise</a>.
     * </p>
     * <note>
     * <p>
     * An Amazon Web Services account is <b>not</b> the same thing as a "user account". An <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/introduction_identity-management.html#intro-identity-users"
     * >Amazon Web Services user</a> is an identity that you create using Identity and Access Management (IAM) and takes
     * the form of either an <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users.html">IAM user</a> or an
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM role, both with credentials</a>. A
     * single Amazon Web Services account can, and typically does, contain many users and roles.
     * </p>
     * </note>
     *
     * @param registerAccountRequest
     * @return A Java Future containing the result of the RegisterAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.RegisterAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/RegisterAccount" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<RegisterAccountResponse> registerAccount(RegisterAccountRequest registerAccountRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, registerAccountRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RegisterAccount");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RegisterAccountResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RegisterAccountResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RegisterAccountResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RegisterAccountRequest, RegisterAccountResponse>()
                            .withOperationName("RegisterAccount")
                            .withMarshaller(new RegisterAccountRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(registerAccountRequest));
            CompletableFuture<RegisterAccountResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds to or modifies the tags of the given resource. Tags are metadata which can be used to manage a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the given tags (metadata) from the resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource")
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a campaign.
     * </p>
     *
     * @param updateCampaignRequest
     * @return A Java Future containing the result of the UpdateCampaign operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.UpdateCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/UpdateCampaign" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateCampaignResponse> updateCampaign(UpdateCampaignRequest updateCampaignRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateCampaignRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCampaign");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateCampaignResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateCampaignResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateCampaignResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateCampaignRequest, UpdateCampaignResponse>()
                            .withOperationName("UpdateCampaign")
                            .withMarshaller(new UpdateCampaignRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateCampaignRequest));
            CompletableFuture<UpdateCampaignResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a decoder manifest.
     * </p>
     * <p>
     * A decoder manifest can only be updated when the status is <code>DRAFT</code>. Only <code>ACTIVE</code> decoder
     * manifests can be associated with vehicles.
     * </p>
     *
     * @param updateDecoderManifestRequest
     * @return A Java Future containing the result of the UpdateDecoderManifest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>LimitExceededException A service quota was exceeded.</li>
     *         <li>DecoderManifestValidationException The request couldn't be completed because it contains signal
     *         decoders with one or more validation errors.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.UpdateDecoderManifest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/UpdateDecoderManifest"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateDecoderManifestResponse> updateDecoderManifest(
            UpdateDecoderManifestRequest updateDecoderManifestRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDecoderManifestRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDecoderManifest");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateDecoderManifestResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateDecoderManifestResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateDecoderManifestResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateDecoderManifestRequest, UpdateDecoderManifestResponse>()
                            .withOperationName("UpdateDecoderManifest")
                            .withMarshaller(new UpdateDecoderManifestRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateDecoderManifestRequest));
            CompletableFuture<UpdateDecoderManifestResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the description of an existing fleet.
     * </p>
     * <note>
     * <p>
     * If the fleet is successfully updated, Amazon Web Services IoT FleetWise sends back an HTTP 200 response with an
     * empty HTTP body.
     * </p>
     * </note>
     *
     * @param updateFleetRequest
     * @return A Java Future containing the result of the UpdateFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.UpdateFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/UpdateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateFleetResponse> updateFleet(UpdateFleetRequest updateFleetRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateFleetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFleet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateFleetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateFleetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateFleetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateFleetRequest, UpdateFleetResponse>()
                            .withOperationName("UpdateFleet").withMarshaller(new UpdateFleetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateFleetRequest));
            CompletableFuture<UpdateFleetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a vehicle model (model manifest). If created vehicles are associated with a vehicle model, it can't be
     * updated.
     * </p>
     *
     * @param updateModelManifestRequest
     * @return A Java Future containing the result of the UpdateModelManifest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InvalidSignalsException The request couldn't be completed because it contains signals that aren't
     *         valid.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.UpdateModelManifest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/UpdateModelManifest"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateModelManifestResponse> updateModelManifest(
            UpdateModelManifestRequest updateModelManifestRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateModelManifestRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateModelManifest");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateModelManifestResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateModelManifestResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateModelManifestResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateModelManifestRequest, UpdateModelManifestResponse>()
                            .withOperationName("UpdateModelManifest")
                            .withMarshaller(new UpdateModelManifestRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateModelManifestRequest));
            CompletableFuture<UpdateModelManifestResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a signal catalog.
     * </p>
     *
     * @param updateSignalCatalogRequest
     * @return A Java Future containing the result of the UpdateSignalCatalog operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>LimitExceededException A service quota was exceeded.</li>
     *         <li>InvalidNodeException The specified node type doesn't match the expected node type for a node. You can
     *         specify the node type as branch, sensor, actuator, or attribute.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>InvalidSignalsException The request couldn't be completed because it contains signals that aren't
     *         valid.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.UpdateSignalCatalog
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/UpdateSignalCatalog"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateSignalCatalogResponse> updateSignalCatalog(
            UpdateSignalCatalogRequest updateSignalCatalogRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSignalCatalogRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSignalCatalog");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateSignalCatalogResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateSignalCatalogResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateSignalCatalogResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateSignalCatalogRequest, UpdateSignalCatalogResponse>()
                            .withOperationName("UpdateSignalCatalog")
                            .withMarshaller(new UpdateSignalCatalogRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateSignalCatalogRequest));
            CompletableFuture<UpdateSignalCatalogResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a vehicle.
     * </p>
     *
     * @param updateVehicleRequest
     * @return A Java Future containing the result of the UpdateVehicle operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.UpdateVehicle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/UpdateVehicle" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateVehicleResponse> updateVehicle(UpdateVehicleRequest updateVehicleRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateVehicleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateVehicle");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateVehicleResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateVehicleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateVehicleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateVehicleRequest, UpdateVehicleResponse>()
                            .withOperationName("UpdateVehicle")
                            .withMarshaller(new UpdateVehicleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateVehicleRequest));
            CompletableFuture<UpdateVehicleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(IoTFleetWiseException::builder)
                .protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.0")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DecoderManifestValidationException")
                                .exceptionBuilderSupplier(DecoderManifestValidationException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerException")
                                .exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidSignalsException")
                                .exceptionBuilderSupplier(InvalidSignalsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LimitExceededException")
                                .exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidNodeException")
                                .exceptionBuilderSupplier(InvalidNodeException::builder).httpStatusCode(400).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private <T extends IoTFleetWiseRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }
}
