/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A signal that represents a vehicle device such as the engine, heater, and door locks. Data from an actuator reports
 * the state of a certain vehicle device.
 * </p>
 * <note>
 * <p>
 * Updating actuator data can change the state of a device. For example, you can turn on or off the heater by updating
 * its actuator data.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Actuator implements SdkPojo, Serializable, ToCopyableBuilder<Actuator.Builder, Actuator> {
    private static final SdkField<String> FULLY_QUALIFIED_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fullyQualifiedName").getter(getter(Actuator::fullyQualifiedName))
            .setter(setter(Builder::fullyQualifiedName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fullyQualifiedName").build())
            .build();

    private static final SdkField<String> DATA_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataType").getter(getter(Actuator::dataTypeAsString)).setter(setter(Builder::dataType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataType").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(Actuator::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("unit")
            .getter(getter(Actuator::unit)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unit").build()).build();

    private static final SdkField<List<String>> ALLOWED_VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("allowedValues")
            .getter(getter(Actuator::allowedValues))
            .setter(setter(Builder::allowedValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Double> MIN_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("min")
            .getter(getter(Actuator::min)).setter(setter(Builder::min))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("min").build()).build();

    private static final SdkField<Double> MAX_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("max")
            .getter(getter(Actuator::max)).setter(setter(Builder::max))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("max").build()).build();

    private static final SdkField<String> ASSIGNED_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assignedValue").getter(getter(Actuator::assignedValue)).setter(setter(Builder::assignedValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assignedValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FULLY_QUALIFIED_NAME_FIELD,
            DATA_TYPE_FIELD, DESCRIPTION_FIELD, UNIT_FIELD, ALLOWED_VALUES_FIELD, MIN_FIELD, MAX_FIELD, ASSIGNED_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fullyQualifiedName;

    private final String dataType;

    private final String description;

    private final String unit;

    private final List<String> allowedValues;

    private final Double min;

    private final Double max;

    private final String assignedValue;

    private Actuator(BuilderImpl builder) {
        this.fullyQualifiedName = builder.fullyQualifiedName;
        this.dataType = builder.dataType;
        this.description = builder.description;
        this.unit = builder.unit;
        this.allowedValues = builder.allowedValues;
        this.min = builder.min;
        this.max = builder.max;
        this.assignedValue = builder.assignedValue;
    }

    /**
     * <p>
     * The fully qualified name of the actuator. For example, the fully qualified name of an actuator might be
     * <code>Vehicle.Front.Left.Door.Lock</code>.
     * </p>
     * 
     * @return The fully qualified name of the actuator. For example, the fully qualified name of an actuator might be
     *         <code>Vehicle.Front.Left.Door.Lock</code>.
     */
    public final String fullyQualifiedName() {
        return fullyQualifiedName;
    }

    /**
     * <p>
     * The specified data type of the actuator.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataType} will
     * return {@link NodeDataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataTypeAsString}.
     * </p>
     * 
     * @return The specified data type of the actuator.
     * @see NodeDataType
     */
    public final NodeDataType dataType() {
        return NodeDataType.fromValue(dataType);
    }

    /**
     * <p>
     * The specified data type of the actuator.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataType} will
     * return {@link NodeDataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataTypeAsString}.
     * </p>
     * 
     * @return The specified data type of the actuator.
     * @see NodeDataType
     */
    public final String dataTypeAsString() {
        return dataType;
    }

    /**
     * <p>
     * A brief description of the actuator.
     * </p>
     * 
     * @return A brief description of the actuator.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The scientific unit for the actuator.
     * </p>
     * 
     * @return The scientific unit for the actuator.
     */
    public final String unit() {
        return unit;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAllowedValues() {
        return allowedValues != null && !(allowedValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of possible values an actuator can take.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedValues} method.
     * </p>
     * 
     * @return A list of possible values an actuator can take.
     */
    public final List<String> allowedValues() {
        return allowedValues;
    }

    /**
     * <p>
     * The specified possible minimum value of an actuator.
     * </p>
     * 
     * @return The specified possible minimum value of an actuator.
     */
    public final Double min() {
        return min;
    }

    /**
     * <p>
     * The specified possible maximum value of an actuator.
     * </p>
     * 
     * @return The specified possible maximum value of an actuator.
     */
    public final Double max() {
        return max;
    }

    /**
     * <p>
     * A specified value for the actuator.
     * </p>
     * 
     * @return A specified value for the actuator.
     * @deprecated assignedValue is no longer in use
     */
    @Deprecated
    public final String assignedValue() {
        return assignedValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fullyQualifiedName());
        hashCode = 31 * hashCode + Objects.hashCode(dataTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(unit());
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedValues() ? allowedValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(min());
        hashCode = 31 * hashCode + Objects.hashCode(max());
        hashCode = 31 * hashCode + Objects.hashCode(assignedValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Actuator)) {
            return false;
        }
        Actuator other = (Actuator) obj;
        return Objects.equals(fullyQualifiedName(), other.fullyQualifiedName())
                && Objects.equals(dataTypeAsString(), other.dataTypeAsString())
                && Objects.equals(description(), other.description()) && Objects.equals(unit(), other.unit())
                && hasAllowedValues() == other.hasAllowedValues() && Objects.equals(allowedValues(), other.allowedValues())
                && Objects.equals(min(), other.min()) && Objects.equals(max(), other.max())
                && Objects.equals(assignedValue(), other.assignedValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Actuator").add("FullyQualifiedName", fullyQualifiedName()).add("DataType", dataTypeAsString())
                .add("Description", description()).add("Unit", unit())
                .add("AllowedValues", hasAllowedValues() ? allowedValues() : null).add("Min", min()).add("Max", max())
                .add("AssignedValue", assignedValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fullyQualifiedName":
            return Optional.ofNullable(clazz.cast(fullyQualifiedName()));
        case "dataType":
            return Optional.ofNullable(clazz.cast(dataTypeAsString()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "unit":
            return Optional.ofNullable(clazz.cast(unit()));
        case "allowedValues":
            return Optional.ofNullable(clazz.cast(allowedValues()));
        case "min":
            return Optional.ofNullable(clazz.cast(min()));
        case "max":
            return Optional.ofNullable(clazz.cast(max()));
        case "assignedValue":
            return Optional.ofNullable(clazz.cast(assignedValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Actuator, T> g) {
        return obj -> g.apply((Actuator) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Actuator> {
        /**
         * <p>
         * The fully qualified name of the actuator. For example, the fully qualified name of an actuator might be
         * <code>Vehicle.Front.Left.Door.Lock</code>.
         * </p>
         * 
         * @param fullyQualifiedName
         *        The fully qualified name of the actuator. For example, the fully qualified name of an actuator might
         *        be <code>Vehicle.Front.Left.Door.Lock</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fullyQualifiedName(String fullyQualifiedName);

        /**
         * <p>
         * The specified data type of the actuator.
         * </p>
         * 
         * @param dataType
         *        The specified data type of the actuator.
         * @see NodeDataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeDataType
         */
        Builder dataType(String dataType);

        /**
         * <p>
         * The specified data type of the actuator.
         * </p>
         * 
         * @param dataType
         *        The specified data type of the actuator.
         * @see NodeDataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeDataType
         */
        Builder dataType(NodeDataType dataType);

        /**
         * <p>
         * A brief description of the actuator.
         * </p>
         * 
         * @param description
         *        A brief description of the actuator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The scientific unit for the actuator.
         * </p>
         * 
         * @param unit
         *        The scientific unit for the actuator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unit(String unit);

        /**
         * <p>
         * A list of possible values an actuator can take.
         * </p>
         * 
         * @param allowedValues
         *        A list of possible values an actuator can take.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedValues(Collection<String> allowedValues);

        /**
         * <p>
         * A list of possible values an actuator can take.
         * </p>
         * 
         * @param allowedValues
         *        A list of possible values an actuator can take.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedValues(String... allowedValues);

        /**
         * <p>
         * The specified possible minimum value of an actuator.
         * </p>
         * 
         * @param min
         *        The specified possible minimum value of an actuator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder min(Double min);

        /**
         * <p>
         * The specified possible maximum value of an actuator.
         * </p>
         * 
         * @param max
         *        The specified possible maximum value of an actuator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder max(Double max);

        /**
         * <p>
         * A specified value for the actuator.
         * </p>
         * 
         * @param assignedValue
         *        A specified value for the actuator.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated assignedValue is no longer in use
         */
        @Deprecated
        Builder assignedValue(String assignedValue);
    }

    static final class BuilderImpl implements Builder {
        private String fullyQualifiedName;

        private String dataType;

        private String description;

        private String unit;

        private List<String> allowedValues = DefaultSdkAutoConstructList.getInstance();

        private Double min;

        private Double max;

        private String assignedValue;

        private BuilderImpl() {
        }

        private BuilderImpl(Actuator model) {
            fullyQualifiedName(model.fullyQualifiedName);
            dataType(model.dataType);
            description(model.description);
            unit(model.unit);
            allowedValues(model.allowedValues);
            min(model.min);
            max(model.max);
            assignedValue(model.assignedValue);
        }

        public final String getFullyQualifiedName() {
            return fullyQualifiedName;
        }

        public final void setFullyQualifiedName(String fullyQualifiedName) {
            this.fullyQualifiedName = fullyQualifiedName;
        }

        @Override
        public final Builder fullyQualifiedName(String fullyQualifiedName) {
            this.fullyQualifiedName = fullyQualifiedName;
            return this;
        }

        public final String getDataType() {
            return dataType;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        @Override
        public final Builder dataType(NodeDataType dataType) {
            this.dataType(dataType == null ? null : dataType.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getUnit() {
            return unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public final Collection<String> getAllowedValues() {
            if (allowedValues instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedValues;
        }

        public final void setAllowedValues(Collection<String> allowedValues) {
            this.allowedValues = _listOfStringsCopier.copy(allowedValues);
        }

        @Override
        public final Builder allowedValues(Collection<String> allowedValues) {
            this.allowedValues = _listOfStringsCopier.copy(allowedValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedValues(String... allowedValues) {
            allowedValues(Arrays.asList(allowedValues));
            return this;
        }

        public final Double getMin() {
            return min;
        }

        public final void setMin(Double min) {
            this.min = min;
        }

        @Override
        public final Builder min(Double min) {
            this.min = min;
            return this;
        }

        public final Double getMax() {
            return max;
        }

        public final void setMax(Double max) {
            this.max = max;
        }

        @Override
        public final Builder max(Double max) {
            this.max = max;
            return this;
        }

        @Deprecated
        public final String getAssignedValue() {
            return assignedValue;
        }

        @Deprecated
        public final void setAssignedValue(String assignedValue) {
            this.assignedValue = assignedValue;
        }

        @Override
        @Deprecated
        public final Builder assignedValue(String assignedValue) {
            this.assignedValue = assignedValue;
            return this;
        }

        @Override
        public Actuator build() {
            return new Actuator(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
