/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a signal decoder.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SignalDecoder implements SdkPojo, Serializable, ToCopyableBuilder<SignalDecoder.Builder, SignalDecoder> {
    private static final SdkField<String> FULLY_QUALIFIED_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fullyQualifiedName").getter(getter(SignalDecoder::fullyQualifiedName))
            .setter(setter(Builder::fullyQualifiedName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fullyQualifiedName").build())
            .build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(SignalDecoder::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> INTERFACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("interfaceId").getter(getter(SignalDecoder::interfaceId)).setter(setter(Builder::interfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interfaceId").build()).build();

    private static final SdkField<CanSignal> CAN_SIGNAL_FIELD = SdkField.<CanSignal> builder(MarshallingType.SDK_POJO)
            .memberName("canSignal").getter(getter(SignalDecoder::canSignal)).setter(setter(Builder::canSignal))
            .constructor(CanSignal::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("canSignal").build()).build();

    private static final SdkField<ObdSignal> OBD_SIGNAL_FIELD = SdkField.<ObdSignal> builder(MarshallingType.SDK_POJO)
            .memberName("obdSignal").getter(getter(SignalDecoder::obdSignal)).setter(setter(Builder::obdSignal))
            .constructor(ObdSignal::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("obdSignal").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FULLY_QUALIFIED_NAME_FIELD,
            TYPE_FIELD, INTERFACE_ID_FIELD, CAN_SIGNAL_FIELD, OBD_SIGNAL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fullyQualifiedName;

    private final String type;

    private final String interfaceId;

    private final CanSignal canSignal;

    private final ObdSignal obdSignal;

    private SignalDecoder(BuilderImpl builder) {
        this.fullyQualifiedName = builder.fullyQualifiedName;
        this.type = builder.type;
        this.interfaceId = builder.interfaceId;
        this.canSignal = builder.canSignal;
        this.obdSignal = builder.obdSignal;
    }

    /**
     * <p>
     * The fully qualified name of a signal decoder as defined in a vehicle model.
     * </p>
     * 
     * @return The fully qualified name of a signal decoder as defined in a vehicle model.
     */
    public final String fullyQualifiedName() {
        return fullyQualifiedName;
    }

    /**
     * <p>
     * The network protocol for the vehicle. For example, <code>CAN_SIGNAL</code> specifies a protocol that defines how
     * data is communicated between electronic control units (ECUs). <code>OBD_SIGNAL</code> specifies a protocol that
     * defines how self-diagnostic data is communicated between ECUs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SignalDecoderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The network protocol for the vehicle. For example, <code>CAN_SIGNAL</code> specifies a protocol that
     *         defines how data is communicated between electronic control units (ECUs). <code>OBD_SIGNAL</code>
     *         specifies a protocol that defines how self-diagnostic data is communicated between ECUs.
     * @see SignalDecoderType
     */
    public final SignalDecoderType type() {
        return SignalDecoderType.fromValue(type);
    }

    /**
     * <p>
     * The network protocol for the vehicle. For example, <code>CAN_SIGNAL</code> specifies a protocol that defines how
     * data is communicated between electronic control units (ECUs). <code>OBD_SIGNAL</code> specifies a protocol that
     * defines how self-diagnostic data is communicated between ECUs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SignalDecoderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The network protocol for the vehicle. For example, <code>CAN_SIGNAL</code> specifies a protocol that
     *         defines how data is communicated between electronic control units (ECUs). <code>OBD_SIGNAL</code>
     *         specifies a protocol that defines how self-diagnostic data is communicated between ECUs.
     * @see SignalDecoderType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The ID of a network interface that specifies what network protocol a vehicle follows.
     * </p>
     * 
     * @return The ID of a network interface that specifies what network protocol a vehicle follows.
     */
    public final String interfaceId() {
        return interfaceId;
    }

    /**
     * <p>
     * Information about signal decoder using the Controller Area Network (CAN) protocol.
     * </p>
     * 
     * @return Information about signal decoder using the Controller Area Network (CAN) protocol.
     */
    public final CanSignal canSignal() {
        return canSignal;
    }

    /**
     * <p>
     * Information about signal decoder using the On-board diagnostic (OBD) II protocol.
     * </p>
     * 
     * @return Information about signal decoder using the On-board diagnostic (OBD) II protocol.
     */
    public final ObdSignal obdSignal() {
        return obdSignal;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fullyQualifiedName());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(interfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(canSignal());
        hashCode = 31 * hashCode + Objects.hashCode(obdSignal());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SignalDecoder)) {
            return false;
        }
        SignalDecoder other = (SignalDecoder) obj;
        return Objects.equals(fullyQualifiedName(), other.fullyQualifiedName())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(interfaceId(), other.interfaceId())
                && Objects.equals(canSignal(), other.canSignal()) && Objects.equals(obdSignal(), other.obdSignal());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SignalDecoder").add("FullyQualifiedName", fullyQualifiedName()).add("Type", typeAsString())
                .add("InterfaceId", interfaceId()).add("CanSignal", canSignal()).add("ObdSignal", obdSignal()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fullyQualifiedName":
            return Optional.ofNullable(clazz.cast(fullyQualifiedName()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "interfaceId":
            return Optional.ofNullable(clazz.cast(interfaceId()));
        case "canSignal":
            return Optional.ofNullable(clazz.cast(canSignal()));
        case "obdSignal":
            return Optional.ofNullable(clazz.cast(obdSignal()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SignalDecoder, T> g) {
        return obj -> g.apply((SignalDecoder) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SignalDecoder> {
        /**
         * <p>
         * The fully qualified name of a signal decoder as defined in a vehicle model.
         * </p>
         * 
         * @param fullyQualifiedName
         *        The fully qualified name of a signal decoder as defined in a vehicle model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fullyQualifiedName(String fullyQualifiedName);

        /**
         * <p>
         * The network protocol for the vehicle. For example, <code>CAN_SIGNAL</code> specifies a protocol that defines
         * how data is communicated between electronic control units (ECUs). <code>OBD_SIGNAL</code> specifies a
         * protocol that defines how self-diagnostic data is communicated between ECUs.
         * </p>
         * 
         * @param type
         *        The network protocol for the vehicle. For example, <code>CAN_SIGNAL</code> specifies a protocol that
         *        defines how data is communicated between electronic control units (ECUs). <code>OBD_SIGNAL</code>
         *        specifies a protocol that defines how self-diagnostic data is communicated between ECUs.
         * @see SignalDecoderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SignalDecoderType
         */
        Builder type(String type);

        /**
         * <p>
         * The network protocol for the vehicle. For example, <code>CAN_SIGNAL</code> specifies a protocol that defines
         * how data is communicated between electronic control units (ECUs). <code>OBD_SIGNAL</code> specifies a
         * protocol that defines how self-diagnostic data is communicated between ECUs.
         * </p>
         * 
         * @param type
         *        The network protocol for the vehicle. For example, <code>CAN_SIGNAL</code> specifies a protocol that
         *        defines how data is communicated between electronic control units (ECUs). <code>OBD_SIGNAL</code>
         *        specifies a protocol that defines how self-diagnostic data is communicated between ECUs.
         * @see SignalDecoderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SignalDecoderType
         */
        Builder type(SignalDecoderType type);

        /**
         * <p>
         * The ID of a network interface that specifies what network protocol a vehicle follows.
         * </p>
         * 
         * @param interfaceId
         *        The ID of a network interface that specifies what network protocol a vehicle follows.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interfaceId(String interfaceId);

        /**
         * <p>
         * Information about signal decoder using the Controller Area Network (CAN) protocol.
         * </p>
         * 
         * @param canSignal
         *        Information about signal decoder using the Controller Area Network (CAN) protocol.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder canSignal(CanSignal canSignal);

        /**
         * <p>
         * Information about signal decoder using the Controller Area Network (CAN) protocol.
         * </p>
         * This is a convenience method that creates an instance of the {@link CanSignal.Builder} avoiding the need to
         * create one manually via {@link CanSignal#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CanSignal.Builder#build()} is called immediately and its result
         * is passed to {@link #canSignal(CanSignal)}.
         * 
         * @param canSignal
         *        a consumer that will call methods on {@link CanSignal.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #canSignal(CanSignal)
         */
        default Builder canSignal(Consumer<CanSignal.Builder> canSignal) {
            return canSignal(CanSignal.builder().applyMutation(canSignal).build());
        }

        /**
         * <p>
         * Information about signal decoder using the On-board diagnostic (OBD) II protocol.
         * </p>
         * 
         * @param obdSignal
         *        Information about signal decoder using the On-board diagnostic (OBD) II protocol.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder obdSignal(ObdSignal obdSignal);

        /**
         * <p>
         * Information about signal decoder using the On-board diagnostic (OBD) II protocol.
         * </p>
         * This is a convenience method that creates an instance of the {@link ObdSignal.Builder} avoiding the need to
         * create one manually via {@link ObdSignal#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ObdSignal.Builder#build()} is called immediately and its result
         * is passed to {@link #obdSignal(ObdSignal)}.
         * 
         * @param obdSignal
         *        a consumer that will call methods on {@link ObdSignal.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #obdSignal(ObdSignal)
         */
        default Builder obdSignal(Consumer<ObdSignal.Builder> obdSignal) {
            return obdSignal(ObdSignal.builder().applyMutation(obdSignal).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String fullyQualifiedName;

        private String type;

        private String interfaceId;

        private CanSignal canSignal;

        private ObdSignal obdSignal;

        private BuilderImpl() {
        }

        private BuilderImpl(SignalDecoder model) {
            fullyQualifiedName(model.fullyQualifiedName);
            type(model.type);
            interfaceId(model.interfaceId);
            canSignal(model.canSignal);
            obdSignal(model.obdSignal);
        }

        public final String getFullyQualifiedName() {
            return fullyQualifiedName;
        }

        public final void setFullyQualifiedName(String fullyQualifiedName) {
            this.fullyQualifiedName = fullyQualifiedName;
        }

        @Override
        public final Builder fullyQualifiedName(String fullyQualifiedName) {
            this.fullyQualifiedName = fullyQualifiedName;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SignalDecoderType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getInterfaceId() {
            return interfaceId;
        }

        public final void setInterfaceId(String interfaceId) {
            this.interfaceId = interfaceId;
        }

        @Override
        public final Builder interfaceId(String interfaceId) {
            this.interfaceId = interfaceId;
            return this;
        }

        public final CanSignal.Builder getCanSignal() {
            return canSignal != null ? canSignal.toBuilder() : null;
        }

        public final void setCanSignal(CanSignal.BuilderImpl canSignal) {
            this.canSignal = canSignal != null ? canSignal.build() : null;
        }

        @Override
        public final Builder canSignal(CanSignal canSignal) {
            this.canSignal = canSignal;
            return this;
        }

        public final ObdSignal.Builder getObdSignal() {
            return obdSignal != null ? obdSignal.toBuilder() : null;
        }

        public final void setObdSignal(ObdSignal.BuilderImpl obdSignal) {
            this.obdSignal = obdSignal != null ? obdSignal.build() : null;
        }

        @Override
        public final Builder obdSignal(ObdSignal obdSignal) {
            this.obdSignal = obdSignal;
            return this;
        }

        @Override
        public SignalDecoder build() {
            return new SignalDecoder(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
