/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateCampaignRequest extends IoTFleetWiseRequest implements
        ToCopyableBuilder<UpdateCampaignRequest.Builder, UpdateCampaignRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateCampaignRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateCampaignRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<String>> DATA_EXTRA_DIMENSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("dataExtraDimensions")
            .getter(getter(UpdateCampaignRequest::dataExtraDimensions))
            .setter(setter(Builder::dataExtraDimensions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataExtraDimensions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("action")
            .getter(getter(UpdateCampaignRequest::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            DATA_EXTRA_DIMENSIONS_FIELD, ACTION_FIELD));

    private final String name;

    private final String description;

    private final List<String> dataExtraDimensions;

    private final String action;

    private UpdateCampaignRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.dataExtraDimensions = builder.dataExtraDimensions;
        this.action = builder.action;
    }

    /**
     * <p>
     * The name of the campaign to update.
     * </p>
     * 
     * @return The name of the campaign to update.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the campaign.
     * </p>
     * 
     * @return The description of the campaign.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataExtraDimensions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDataExtraDimensions() {
        return dataExtraDimensions != null && !(dataExtraDimensions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of vehicle attributes to associate with a signal.
     * </p>
     * <p>
     * Default: An empty array
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataExtraDimensions} method.
     * </p>
     * 
     * @return A list of vehicle attributes to associate with a signal. </p>
     *         <p>
     *         Default: An empty array
     */
    public final List<String> dataExtraDimensions() {
        return dataExtraDimensions;
    }

    /**
     * <p>
     * Specifies how to update a campaign. The action can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>APPROVE</code> - To approve delivering a data collection scheme to vehicles.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUSPEND</code> - To suspend collecting signal data. The campaign is deleted from vehicles and all vehicles
     * in the suspended campaign will stop sending data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RESUME</code> - To reactivate the <code>SUSPEND</code> campaign. The campaign is redeployed to all vehicles
     * and the vehicles will resume sending data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE</code> - To update a campaign.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link UpdateCampaignAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #actionAsString}.
     * </p>
     * 
     * @return Specifies how to update a campaign. The action can be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>APPROVE</code> - To approve delivering a data collection scheme to vehicles.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUSPEND</code> - To suspend collecting signal data. The campaign is deleted from vehicles and all
     *         vehicles in the suspended campaign will stop sending data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RESUME</code> - To reactivate the <code>SUSPEND</code> campaign. The campaign is redeployed to all
     *         vehicles and the vehicles will resume sending data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE</code> - To update a campaign.
     *         </p>
     *         </li>
     * @see UpdateCampaignAction
     */
    public final UpdateCampaignAction action() {
        return UpdateCampaignAction.fromValue(action);
    }

    /**
     * <p>
     * Specifies how to update a campaign. The action can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>APPROVE</code> - To approve delivering a data collection scheme to vehicles.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUSPEND</code> - To suspend collecting signal data. The campaign is deleted from vehicles and all vehicles
     * in the suspended campaign will stop sending data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RESUME</code> - To reactivate the <code>SUSPEND</code> campaign. The campaign is redeployed to all vehicles
     * and the vehicles will resume sending data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE</code> - To update a campaign.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link UpdateCampaignAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #actionAsString}.
     * </p>
     * 
     * @return Specifies how to update a campaign. The action can be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>APPROVE</code> - To approve delivering a data collection scheme to vehicles.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUSPEND</code> - To suspend collecting signal data. The campaign is deleted from vehicles and all
     *         vehicles in the suspended campaign will stop sending data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RESUME</code> - To reactivate the <code>SUSPEND</code> campaign. The campaign is redeployed to all
     *         vehicles and the vehicles will resume sending data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE</code> - To update a campaign.
     *         </p>
     *         </li>
     * @see UpdateCampaignAction
     */
    public final String actionAsString() {
        return action;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasDataExtraDimensions() ? dataExtraDimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCampaignRequest)) {
            return false;
        }
        UpdateCampaignRequest other = (UpdateCampaignRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && hasDataExtraDimensions() == other.hasDataExtraDimensions()
                && Objects.equals(dataExtraDimensions(), other.dataExtraDimensions())
                && Objects.equals(actionAsString(), other.actionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateCampaignRequest").add("Name", name()).add("Description", description())
                .add("DataExtraDimensions", hasDataExtraDimensions() ? dataExtraDimensions() : null)
                .add("Action", actionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "dataExtraDimensions":
            return Optional.ofNullable(clazz.cast(dataExtraDimensions()));
        case "action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateCampaignRequest, T> g) {
        return obj -> g.apply((UpdateCampaignRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTFleetWiseRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateCampaignRequest> {
        /**
         * <p>
         * The name of the campaign to update.
         * </p>
         * 
         * @param name
         *        The name of the campaign to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the campaign.
         * </p>
         * 
         * @param description
         *        The description of the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A list of vehicle attributes to associate with a signal.
         * </p>
         * <p>
         * Default: An empty array
         * </p>
         * 
         * @param dataExtraDimensions
         *        A list of vehicle attributes to associate with a signal. </p>
         *        <p>
         *        Default: An empty array
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataExtraDimensions(Collection<String> dataExtraDimensions);

        /**
         * <p>
         * A list of vehicle attributes to associate with a signal.
         * </p>
         * <p>
         * Default: An empty array
         * </p>
         * 
         * @param dataExtraDimensions
         *        A list of vehicle attributes to associate with a signal. </p>
         *        <p>
         *        Default: An empty array
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataExtraDimensions(String... dataExtraDimensions);

        /**
         * <p>
         * Specifies how to update a campaign. The action can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>APPROVE</code> - To approve delivering a data collection scheme to vehicles.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUSPEND</code> - To suspend collecting signal data. The campaign is deleted from vehicles and all
         * vehicles in the suspended campaign will stop sending data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RESUME</code> - To reactivate the <code>SUSPEND</code> campaign. The campaign is redeployed to all
         * vehicles and the vehicles will resume sending data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE</code> - To update a campaign.
         * </p>
         * </li>
         * </ul>
         * 
         * @param action
         *        Specifies how to update a campaign. The action can be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>APPROVE</code> - To approve delivering a data collection scheme to vehicles.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUSPEND</code> - To suspend collecting signal data. The campaign is deleted from vehicles and
         *        all vehicles in the suspended campaign will stop sending data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RESUME</code> - To reactivate the <code>SUSPEND</code> campaign. The campaign is redeployed to
         *        all vehicles and the vehicles will resume sending data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE</code> - To update a campaign.
         *        </p>
         *        </li>
         * @see UpdateCampaignAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateCampaignAction
         */
        Builder action(String action);

        /**
         * <p>
         * Specifies how to update a campaign. The action can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>APPROVE</code> - To approve delivering a data collection scheme to vehicles.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUSPEND</code> - To suspend collecting signal data. The campaign is deleted from vehicles and all
         * vehicles in the suspended campaign will stop sending data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RESUME</code> - To reactivate the <code>SUSPEND</code> campaign. The campaign is redeployed to all
         * vehicles and the vehicles will resume sending data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE</code> - To update a campaign.
         * </p>
         * </li>
         * </ul>
         * 
         * @param action
         *        Specifies how to update a campaign. The action can be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>APPROVE</code> - To approve delivering a data collection scheme to vehicles.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUSPEND</code> - To suspend collecting signal data. The campaign is deleted from vehicles and
         *        all vehicles in the suspended campaign will stop sending data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RESUME</code> - To reactivate the <code>SUSPEND</code> campaign. The campaign is redeployed to
         *        all vehicles and the vehicles will resume sending data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE</code> - To update a campaign.
         *        </p>
         *        </li>
         * @see UpdateCampaignAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateCampaignAction
         */
        Builder action(UpdateCampaignAction action);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTFleetWiseRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private List<String> dataExtraDimensions = DefaultSdkAutoConstructList.getInstance();

        private String action;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCampaignRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            dataExtraDimensions(model.dataExtraDimensions);
            action(model.action);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getDataExtraDimensions() {
            if (dataExtraDimensions instanceof SdkAutoConstructList) {
                return null;
            }
            return dataExtraDimensions;
        }

        public final void setDataExtraDimensions(Collection<String> dataExtraDimensions) {
            this.dataExtraDimensions = DataExtraDimensionNodePathListCopier.copy(dataExtraDimensions);
        }

        @Override
        public final Builder dataExtraDimensions(Collection<String> dataExtraDimensions) {
            this.dataExtraDimensions = DataExtraDimensionNodePathListCopier.copy(dataExtraDimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataExtraDimensions(String... dataExtraDimensions) {
            dataExtraDimensions(Arrays.asList(dataExtraDimensions));
            return this;
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(UpdateCampaignAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCampaignRequest build() {
            return new UpdateCampaignRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
