/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a signal.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SignalInformation implements SdkPojo, Serializable,
        ToCopyableBuilder<SignalInformation.Builder, SignalInformation> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(SignalInformation::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Long> MAX_SAMPLE_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("maxSampleCount").getter(getter(SignalInformation::maxSampleCount))
            .setter(setter(Builder::maxSampleCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxSampleCount").build()).build();

    private static final SdkField<Long> MINIMUM_SAMPLING_INTERVAL_MS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("minimumSamplingIntervalMs").getter(getter(SignalInformation::minimumSamplingIntervalMs))
            .setter(setter(Builder::minimumSamplingIntervalMs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumSamplingIntervalMs").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            MAX_SAMPLE_COUNT_FIELD, MINIMUM_SAMPLING_INTERVAL_MS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Long maxSampleCount;

    private final Long minimumSamplingIntervalMs;

    private SignalInformation(BuilderImpl builder) {
        this.name = builder.name;
        this.maxSampleCount = builder.maxSampleCount;
        this.minimumSamplingIntervalMs = builder.minimumSamplingIntervalMs;
    }

    /**
     * <p>
     * The name of the signal.
     * </p>
     * 
     * @return The name of the signal.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The maximum number of samples to collect.
     * </p>
     * 
     * @return The maximum number of samples to collect.
     */
    public final Long maxSampleCount() {
        return maxSampleCount;
    }

    /**
     * <p>
     * The minimum duration of time (in milliseconds) between two triggering events to collect data.
     * </p>
     * <note>
     * <p>
     * If a signal changes often, you might want to collect data at a slower rate.
     * </p>
     * </note>
     * 
     * @return The minimum duration of time (in milliseconds) between two triggering events to collect data.</p> <note>
     *         <p>
     *         If a signal changes often, you might want to collect data at a slower rate.
     *         </p>
     */
    public final Long minimumSamplingIntervalMs() {
        return minimumSamplingIntervalMs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(maxSampleCount());
        hashCode = 31 * hashCode + Objects.hashCode(minimumSamplingIntervalMs());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SignalInformation)) {
            return false;
        }
        SignalInformation other = (SignalInformation) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(maxSampleCount(), other.maxSampleCount())
                && Objects.equals(minimumSamplingIntervalMs(), other.minimumSamplingIntervalMs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SignalInformation").add("Name", name()).add("MaxSampleCount", maxSampleCount())
                .add("MinimumSamplingIntervalMs", minimumSamplingIntervalMs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "maxSampleCount":
            return Optional.ofNullable(clazz.cast(maxSampleCount()));
        case "minimumSamplingIntervalMs":
            return Optional.ofNullable(clazz.cast(minimumSamplingIntervalMs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SignalInformation, T> g) {
        return obj -> g.apply((SignalInformation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SignalInformation> {
        /**
         * <p>
         * The name of the signal.
         * </p>
         * 
         * @param name
         *        The name of the signal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The maximum number of samples to collect.
         * </p>
         * 
         * @param maxSampleCount
         *        The maximum number of samples to collect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSampleCount(Long maxSampleCount);

        /**
         * <p>
         * The minimum duration of time (in milliseconds) between two triggering events to collect data.
         * </p>
         * <note>
         * <p>
         * If a signal changes often, you might want to collect data at a slower rate.
         * </p>
         * </note>
         * 
         * @param minimumSamplingIntervalMs
         *        The minimum duration of time (in milliseconds) between two triggering events to collect data.</p>
         *        <note>
         *        <p>
         *        If a signal changes often, you might want to collect data at a slower rate.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumSamplingIntervalMs(Long minimumSamplingIntervalMs);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Long maxSampleCount;

        private Long minimumSamplingIntervalMs;

        private BuilderImpl() {
        }

        private BuilderImpl(SignalInformation model) {
            name(model.name);
            maxSampleCount(model.maxSampleCount);
            minimumSamplingIntervalMs(model.minimumSamplingIntervalMs);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Long getMaxSampleCount() {
            return maxSampleCount;
        }

        public final void setMaxSampleCount(Long maxSampleCount) {
            this.maxSampleCount = maxSampleCount;
        }

        @Override
        public final Builder maxSampleCount(Long maxSampleCount) {
            this.maxSampleCount = maxSampleCount;
            return this;
        }

        public final Long getMinimumSamplingIntervalMs() {
            return minimumSamplingIntervalMs;
        }

        public final void setMinimumSamplingIntervalMs(Long minimumSamplingIntervalMs) {
            this.minimumSamplingIntervalMs = minimumSamplingIntervalMs;
        }

        @Override
        public final Builder minimumSamplingIntervalMs(Long minimumSamplingIntervalMs) {
            this.minimumSamplingIntervalMs = minimumSamplingIntervalMs;
            return this;
        }

        @Override
        public SignalInformation build() {
            return new SignalInformation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
