/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a collection scheme that uses a simple logical expression to recognize what data to collect.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConditionBasedCollectionScheme implements SdkPojo, Serializable,
        ToCopyableBuilder<ConditionBasedCollectionScheme.Builder, ConditionBasedCollectionScheme> {
    private static final SdkField<String> EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("expression").getter(getter(ConditionBasedCollectionScheme::expression))
            .setter(setter(Builder::expression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expression").build()).build();

    private static final SdkField<Long> MINIMUM_TRIGGER_INTERVAL_MS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("minimumTriggerIntervalMs").getter(getter(ConditionBasedCollectionScheme::minimumTriggerIntervalMs))
            .setter(setter(Builder::minimumTriggerIntervalMs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumTriggerIntervalMs").build())
            .build();

    private static final SdkField<String> TRIGGER_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("triggerMode").getter(getter(ConditionBasedCollectionScheme::triggerModeAsString))
            .setter(setter(Builder::triggerMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggerMode").build()).build();

    private static final SdkField<Integer> CONDITION_LANGUAGE_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("conditionLanguageVersion").getter(getter(ConditionBasedCollectionScheme::conditionLanguageVersion))
            .setter(setter(Builder::conditionLanguageVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conditionLanguageVersion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPRESSION_FIELD,
            MINIMUM_TRIGGER_INTERVAL_MS_FIELD, TRIGGER_MODE_FIELD, CONDITION_LANGUAGE_VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String expression;

    private final Long minimumTriggerIntervalMs;

    private final String triggerMode;

    private final Integer conditionLanguageVersion;

    private ConditionBasedCollectionScheme(BuilderImpl builder) {
        this.expression = builder.expression;
        this.minimumTriggerIntervalMs = builder.minimumTriggerIntervalMs;
        this.triggerMode = builder.triggerMode;
        this.conditionLanguageVersion = builder.conditionLanguageVersion;
    }

    /**
     * <p>
     * The logical expression used to recognize what data to collect. For example,
     * <code>$variable.`Vehicle.OutsideAirTemperature` &gt;= 105.0</code>.
     * </p>
     * 
     * @return The logical expression used to recognize what data to collect. For example,
     *         <code>$variable.`Vehicle.OutsideAirTemperature` &gt;= 105.0</code>.
     */
    public final String expression() {
        return expression;
    }

    /**
     * <p>
     * The minimum duration of time between two triggering events to collect data, in milliseconds.
     * </p>
     * <note>
     * <p>
     * If a signal changes often, you might want to collect data at a slower rate.
     * </p>
     * </note>
     * 
     * @return The minimum duration of time between two triggering events to collect data, in milliseconds.</p> <note>
     *         <p>
     *         If a signal changes often, you might want to collect data at a slower rate.
     *         </p>
     */
    public final Long minimumTriggerIntervalMs() {
        return minimumTriggerIntervalMs;
    }

    /**
     * <p>
     * Whether to collect data for all triggering events (<code>ALWAYS</code>). Specify (<code>RISING_EDGE</code>), or
     * specify only when the condition first evaluates to false. For example, triggering on "AirbagDeployed"; Users
     * aren't interested on triggering when the airbag is already exploded; they only care about the change from not
     * deployed =&gt; deployed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #triggerMode} will
     * return {@link TriggerMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #triggerModeAsString}.
     * </p>
     * 
     * @return Whether to collect data for all triggering events (<code>ALWAYS</code>). Specify (
     *         <code>RISING_EDGE</code>), or specify only when the condition first evaluates to false. For example,
     *         triggering on "AirbagDeployed"; Users aren't interested on triggering when the airbag is already
     *         exploded; they only care about the change from not deployed =&gt; deployed.
     * @see TriggerMode
     */
    public final TriggerMode triggerMode() {
        return TriggerMode.fromValue(triggerMode);
    }

    /**
     * <p>
     * Whether to collect data for all triggering events (<code>ALWAYS</code>). Specify (<code>RISING_EDGE</code>), or
     * specify only when the condition first evaluates to false. For example, triggering on "AirbagDeployed"; Users
     * aren't interested on triggering when the airbag is already exploded; they only care about the change from not
     * deployed =&gt; deployed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #triggerMode} will
     * return {@link TriggerMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #triggerModeAsString}.
     * </p>
     * 
     * @return Whether to collect data for all triggering events (<code>ALWAYS</code>). Specify (
     *         <code>RISING_EDGE</code>), or specify only when the condition first evaluates to false. For example,
     *         triggering on "AirbagDeployed"; Users aren't interested on triggering when the airbag is already
     *         exploded; they only care about the change from not deployed =&gt; deployed.
     * @see TriggerMode
     */
    public final String triggerModeAsString() {
        return triggerMode;
    }

    /**
     * <p>
     * Specifies the version of the conditional expression language.
     * </p>
     * 
     * @return Specifies the version of the conditional expression language.
     */
    public final Integer conditionLanguageVersion() {
        return conditionLanguageVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(expression());
        hashCode = 31 * hashCode + Objects.hashCode(minimumTriggerIntervalMs());
        hashCode = 31 * hashCode + Objects.hashCode(triggerModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(conditionLanguageVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConditionBasedCollectionScheme)) {
            return false;
        }
        ConditionBasedCollectionScheme other = (ConditionBasedCollectionScheme) obj;
        return Objects.equals(expression(), other.expression())
                && Objects.equals(minimumTriggerIntervalMs(), other.minimumTriggerIntervalMs())
                && Objects.equals(triggerModeAsString(), other.triggerModeAsString())
                && Objects.equals(conditionLanguageVersion(), other.conditionLanguageVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConditionBasedCollectionScheme")
                .add("Expression", expression() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MinimumTriggerIntervalMs", minimumTriggerIntervalMs()).add("TriggerMode", triggerModeAsString())
                .add("ConditionLanguageVersion", conditionLanguageVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "expression":
            return Optional.ofNullable(clazz.cast(expression()));
        case "minimumTriggerIntervalMs":
            return Optional.ofNullable(clazz.cast(minimumTriggerIntervalMs()));
        case "triggerMode":
            return Optional.ofNullable(clazz.cast(triggerModeAsString()));
        case "conditionLanguageVersion":
            return Optional.ofNullable(clazz.cast(conditionLanguageVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConditionBasedCollectionScheme, T> g) {
        return obj -> g.apply((ConditionBasedCollectionScheme) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConditionBasedCollectionScheme> {
        /**
         * <p>
         * The logical expression used to recognize what data to collect. For example,
         * <code>$variable.`Vehicle.OutsideAirTemperature` &gt;= 105.0</code>.
         * </p>
         * 
         * @param expression
         *        The logical expression used to recognize what data to collect. For example,
         *        <code>$variable.`Vehicle.OutsideAirTemperature` &gt;= 105.0</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expression(String expression);

        /**
         * <p>
         * The minimum duration of time between two triggering events to collect data, in milliseconds.
         * </p>
         * <note>
         * <p>
         * If a signal changes often, you might want to collect data at a slower rate.
         * </p>
         * </note>
         * 
         * @param minimumTriggerIntervalMs
         *        The minimum duration of time between two triggering events to collect data, in milliseconds.</p>
         *        <note>
         *        <p>
         *        If a signal changes often, you might want to collect data at a slower rate.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumTriggerIntervalMs(Long minimumTriggerIntervalMs);

        /**
         * <p>
         * Whether to collect data for all triggering events (<code>ALWAYS</code>). Specify (<code>RISING_EDGE</code>),
         * or specify only when the condition first evaluates to false. For example, triggering on "AirbagDeployed";
         * Users aren't interested on triggering when the airbag is already exploded; they only care about the change
         * from not deployed =&gt; deployed.
         * </p>
         * 
         * @param triggerMode
         *        Whether to collect data for all triggering events (<code>ALWAYS</code>). Specify (
         *        <code>RISING_EDGE</code>), or specify only when the condition first evaluates to false. For example,
         *        triggering on "AirbagDeployed"; Users aren't interested on triggering when the airbag is already
         *        exploded; they only care about the change from not deployed =&gt; deployed.
         * @see TriggerMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TriggerMode
         */
        Builder triggerMode(String triggerMode);

        /**
         * <p>
         * Whether to collect data for all triggering events (<code>ALWAYS</code>). Specify (<code>RISING_EDGE</code>),
         * or specify only when the condition first evaluates to false. For example, triggering on "AirbagDeployed";
         * Users aren't interested on triggering when the airbag is already exploded; they only care about the change
         * from not deployed =&gt; deployed.
         * </p>
         * 
         * @param triggerMode
         *        Whether to collect data for all triggering events (<code>ALWAYS</code>). Specify (
         *        <code>RISING_EDGE</code>), or specify only when the condition first evaluates to false. For example,
         *        triggering on "AirbagDeployed"; Users aren't interested on triggering when the airbag is already
         *        exploded; they only care about the change from not deployed =&gt; deployed.
         * @see TriggerMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TriggerMode
         */
        Builder triggerMode(TriggerMode triggerMode);

        /**
         * <p>
         * Specifies the version of the conditional expression language.
         * </p>
         * 
         * @param conditionLanguageVersion
         *        Specifies the version of the conditional expression language.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditionLanguageVersion(Integer conditionLanguageVersion);
    }

    static final class BuilderImpl implements Builder {
        private String expression;

        private Long minimumTriggerIntervalMs;

        private String triggerMode;

        private Integer conditionLanguageVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ConditionBasedCollectionScheme model) {
            expression(model.expression);
            minimumTriggerIntervalMs(model.minimumTriggerIntervalMs);
            triggerMode(model.triggerMode);
            conditionLanguageVersion(model.conditionLanguageVersion);
        }

        public final String getExpression() {
            return expression;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final Long getMinimumTriggerIntervalMs() {
            return minimumTriggerIntervalMs;
        }

        public final void setMinimumTriggerIntervalMs(Long minimumTriggerIntervalMs) {
            this.minimumTriggerIntervalMs = minimumTriggerIntervalMs;
        }

        @Override
        public final Builder minimumTriggerIntervalMs(Long minimumTriggerIntervalMs) {
            this.minimumTriggerIntervalMs = minimumTriggerIntervalMs;
            return this;
        }

        public final String getTriggerMode() {
            return triggerMode;
        }

        public final void setTriggerMode(String triggerMode) {
            this.triggerMode = triggerMode;
        }

        @Override
        public final Builder triggerMode(String triggerMode) {
            this.triggerMode = triggerMode;
            return this;
        }

        @Override
        public final Builder triggerMode(TriggerMode triggerMode) {
            this.triggerMode(triggerMode == null ? null : triggerMode.toString());
            return this;
        }

        public final Integer getConditionLanguageVersion() {
            return conditionLanguageVersion;
        }

        public final void setConditionLanguageVersion(Integer conditionLanguageVersion) {
            this.conditionLanguageVersion = conditionLanguageVersion;
        }

        @Override
        public final Builder conditionLanguageVersion(Integer conditionLanguageVersion) {
            this.conditionLanguageVersion = conditionLanguageVersion;
            return this;
        }

        @Override
        public ConditionBasedCollectionScheme build() {
            return new ConditionBasedCollectionScheme(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
