/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The destination where the Amazon Web Services IoT FleetWise campaign sends data. You can send data to be stored in
 * Amazon S3 or Amazon Timestream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataDestinationConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<DataDestinationConfig.Builder, DataDestinationConfig> {
    private static final SdkField<S3Config> S3_CONFIG_FIELD = SdkField.<S3Config> builder(MarshallingType.SDK_POJO)
            .memberName("s3Config").getter(getter(DataDestinationConfig::s3Config)).setter(setter(Builder::s3Config))
            .constructor(S3Config::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Config").build()).build();

    private static final SdkField<TimestreamConfig> TIMESTREAM_CONFIG_FIELD = SdkField
            .<TimestreamConfig> builder(MarshallingType.SDK_POJO).memberName("timestreamConfig")
            .getter(getter(DataDestinationConfig::timestreamConfig)).setter(setter(Builder::timestreamConfig))
            .constructor(TimestreamConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestreamConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_CONFIG_FIELD,
            TIMESTREAM_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final S3Config s3Config;

    private final TimestreamConfig timestreamConfig;

    private final Type type;

    private DataDestinationConfig(BuilderImpl builder) {
        this.s3Config = builder.s3Config;
        this.timestreamConfig = builder.timestreamConfig;
        this.type = builder.type;
    }

    /**
     * <p>
     * The Amazon S3 bucket where the Amazon Web Services IoT FleetWise campaign sends data.
     * </p>
     * 
     * @return The Amazon S3 bucket where the Amazon Web Services IoT FleetWise campaign sends data.
     */
    public final S3Config s3Config() {
        return s3Config;
    }

    /**
     * <p>
     * The Amazon Timestream table where the campaign sends data.
     * </p>
     * 
     * @return The Amazon Timestream table where the campaign sends data.
     */
    public final TimestreamConfig timestreamConfig() {
        return timestreamConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Config());
        hashCode = 31 * hashCode + Objects.hashCode(timestreamConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataDestinationConfig)) {
            return false;
        }
        DataDestinationConfig other = (DataDestinationConfig) obj;
        return Objects.equals(s3Config(), other.s3Config()) && Objects.equals(timestreamConfig(), other.timestreamConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataDestinationConfig").add("S3Config", s3Config()).add("TimestreamConfig", timestreamConfig())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "s3Config":
            return Optional.ofNullable(clazz.cast(s3Config()));
        case "timestreamConfig":
            return Optional.ofNullable(clazz.cast(timestreamConfig()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #s3Config()} initialized to the given value.
     *
     * <p>
     * The Amazon S3 bucket where the Amazon Web Services IoT FleetWise campaign sends data.
     * </p>
     * 
     * @param s3Config
     *        The Amazon S3 bucket where the Amazon Web Services IoT FleetWise campaign sends data.
     */
    public static DataDestinationConfig fromS3Config(S3Config s3Config) {
        return builder().s3Config(s3Config).build();
    }

    /**
     * Create an instance of this class with {@link #s3Config()} initialized to the given value.
     *
     * <p>
     * The Amazon S3 bucket where the Amazon Web Services IoT FleetWise campaign sends data.
     * </p>
     * 
     * @param s3Config
     *        The Amazon S3 bucket where the Amazon Web Services IoT FleetWise campaign sends data.
     */
    public static DataDestinationConfig fromS3Config(Consumer<S3Config.Builder> s3Config) {
        S3Config.Builder builder = S3Config.builder();
        s3Config.accept(builder);
        return fromS3Config(builder.build());
    }

    /**
     * Create an instance of this class with {@link #timestreamConfig()} initialized to the given value.
     *
     * <p>
     * The Amazon Timestream table where the campaign sends data.
     * </p>
     * 
     * @param timestreamConfig
     *        The Amazon Timestream table where the campaign sends data.
     */
    public static DataDestinationConfig fromTimestreamConfig(TimestreamConfig timestreamConfig) {
        return builder().timestreamConfig(timestreamConfig).build();
    }

    /**
     * Create an instance of this class with {@link #timestreamConfig()} initialized to the given value.
     *
     * <p>
     * The Amazon Timestream table where the campaign sends data.
     * </p>
     * 
     * @param timestreamConfig
     *        The Amazon Timestream table where the campaign sends data.
     */
    public static DataDestinationConfig fromTimestreamConfig(Consumer<TimestreamConfig.Builder> timestreamConfig) {
        TimestreamConfig.Builder builder = TimestreamConfig.builder();
        timestreamConfig.accept(builder);
        return fromTimestreamConfig(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataDestinationConfig, T> g) {
        return obj -> g.apply((DataDestinationConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataDestinationConfig> {
        /**
         * <p>
         * The Amazon S3 bucket where the Amazon Web Services IoT FleetWise campaign sends data.
         * </p>
         * 
         * @param s3Config
         *        The Amazon S3 bucket where the Amazon Web Services IoT FleetWise campaign sends data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Config(S3Config s3Config);

        /**
         * <p>
         * The Amazon S3 bucket where the Amazon Web Services IoT FleetWise campaign sends data.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Config.Builder} avoiding the need to
         * create one manually via {@link S3Config#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Config.Builder#build()} is called immediately and its result is
         * passed to {@link #s3Config(S3Config)}.
         * 
         * @param s3Config
         *        a consumer that will call methods on {@link S3Config.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Config(S3Config)
         */
        default Builder s3Config(Consumer<S3Config.Builder> s3Config) {
            return s3Config(S3Config.builder().applyMutation(s3Config).build());
        }

        /**
         * <p>
         * The Amazon Timestream table where the campaign sends data.
         * </p>
         * 
         * @param timestreamConfig
         *        The Amazon Timestream table where the campaign sends data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestreamConfig(TimestreamConfig timestreamConfig);

        /**
         * <p>
         * The Amazon Timestream table where the campaign sends data.
         * </p>
         * This is a convenience method that creates an instance of the {@link TimestreamConfig.Builder} avoiding the
         * need to create one manually via {@link TimestreamConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimestreamConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #timestreamConfig(TimestreamConfig)}.
         * 
         * @param timestreamConfig
         *        a consumer that will call methods on {@link TimestreamConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timestreamConfig(TimestreamConfig)
         */
        default Builder timestreamConfig(Consumer<TimestreamConfig.Builder> timestreamConfig) {
            return timestreamConfig(TimestreamConfig.builder().applyMutation(timestreamConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private S3Config s3Config;

        private TimestreamConfig timestreamConfig;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(DataDestinationConfig model) {
            s3Config(model.s3Config);
            timestreamConfig(model.timestreamConfig);
        }

        public final S3Config.Builder getS3Config() {
            return s3Config != null ? s3Config.toBuilder() : null;
        }

        public final void setS3Config(S3Config.BuilderImpl s3Config) {
            Object oldValue = this.s3Config;
            this.s3Config = s3Config != null ? s3Config.build() : null;
            handleUnionValueChange(Type.S3_CONFIG, oldValue, this.s3Config);
        }

        @Override
        public final Builder s3Config(S3Config s3Config) {
            Object oldValue = this.s3Config;
            this.s3Config = s3Config;
            handleUnionValueChange(Type.S3_CONFIG, oldValue, this.s3Config);
            return this;
        }

        public final TimestreamConfig.Builder getTimestreamConfig() {
            return timestreamConfig != null ? timestreamConfig.toBuilder() : null;
        }

        public final void setTimestreamConfig(TimestreamConfig.BuilderImpl timestreamConfig) {
            Object oldValue = this.timestreamConfig;
            this.timestreamConfig = timestreamConfig != null ? timestreamConfig.build() : null;
            handleUnionValueChange(Type.TIMESTREAM_CONFIG, oldValue, this.timestreamConfig);
        }

        @Override
        public final Builder timestreamConfig(TimestreamConfig timestreamConfig) {
            Object oldValue = this.timestreamConfig;
            this.timestreamConfig = timestreamConfig;
            handleUnionValueChange(Type.TIMESTREAM_CONFIG, oldValue, this.timestreamConfig);
            return this;
        }

        @Override
        public DataDestinationConfig build() {
            return new DataDestinationConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see DataDestinationConfig#type()
     */
    public enum Type {
        S3_CONFIG,

        TIMESTREAM_CONFIG,

        UNKNOWN_TO_SDK_VERSION
    }
}
