/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structured message for the message signal. It can be defined with either a
 * <code>primitiveMessageDefinition</code>, <code>structuredMessageListDefinition</code>, or
 * <code>structuredMessageDefinition</code> recursively.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StructuredMessage implements SdkPojo, Serializable,
        ToCopyableBuilder<StructuredMessage.Builder, StructuredMessage> {
    private static final SdkField<PrimitiveMessageDefinition> PRIMITIVE_MESSAGE_DEFINITION_FIELD = SdkField
            .<PrimitiveMessageDefinition> builder(MarshallingType.SDK_POJO)
            .memberName("primitiveMessageDefinition")
            .getter(getter(StructuredMessage::primitiveMessageDefinition))
            .setter(setter(Builder::primitiveMessageDefinition))
            .constructor(PrimitiveMessageDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("primitiveMessageDefinition").build())
            .build();

    private static final SdkField<StructuredMessageListDefinition> STRUCTURED_MESSAGE_LIST_DEFINITION_FIELD = SdkField
            .<StructuredMessageListDefinition> builder(MarshallingType.SDK_POJO)
            .memberName("structuredMessageListDefinition")
            .getter(getter(StructuredMessage::structuredMessageListDefinition))
            .setter(setter(Builder::structuredMessageListDefinition))
            .constructor(StructuredMessageListDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("structuredMessageListDefinition")
                    .build()).build();

    private static final SdkField<List<StructuredMessageFieldNameAndDataTypePair>> STRUCTURED_MESSAGE_DEFINITION_FIELD = SdkField
            .<List<StructuredMessageFieldNameAndDataTypePair>> builder(MarshallingType.LIST)
            .memberName("structuredMessageDefinition")
            .getter(getter(StructuredMessage::structuredMessageDefinition))
            .setter(setter(Builder::structuredMessageDefinition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("structuredMessageDefinition")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StructuredMessageFieldNameAndDataTypePair> builder(MarshallingType.SDK_POJO)
                                            .constructor(StructuredMessageFieldNameAndDataTypePair::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PRIMITIVE_MESSAGE_DEFINITION_FIELD, STRUCTURED_MESSAGE_LIST_DEFINITION_FIELD, STRUCTURED_MESSAGE_DEFINITION_FIELD));

    private static final long serialVersionUID = 1L;

    private final PrimitiveMessageDefinition primitiveMessageDefinition;

    private final StructuredMessageListDefinition structuredMessageListDefinition;

    private final List<StructuredMessageFieldNameAndDataTypePair> structuredMessageDefinition;

    private final Type type;

    private StructuredMessage(BuilderImpl builder) {
        this.primitiveMessageDefinition = builder.primitiveMessageDefinition;
        this.structuredMessageListDefinition = builder.structuredMessageListDefinition;
        this.structuredMessageDefinition = builder.structuredMessageDefinition;
        this.type = builder.type;
    }

    /**
     * <p>
     * Represents a primitive type node of the complex data structure.
     * </p>
     * 
     * @return Represents a primitive type node of the complex data structure.
     */
    public final PrimitiveMessageDefinition primitiveMessageDefinition() {
        return primitiveMessageDefinition;
    }

    /**
     * <p>
     * Represents a list type node of the complex data structure.
     * </p>
     * 
     * @return Represents a list type node of the complex data structure.
     */
    public final StructuredMessageListDefinition structuredMessageListDefinition() {
        return structuredMessageListDefinition;
    }

    /**
     * For responses, this returns true if the service returned a value for the StructuredMessageDefinition property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasStructuredMessageDefinition() {
        return structuredMessageDefinition != null && !(structuredMessageDefinition instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Represents a struct type node of the complex data structure.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStructuredMessageDefinition} method.
     * </p>
     * 
     * @return Represents a struct type node of the complex data structure.
     */
    public final List<StructuredMessageFieldNameAndDataTypePair> structuredMessageDefinition() {
        return structuredMessageDefinition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(primitiveMessageDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(structuredMessageListDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(hasStructuredMessageDefinition() ? structuredMessageDefinition() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StructuredMessage)) {
            return false;
        }
        StructuredMessage other = (StructuredMessage) obj;
        return Objects.equals(primitiveMessageDefinition(), other.primitiveMessageDefinition())
                && Objects.equals(structuredMessageListDefinition(), other.structuredMessageListDefinition())
                && hasStructuredMessageDefinition() == other.hasStructuredMessageDefinition()
                && Objects.equals(structuredMessageDefinition(), other.structuredMessageDefinition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StructuredMessage").add("PrimitiveMessageDefinition", primitiveMessageDefinition())
                .add("StructuredMessageListDefinition", structuredMessageListDefinition())
                .add("StructuredMessageDefinition", hasStructuredMessageDefinition() ? structuredMessageDefinition() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "primitiveMessageDefinition":
            return Optional.ofNullable(clazz.cast(primitiveMessageDefinition()));
        case "structuredMessageListDefinition":
            return Optional.ofNullable(clazz.cast(structuredMessageListDefinition()));
        case "structuredMessageDefinition":
            return Optional.ofNullable(clazz.cast(structuredMessageDefinition()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #primitiveMessageDefinition()} initialized to the given value.
     *
     * <p>
     * Represents a primitive type node of the complex data structure.
     * </p>
     * 
     * @param primitiveMessageDefinition
     *        Represents a primitive type node of the complex data structure.
     */
    public static StructuredMessage fromPrimitiveMessageDefinition(PrimitiveMessageDefinition primitiveMessageDefinition) {
        return builder().primitiveMessageDefinition(primitiveMessageDefinition).build();
    }

    /**
     * Create an instance of this class with {@link #primitiveMessageDefinition()} initialized to the given value.
     *
     * <p>
     * Represents a primitive type node of the complex data structure.
     * </p>
     * 
     * @param primitiveMessageDefinition
     *        Represents a primitive type node of the complex data structure.
     */
    public static StructuredMessage fromPrimitiveMessageDefinition(
            Consumer<PrimitiveMessageDefinition.Builder> primitiveMessageDefinition) {
        PrimitiveMessageDefinition.Builder builder = PrimitiveMessageDefinition.builder();
        primitiveMessageDefinition.accept(builder);
        return fromPrimitiveMessageDefinition(builder.build());
    }

    /**
     * Create an instance of this class with {@link #structuredMessageListDefinition()} initialized to the given value.
     *
     * <p>
     * Represents a list type node of the complex data structure.
     * </p>
     * 
     * @param structuredMessageListDefinition
     *        Represents a list type node of the complex data structure.
     */
    public static StructuredMessage fromStructuredMessageListDefinition(
            StructuredMessageListDefinition structuredMessageListDefinition) {
        return builder().structuredMessageListDefinition(structuredMessageListDefinition).build();
    }

    /**
     * Create an instance of this class with {@link #structuredMessageListDefinition()} initialized to the given value.
     *
     * <p>
     * Represents a list type node of the complex data structure.
     * </p>
     * 
     * @param structuredMessageListDefinition
     *        Represents a list type node of the complex data structure.
     */
    public static StructuredMessage fromStructuredMessageListDefinition(
            Consumer<StructuredMessageListDefinition.Builder> structuredMessageListDefinition) {
        StructuredMessageListDefinition.Builder builder = StructuredMessageListDefinition.builder();
        structuredMessageListDefinition.accept(builder);
        return fromStructuredMessageListDefinition(builder.build());
    }

    /**
     * Create an instance of this class with {@link #structuredMessageDefinition()} initialized to the given value.
     *
     * <p>
     * Represents a struct type node of the complex data structure.
     * </p>
     * 
     * @param structuredMessageDefinition
     *        Represents a struct type node of the complex data structure.
     */
    public static StructuredMessage fromStructuredMessageDefinition(
            List<StructuredMessageFieldNameAndDataTypePair> structuredMessageDefinition) {
        return builder().structuredMessageDefinition(structuredMessageDefinition).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StructuredMessage, T> g) {
        return obj -> g.apply((StructuredMessage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StructuredMessage> {
        /**
         * <p>
         * Represents a primitive type node of the complex data structure.
         * </p>
         * 
         * @param primitiveMessageDefinition
         *        Represents a primitive type node of the complex data structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primitiveMessageDefinition(PrimitiveMessageDefinition primitiveMessageDefinition);

        /**
         * <p>
         * Represents a primitive type node of the complex data structure.
         * </p>
         * This is a convenience method that creates an instance of the {@link PrimitiveMessageDefinition.Builder}
         * avoiding the need to create one manually via {@link PrimitiveMessageDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PrimitiveMessageDefinition.Builder#build()} is called immediately
         * and its result is passed to {@link #primitiveMessageDefinition(PrimitiveMessageDefinition)}.
         * 
         * @param primitiveMessageDefinition
         *        a consumer that will call methods on {@link PrimitiveMessageDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #primitiveMessageDefinition(PrimitiveMessageDefinition)
         */
        default Builder primitiveMessageDefinition(Consumer<PrimitiveMessageDefinition.Builder> primitiveMessageDefinition) {
            return primitiveMessageDefinition(PrimitiveMessageDefinition.builder().applyMutation(primitiveMessageDefinition)
                    .build());
        }

        /**
         * <p>
         * Represents a list type node of the complex data structure.
         * </p>
         * 
         * @param structuredMessageListDefinition
         *        Represents a list type node of the complex data structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder structuredMessageListDefinition(StructuredMessageListDefinition structuredMessageListDefinition);

        /**
         * <p>
         * Represents a list type node of the complex data structure.
         * </p>
         * This is a convenience method that creates an instance of the {@link StructuredMessageListDefinition.Builder}
         * avoiding the need to create one manually via {@link StructuredMessageListDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StructuredMessageListDefinition.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #structuredMessageListDefinition(StructuredMessageListDefinition)}.
         * 
         * @param structuredMessageListDefinition
         *        a consumer that will call methods on {@link StructuredMessageListDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #structuredMessageListDefinition(StructuredMessageListDefinition)
         */
        default Builder structuredMessageListDefinition(
                Consumer<StructuredMessageListDefinition.Builder> structuredMessageListDefinition) {
            return structuredMessageListDefinition(StructuredMessageListDefinition.builder()
                    .applyMutation(structuredMessageListDefinition).build());
        }

        /**
         * <p>
         * Represents a struct type node of the complex data structure.
         * </p>
         * 
         * @param structuredMessageDefinition
         *        Represents a struct type node of the complex data structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder structuredMessageDefinition(Collection<StructuredMessageFieldNameAndDataTypePair> structuredMessageDefinition);

        /**
         * <p>
         * Represents a struct type node of the complex data structure.
         * </p>
         * 
         * @param structuredMessageDefinition
         *        Represents a struct type node of the complex data structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder structuredMessageDefinition(StructuredMessageFieldNameAndDataTypePair... structuredMessageDefinition);

        /**
         * <p>
         * Represents a struct type node of the complex data structure.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotfleetwise.model.StructuredMessageFieldNameAndDataTypePair.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.iotfleetwise.model.StructuredMessageFieldNameAndDataTypePair#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotfleetwise.model.StructuredMessageFieldNameAndDataTypePair.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #structuredMessageDefinition(List<StructuredMessageFieldNameAndDataTypePair>)}.
         * 
         * @param structuredMessageDefinition
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotfleetwise.model.StructuredMessageFieldNameAndDataTypePair.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #structuredMessageDefinition(java.util.Collection<StructuredMessageFieldNameAndDataTypePair>)
         */
        Builder structuredMessageDefinition(
                Consumer<StructuredMessageFieldNameAndDataTypePair.Builder>... structuredMessageDefinition);
    }

    static final class BuilderImpl implements Builder {
        private PrimitiveMessageDefinition primitiveMessageDefinition;

        private StructuredMessageListDefinition structuredMessageListDefinition;

        private List<StructuredMessageFieldNameAndDataTypePair> structuredMessageDefinition = DefaultSdkAutoConstructList
                .getInstance();

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(StructuredMessage model) {
            primitiveMessageDefinition(model.primitiveMessageDefinition);
            structuredMessageListDefinition(model.structuredMessageListDefinition);
            structuredMessageDefinition(model.structuredMessageDefinition);
        }

        public final PrimitiveMessageDefinition.Builder getPrimitiveMessageDefinition() {
            return primitiveMessageDefinition != null ? primitiveMessageDefinition.toBuilder() : null;
        }

        public final void setPrimitiveMessageDefinition(PrimitiveMessageDefinition.BuilderImpl primitiveMessageDefinition) {
            Object oldValue = this.primitiveMessageDefinition;
            this.primitiveMessageDefinition = primitiveMessageDefinition != null ? primitiveMessageDefinition.build() : null;
            handleUnionValueChange(Type.PRIMITIVE_MESSAGE_DEFINITION, oldValue, this.primitiveMessageDefinition);
        }

        @Override
        public final Builder primitiveMessageDefinition(PrimitiveMessageDefinition primitiveMessageDefinition) {
            Object oldValue = this.primitiveMessageDefinition;
            this.primitiveMessageDefinition = primitiveMessageDefinition;
            handleUnionValueChange(Type.PRIMITIVE_MESSAGE_DEFINITION, oldValue, this.primitiveMessageDefinition);
            return this;
        }

        public final StructuredMessageListDefinition.Builder getStructuredMessageListDefinition() {
            return structuredMessageListDefinition != null ? structuredMessageListDefinition.toBuilder() : null;
        }

        public final void setStructuredMessageListDefinition(
                StructuredMessageListDefinition.BuilderImpl structuredMessageListDefinition) {
            Object oldValue = this.structuredMessageListDefinition;
            this.structuredMessageListDefinition = structuredMessageListDefinition != null ? structuredMessageListDefinition
                    .build() : null;
            handleUnionValueChange(Type.STRUCTURED_MESSAGE_LIST_DEFINITION, oldValue, this.structuredMessageListDefinition);
        }

        @Override
        public final Builder structuredMessageListDefinition(StructuredMessageListDefinition structuredMessageListDefinition) {
            Object oldValue = this.structuredMessageListDefinition;
            this.structuredMessageListDefinition = structuredMessageListDefinition;
            handleUnionValueChange(Type.STRUCTURED_MESSAGE_LIST_DEFINITION, oldValue, this.structuredMessageListDefinition);
            return this;
        }

        public final List<StructuredMessageFieldNameAndDataTypePair.Builder> getStructuredMessageDefinition() {
            List<StructuredMessageFieldNameAndDataTypePair.Builder> result = StructuredMessageDefinitionCopier
                    .copyToBuilder(this.structuredMessageDefinition);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStructuredMessageDefinition(
                Collection<StructuredMessageFieldNameAndDataTypePair.BuilderImpl> structuredMessageDefinition) {
            Object oldValue = this.structuredMessageDefinition;
            this.structuredMessageDefinition = StructuredMessageDefinitionCopier.copyFromBuilder(structuredMessageDefinition);
            handleUnionValueChange(Type.STRUCTURED_MESSAGE_DEFINITION, oldValue, this.structuredMessageDefinition);
        }

        @Override
        public final Builder structuredMessageDefinition(
                Collection<StructuredMessageFieldNameAndDataTypePair> structuredMessageDefinition) {
            Object oldValue = this.structuredMessageDefinition;
            this.structuredMessageDefinition = StructuredMessageDefinitionCopier.copy(structuredMessageDefinition);
            handleUnionValueChange(Type.STRUCTURED_MESSAGE_DEFINITION, oldValue, this.structuredMessageDefinition);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder structuredMessageDefinition(StructuredMessageFieldNameAndDataTypePair... structuredMessageDefinition) {
            structuredMessageDefinition(Arrays.asList(structuredMessageDefinition));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder structuredMessageDefinition(
                Consumer<StructuredMessageFieldNameAndDataTypePair.Builder>... structuredMessageDefinition) {
            structuredMessageDefinition(Stream.of(structuredMessageDefinition)
                    .map(c -> StructuredMessageFieldNameAndDataTypePair.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public StructuredMessage build() {
            return new StructuredMessage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see StructuredMessage#type()
     */
    public enum Type {
        PRIMITIVE_MESSAGE_DEFINITION,

        STRUCTURED_MESSAGE_LIST_DEFINITION,

        STRUCTURED_MESSAGE_DEFINITION,

        UNKNOWN_TO_SDK_VERSION
    }
}
