/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.iotfleetwise.model.AssociateVehicleFleetRequest;
import software.amazon.awssdk.services.iotfleetwise.model.AssociateVehicleFleetResponse;
import software.amazon.awssdk.services.iotfleetwise.model.BatchCreateVehicleRequest;
import software.amazon.awssdk.services.iotfleetwise.model.BatchCreateVehicleResponse;
import software.amazon.awssdk.services.iotfleetwise.model.BatchUpdateVehicleRequest;
import software.amazon.awssdk.services.iotfleetwise.model.BatchUpdateVehicleResponse;
import software.amazon.awssdk.services.iotfleetwise.model.CreateCampaignRequest;
import software.amazon.awssdk.services.iotfleetwise.model.CreateCampaignResponse;
import software.amazon.awssdk.services.iotfleetwise.model.CreateDecoderManifestRequest;
import software.amazon.awssdk.services.iotfleetwise.model.CreateDecoderManifestResponse;
import software.amazon.awssdk.services.iotfleetwise.model.CreateFleetRequest;
import software.amazon.awssdk.services.iotfleetwise.model.CreateFleetResponse;
import software.amazon.awssdk.services.iotfleetwise.model.CreateModelManifestRequest;
import software.amazon.awssdk.services.iotfleetwise.model.CreateModelManifestResponse;
import software.amazon.awssdk.services.iotfleetwise.model.CreateSignalCatalogRequest;
import software.amazon.awssdk.services.iotfleetwise.model.CreateSignalCatalogResponse;
import software.amazon.awssdk.services.iotfleetwise.model.CreateVehicleRequest;
import software.amazon.awssdk.services.iotfleetwise.model.CreateVehicleResponse;
import software.amazon.awssdk.services.iotfleetwise.model.DeleteCampaignRequest;
import software.amazon.awssdk.services.iotfleetwise.model.DeleteCampaignResponse;
import software.amazon.awssdk.services.iotfleetwise.model.DeleteDecoderManifestRequest;
import software.amazon.awssdk.services.iotfleetwise.model.DeleteDecoderManifestResponse;
import software.amazon.awssdk.services.iotfleetwise.model.DeleteFleetRequest;
import software.amazon.awssdk.services.iotfleetwise.model.DeleteFleetResponse;
import software.amazon.awssdk.services.iotfleetwise.model.DeleteModelManifestRequest;
import software.amazon.awssdk.services.iotfleetwise.model.DeleteModelManifestResponse;
import software.amazon.awssdk.services.iotfleetwise.model.DeleteSignalCatalogRequest;
import software.amazon.awssdk.services.iotfleetwise.model.DeleteSignalCatalogResponse;
import software.amazon.awssdk.services.iotfleetwise.model.DeleteVehicleRequest;
import software.amazon.awssdk.services.iotfleetwise.model.DeleteVehicleResponse;
import software.amazon.awssdk.services.iotfleetwise.model.DisassociateVehicleFleetRequest;
import software.amazon.awssdk.services.iotfleetwise.model.DisassociateVehicleFleetResponse;
import software.amazon.awssdk.services.iotfleetwise.model.GetCampaignRequest;
import software.amazon.awssdk.services.iotfleetwise.model.GetCampaignResponse;
import software.amazon.awssdk.services.iotfleetwise.model.GetDecoderManifestRequest;
import software.amazon.awssdk.services.iotfleetwise.model.GetDecoderManifestResponse;
import software.amazon.awssdk.services.iotfleetwise.model.GetEncryptionConfigurationRequest;
import software.amazon.awssdk.services.iotfleetwise.model.GetEncryptionConfigurationResponse;
import software.amazon.awssdk.services.iotfleetwise.model.GetFleetRequest;
import software.amazon.awssdk.services.iotfleetwise.model.GetFleetResponse;
import software.amazon.awssdk.services.iotfleetwise.model.GetLoggingOptionsRequest;
import software.amazon.awssdk.services.iotfleetwise.model.GetLoggingOptionsResponse;
import software.amazon.awssdk.services.iotfleetwise.model.GetModelManifestRequest;
import software.amazon.awssdk.services.iotfleetwise.model.GetModelManifestResponse;
import software.amazon.awssdk.services.iotfleetwise.model.GetRegisterAccountStatusRequest;
import software.amazon.awssdk.services.iotfleetwise.model.GetRegisterAccountStatusResponse;
import software.amazon.awssdk.services.iotfleetwise.model.GetSignalCatalogRequest;
import software.amazon.awssdk.services.iotfleetwise.model.GetSignalCatalogResponse;
import software.amazon.awssdk.services.iotfleetwise.model.GetVehicleRequest;
import software.amazon.awssdk.services.iotfleetwise.model.GetVehicleResponse;
import software.amazon.awssdk.services.iotfleetwise.model.GetVehicleStatusRequest;
import software.amazon.awssdk.services.iotfleetwise.model.GetVehicleStatusResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ImportDecoderManifestRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ImportDecoderManifestResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ImportSignalCatalogRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ImportSignalCatalogResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ListCampaignsRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListCampaignsResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestNetworkInterfacesRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestNetworkInterfacesResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestSignalsRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestSignalsResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestsRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestsResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ListFleetsForVehicleRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListFleetsForVehicleResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ListFleetsRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListFleetsResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestNodesRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestNodesResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestsRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestsResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogNodesRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogNodesResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogsRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogsResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesInFleetRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesInFleetResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesResponse;
import software.amazon.awssdk.services.iotfleetwise.model.PutEncryptionConfigurationRequest;
import software.amazon.awssdk.services.iotfleetwise.model.PutEncryptionConfigurationResponse;
import software.amazon.awssdk.services.iotfleetwise.model.PutLoggingOptionsRequest;
import software.amazon.awssdk.services.iotfleetwise.model.PutLoggingOptionsResponse;
import software.amazon.awssdk.services.iotfleetwise.model.RegisterAccountRequest;
import software.amazon.awssdk.services.iotfleetwise.model.RegisterAccountResponse;
import software.amazon.awssdk.services.iotfleetwise.model.TagResourceRequest;
import software.amazon.awssdk.services.iotfleetwise.model.TagResourceResponse;
import software.amazon.awssdk.services.iotfleetwise.model.UntagResourceRequest;
import software.amazon.awssdk.services.iotfleetwise.model.UntagResourceResponse;
import software.amazon.awssdk.services.iotfleetwise.model.UpdateCampaignRequest;
import software.amazon.awssdk.services.iotfleetwise.model.UpdateCampaignResponse;
import software.amazon.awssdk.services.iotfleetwise.model.UpdateDecoderManifestRequest;
import software.amazon.awssdk.services.iotfleetwise.model.UpdateDecoderManifestResponse;
import software.amazon.awssdk.services.iotfleetwise.model.UpdateFleetRequest;
import software.amazon.awssdk.services.iotfleetwise.model.UpdateFleetResponse;
import software.amazon.awssdk.services.iotfleetwise.model.UpdateModelManifestRequest;
import software.amazon.awssdk.services.iotfleetwise.model.UpdateModelManifestResponse;
import software.amazon.awssdk.services.iotfleetwise.model.UpdateSignalCatalogRequest;
import software.amazon.awssdk.services.iotfleetwise.model.UpdateSignalCatalogResponse;
import software.amazon.awssdk.services.iotfleetwise.model.UpdateVehicleRequest;
import software.amazon.awssdk.services.iotfleetwise.model.UpdateVehicleResponse;
import software.amazon.awssdk.services.iotfleetwise.paginators.GetVehicleStatusPublisher;
import software.amazon.awssdk.services.iotfleetwise.paginators.ListCampaignsPublisher;
import software.amazon.awssdk.services.iotfleetwise.paginators.ListDecoderManifestNetworkInterfacesPublisher;
import software.amazon.awssdk.services.iotfleetwise.paginators.ListDecoderManifestSignalsPublisher;
import software.amazon.awssdk.services.iotfleetwise.paginators.ListDecoderManifestsPublisher;
import software.amazon.awssdk.services.iotfleetwise.paginators.ListFleetsForVehiclePublisher;
import software.amazon.awssdk.services.iotfleetwise.paginators.ListFleetsPublisher;
import software.amazon.awssdk.services.iotfleetwise.paginators.ListModelManifestNodesPublisher;
import software.amazon.awssdk.services.iotfleetwise.paginators.ListModelManifestsPublisher;
import software.amazon.awssdk.services.iotfleetwise.paginators.ListSignalCatalogNodesPublisher;
import software.amazon.awssdk.services.iotfleetwise.paginators.ListSignalCatalogsPublisher;
import software.amazon.awssdk.services.iotfleetwise.paginators.ListVehiclesInFleetPublisher;
import software.amazon.awssdk.services.iotfleetwise.paginators.ListVehiclesPublisher;

/**
 * Service client for accessing AWS IoT FleetWise asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * Amazon Web Services IoT FleetWise is a fully managed service that you can use to collect, model, and transfer vehicle
 * data to the Amazon Web Services cloud at scale. With Amazon Web Services IoT FleetWise, you can standardize all of
 * your vehicle data models, independent of the in-vehicle communication architecture, and define data collection rules
 * to transfer only high-value data to the cloud.
 * </p>
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/">What is Amazon
 * Web Services IoT FleetWise?</a> in the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface IoTFleetWiseAsyncClient extends AwsClient {
    String SERVICE_NAME = "iotfleetwise";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "iotfleetwise";

    /**
     * <p>
     * Adds, or associates, a vehicle with a fleet.
     * </p>
     *
     * @param associateVehicleFleetRequest
     * @return A Java Future containing the result of the AssociateVehicleFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>LimitExceededException A service quota was exceeded.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.AssociateVehicleFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/AssociateVehicleFleet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateVehicleFleetResponse> associateVehicleFleet(
            AssociateVehicleFleetRequest associateVehicleFleetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds, or associates, a vehicle with a fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateVehicleFleetRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateVehicleFleetRequest#builder()}
     * </p>
     *
     * @param associateVehicleFleetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.AssociateVehicleFleetRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the AssociateVehicleFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>LimitExceededException A service quota was exceeded.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.AssociateVehicleFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/AssociateVehicleFleet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateVehicleFleetResponse> associateVehicleFleet(
            Consumer<AssociateVehicleFleetRequest.Builder> associateVehicleFleetRequest) {
        return associateVehicleFleet(AssociateVehicleFleetRequest.builder().applyMutation(associateVehicleFleetRequest).build());
    }

    /**
     * <p>
     * Creates a group, or batch, of vehicles.
     * </p>
     * <note>
     * <p>
     * You must specify a decoder manifest and a vehicle model (model manifest) for each vehicle.
     * </p>
     * </note>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/create-vehicles-cli.html">Create multiple
     * vehicles (AWS CLI)</a> in the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.
     * </p>
     *
     * @param batchCreateVehicleRequest
     * @return A Java Future containing the result of the BatchCreateVehicle operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>LimitExceededException A service quota was exceeded.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.BatchCreateVehicle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/BatchCreateVehicle"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchCreateVehicleResponse> batchCreateVehicle(BatchCreateVehicleRequest batchCreateVehicleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a group, or batch, of vehicles.
     * </p>
     * <note>
     * <p>
     * You must specify a decoder manifest and a vehicle model (model manifest) for each vehicle.
     * </p>
     * </note>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/create-vehicles-cli.html">Create multiple
     * vehicles (AWS CLI)</a> in the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchCreateVehicleRequest.Builder} avoiding the
     * need to create one manually via {@link BatchCreateVehicleRequest#builder()}
     * </p>
     *
     * @param batchCreateVehicleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.BatchCreateVehicleRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchCreateVehicle operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>LimitExceededException A service quota was exceeded.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.BatchCreateVehicle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/BatchCreateVehicle"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchCreateVehicleResponse> batchCreateVehicle(
            Consumer<BatchCreateVehicleRequest.Builder> batchCreateVehicleRequest) {
        return batchCreateVehicle(BatchCreateVehicleRequest.builder().applyMutation(batchCreateVehicleRequest).build());
    }

    /**
     * <p>
     * Updates a group, or batch, of vehicles.
     * </p>
     * <note>
     * <p>
     * You must specify a decoder manifest and a vehicle model (model manifest) for each vehicle.
     * </p>
     * </note>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/update-vehicles-cli.html">Update multiple
     * vehicles (AWS CLI)</a> in the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.
     * </p>
     *
     * @param batchUpdateVehicleRequest
     * @return A Java Future containing the result of the BatchUpdateVehicle operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.BatchUpdateVehicle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/BatchUpdateVehicle"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchUpdateVehicleResponse> batchUpdateVehicle(BatchUpdateVehicleRequest batchUpdateVehicleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a group, or batch, of vehicles.
     * </p>
     * <note>
     * <p>
     * You must specify a decoder manifest and a vehicle model (model manifest) for each vehicle.
     * </p>
     * </note>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/update-vehicles-cli.html">Update multiple
     * vehicles (AWS CLI)</a> in the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchUpdateVehicleRequest.Builder} avoiding the
     * need to create one manually via {@link BatchUpdateVehicleRequest#builder()}
     * </p>
     *
     * @param batchUpdateVehicleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.BatchUpdateVehicleRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchUpdateVehicle operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.BatchUpdateVehicle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/BatchUpdateVehicle"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchUpdateVehicleResponse> batchUpdateVehicle(
            Consumer<BatchUpdateVehicleRequest.Builder> batchUpdateVehicleRequest) {
        return batchUpdateVehicle(BatchUpdateVehicleRequest.builder().applyMutation(batchUpdateVehicleRequest).build());
    }

    /**
     * <p>
     * Creates an orchestration of data collection rules. The Amazon Web Services IoT FleetWise Edge Agent software
     * running in vehicles uses campaigns to decide how to collect and transfer data to the cloud. You create campaigns
     * in the cloud. After you or your team approve campaigns, Amazon Web Services IoT FleetWise automatically deploys
     * them to vehicles.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/campaigns.html">Collect and transfer data
     * with campaigns</a> in the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.
     * </p>
     *
     * @param createCampaignRequest
     * @return A Java Future containing the result of the CreateCampaign operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>LimitExceededException A service quota was exceeded.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.CreateCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/CreateCampaign" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateCampaignResponse> createCampaign(CreateCampaignRequest createCampaignRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an orchestration of data collection rules. The Amazon Web Services IoT FleetWise Edge Agent software
     * running in vehicles uses campaigns to decide how to collect and transfer data to the cloud. You create campaigns
     * in the cloud. After you or your team approve campaigns, Amazon Web Services IoT FleetWise automatically deploys
     * them to vehicles.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/campaigns.html">Collect and transfer data
     * with campaigns</a> in the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCampaignRequest.Builder} avoiding the need to
     * create one manually via {@link CreateCampaignRequest#builder()}
     * </p>
     *
     * @param createCampaignRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.CreateCampaignRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateCampaign operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>LimitExceededException A service quota was exceeded.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.CreateCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/CreateCampaign" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateCampaignResponse> createCampaign(Consumer<CreateCampaignRequest.Builder> createCampaignRequest) {
        return createCampaign(CreateCampaignRequest.builder().applyMutation(createCampaignRequest).build());
    }

    /**
     * <p>
     * Creates the decoder manifest associated with a model manifest. To create a decoder manifest, the following must
     * be true:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Every signal decoder has a unique name.
     * </p>
     * </li>
     * <li>
     * <p>
     * Each signal decoder is associated with a network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * Each network interface has a unique ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * The signal decoders are specified in the model manifest.
     * </p>
     * </li>
     * </ul>
     *
     * @param createDecoderManifestRequest
     * @return A Java Future containing the result of the CreateDecoderManifest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>LimitExceededException A service quota was exceeded.</li>
     *         <li>DecoderManifestValidationException The request couldn't be completed because it contains signal
     *         decoders with one or more validation errors.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.CreateDecoderManifest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/CreateDecoderManifest"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDecoderManifestResponse> createDecoderManifest(
            CreateDecoderManifestRequest createDecoderManifestRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates the decoder manifest associated with a model manifest. To create a decoder manifest, the following must
     * be true:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Every signal decoder has a unique name.
     * </p>
     * </li>
     * <li>
     * <p>
     * Each signal decoder is associated with a network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * Each network interface has a unique ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * The signal decoders are specified in the model manifest.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDecoderManifestRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDecoderManifestRequest#builder()}
     * </p>
     *
     * @param createDecoderManifestRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.CreateDecoderManifestRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateDecoderManifest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>LimitExceededException A service quota was exceeded.</li>
     *         <li>DecoderManifestValidationException The request couldn't be completed because it contains signal
     *         decoders with one or more validation errors.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.CreateDecoderManifest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/CreateDecoderManifest"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDecoderManifestResponse> createDecoderManifest(
            Consumer<CreateDecoderManifestRequest.Builder> createDecoderManifestRequest) {
        return createDecoderManifest(CreateDecoderManifestRequest.builder().applyMutation(createDecoderManifestRequest).build());
    }

    /**
     * <p>
     * Creates a fleet that represents a group of vehicles.
     * </p>
     * <note>
     * <p>
     * You must create both a signal catalog and vehicles before you can create a fleet.
     * </p>
     * </note>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/fleets.html">Fleets</a> in the <i>Amazon
     * Web Services IoT FleetWise Developer Guide</i>.
     * </p>
     *
     * @param createFleetRequest
     * @return A Java Future containing the result of the CreateFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>LimitExceededException A service quota was exceeded.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.CreateFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/CreateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateFleetResponse> createFleet(CreateFleetRequest createFleetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a fleet that represents a group of vehicles.
     * </p>
     * <note>
     * <p>
     * You must create both a signal catalog and vehicles before you can create a fleet.
     * </p>
     * </note>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/fleets.html">Fleets</a> in the <i>Amazon
     * Web Services IoT FleetWise Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFleetRequest.Builder} avoiding the need to
     * create one manually via {@link CreateFleetRequest#builder()}
     * </p>
     *
     * @param createFleetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.CreateFleetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>LimitExceededException A service quota was exceeded.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.CreateFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/CreateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateFleetResponse> createFleet(Consumer<CreateFleetRequest.Builder> createFleetRequest) {
        return createFleet(CreateFleetRequest.builder().applyMutation(createFleetRequest).build());
    }

    /**
     * <p>
     * Creates a vehicle model (model manifest) that specifies signals (attributes, branches, sensors, and actuators).
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/vehicle-models.html">Vehicle models</a> in
     * the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.
     * </p>
     *
     * @param createModelManifestRequest
     * @return A Java Future containing the result of the CreateModelManifest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>LimitExceededException A service quota was exceeded.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InvalidSignalsException The request couldn't be completed because it contains signals that aren't
     *         valid.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.CreateModelManifest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/CreateModelManifest"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateModelManifestResponse> createModelManifest(
            CreateModelManifestRequest createModelManifestRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a vehicle model (model manifest) that specifies signals (attributes, branches, sensors, and actuators).
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/vehicle-models.html">Vehicle models</a> in
     * the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateModelManifestRequest.Builder} avoiding the
     * need to create one manually via {@link CreateModelManifestRequest#builder()}
     * </p>
     *
     * @param createModelManifestRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.CreateModelManifestRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateModelManifest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>LimitExceededException A service quota was exceeded.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InvalidSignalsException The request couldn't be completed because it contains signals that aren't
     *         valid.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.CreateModelManifest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/CreateModelManifest"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateModelManifestResponse> createModelManifest(
            Consumer<CreateModelManifestRequest.Builder> createModelManifestRequest) {
        return createModelManifest(CreateModelManifestRequest.builder().applyMutation(createModelManifestRequest).build());
    }

    /**
     * <p>
     * Creates a collection of standardized signals that can be reused to create vehicle models.
     * </p>
     *
     * @param createSignalCatalogRequest
     * @return A Java Future containing the result of the CreateSignalCatalog operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>LimitExceededException A service quota was exceeded.</li>
     *         <li>InvalidNodeException The specified node type doesn't match the expected node type for a node. You can
     *         specify the node type as branch, sensor, actuator, or attribute.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InvalidSignalsException The request couldn't be completed because it contains signals that aren't
     *         valid.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.CreateSignalCatalog
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/CreateSignalCatalog"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSignalCatalogResponse> createSignalCatalog(
            CreateSignalCatalogRequest createSignalCatalogRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a collection of standardized signals that can be reused to create vehicle models.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSignalCatalogRequest.Builder} avoiding the
     * need to create one manually via {@link CreateSignalCatalogRequest#builder()}
     * </p>
     *
     * @param createSignalCatalogRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.CreateSignalCatalogRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateSignalCatalog operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>LimitExceededException A service quota was exceeded.</li>
     *         <li>InvalidNodeException The specified node type doesn't match the expected node type for a node. You can
     *         specify the node type as branch, sensor, actuator, or attribute.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InvalidSignalsException The request couldn't be completed because it contains signals that aren't
     *         valid.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.CreateSignalCatalog
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/CreateSignalCatalog"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSignalCatalogResponse> createSignalCatalog(
            Consumer<CreateSignalCatalogRequest.Builder> createSignalCatalogRequest) {
        return createSignalCatalog(CreateSignalCatalogRequest.builder().applyMutation(createSignalCatalogRequest).build());
    }

    /**
     * <p>
     * Creates a vehicle, which is an instance of a vehicle model (model manifest). Vehicles created from the same
     * vehicle model consist of the same signals inherited from the vehicle model.
     * </p>
     * <note>
     * <p>
     * If you have an existing Amazon Web Services IoT thing, you can use Amazon Web Services IoT FleetWise to create a
     * vehicle and collect data from your thing.
     * </p>
     * </note>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/create-vehicle-cli.html">Create a vehicle
     * (AWS CLI)</a> in the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.
     * </p>
     *
     * @param createVehicleRequest
     * @return A Java Future containing the result of the CreateVehicle operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>LimitExceededException A service quota was exceeded.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.CreateVehicle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/CreateVehicle" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateVehicleResponse> createVehicle(CreateVehicleRequest createVehicleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a vehicle, which is an instance of a vehicle model (model manifest). Vehicles created from the same
     * vehicle model consist of the same signals inherited from the vehicle model.
     * </p>
     * <note>
     * <p>
     * If you have an existing Amazon Web Services IoT thing, you can use Amazon Web Services IoT FleetWise to create a
     * vehicle and collect data from your thing.
     * </p>
     * </note>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/create-vehicle-cli.html">Create a vehicle
     * (AWS CLI)</a> in the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVehicleRequest.Builder} avoiding the need to
     * create one manually via {@link CreateVehicleRequest#builder()}
     * </p>
     *
     * @param createVehicleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.CreateVehicleRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateVehicle operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>LimitExceededException A service quota was exceeded.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.CreateVehicle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/CreateVehicle" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateVehicleResponse> createVehicle(Consumer<CreateVehicleRequest.Builder> createVehicleRequest) {
        return createVehicle(CreateVehicleRequest.builder().applyMutation(createVehicleRequest).build());
    }

    /**
     * <p>
     * Deletes a data collection campaign. Deleting a campaign suspends all data collection and removes it from any
     * vehicles.
     * </p>
     *
     * @param deleteCampaignRequest
     * @return A Java Future containing the result of the DeleteCampaign operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.DeleteCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/DeleteCampaign" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteCampaignResponse> deleteCampaign(DeleteCampaignRequest deleteCampaignRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a data collection campaign. Deleting a campaign suspends all data collection and removes it from any
     * vehicles.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCampaignRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteCampaignRequest#builder()}
     * </p>
     *
     * @param deleteCampaignRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.DeleteCampaignRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteCampaign operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.DeleteCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/DeleteCampaign" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteCampaignResponse> deleteCampaign(Consumer<DeleteCampaignRequest.Builder> deleteCampaignRequest) {
        return deleteCampaign(DeleteCampaignRequest.builder().applyMutation(deleteCampaignRequest).build());
    }

    /**
     * <p>
     * Deletes a decoder manifest. You can't delete a decoder manifest if it has vehicles associated with it.
     * </p>
     * <note>
     * <p>
     * If the decoder manifest is successfully deleted, Amazon Web Services IoT FleetWise sends back an HTTP 200
     * response with an empty body.
     * </p>
     * </note>
     *
     * @param deleteDecoderManifestRequest
     * @return A Java Future containing the result of the DeleteDecoderManifest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.DeleteDecoderManifest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/DeleteDecoderManifest"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDecoderManifestResponse> deleteDecoderManifest(
            DeleteDecoderManifestRequest deleteDecoderManifestRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a decoder manifest. You can't delete a decoder manifest if it has vehicles associated with it.
     * </p>
     * <note>
     * <p>
     * If the decoder manifest is successfully deleted, Amazon Web Services IoT FleetWise sends back an HTTP 200
     * response with an empty body.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDecoderManifestRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDecoderManifestRequest#builder()}
     * </p>
     *
     * @param deleteDecoderManifestRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.DeleteDecoderManifestRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteDecoderManifest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.DeleteDecoderManifest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/DeleteDecoderManifest"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDecoderManifestResponse> deleteDecoderManifest(
            Consumer<DeleteDecoderManifestRequest.Builder> deleteDecoderManifestRequest) {
        return deleteDecoderManifest(DeleteDecoderManifestRequest.builder().applyMutation(deleteDecoderManifestRequest).build());
    }

    /**
     * <p>
     * Deletes a fleet. Before you delete a fleet, all vehicles must be dissociated from the fleet. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/delete-fleet-cli.html">Delete a fleet (AWS
     * CLI)</a> in the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.
     * </p>
     * <note>
     * <p>
     * If the fleet is successfully deleted, Amazon Web Services IoT FleetWise sends back an HTTP 200 response with an
     * empty body.
     * </p>
     * </note>
     *
     * @param deleteFleetRequest
     * @return A Java Future containing the result of the DeleteFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.DeleteFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/DeleteFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteFleetResponse> deleteFleet(DeleteFleetRequest deleteFleetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a fleet. Before you delete a fleet, all vehicles must be dissociated from the fleet. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/delete-fleet-cli.html">Delete a fleet (AWS
     * CLI)</a> in the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.
     * </p>
     * <note>
     * <p>
     * If the fleet is successfully deleted, Amazon Web Services IoT FleetWise sends back an HTTP 200 response with an
     * empty body.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFleetRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteFleetRequest#builder()}
     * </p>
     *
     * @param deleteFleetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.DeleteFleetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.DeleteFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/DeleteFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteFleetResponse> deleteFleet(Consumer<DeleteFleetRequest.Builder> deleteFleetRequest) {
        return deleteFleet(DeleteFleetRequest.builder().applyMutation(deleteFleetRequest).build());
    }

    /**
     * <p>
     * Deletes a vehicle model (model manifest).
     * </p>
     * <note>
     * <p>
     * If the vehicle model is successfully deleted, Amazon Web Services IoT FleetWise sends back an HTTP 200 response
     * with an empty body.
     * </p>
     * </note>
     *
     * @param deleteModelManifestRequest
     * @return A Java Future containing the result of the DeleteModelManifest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.DeleteModelManifest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/DeleteModelManifest"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteModelManifestResponse> deleteModelManifest(
            DeleteModelManifestRequest deleteModelManifestRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a vehicle model (model manifest).
     * </p>
     * <note>
     * <p>
     * If the vehicle model is successfully deleted, Amazon Web Services IoT FleetWise sends back an HTTP 200 response
     * with an empty body.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteModelManifestRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteModelManifestRequest#builder()}
     * </p>
     *
     * @param deleteModelManifestRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.DeleteModelManifestRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteModelManifest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.DeleteModelManifest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/DeleteModelManifest"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteModelManifestResponse> deleteModelManifest(
            Consumer<DeleteModelManifestRequest.Builder> deleteModelManifestRequest) {
        return deleteModelManifest(DeleteModelManifestRequest.builder().applyMutation(deleteModelManifestRequest).build());
    }

    /**
     * <p>
     * Deletes a signal catalog.
     * </p>
     * <note>
     * <p>
     * If the signal catalog is successfully deleted, Amazon Web Services IoT FleetWise sends back an HTTP 200 response
     * with an empty body.
     * </p>
     * </note>
     *
     * @param deleteSignalCatalogRequest
     * @return A Java Future containing the result of the DeleteSignalCatalog operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.DeleteSignalCatalog
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/DeleteSignalCatalog"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSignalCatalogResponse> deleteSignalCatalog(
            DeleteSignalCatalogRequest deleteSignalCatalogRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a signal catalog.
     * </p>
     * <note>
     * <p>
     * If the signal catalog is successfully deleted, Amazon Web Services IoT FleetWise sends back an HTTP 200 response
     * with an empty body.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSignalCatalogRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteSignalCatalogRequest#builder()}
     * </p>
     *
     * @param deleteSignalCatalogRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.DeleteSignalCatalogRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteSignalCatalog operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.DeleteSignalCatalog
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/DeleteSignalCatalog"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSignalCatalogResponse> deleteSignalCatalog(
            Consumer<DeleteSignalCatalogRequest.Builder> deleteSignalCatalogRequest) {
        return deleteSignalCatalog(DeleteSignalCatalogRequest.builder().applyMutation(deleteSignalCatalogRequest).build());
    }

    /**
     * <p>
     * Deletes a vehicle and removes it from any campaigns.
     * </p>
     * <note>
     * <p>
     * If the vehicle is successfully deleted, Amazon Web Services IoT FleetWise sends back an HTTP 200 response with an
     * empty body.
     * </p>
     * </note>
     *
     * @param deleteVehicleRequest
     * @return A Java Future containing the result of the DeleteVehicle operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.DeleteVehicle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/DeleteVehicle" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteVehicleResponse> deleteVehicle(DeleteVehicleRequest deleteVehicleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a vehicle and removes it from any campaigns.
     * </p>
     * <note>
     * <p>
     * If the vehicle is successfully deleted, Amazon Web Services IoT FleetWise sends back an HTTP 200 response with an
     * empty body.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVehicleRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteVehicleRequest#builder()}
     * </p>
     *
     * @param deleteVehicleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.DeleteVehicleRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteVehicle operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.DeleteVehicle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/DeleteVehicle" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteVehicleResponse> deleteVehicle(Consumer<DeleteVehicleRequest.Builder> deleteVehicleRequest) {
        return deleteVehicle(DeleteVehicleRequest.builder().applyMutation(deleteVehicleRequest).build());
    }

    /**
     * <p>
     * Removes, or disassociates, a vehicle from a fleet. Disassociating a vehicle from a fleet doesn't delete the
     * vehicle.
     * </p>
     * <note>
     * <p>
     * If the vehicle is successfully dissociated from a fleet, Amazon Web Services IoT FleetWise sends back an HTTP 200
     * response with an empty body.
     * </p>
     * </note>
     *
     * @param disassociateVehicleFleetRequest
     * @return A Java Future containing the result of the DisassociateVehicleFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.DisassociateVehicleFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/DisassociateVehicleFleet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateVehicleFleetResponse> disassociateVehicleFleet(
            DisassociateVehicleFleetRequest disassociateVehicleFleetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes, or disassociates, a vehicle from a fleet. Disassociating a vehicle from a fleet doesn't delete the
     * vehicle.
     * </p>
     * <note>
     * <p>
     * If the vehicle is successfully dissociated from a fleet, Amazon Web Services IoT FleetWise sends back an HTTP 200
     * response with an empty body.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateVehicleFleetRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateVehicleFleetRequest#builder()}
     * </p>
     *
     * @param disassociateVehicleFleetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.DisassociateVehicleFleetRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DisassociateVehicleFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.DisassociateVehicleFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/DisassociateVehicleFleet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateVehicleFleetResponse> disassociateVehicleFleet(
            Consumer<DisassociateVehicleFleetRequest.Builder> disassociateVehicleFleetRequest) {
        return disassociateVehicleFleet(DisassociateVehicleFleetRequest.builder().applyMutation(disassociateVehicleFleetRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves information about a campaign.
     * </p>
     *
     * @param getCampaignRequest
     * @return A Java Future containing the result of the GetCampaign operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.GetCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetCampaign" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetCampaignResponse> getCampaign(GetCampaignRequest getCampaignRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a campaign.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCampaignRequest.Builder} avoiding the need to
     * create one manually via {@link GetCampaignRequest#builder()}
     * </p>
     *
     * @param getCampaignRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.GetCampaignRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetCampaign operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.GetCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetCampaign" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetCampaignResponse> getCampaign(Consumer<GetCampaignRequest.Builder> getCampaignRequest) {
        return getCampaign(GetCampaignRequest.builder().applyMutation(getCampaignRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a created decoder manifest.
     * </p>
     *
     * @param getDecoderManifestRequest
     * @return A Java Future containing the result of the GetDecoderManifest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.GetDecoderManifest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetDecoderManifest"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDecoderManifestResponse> getDecoderManifest(GetDecoderManifestRequest getDecoderManifestRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a created decoder manifest.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDecoderManifestRequest.Builder} avoiding the
     * need to create one manually via {@link GetDecoderManifestRequest#builder()}
     * </p>
     *
     * @param getDecoderManifestRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.GetDecoderManifestRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetDecoderManifest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.GetDecoderManifest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetDecoderManifest"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDecoderManifestResponse> getDecoderManifest(
            Consumer<GetDecoderManifestRequest.Builder> getDecoderManifestRequest) {
        return getDecoderManifest(GetDecoderManifestRequest.builder().applyMutation(getDecoderManifestRequest).build());
    }

    /**
     * <p>
     * Retrieves the encryption configuration for resources and data in Amazon Web Services IoT FleetWise.
     * </p>
     *
     * @param getEncryptionConfigurationRequest
     * @return A Java Future containing the result of the GetEncryptionConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.GetEncryptionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetEncryptionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEncryptionConfigurationResponse> getEncryptionConfiguration(
            GetEncryptionConfigurationRequest getEncryptionConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the encryption configuration for resources and data in Amazon Web Services IoT FleetWise.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEncryptionConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link GetEncryptionConfigurationRequest#builder()}
     * </p>
     *
     * @param getEncryptionConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.GetEncryptionConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetEncryptionConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.GetEncryptionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetEncryptionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEncryptionConfigurationResponse> getEncryptionConfiguration(
            Consumer<GetEncryptionConfigurationRequest.Builder> getEncryptionConfigurationRequest) {
        return getEncryptionConfiguration(GetEncryptionConfigurationRequest.builder()
                .applyMutation(getEncryptionConfigurationRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a fleet.
     * </p>
     *
     * @param getFleetRequest
     * @return A Java Future containing the result of the GetFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.GetFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetFleetResponse> getFleet(GetFleetRequest getFleetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFleetRequest.Builder} avoiding the need to
     * create one manually via {@link GetFleetRequest#builder()}
     * </p>
     *
     * @param getFleetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.GetFleetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.GetFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetFleetResponse> getFleet(Consumer<GetFleetRequest.Builder> getFleetRequest) {
        return getFleet(GetFleetRequest.builder().applyMutation(getFleetRequest).build());
    }

    /**
     * <p>
     * Retrieves the logging options.
     * </p>
     *
     * @param getLoggingOptionsRequest
     * @return A Java Future containing the result of the GetLoggingOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.GetLoggingOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetLoggingOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetLoggingOptionsResponse> getLoggingOptions(GetLoggingOptionsRequest getLoggingOptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the logging options.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLoggingOptionsRequest.Builder} avoiding the need
     * to create one manually via {@link GetLoggingOptionsRequest#builder()}
     * </p>
     *
     * @param getLoggingOptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.GetLoggingOptionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetLoggingOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.GetLoggingOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetLoggingOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetLoggingOptionsResponse> getLoggingOptions(
            Consumer<GetLoggingOptionsRequest.Builder> getLoggingOptionsRequest) {
        return getLoggingOptions(GetLoggingOptionsRequest.builder().applyMutation(getLoggingOptionsRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a vehicle model (model manifest).
     * </p>
     *
     * @param getModelManifestRequest
     * @return A Java Future containing the result of the GetModelManifest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.GetModelManifest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetModelManifest" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetModelManifestResponse> getModelManifest(GetModelManifestRequest getModelManifestRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a vehicle model (model manifest).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetModelManifestRequest.Builder} avoiding the need
     * to create one manually via {@link GetModelManifestRequest#builder()}
     * </p>
     *
     * @param getModelManifestRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.GetModelManifestRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetModelManifest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.GetModelManifest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetModelManifest" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetModelManifestResponse> getModelManifest(
            Consumer<GetModelManifestRequest.Builder> getModelManifestRequest) {
        return getModelManifest(GetModelManifestRequest.builder().applyMutation(getModelManifestRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the status of registering your Amazon Web Services account, IAM, and Amazon
     * Timestream resources so that Amazon Web Services IoT FleetWise can transfer your vehicle data to the Amazon Web
     * Services Cloud.
     * </p>
     * <p>
     * For more information, including step-by-step procedures, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/setting-up.html">Setting up Amazon Web
     * Services IoT FleetWise</a>.
     * </p>
     * <note>
     * <p>
     * This API operation doesn't require input parameters.
     * </p>
     * </note>
     *
     * @param getRegisterAccountStatusRequest
     * @return A Java Future containing the result of the GetRegisterAccountStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.GetRegisterAccountStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetRegisterAccountStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRegisterAccountStatusResponse> getRegisterAccountStatus(
            GetRegisterAccountStatusRequest getRegisterAccountStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the status of registering your Amazon Web Services account, IAM, and Amazon
     * Timestream resources so that Amazon Web Services IoT FleetWise can transfer your vehicle data to the Amazon Web
     * Services Cloud.
     * </p>
     * <p>
     * For more information, including step-by-step procedures, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/setting-up.html">Setting up Amazon Web
     * Services IoT FleetWise</a>.
     * </p>
     * <note>
     * <p>
     * This API operation doesn't require input parameters.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRegisterAccountStatusRequest.Builder} avoiding
     * the need to create one manually via {@link GetRegisterAccountStatusRequest#builder()}
     * </p>
     *
     * @param getRegisterAccountStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.GetRegisterAccountStatusRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetRegisterAccountStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.GetRegisterAccountStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetRegisterAccountStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRegisterAccountStatusResponse> getRegisterAccountStatus(
            Consumer<GetRegisterAccountStatusRequest.Builder> getRegisterAccountStatusRequest) {
        return getRegisterAccountStatus(GetRegisterAccountStatusRequest.builder().applyMutation(getRegisterAccountStatusRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves information about a signal catalog.
     * </p>
     *
     * @param getSignalCatalogRequest
     * @return A Java Future containing the result of the GetSignalCatalog operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.GetSignalCatalog
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetSignalCatalog" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetSignalCatalogResponse> getSignalCatalog(GetSignalCatalogRequest getSignalCatalogRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a signal catalog.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSignalCatalogRequest.Builder} avoiding the need
     * to create one manually via {@link GetSignalCatalogRequest#builder()}
     * </p>
     *
     * @param getSignalCatalogRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.GetSignalCatalogRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetSignalCatalog operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.GetSignalCatalog
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetSignalCatalog" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetSignalCatalogResponse> getSignalCatalog(
            Consumer<GetSignalCatalogRequest.Builder> getSignalCatalogRequest) {
        return getSignalCatalog(GetSignalCatalogRequest.builder().applyMutation(getSignalCatalogRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a vehicle.
     * </p>
     *
     * @param getVehicleRequest
     * @return A Java Future containing the result of the GetVehicle operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.GetVehicle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetVehicle" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetVehicleResponse> getVehicle(GetVehicleRequest getVehicleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a vehicle.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVehicleRequest.Builder} avoiding the need to
     * create one manually via {@link GetVehicleRequest#builder()}
     * </p>
     *
     * @param getVehicleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.GetVehicleRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetVehicle operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.GetVehicle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetVehicle" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetVehicleResponse> getVehicle(Consumer<GetVehicleRequest.Builder> getVehicleRequest) {
        return getVehicle(GetVehicleRequest.builder().applyMutation(getVehicleRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the status of a vehicle with any associated campaigns.
     * </p>
     *
     * @param getVehicleStatusRequest
     * @return A Java Future containing the result of the GetVehicleStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.GetVehicleStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetVehicleStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetVehicleStatusResponse> getVehicleStatus(GetVehicleStatusRequest getVehicleStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the status of a vehicle with any associated campaigns.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVehicleStatusRequest.Builder} avoiding the need
     * to create one manually via {@link GetVehicleStatusRequest#builder()}
     * </p>
     *
     * @param getVehicleStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.GetVehicleStatusRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetVehicleStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.GetVehicleStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetVehicleStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetVehicleStatusResponse> getVehicleStatus(
            Consumer<GetVehicleStatusRequest.Builder> getVehicleStatusRequest) {
        return getVehicleStatus(GetVehicleStatusRequest.builder().applyMutation(getVehicleStatusRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getVehicleStatus(software.amazon.awssdk.services.iotfleetwise.model.GetVehicleStatusRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.GetVehicleStatusPublisher publisher = client.getVehicleStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.GetVehicleStatusPublisher publisher = client.getVehicleStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotfleetwise.model.GetVehicleStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotfleetwise.model.GetVehicleStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getVehicleStatus(software.amazon.awssdk.services.iotfleetwise.model.GetVehicleStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param getVehicleStatusRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.GetVehicleStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetVehicleStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default GetVehicleStatusPublisher getVehicleStatusPaginator(GetVehicleStatusRequest getVehicleStatusRequest) {
        return new GetVehicleStatusPublisher(this, getVehicleStatusRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getVehicleStatus(software.amazon.awssdk.services.iotfleetwise.model.GetVehicleStatusRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.GetVehicleStatusPublisher publisher = client.getVehicleStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.GetVehicleStatusPublisher publisher = client.getVehicleStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotfleetwise.model.GetVehicleStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotfleetwise.model.GetVehicleStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getVehicleStatus(software.amazon.awssdk.services.iotfleetwise.model.GetVehicleStatusRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVehicleStatusRequest.Builder} avoiding the need
     * to create one manually via {@link GetVehicleStatusRequest#builder()}
     * </p>
     *
     * @param getVehicleStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.GetVehicleStatusRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.GetVehicleStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetVehicleStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default GetVehicleStatusPublisher getVehicleStatusPaginator(Consumer<GetVehicleStatusRequest.Builder> getVehicleStatusRequest) {
        return getVehicleStatusPaginator(GetVehicleStatusRequest.builder().applyMutation(getVehicleStatusRequest).build());
    }

    /**
     * <p>
     * Creates a decoder manifest using your existing CAN DBC file from your local device.
     * </p>
     *
     * @param importDecoderManifestRequest
     * @return A Java Future containing the result of the ImportDecoderManifest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>DecoderManifestValidationException The request couldn't be completed because it contains signal
     *         decoders with one or more validation errors.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InvalidSignalsException The request couldn't be completed because it contains signals that aren't
     *         valid.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ImportDecoderManifest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ImportDecoderManifest"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ImportDecoderManifestResponse> importDecoderManifest(
            ImportDecoderManifestRequest importDecoderManifestRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a decoder manifest using your existing CAN DBC file from your local device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportDecoderManifestRequest.Builder} avoiding the
     * need to create one manually via {@link ImportDecoderManifestRequest#builder()}
     * </p>
     *
     * @param importDecoderManifestRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.ImportDecoderManifestRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ImportDecoderManifest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>DecoderManifestValidationException The request couldn't be completed because it contains signal
     *         decoders with one or more validation errors.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InvalidSignalsException The request couldn't be completed because it contains signals that aren't
     *         valid.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ImportDecoderManifest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ImportDecoderManifest"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ImportDecoderManifestResponse> importDecoderManifest(
            Consumer<ImportDecoderManifestRequest.Builder> importDecoderManifestRequest) {
        return importDecoderManifest(ImportDecoderManifestRequest.builder().applyMutation(importDecoderManifestRequest).build());
    }

    /**
     * <p>
     * Creates a signal catalog using your existing VSS formatted content from your local device.
     * </p>
     *
     * @param importSignalCatalogRequest
     * @return A Java Future containing the result of the ImportSignalCatalog operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>LimitExceededException A service quota was exceeded.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InvalidSignalsException The request couldn't be completed because it contains signals that aren't
     *         valid.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ImportSignalCatalog
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ImportSignalCatalog"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ImportSignalCatalogResponse> importSignalCatalog(
            ImportSignalCatalogRequest importSignalCatalogRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a signal catalog using your existing VSS formatted content from your local device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportSignalCatalogRequest.Builder} avoiding the
     * need to create one manually via {@link ImportSignalCatalogRequest#builder()}
     * </p>
     *
     * @param importSignalCatalogRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.ImportSignalCatalogRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ImportSignalCatalog operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>LimitExceededException A service quota was exceeded.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InvalidSignalsException The request couldn't be completed because it contains signals that aren't
     *         valid.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ImportSignalCatalog
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ImportSignalCatalog"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ImportSignalCatalogResponse> importSignalCatalog(
            Consumer<ImportSignalCatalogRequest.Builder> importSignalCatalogRequest) {
        return importSignalCatalog(ImportSignalCatalogRequest.builder().applyMutation(importSignalCatalogRequest).build());
    }

    /**
     * <p>
     * Lists information about created campaigns.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note>
     *
     * @param listCampaignsRequest
     * @return A Java Future containing the result of the ListCampaigns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListCampaigns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListCampaigns" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListCampaignsResponse> listCampaigns(ListCampaignsRequest listCampaignsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists information about created campaigns.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCampaignsRequest.Builder} avoiding the need to
     * create one manually via {@link ListCampaignsRequest#builder()}
     * </p>
     *
     * @param listCampaignsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.ListCampaignsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListCampaigns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListCampaigns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListCampaigns" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListCampaignsResponse> listCampaigns(Consumer<ListCampaignsRequest.Builder> listCampaignsRequest) {
        return listCampaigns(ListCampaignsRequest.builder().applyMutation(listCampaignsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCampaigns(software.amazon.awssdk.services.iotfleetwise.model.ListCampaignsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListCampaignsPublisher publisher = client.listCampaignsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListCampaignsPublisher publisher = client.listCampaignsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotfleetwise.model.ListCampaignsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotfleetwise.model.ListCampaignsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCampaigns(software.amazon.awssdk.services.iotfleetwise.model.ListCampaignsRequest)} operation.</b>
     * </p>
     *
     * @param listCampaignsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListCampaigns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListCampaigns" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCampaignsPublisher listCampaignsPaginator(ListCampaignsRequest listCampaignsRequest) {
        return new ListCampaignsPublisher(this, listCampaignsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCampaigns(software.amazon.awssdk.services.iotfleetwise.model.ListCampaignsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListCampaignsPublisher publisher = client.listCampaignsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListCampaignsPublisher publisher = client.listCampaignsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotfleetwise.model.ListCampaignsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotfleetwise.model.ListCampaignsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCampaigns(software.amazon.awssdk.services.iotfleetwise.model.ListCampaignsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCampaignsRequest.Builder} avoiding the need to
     * create one manually via {@link ListCampaignsRequest#builder()}
     * </p>
     *
     * @param listCampaignsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.ListCampaignsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListCampaigns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListCampaigns" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCampaignsPublisher listCampaignsPaginator(Consumer<ListCampaignsRequest.Builder> listCampaignsRequest) {
        return listCampaignsPaginator(ListCampaignsRequest.builder().applyMutation(listCampaignsRequest).build());
    }

    /**
     * <p>
     * Lists the network interfaces specified in a decoder manifest.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note>
     *
     * @param listDecoderManifestNetworkInterfacesRequest
     * @return A Java Future containing the result of the ListDecoderManifestNetworkInterfaces operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListDecoderManifestNetworkInterfaces
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListDecoderManifestNetworkInterfaces"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDecoderManifestNetworkInterfacesResponse> listDecoderManifestNetworkInterfaces(
            ListDecoderManifestNetworkInterfacesRequest listDecoderManifestNetworkInterfacesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the network interfaces specified in a decoder manifest.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListDecoderManifestNetworkInterfacesRequest.Builder} avoiding the need to create one manually via
     * {@link ListDecoderManifestNetworkInterfacesRequest#builder()}
     * </p>
     *
     * @param listDecoderManifestNetworkInterfacesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestNetworkInterfacesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListDecoderManifestNetworkInterfaces operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListDecoderManifestNetworkInterfaces
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListDecoderManifestNetworkInterfaces"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDecoderManifestNetworkInterfacesResponse> listDecoderManifestNetworkInterfaces(
            Consumer<ListDecoderManifestNetworkInterfacesRequest.Builder> listDecoderManifestNetworkInterfacesRequest) {
        return listDecoderManifestNetworkInterfaces(ListDecoderManifestNetworkInterfacesRequest.builder()
                .applyMutation(listDecoderManifestNetworkInterfacesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDecoderManifestNetworkInterfaces(software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestNetworkInterfacesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListDecoderManifestNetworkInterfacesPublisher publisher = client.listDecoderManifestNetworkInterfacesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListDecoderManifestNetworkInterfacesPublisher publisher = client.listDecoderManifestNetworkInterfacesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestNetworkInterfacesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestNetworkInterfacesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDecoderManifestNetworkInterfaces(software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestNetworkInterfacesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDecoderManifestNetworkInterfacesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListDecoderManifestNetworkInterfaces
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListDecoderManifestNetworkInterfaces"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDecoderManifestNetworkInterfacesPublisher listDecoderManifestNetworkInterfacesPaginator(
            ListDecoderManifestNetworkInterfacesRequest listDecoderManifestNetworkInterfacesRequest) {
        return new ListDecoderManifestNetworkInterfacesPublisher(this, listDecoderManifestNetworkInterfacesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDecoderManifestNetworkInterfaces(software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestNetworkInterfacesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListDecoderManifestNetworkInterfacesPublisher publisher = client.listDecoderManifestNetworkInterfacesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListDecoderManifestNetworkInterfacesPublisher publisher = client.listDecoderManifestNetworkInterfacesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestNetworkInterfacesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestNetworkInterfacesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDecoderManifestNetworkInterfaces(software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestNetworkInterfacesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListDecoderManifestNetworkInterfacesRequest.Builder} avoiding the need to create one manually via
     * {@link ListDecoderManifestNetworkInterfacesRequest#builder()}
     * </p>
     *
     * @param listDecoderManifestNetworkInterfacesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestNetworkInterfacesRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListDecoderManifestNetworkInterfaces
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListDecoderManifestNetworkInterfaces"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDecoderManifestNetworkInterfacesPublisher listDecoderManifestNetworkInterfacesPaginator(
            Consumer<ListDecoderManifestNetworkInterfacesRequest.Builder> listDecoderManifestNetworkInterfacesRequest) {
        return listDecoderManifestNetworkInterfacesPaginator(ListDecoderManifestNetworkInterfacesRequest.builder()
                .applyMutation(listDecoderManifestNetworkInterfacesRequest).build());
    }

    /**
     * <p>
     * A list of information about signal decoders specified in a decoder manifest.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note>
     *
     * @param listDecoderManifestSignalsRequest
     * @return A Java Future containing the result of the ListDecoderManifestSignals operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListDecoderManifestSignals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListDecoderManifestSignals"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDecoderManifestSignalsResponse> listDecoderManifestSignals(
            ListDecoderManifestSignalsRequest listDecoderManifestSignalsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A list of information about signal decoders specified in a decoder manifest.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDecoderManifestSignalsRequest.Builder} avoiding
     * the need to create one manually via {@link ListDecoderManifestSignalsRequest#builder()}
     * </p>
     *
     * @param listDecoderManifestSignalsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestSignalsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListDecoderManifestSignals operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListDecoderManifestSignals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListDecoderManifestSignals"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDecoderManifestSignalsResponse> listDecoderManifestSignals(
            Consumer<ListDecoderManifestSignalsRequest.Builder> listDecoderManifestSignalsRequest) {
        return listDecoderManifestSignals(ListDecoderManifestSignalsRequest.builder()
                .applyMutation(listDecoderManifestSignalsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDecoderManifestSignals(software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestSignalsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListDecoderManifestSignalsPublisher publisher = client.listDecoderManifestSignalsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListDecoderManifestSignalsPublisher publisher = client.listDecoderManifestSignalsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestSignalsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestSignalsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDecoderManifestSignals(software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestSignalsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDecoderManifestSignalsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListDecoderManifestSignals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListDecoderManifestSignals"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDecoderManifestSignalsPublisher listDecoderManifestSignalsPaginator(
            ListDecoderManifestSignalsRequest listDecoderManifestSignalsRequest) {
        return new ListDecoderManifestSignalsPublisher(this, listDecoderManifestSignalsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDecoderManifestSignals(software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestSignalsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListDecoderManifestSignalsPublisher publisher = client.listDecoderManifestSignalsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListDecoderManifestSignalsPublisher publisher = client.listDecoderManifestSignalsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestSignalsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestSignalsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDecoderManifestSignals(software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestSignalsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDecoderManifestSignalsRequest.Builder} avoiding
     * the need to create one manually via {@link ListDecoderManifestSignalsRequest#builder()}
     * </p>
     *
     * @param listDecoderManifestSignalsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestSignalsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListDecoderManifestSignals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListDecoderManifestSignals"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDecoderManifestSignalsPublisher listDecoderManifestSignalsPaginator(
            Consumer<ListDecoderManifestSignalsRequest.Builder> listDecoderManifestSignalsRequest) {
        return listDecoderManifestSignalsPaginator(ListDecoderManifestSignalsRequest.builder()
                .applyMutation(listDecoderManifestSignalsRequest).build());
    }

    /**
     * <p>
     * Lists decoder manifests.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note>
     *
     * @param listDecoderManifestsRequest
     * @return A Java Future containing the result of the ListDecoderManifests operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListDecoderManifests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListDecoderManifests"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDecoderManifestsResponse> listDecoderManifests(
            ListDecoderManifestsRequest listDecoderManifestsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists decoder manifests.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDecoderManifestsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDecoderManifestsRequest#builder()}
     * </p>
     *
     * @param listDecoderManifestsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListDecoderManifests operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListDecoderManifests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListDecoderManifests"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDecoderManifestsResponse> listDecoderManifests(
            Consumer<ListDecoderManifestsRequest.Builder> listDecoderManifestsRequest) {
        return listDecoderManifests(ListDecoderManifestsRequest.builder().applyMutation(listDecoderManifestsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDecoderManifests(software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListDecoderManifestsPublisher publisher = client.listDecoderManifestsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListDecoderManifestsPublisher publisher = client.listDecoderManifestsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDecoderManifests(software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDecoderManifestsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListDecoderManifests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListDecoderManifests"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDecoderManifestsPublisher listDecoderManifestsPaginator(ListDecoderManifestsRequest listDecoderManifestsRequest) {
        return new ListDecoderManifestsPublisher(this, listDecoderManifestsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDecoderManifests(software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListDecoderManifestsPublisher publisher = client.listDecoderManifestsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListDecoderManifestsPublisher publisher = client.listDecoderManifestsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDecoderManifests(software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDecoderManifestsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDecoderManifestsRequest#builder()}
     * </p>
     *
     * @param listDecoderManifestsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListDecoderManifests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListDecoderManifests"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDecoderManifestsPublisher listDecoderManifestsPaginator(
            Consumer<ListDecoderManifestsRequest.Builder> listDecoderManifestsRequest) {
        return listDecoderManifestsPaginator(ListDecoderManifestsRequest.builder().applyMutation(listDecoderManifestsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves information for each created fleet in an Amazon Web Services account.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note>
     *
     * @param listFleetsRequest
     * @return A Java Future containing the result of the ListFleets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListFleetsResponse> listFleets(ListFleetsRequest listFleetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information for each created fleet in an Amazon Web Services account.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFleetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFleetsRequest#builder()}
     * </p>
     *
     * @param listFleetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.ListFleetsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListFleets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListFleetsResponse> listFleets(Consumer<ListFleetsRequest.Builder> listFleetsRequest) {
        return listFleets(ListFleetsRequest.builder().applyMutation(listFleetsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of IDs for all fleets that the vehicle is associated with.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note>
     *
     * @param listFleetsForVehicleRequest
     * @return A Java Future containing the result of the ListFleetsForVehicle operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListFleetsForVehicle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListFleetsForVehicle"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListFleetsForVehicleResponse> listFleetsForVehicle(
            ListFleetsForVehicleRequest listFleetsForVehicleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of IDs for all fleets that the vehicle is associated with.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFleetsForVehicleRequest.Builder} avoiding the
     * need to create one manually via {@link ListFleetsForVehicleRequest#builder()}
     * </p>
     *
     * @param listFleetsForVehicleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.ListFleetsForVehicleRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListFleetsForVehicle operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListFleetsForVehicle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListFleetsForVehicle"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListFleetsForVehicleResponse> listFleetsForVehicle(
            Consumer<ListFleetsForVehicleRequest.Builder> listFleetsForVehicleRequest) {
        return listFleetsForVehicle(ListFleetsForVehicleRequest.builder().applyMutation(listFleetsForVehicleRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listFleetsForVehicle(software.amazon.awssdk.services.iotfleetwise.model.ListFleetsForVehicleRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListFleetsForVehiclePublisher publisher = client.listFleetsForVehiclePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListFleetsForVehiclePublisher publisher = client.listFleetsForVehiclePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotfleetwise.model.ListFleetsForVehicleResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotfleetwise.model.ListFleetsForVehicleResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFleetsForVehicle(software.amazon.awssdk.services.iotfleetwise.model.ListFleetsForVehicleRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFleetsForVehicleRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListFleetsForVehicle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListFleetsForVehicle"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFleetsForVehiclePublisher listFleetsForVehiclePaginator(ListFleetsForVehicleRequest listFleetsForVehicleRequest) {
        return new ListFleetsForVehiclePublisher(this, listFleetsForVehicleRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listFleetsForVehicle(software.amazon.awssdk.services.iotfleetwise.model.ListFleetsForVehicleRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListFleetsForVehiclePublisher publisher = client.listFleetsForVehiclePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListFleetsForVehiclePublisher publisher = client.listFleetsForVehiclePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotfleetwise.model.ListFleetsForVehicleResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotfleetwise.model.ListFleetsForVehicleResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFleetsForVehicle(software.amazon.awssdk.services.iotfleetwise.model.ListFleetsForVehicleRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFleetsForVehicleRequest.Builder} avoiding the
     * need to create one manually via {@link ListFleetsForVehicleRequest#builder()}
     * </p>
     *
     * @param listFleetsForVehicleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.ListFleetsForVehicleRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListFleetsForVehicle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListFleetsForVehicle"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFleetsForVehiclePublisher listFleetsForVehiclePaginator(
            Consumer<ListFleetsForVehicleRequest.Builder> listFleetsForVehicleRequest) {
        return listFleetsForVehiclePaginator(ListFleetsForVehicleRequest.builder().applyMutation(listFleetsForVehicleRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of {@link #listFleets(software.amazon.awssdk.services.iotfleetwise.model.ListFleetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListFleetsPublisher publisher = client.listFleetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListFleetsPublisher publisher = client.listFleetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotfleetwise.model.ListFleetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotfleetwise.model.ListFleetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFleets(software.amazon.awssdk.services.iotfleetwise.model.ListFleetsRequest)} operation.</b>
     * </p>
     *
     * @param listFleetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFleetsPublisher listFleetsPaginator(ListFleetsRequest listFleetsRequest) {
        return new ListFleetsPublisher(this, listFleetsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listFleets(software.amazon.awssdk.services.iotfleetwise.model.ListFleetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListFleetsPublisher publisher = client.listFleetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListFleetsPublisher publisher = client.listFleetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotfleetwise.model.ListFleetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotfleetwise.model.ListFleetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFleets(software.amazon.awssdk.services.iotfleetwise.model.ListFleetsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFleetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFleetsRequest#builder()}
     * </p>
     *
     * @param listFleetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.ListFleetsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFleetsPublisher listFleetsPaginator(Consumer<ListFleetsRequest.Builder> listFleetsRequest) {
        return listFleetsPaginator(ListFleetsRequest.builder().applyMutation(listFleetsRequest).build());
    }

    /**
     * <p>
     * Lists information about nodes specified in a vehicle model (model manifest).
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note>
     *
     * @param listModelManifestNodesRequest
     * @return A Java Future containing the result of the ListModelManifestNodes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>LimitExceededException A service quota was exceeded.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListModelManifestNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListModelManifestNodes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListModelManifestNodesResponse> listModelManifestNodes(
            ListModelManifestNodesRequest listModelManifestNodesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists information about nodes specified in a vehicle model (model manifest).
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListModelManifestNodesRequest.Builder} avoiding the
     * need to create one manually via {@link ListModelManifestNodesRequest#builder()}
     * </p>
     *
     * @param listModelManifestNodesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestNodesRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListModelManifestNodes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>LimitExceededException A service quota was exceeded.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListModelManifestNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListModelManifestNodes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListModelManifestNodesResponse> listModelManifestNodes(
            Consumer<ListModelManifestNodesRequest.Builder> listModelManifestNodesRequest) {
        return listModelManifestNodes(ListModelManifestNodesRequest.builder().applyMutation(listModelManifestNodesRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listModelManifestNodes(software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestNodesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListModelManifestNodesPublisher publisher = client.listModelManifestNodesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListModelManifestNodesPublisher publisher = client.listModelManifestNodesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestNodesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestNodesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listModelManifestNodes(software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestNodesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listModelManifestNodesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>LimitExceededException A service quota was exceeded.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListModelManifestNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListModelManifestNodes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListModelManifestNodesPublisher listModelManifestNodesPaginator(
            ListModelManifestNodesRequest listModelManifestNodesRequest) {
        return new ListModelManifestNodesPublisher(this, listModelManifestNodesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listModelManifestNodes(software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestNodesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListModelManifestNodesPublisher publisher = client.listModelManifestNodesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListModelManifestNodesPublisher publisher = client.listModelManifestNodesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestNodesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestNodesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listModelManifestNodes(software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestNodesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListModelManifestNodesRequest.Builder} avoiding the
     * need to create one manually via {@link ListModelManifestNodesRequest#builder()}
     * </p>
     *
     * @param listModelManifestNodesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestNodesRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>LimitExceededException A service quota was exceeded.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListModelManifestNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListModelManifestNodes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListModelManifestNodesPublisher listModelManifestNodesPaginator(
            Consumer<ListModelManifestNodesRequest.Builder> listModelManifestNodesRequest) {
        return listModelManifestNodesPaginator(ListModelManifestNodesRequest.builder()
                .applyMutation(listModelManifestNodesRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of vehicle models (model manifests).
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note>
     *
     * @param listModelManifestsRequest
     * @return A Java Future containing the result of the ListModelManifests operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListModelManifests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListModelManifests"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListModelManifestsResponse> listModelManifests(ListModelManifestsRequest listModelManifestsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of vehicle models (model manifests).
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListModelManifestsRequest.Builder} avoiding the
     * need to create one manually via {@link ListModelManifestsRequest#builder()}
     * </p>
     *
     * @param listModelManifestsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListModelManifests operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListModelManifests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListModelManifests"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListModelManifestsResponse> listModelManifests(
            Consumer<ListModelManifestsRequest.Builder> listModelManifestsRequest) {
        return listModelManifests(ListModelManifestsRequest.builder().applyMutation(listModelManifestsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listModelManifests(software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListModelManifestsPublisher publisher = client.listModelManifestsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListModelManifestsPublisher publisher = client.listModelManifestsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listModelManifests(software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listModelManifestsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListModelManifests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListModelManifests"
     *      target="_top">AWS API Documentation</a>
     */
    default ListModelManifestsPublisher listModelManifestsPaginator(ListModelManifestsRequest listModelManifestsRequest) {
        return new ListModelManifestsPublisher(this, listModelManifestsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listModelManifests(software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListModelManifestsPublisher publisher = client.listModelManifestsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListModelManifestsPublisher publisher = client.listModelManifestsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listModelManifests(software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListModelManifestsRequest.Builder} avoiding the
     * need to create one manually via {@link ListModelManifestsRequest#builder()}
     * </p>
     *
     * @param listModelManifestsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListModelManifests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListModelManifests"
     *      target="_top">AWS API Documentation</a>
     */
    default ListModelManifestsPublisher listModelManifestsPaginator(
            Consumer<ListModelManifestsRequest.Builder> listModelManifestsRequest) {
        return listModelManifestsPaginator(ListModelManifestsRequest.builder().applyMutation(listModelManifestsRequest).build());
    }

    /**
     * <p>
     * Lists of information about the signals (nodes) specified in a signal catalog.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note>
     *
     * @param listSignalCatalogNodesRequest
     * @return A Java Future containing the result of the ListSignalCatalogNodes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>LimitExceededException A service quota was exceeded.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListSignalCatalogNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListSignalCatalogNodes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSignalCatalogNodesResponse> listSignalCatalogNodes(
            ListSignalCatalogNodesRequest listSignalCatalogNodesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists of information about the signals (nodes) specified in a signal catalog.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSignalCatalogNodesRequest.Builder} avoiding the
     * need to create one manually via {@link ListSignalCatalogNodesRequest#builder()}
     * </p>
     *
     * @param listSignalCatalogNodesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogNodesRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListSignalCatalogNodes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>LimitExceededException A service quota was exceeded.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListSignalCatalogNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListSignalCatalogNodes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSignalCatalogNodesResponse> listSignalCatalogNodes(
            Consumer<ListSignalCatalogNodesRequest.Builder> listSignalCatalogNodesRequest) {
        return listSignalCatalogNodes(ListSignalCatalogNodesRequest.builder().applyMutation(listSignalCatalogNodesRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSignalCatalogNodes(software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogNodesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListSignalCatalogNodesPublisher publisher = client.listSignalCatalogNodesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListSignalCatalogNodesPublisher publisher = client.listSignalCatalogNodesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogNodesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogNodesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSignalCatalogNodes(software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogNodesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSignalCatalogNodesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>LimitExceededException A service quota was exceeded.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListSignalCatalogNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListSignalCatalogNodes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSignalCatalogNodesPublisher listSignalCatalogNodesPaginator(
            ListSignalCatalogNodesRequest listSignalCatalogNodesRequest) {
        return new ListSignalCatalogNodesPublisher(this, listSignalCatalogNodesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSignalCatalogNodes(software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogNodesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListSignalCatalogNodesPublisher publisher = client.listSignalCatalogNodesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListSignalCatalogNodesPublisher publisher = client.listSignalCatalogNodesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogNodesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogNodesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSignalCatalogNodes(software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogNodesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSignalCatalogNodesRequest.Builder} avoiding the
     * need to create one manually via {@link ListSignalCatalogNodesRequest#builder()}
     * </p>
     *
     * @param listSignalCatalogNodesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogNodesRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>LimitExceededException A service quota was exceeded.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListSignalCatalogNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListSignalCatalogNodes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSignalCatalogNodesPublisher listSignalCatalogNodesPaginator(
            Consumer<ListSignalCatalogNodesRequest.Builder> listSignalCatalogNodesRequest) {
        return listSignalCatalogNodesPaginator(ListSignalCatalogNodesRequest.builder()
                .applyMutation(listSignalCatalogNodesRequest).build());
    }

    /**
     * <p>
     * Lists all the created signal catalogs in an Amazon Web Services account.
     * </p>
     * <p>
     * You can use to list information about each signal (node) specified in a signal catalog.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note>
     *
     * @param listSignalCatalogsRequest
     * @return A Java Future containing the result of the ListSignalCatalogs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListSignalCatalogs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListSignalCatalogs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSignalCatalogsResponse> listSignalCatalogs(ListSignalCatalogsRequest listSignalCatalogsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the created signal catalogs in an Amazon Web Services account.
     * </p>
     * <p>
     * You can use to list information about each signal (node) specified in a signal catalog.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSignalCatalogsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSignalCatalogsRequest#builder()}
     * </p>
     *
     * @param listSignalCatalogsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListSignalCatalogs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListSignalCatalogs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListSignalCatalogs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSignalCatalogsResponse> listSignalCatalogs(
            Consumer<ListSignalCatalogsRequest.Builder> listSignalCatalogsRequest) {
        return listSignalCatalogs(ListSignalCatalogsRequest.builder().applyMutation(listSignalCatalogsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSignalCatalogs(software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListSignalCatalogsPublisher publisher = client.listSignalCatalogsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListSignalCatalogsPublisher publisher = client.listSignalCatalogsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSignalCatalogs(software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSignalCatalogsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListSignalCatalogs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListSignalCatalogs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSignalCatalogsPublisher listSignalCatalogsPaginator(ListSignalCatalogsRequest listSignalCatalogsRequest) {
        return new ListSignalCatalogsPublisher(this, listSignalCatalogsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSignalCatalogs(software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListSignalCatalogsPublisher publisher = client.listSignalCatalogsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListSignalCatalogsPublisher publisher = client.listSignalCatalogsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSignalCatalogs(software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSignalCatalogsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSignalCatalogsRequest#builder()}
     * </p>
     *
     * @param listSignalCatalogsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListSignalCatalogs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListSignalCatalogs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSignalCatalogsPublisher listSignalCatalogsPaginator(
            Consumer<ListSignalCatalogsRequest.Builder> listSignalCatalogsRequest) {
        return listSignalCatalogsPaginator(ListSignalCatalogsRequest.builder().applyMutation(listSignalCatalogsRequest).build());
    }

    /**
     * <p>
     * Lists the tags (metadata) you have assigned to the resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags (metadata) you have assigned to the resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of summaries of created vehicles.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note>
     *
     * @param listVehiclesRequest
     * @return A Java Future containing the result of the ListVehicles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListVehicles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListVehicles" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListVehiclesResponse> listVehicles(ListVehiclesRequest listVehiclesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of summaries of created vehicles.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVehiclesRequest.Builder} avoiding the need to
     * create one manually via {@link ListVehiclesRequest#builder()}
     * </p>
     *
     * @param listVehiclesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListVehicles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListVehicles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListVehicles" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListVehiclesResponse> listVehicles(Consumer<ListVehiclesRequest.Builder> listVehiclesRequest) {
        return listVehicles(ListVehiclesRequest.builder().applyMutation(listVehiclesRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of summaries of all vehicles associated with a fleet.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note>
     *
     * @param listVehiclesInFleetRequest
     * @return A Java Future containing the result of the ListVehiclesInFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListVehiclesInFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListVehiclesInFleet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListVehiclesInFleetResponse> listVehiclesInFleet(
            ListVehiclesInFleetRequest listVehiclesInFleetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of summaries of all vehicles associated with a fleet.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVehiclesInFleetRequest.Builder} avoiding the
     * need to create one manually via {@link ListVehiclesInFleetRequest#builder()}
     * </p>
     *
     * @param listVehiclesInFleetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesInFleetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListVehiclesInFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListVehiclesInFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListVehiclesInFleet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListVehiclesInFleetResponse> listVehiclesInFleet(
            Consumer<ListVehiclesInFleetRequest.Builder> listVehiclesInFleetRequest) {
        return listVehiclesInFleet(ListVehiclesInFleetRequest.builder().applyMutation(listVehiclesInFleetRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listVehiclesInFleet(software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesInFleetRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListVehiclesInFleetPublisher publisher = client.listVehiclesInFleetPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListVehiclesInFleetPublisher publisher = client.listVehiclesInFleetPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesInFleetResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesInFleetResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVehiclesInFleet(software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesInFleetRequest)}
     * operation.</b>
     * </p>
     *
     * @param listVehiclesInFleetRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListVehiclesInFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListVehiclesInFleet"
     *      target="_top">AWS API Documentation</a>
     */
    default ListVehiclesInFleetPublisher listVehiclesInFleetPaginator(ListVehiclesInFleetRequest listVehiclesInFleetRequest) {
        return new ListVehiclesInFleetPublisher(this, listVehiclesInFleetRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listVehiclesInFleet(software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesInFleetRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListVehiclesInFleetPublisher publisher = client.listVehiclesInFleetPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListVehiclesInFleetPublisher publisher = client.listVehiclesInFleetPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesInFleetResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesInFleetResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVehiclesInFleet(software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesInFleetRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVehiclesInFleetRequest.Builder} avoiding the
     * need to create one manually via {@link ListVehiclesInFleetRequest#builder()}
     * </p>
     *
     * @param listVehiclesInFleetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesInFleetRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListVehiclesInFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListVehiclesInFleet"
     *      target="_top">AWS API Documentation</a>
     */
    default ListVehiclesInFleetPublisher listVehiclesInFleetPaginator(
            Consumer<ListVehiclesInFleetRequest.Builder> listVehiclesInFleetRequest) {
        return listVehiclesInFleetPaginator(ListVehiclesInFleetRequest.builder().applyMutation(listVehiclesInFleetRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listVehicles(software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListVehiclesPublisher publisher = client.listVehiclesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListVehiclesPublisher publisher = client.listVehiclesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVehicles(software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesRequest)} operation.</b>
     * </p>
     *
     * @param listVehiclesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListVehicles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListVehicles" target="_top">AWS API
     *      Documentation</a>
     */
    default ListVehiclesPublisher listVehiclesPaginator(ListVehiclesRequest listVehiclesRequest) {
        return new ListVehiclesPublisher(this, listVehiclesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listVehicles(software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListVehiclesPublisher publisher = client.listVehiclesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListVehiclesPublisher publisher = client.listVehiclesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVehicles(software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVehiclesRequest.Builder} avoiding the need to
     * create one manually via {@link ListVehiclesRequest#builder()}
     * </p>
     *
     * @param listVehiclesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.ListVehicles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListVehicles" target="_top">AWS API
     *      Documentation</a>
     */
    default ListVehiclesPublisher listVehiclesPaginator(Consumer<ListVehiclesRequest.Builder> listVehiclesRequest) {
        return listVehiclesPaginator(ListVehiclesRequest.builder().applyMutation(listVehiclesRequest).build());
    }

    /**
     * <p>
     * Creates or updates the encryption configuration. Amazon Web Services IoT FleetWise can encrypt your data and
     * resources using an Amazon Web Services managed key. Or, you can use a KMS key that you own and manage. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/data-encryption.html">Data encryption</a>
     * in the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.
     * </p>
     *
     * @param putEncryptionConfigurationRequest
     * @return A Java Future containing the result of the PutEncryptionConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.PutEncryptionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/PutEncryptionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutEncryptionConfigurationResponse> putEncryptionConfiguration(
            PutEncryptionConfigurationRequest putEncryptionConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates the encryption configuration. Amazon Web Services IoT FleetWise can encrypt your data and
     * resources using an Amazon Web Services managed key. Or, you can use a KMS key that you own and manage. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/data-encryption.html">Data encryption</a>
     * in the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutEncryptionConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link PutEncryptionConfigurationRequest#builder()}
     * </p>
     *
     * @param putEncryptionConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.PutEncryptionConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the PutEncryptionConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.PutEncryptionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/PutEncryptionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutEncryptionConfigurationResponse> putEncryptionConfiguration(
            Consumer<PutEncryptionConfigurationRequest.Builder> putEncryptionConfigurationRequest) {
        return putEncryptionConfiguration(PutEncryptionConfigurationRequest.builder()
                .applyMutation(putEncryptionConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates or updates the logging option.
     * </p>
     *
     * @param putLoggingOptionsRequest
     * @return A Java Future containing the result of the PutLoggingOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.PutLoggingOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/PutLoggingOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutLoggingOptionsResponse> putLoggingOptions(PutLoggingOptionsRequest putLoggingOptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates the logging option.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutLoggingOptionsRequest.Builder} avoiding the need
     * to create one manually via {@link PutLoggingOptionsRequest#builder()}
     * </p>
     *
     * @param putLoggingOptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.PutLoggingOptionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutLoggingOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.PutLoggingOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/PutLoggingOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutLoggingOptionsResponse> putLoggingOptions(
            Consumer<PutLoggingOptionsRequest.Builder> putLoggingOptionsRequest) {
        return putLoggingOptions(PutLoggingOptionsRequest.builder().applyMutation(putLoggingOptionsRequest).build());
    }

    /**
     * <important>
     * <p>
     * This API operation contains deprecated parameters. Register your account again without the Timestream resources
     * parameter so that Amazon Web Services IoT FleetWise can remove the Timestream metadata stored. You should then
     * pass the data destination into the <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/APIReference/API_CreateCampaign.html">CreateCampaign</a>
     * API operation.
     * </p>
     * <p>
     * You must delete any existing campaigns that include an empty data destination before you register your account
     * again. For more information, see the <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/APIReference/API_DeleteCampaign.html">DeleteCampaign</a>
     * API operation.
     * </p>
     * <p>
     * If you want to delete the Timestream inline policy from the service-linked role, such as to mitigate an overly
     * permissive policy, you must first delete any existing campaigns. Then delete the service-linked role and register
     * your account again to enable CloudWatch metrics. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteServiceLinkedRole.html"
     * >DeleteServiceLinkedRole</a> in the <i>Identity and Access Management API Reference</i>.
     * </p>
     * </important>
     * <p>
     * Registers your Amazon Web Services account, IAM, and Amazon Timestream resources so Amazon Web Services IoT
     * FleetWise can transfer your vehicle data to the Amazon Web Services Cloud. For more information, including
     * step-by-step procedures, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/setting-up.html">Setting up Amazon Web
     * Services IoT FleetWise</a>.
     * </p>
     * <note>
     * <p>
     * An Amazon Web Services account is <b>not</b> the same thing as a "user." An <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/introduction_identity-management.html#intro-identity-users"
     * >Amazon Web Services user</a> is an identity that you create using Identity and Access Management (IAM) and takes
     * the form of either an <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users.html">IAM user</a> or an
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM role, both with credentials</a>. A
     * single Amazon Web Services account can, and typically does, contain many users and roles.
     * </p>
     * </note>
     *
     * @param registerAccountRequest
     * @return A Java Future containing the result of the RegisterAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.RegisterAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/RegisterAccount" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RegisterAccountResponse> registerAccount(RegisterAccountRequest registerAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <important>
     * <p>
     * This API operation contains deprecated parameters. Register your account again without the Timestream resources
     * parameter so that Amazon Web Services IoT FleetWise can remove the Timestream metadata stored. You should then
     * pass the data destination into the <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/APIReference/API_CreateCampaign.html">CreateCampaign</a>
     * API operation.
     * </p>
     * <p>
     * You must delete any existing campaigns that include an empty data destination before you register your account
     * again. For more information, see the <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/APIReference/API_DeleteCampaign.html">DeleteCampaign</a>
     * API operation.
     * </p>
     * <p>
     * If you want to delete the Timestream inline policy from the service-linked role, such as to mitigate an overly
     * permissive policy, you must first delete any existing campaigns. Then delete the service-linked role and register
     * your account again to enable CloudWatch metrics. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteServiceLinkedRole.html"
     * >DeleteServiceLinkedRole</a> in the <i>Identity and Access Management API Reference</i>.
     * </p>
     * </important>
     * <p>
     * Registers your Amazon Web Services account, IAM, and Amazon Timestream resources so Amazon Web Services IoT
     * FleetWise can transfer your vehicle data to the Amazon Web Services Cloud. For more information, including
     * step-by-step procedures, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/setting-up.html">Setting up Amazon Web
     * Services IoT FleetWise</a>.
     * </p>
     * <note>
     * <p>
     * An Amazon Web Services account is <b>not</b> the same thing as a "user." An <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/introduction_identity-management.html#intro-identity-users"
     * >Amazon Web Services user</a> is an identity that you create using Identity and Access Management (IAM) and takes
     * the form of either an <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users.html">IAM user</a> or an
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM role, both with credentials</a>. A
     * single Amazon Web Services account can, and typically does, contain many users and roles.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterAccountRequest.Builder} avoiding the need
     * to create one manually via {@link RegisterAccountRequest#builder()}
     * </p>
     *
     * @param registerAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.RegisterAccountRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RegisterAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.RegisterAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/RegisterAccount" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RegisterAccountResponse> registerAccount(
            Consumer<RegisterAccountRequest.Builder> registerAccountRequest) {
        return registerAccount(RegisterAccountRequest.builder().applyMutation(registerAccountRequest).build());
    }

    /**
     * <p>
     * Adds to or modifies the tags of the given resource. Tags are metadata which can be used to manage a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds to or modifies the tags of the given resource. Tags are metadata which can be used to manage a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes the given tags (metadata) from the resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the given tags (metadata) from the resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates a campaign.
     * </p>
     *
     * @param updateCampaignRequest
     * @return A Java Future containing the result of the UpdateCampaign operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.UpdateCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/UpdateCampaign" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateCampaignResponse> updateCampaign(UpdateCampaignRequest updateCampaignRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a campaign.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCampaignRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateCampaignRequest#builder()}
     * </p>
     *
     * @param updateCampaignRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.UpdateCampaignRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateCampaign operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.UpdateCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/UpdateCampaign" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateCampaignResponse> updateCampaign(Consumer<UpdateCampaignRequest.Builder> updateCampaignRequest) {
        return updateCampaign(UpdateCampaignRequest.builder().applyMutation(updateCampaignRequest).build());
    }

    /**
     * <p>
     * Updates a decoder manifest.
     * </p>
     * <p>
     * A decoder manifest can only be updated when the status is <code>DRAFT</code>. Only <code>ACTIVE</code> decoder
     * manifests can be associated with vehicles.
     * </p>
     *
     * @param updateDecoderManifestRequest
     * @return A Java Future containing the result of the UpdateDecoderManifest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>LimitExceededException A service quota was exceeded.</li>
     *         <li>DecoderManifestValidationException The request couldn't be completed because it contains signal
     *         decoders with one or more validation errors.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.UpdateDecoderManifest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/UpdateDecoderManifest"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDecoderManifestResponse> updateDecoderManifest(
            UpdateDecoderManifestRequest updateDecoderManifestRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a decoder manifest.
     * </p>
     * <p>
     * A decoder manifest can only be updated when the status is <code>DRAFT</code>. Only <code>ACTIVE</code> decoder
     * manifests can be associated with vehicles.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDecoderManifestRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateDecoderManifestRequest#builder()}
     * </p>
     *
     * @param updateDecoderManifestRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.UpdateDecoderManifestRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateDecoderManifest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>LimitExceededException A service quota was exceeded.</li>
     *         <li>DecoderManifestValidationException The request couldn't be completed because it contains signal
     *         decoders with one or more validation errors.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.UpdateDecoderManifest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/UpdateDecoderManifest"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDecoderManifestResponse> updateDecoderManifest(
            Consumer<UpdateDecoderManifestRequest.Builder> updateDecoderManifestRequest) {
        return updateDecoderManifest(UpdateDecoderManifestRequest.builder().applyMutation(updateDecoderManifestRequest).build());
    }

    /**
     * <p>
     * Updates the description of an existing fleet.
     * </p>
     * <note>
     * <p>
     * If the fleet is successfully updated, Amazon Web Services IoT FleetWise sends back an HTTP 200 response with an
     * empty HTTP body.
     * </p>
     * </note>
     *
     * @param updateFleetRequest
     * @return A Java Future containing the result of the UpdateFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.UpdateFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/UpdateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateFleetResponse> updateFleet(UpdateFleetRequest updateFleetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the description of an existing fleet.
     * </p>
     * <note>
     * <p>
     * If the fleet is successfully updated, Amazon Web Services IoT FleetWise sends back an HTTP 200 response with an
     * empty HTTP body.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFleetRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateFleetRequest#builder()}
     * </p>
     *
     * @param updateFleetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.UpdateFleetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.UpdateFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/UpdateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateFleetResponse> updateFleet(Consumer<UpdateFleetRequest.Builder> updateFleetRequest) {
        return updateFleet(UpdateFleetRequest.builder().applyMutation(updateFleetRequest).build());
    }

    /**
     * <p>
     * Updates a vehicle model (model manifest). If created vehicles are associated with a vehicle model, it can't be
     * updated.
     * </p>
     *
     * @param updateModelManifestRequest
     * @return A Java Future containing the result of the UpdateModelManifest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InvalidSignalsException The request couldn't be completed because it contains signals that aren't
     *         valid.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.UpdateModelManifest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/UpdateModelManifest"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateModelManifestResponse> updateModelManifest(
            UpdateModelManifestRequest updateModelManifestRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a vehicle model (model manifest). If created vehicles are associated with a vehicle model, it can't be
     * updated.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateModelManifestRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateModelManifestRequest#builder()}
     * </p>
     *
     * @param updateModelManifestRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.UpdateModelManifestRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateModelManifest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InvalidSignalsException The request couldn't be completed because it contains signals that aren't
     *         valid.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.UpdateModelManifest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/UpdateModelManifest"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateModelManifestResponse> updateModelManifest(
            Consumer<UpdateModelManifestRequest.Builder> updateModelManifestRequest) {
        return updateModelManifest(UpdateModelManifestRequest.builder().applyMutation(updateModelManifestRequest).build());
    }

    /**
     * <p>
     * Updates a signal catalog.
     * </p>
     *
     * @param updateSignalCatalogRequest
     * @return A Java Future containing the result of the UpdateSignalCatalog operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>LimitExceededException A service quota was exceeded.</li>
     *         <li>InvalidNodeException The specified node type doesn't match the expected node type for a node. You can
     *         specify the node type as branch, sensor, actuator, or attribute.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InvalidSignalsException The request couldn't be completed because it contains signals that aren't
     *         valid.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.UpdateSignalCatalog
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/UpdateSignalCatalog"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateSignalCatalogResponse> updateSignalCatalog(
            UpdateSignalCatalogRequest updateSignalCatalogRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a signal catalog.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSignalCatalogRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateSignalCatalogRequest#builder()}
     * </p>
     *
     * @param updateSignalCatalogRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.UpdateSignalCatalogRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateSignalCatalog operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>LimitExceededException A service quota was exceeded.</li>
     *         <li>InvalidNodeException The specified node type doesn't match the expected node type for a node. You can
     *         specify the node type as branch, sensor, actuator, or attribute.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InvalidSignalsException The request couldn't be completed because it contains signals that aren't
     *         valid.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.UpdateSignalCatalog
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/UpdateSignalCatalog"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateSignalCatalogResponse> updateSignalCatalog(
            Consumer<UpdateSignalCatalogRequest.Builder> updateSignalCatalogRequest) {
        return updateSignalCatalog(UpdateSignalCatalogRequest.builder().applyMutation(updateSignalCatalogRequest).build());
    }

    /**
     * <p>
     * Updates a vehicle.
     * </p>
     *
     * @param updateVehicleRequest
     * @return A Java Future containing the result of the UpdateVehicle operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.UpdateVehicle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/UpdateVehicle" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateVehicleResponse> updateVehicle(UpdateVehicleRequest updateVehicleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a vehicle.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateVehicleRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateVehicleRequest#builder()}
     * </p>
     *
     * @param updateVehicleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.UpdateVehicleRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateVehicle operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request couldn't be completed because the server temporarily failed.</li>
     *         <li>ResourceNotFoundException The resource wasn't found.</li>
     *         <li>ConflictException The request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ThrottlingException The request couldn't be completed due to throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTFleetWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTFleetWiseAsyncClient.UpdateVehicle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/UpdateVehicle" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateVehicleResponse> updateVehicle(Consumer<UpdateVehicleRequest.Builder> updateVehicleRequest) {
        return updateVehicle(UpdateVehicleRequest.builder().applyMutation(updateVehicleRequest).build());
    }

    @Override
    default IoTFleetWiseServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link IoTFleetWiseAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static IoTFleetWiseAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link IoTFleetWiseAsyncClient}.
     */
    static IoTFleetWiseAsyncClientBuilder builder() {
        return new DefaultIoTFleetWiseAsyncClientBuilder();
    }
}
