/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListVehiclesRequest extends IoTFleetWiseRequest implements
        ToCopyableBuilder<ListVehiclesRequest.Builder, ListVehiclesRequest> {
    private static final SdkField<String> MODEL_MANIFEST_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelManifestArn").getter(getter(ListVehiclesRequest::modelManifestArn))
            .setter(setter(Builder::modelManifestArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelManifestArn").build()).build();

    private static final SdkField<List<String>> ATTRIBUTE_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("attributeNames")
            .getter(getter(ListVehiclesRequest::attributeNames))
            .setter(setter(Builder::attributeNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributeNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ATTRIBUTE_VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("attributeValues")
            .getter(getter(ListVehiclesRequest::attributeValues))
            .setter(setter(Builder::attributeValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributeValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListVehiclesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListVehiclesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_MANIFEST_ARN_FIELD,
            ATTRIBUTE_NAMES_FIELD, ATTRIBUTE_VALUES_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String modelManifestArn;

    private final List<String> attributeNames;

    private final List<String> attributeValues;

    private final String nextToken;

    private final Integer maxResults;

    private ListVehiclesRequest(BuilderImpl builder) {
        super(builder);
        this.modelManifestArn = builder.modelManifestArn;
        this.attributeNames = builder.attributeNames;
        this.attributeValues = builder.attributeValues;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a vehicle model (model manifest). You can use this optional parameter to list
     * only the vehicles created from a certain vehicle model.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a vehicle model (model manifest). You can use this optional parameter
     *         to list only the vehicles created from a certain vehicle model.
     */
    public final String modelManifestArn() {
        return modelManifestArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the AttributeNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAttributeNames() {
        return attributeNames != null && !(attributeNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The fully qualified names of the attributes. For example, the fully qualified name of an attribute might be
     * <code>Vehicle.Body.Engine.Type</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributeNames} method.
     * </p>
     * 
     * @return The fully qualified names of the attributes. For example, the fully qualified name of an attribute might
     *         be <code>Vehicle.Body.Engine.Type</code>.
     */
    public final List<String> attributeNames() {
        return attributeNames;
    }

    /**
     * For responses, this returns true if the service returned a value for the AttributeValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAttributeValues() {
        return attributeValues != null && !(attributeValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Static information about a vehicle attribute value in string format. For example:
     * </p>
     * <p>
     * <code>"1.3 L R2"</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributeValues} method.
     * </p>
     * 
     * @return Static information about a vehicle attribute value in string format. For example:</p>
     *         <p>
     *         <code>"1.3 L R2"</code>
     */
    public final List<String> attributeValues() {
        return attributeValues;
    }

    /**
     * <p>
     * A pagination token for the next set of results.
     * </p>
     * <p>
     * If the results of a search are large, only a portion of the results are returned, and a <code>nextToken</code>
     * pagination token is returned in the response. To retrieve the next set of results, reissue the search request and
     * include the returned token. When all results have been returned, the response does not contain a pagination token
     * value.
     * </p>
     * 
     * @return A pagination token for the next set of results.</p>
     *         <p>
     *         If the results of a search are large, only a portion of the results are returned, and a
     *         <code>nextToken</code> pagination token is returned in the response. To retrieve the next set of results,
     *         reissue the search request and include the returned token. When all results have been returned, the
     *         response does not contain a pagination token value.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of items to return, between 1 and 100, inclusive.
     * </p>
     * 
     * @return The maximum number of items to return, between 1 and 100, inclusive.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(modelManifestArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributeNames() ? attributeNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributeValues() ? attributeValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVehiclesRequest)) {
            return false;
        }
        ListVehiclesRequest other = (ListVehiclesRequest) obj;
        return Objects.equals(modelManifestArn(), other.modelManifestArn()) && hasAttributeNames() == other.hasAttributeNames()
                && Objects.equals(attributeNames(), other.attributeNames()) && hasAttributeValues() == other.hasAttributeValues()
                && Objects.equals(attributeValues(), other.attributeValues()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListVehiclesRequest").add("ModelManifestArn", modelManifestArn())
                .add("AttributeNames", hasAttributeNames() ? attributeNames() : null)
                .add("AttributeValues", hasAttributeValues() ? attributeValues() : null).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "modelManifestArn":
            return Optional.ofNullable(clazz.cast(modelManifestArn()));
        case "attributeNames":
            return Optional.ofNullable(clazz.cast(attributeNames()));
        case "attributeValues":
            return Optional.ofNullable(clazz.cast(attributeValues()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListVehiclesRequest, T> g) {
        return obj -> g.apply((ListVehiclesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTFleetWiseRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListVehiclesRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of a vehicle model (model manifest). You can use this optional parameter to
         * list only the vehicles created from a certain vehicle model.
         * </p>
         * 
         * @param modelManifestArn
         *        The Amazon Resource Name (ARN) of a vehicle model (model manifest). You can use this optional
         *        parameter to list only the vehicles created from a certain vehicle model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelManifestArn(String modelManifestArn);

        /**
         * <p>
         * The fully qualified names of the attributes. For example, the fully qualified name of an attribute might be
         * <code>Vehicle.Body.Engine.Type</code>.
         * </p>
         * 
         * @param attributeNames
         *        The fully qualified names of the attributes. For example, the fully qualified name of an attribute
         *        might be <code>Vehicle.Body.Engine.Type</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeNames(Collection<String> attributeNames);

        /**
         * <p>
         * The fully qualified names of the attributes. For example, the fully qualified name of an attribute might be
         * <code>Vehicle.Body.Engine.Type</code>.
         * </p>
         * 
         * @param attributeNames
         *        The fully qualified names of the attributes. For example, the fully qualified name of an attribute
         *        might be <code>Vehicle.Body.Engine.Type</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeNames(String... attributeNames);

        /**
         * <p>
         * Static information about a vehicle attribute value in string format. For example:
         * </p>
         * <p>
         * <code>"1.3 L R2"</code>
         * </p>
         * 
         * @param attributeValues
         *        Static information about a vehicle attribute value in string format. For example:</p>
         *        <p>
         *        <code>"1.3 L R2"</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeValues(Collection<String> attributeValues);

        /**
         * <p>
         * Static information about a vehicle attribute value in string format. For example:
         * </p>
         * <p>
         * <code>"1.3 L R2"</code>
         * </p>
         * 
         * @param attributeValues
         *        Static information about a vehicle attribute value in string format. For example:</p>
         *        <p>
         *        <code>"1.3 L R2"</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeValues(String... attributeValues);

        /**
         * <p>
         * A pagination token for the next set of results.
         * </p>
         * <p>
         * If the results of a search are large, only a portion of the results are returned, and a
         * <code>nextToken</code> pagination token is returned in the response. To retrieve the next set of results,
         * reissue the search request and include the returned token. When all results have been returned, the response
         * does not contain a pagination token value.
         * </p>
         * 
         * @param nextToken
         *        A pagination token for the next set of results.</p>
         *        <p>
         *        If the results of a search are large, only a portion of the results are returned, and a
         *        <code>nextToken</code> pagination token is returned in the response. To retrieve the next set of
         *        results, reissue the search request and include the returned token. When all results have been
         *        returned, the response does not contain a pagination token value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of items to return, between 1 and 100, inclusive.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return, between 1 and 100, inclusive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTFleetWiseRequest.BuilderImpl implements Builder {
        private String modelManifestArn;

        private List<String> attributeNames = DefaultSdkAutoConstructList.getInstance();

        private List<String> attributeValues = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListVehiclesRequest model) {
            super(model);
            modelManifestArn(model.modelManifestArn);
            attributeNames(model.attributeNames);
            attributeValues(model.attributeValues);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getModelManifestArn() {
            return modelManifestArn;
        }

        public final void setModelManifestArn(String modelManifestArn) {
            this.modelManifestArn = modelManifestArn;
        }

        @Override
        public final Builder modelManifestArn(String modelManifestArn) {
            this.modelManifestArn = modelManifestArn;
            return this;
        }

        public final Collection<String> getAttributeNames() {
            if (attributeNames instanceof SdkAutoConstructList) {
                return null;
            }
            return attributeNames;
        }

        public final void setAttributeNames(Collection<String> attributeNames) {
            this.attributeNames = _attributeNamesListCopier.copy(attributeNames);
        }

        @Override
        public final Builder attributeNames(Collection<String> attributeNames) {
            this.attributeNames = _attributeNamesListCopier.copy(attributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeNames(String... attributeNames) {
            attributeNames(Arrays.asList(attributeNames));
            return this;
        }

        public final Collection<String> getAttributeValues() {
            if (attributeValues instanceof SdkAutoConstructList) {
                return null;
            }
            return attributeValues;
        }

        public final void setAttributeValues(Collection<String> attributeValues) {
            this.attributeValues = _attributeValuesListCopier.copy(attributeValues);
        }

        @Override
        public final Builder attributeValues(Collection<String> attributeValues) {
            this.attributeValues = _attributeValuesListCopier.copy(attributeValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeValues(String... attributeValues) {
            attributeValues(Arrays.asList(attributeValues));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListVehiclesRequest build() {
            return new ListVehiclesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
