/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotfleetwise.model.CanInterface;
import software.amazon.awssdk.services.iotfleetwise.model.NetworkInterfaceType;
import software.amazon.awssdk.services.iotfleetwise.model.ObdInterface;
import software.amazon.awssdk.services.iotfleetwise.model.VehicleMiddleware;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkInterface
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkInterface> {
    private static final SdkField<String> INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("interfaceId").getter(NetworkInterface.getter(NetworkInterface::interfaceId)).setter(NetworkInterface.setter(Builder::interfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interfaceId").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(NetworkInterface.getter(NetworkInterface::typeAsString)).setter(NetworkInterface.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<CanInterface> CAN_INTERFACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("canInterface").getter(NetworkInterface.getter(NetworkInterface::canInterface)).setter(NetworkInterface.setter(Builder::canInterface)).constructor(CanInterface::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("canInterface").build()}).build();
    private static final SdkField<ObdInterface> OBD_INTERFACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("obdInterface").getter(NetworkInterface.getter(NetworkInterface::obdInterface)).setter(NetworkInterface.setter(Builder::obdInterface)).constructor(ObdInterface::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("obdInterface").build()}).build();
    private static final SdkField<VehicleMiddleware> VEHICLE_MIDDLEWARE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("vehicleMiddleware").getter(NetworkInterface.getter(NetworkInterface::vehicleMiddleware)).setter(NetworkInterface.setter(Builder::vehicleMiddleware)).constructor(VehicleMiddleware::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vehicleMiddleware").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTERFACE_ID_FIELD, TYPE_FIELD, CAN_INTERFACE_FIELD, OBD_INTERFACE_FIELD, VEHICLE_MIDDLEWARE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("interfaceId", INTERFACE_ID_FIELD);
            this.put("type", TYPE_FIELD);
            this.put("canInterface", CAN_INTERFACE_FIELD);
            this.put("obdInterface", OBD_INTERFACE_FIELD);
            this.put("vehicleMiddleware", VEHICLE_MIDDLEWARE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String interfaceId;
    private final String type;
    private final CanInterface canInterface;
    private final ObdInterface obdInterface;
    private final VehicleMiddleware vehicleMiddleware;

    private NetworkInterface(BuilderImpl builder) {
        this.interfaceId = builder.interfaceId;
        this.type = builder.type;
        this.canInterface = builder.canInterface;
        this.obdInterface = builder.obdInterface;
        this.vehicleMiddleware = builder.vehicleMiddleware;
    }

    public final String interfaceId() {
        return this.interfaceId;
    }

    public final NetworkInterfaceType type() {
        return NetworkInterfaceType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final CanInterface canInterface() {
        return this.canInterface;
    }

    public final ObdInterface obdInterface() {
        return this.obdInterface;
    }

    public final VehicleMiddleware vehicleMiddleware() {
        return this.vehicleMiddleware;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.interfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.canInterface());
        hashCode = 31 * hashCode + Objects.hashCode(this.obdInterface());
        hashCode = 31 * hashCode + Objects.hashCode(this.vehicleMiddleware());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInterface)) {
            return false;
        }
        NetworkInterface other = (NetworkInterface)obj;
        return Objects.equals(this.interfaceId(), other.interfaceId()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.canInterface(), other.canInterface()) && Objects.equals(this.obdInterface(), other.obdInterface()) && Objects.equals(this.vehicleMiddleware(), other.vehicleMiddleware());
    }

    public final String toString() {
        return ToString.builder((String)"NetworkInterface").add("InterfaceId", (Object)this.interfaceId()).add("Type", (Object)this.typeAsString()).add("CanInterface", (Object)this.canInterface()).add("ObdInterface", (Object)this.obdInterface()).add("VehicleMiddleware", (Object)this.vehicleMiddleware()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "interfaceId": {
                return Optional.ofNullable(clazz.cast(this.interfaceId()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "canInterface": {
                return Optional.ofNullable(clazz.cast(this.canInterface()));
            }
            case "obdInterface": {
                return Optional.ofNullable(clazz.cast(this.obdInterface()));
            }
            case "vehicleMiddleware": {
                return Optional.ofNullable(clazz.cast(this.vehicleMiddleware()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<NetworkInterface, T> g) {
        return obj -> g.apply((NetworkInterface)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String interfaceId;
        private String type;
        private CanInterface canInterface;
        private ObdInterface obdInterface;
        private VehicleMiddleware vehicleMiddleware;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInterface model) {
            this.interfaceId(model.interfaceId);
            this.type(model.type);
            this.canInterface(model.canInterface);
            this.obdInterface(model.obdInterface);
            this.vehicleMiddleware(model.vehicleMiddleware);
        }

        public final String getInterfaceId() {
            return this.interfaceId;
        }

        public final void setInterfaceId(String interfaceId) {
            this.interfaceId = interfaceId;
        }

        @Override
        public final Builder interfaceId(String interfaceId) {
            this.interfaceId = interfaceId;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(NetworkInterfaceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final CanInterface.Builder getCanInterface() {
            return this.canInterface != null ? this.canInterface.toBuilder() : null;
        }

        public final void setCanInterface(CanInterface.BuilderImpl canInterface) {
            this.canInterface = canInterface != null ? canInterface.build() : null;
        }

        @Override
        public final Builder canInterface(CanInterface canInterface) {
            this.canInterface = canInterface;
            return this;
        }

        public final ObdInterface.Builder getObdInterface() {
            return this.obdInterface != null ? this.obdInterface.toBuilder() : null;
        }

        public final void setObdInterface(ObdInterface.BuilderImpl obdInterface) {
            this.obdInterface = obdInterface != null ? obdInterface.build() : null;
        }

        @Override
        public final Builder obdInterface(ObdInterface obdInterface) {
            this.obdInterface = obdInterface;
            return this;
        }

        public final VehicleMiddleware.Builder getVehicleMiddleware() {
            return this.vehicleMiddleware != null ? this.vehicleMiddleware.toBuilder() : null;
        }

        public final void setVehicleMiddleware(VehicleMiddleware.BuilderImpl vehicleMiddleware) {
            this.vehicleMiddleware = vehicleMiddleware != null ? vehicleMiddleware.build() : null;
        }

        @Override
        public final Builder vehicleMiddleware(VehicleMiddleware vehicleMiddleware) {
            this.vehicleMiddleware = vehicleMiddleware;
            return this;
        }

        public NetworkInterface build() {
            return new NetworkInterface(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkInterface> {
        public Builder interfaceId(String var1);

        public Builder type(String var1);

        public Builder type(NetworkInterfaceType var1);

        public Builder canInterface(CanInterface var1);

        default public Builder canInterface(Consumer<CanInterface.Builder> canInterface) {
            return this.canInterface((CanInterface)((CanInterface.Builder)CanInterface.builder().applyMutation(canInterface)).build());
        }

        public Builder obdInterface(ObdInterface var1);

        default public Builder obdInterface(Consumer<ObdInterface.Builder> obdInterface) {
            return this.obdInterface((ObdInterface)((ObdInterface.Builder)ObdInterface.builder().applyMutation(obdInterface)).build());
        }

        public Builder vehicleMiddleware(VehicleMiddleware var1);

        default public Builder vehicleMiddleware(Consumer<VehicleMiddleware.Builder> vehicleMiddleware) {
            return this.vehicleMiddleware((VehicleMiddleware)((VehicleMiddleware.Builder)VehicleMiddleware.builder().applyMutation(vehicleMiddleware)).build());
        }
    }
}

