/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchUpdateVehicleRequest extends IoTFleetWiseRequest implements
        ToCopyableBuilder<BatchUpdateVehicleRequest.Builder, BatchUpdateVehicleRequest> {
    private static final SdkField<List<UpdateVehicleRequestItem>> VEHICLES_FIELD = SdkField
            .<List<UpdateVehicleRequestItem>> builder(MarshallingType.LIST)
            .memberName("vehicles")
            .getter(getter(BatchUpdateVehicleRequest::vehicles))
            .setter(setter(Builder::vehicles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vehicles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UpdateVehicleRequestItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(UpdateVehicleRequestItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VEHICLES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<UpdateVehicleRequestItem> vehicles;

    private BatchUpdateVehicleRequest(BuilderImpl builder) {
        super(builder);
        this.vehicles = builder.vehicles;
    }

    /**
     * For responses, this returns true if the service returned a value for the Vehicles property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasVehicles() {
        return vehicles != null && !(vehicles instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of information about the vehicles to update. For more information, see the API data type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVehicles} method.
     * </p>
     * 
     * @return A list of information about the vehicles to update. For more information, see the API data type.
     */
    public final List<UpdateVehicleRequestItem> vehicles() {
        return vehicles;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasVehicles() ? vehicles() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateVehicleRequest)) {
            return false;
        }
        BatchUpdateVehicleRequest other = (BatchUpdateVehicleRequest) obj;
        return hasVehicles() == other.hasVehicles() && Objects.equals(vehicles(), other.vehicles());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchUpdateVehicleRequest").add("Vehicles", hasVehicles() ? vehicles() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "vehicles":
            return Optional.ofNullable(clazz.cast(vehicles()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("vehicles", VEHICLES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateVehicleRequest, T> g) {
        return obj -> g.apply((BatchUpdateVehicleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTFleetWiseRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchUpdateVehicleRequest> {
        /**
         * <p>
         * A list of information about the vehicles to update. For more information, see the API data type.
         * </p>
         * 
         * @param vehicles
         *        A list of information about the vehicles to update. For more information, see the API data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vehicles(Collection<UpdateVehicleRequestItem> vehicles);

        /**
         * <p>
         * A list of information about the vehicles to update. For more information, see the API data type.
         * </p>
         * 
         * @param vehicles
         *        A list of information about the vehicles to update. For more information, see the API data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vehicles(UpdateVehicleRequestItem... vehicles);

        /**
         * <p>
         * A list of information about the vehicles to update. For more information, see the API data type.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotfleetwise.model.UpdateVehicleRequestItem.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.iotfleetwise.model.UpdateVehicleRequestItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotfleetwise.model.UpdateVehicleRequestItem.Builder#build()} is called
         * immediately and its result is passed to {@link #vehicles(List<UpdateVehicleRequestItem>)}.
         * 
         * @param vehicles
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotfleetwise.model.UpdateVehicleRequestItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vehicles(java.util.Collection<UpdateVehicleRequestItem>)
         */
        Builder vehicles(Consumer<UpdateVehicleRequestItem.Builder>... vehicles);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTFleetWiseRequest.BuilderImpl implements Builder {
        private List<UpdateVehicleRequestItem> vehicles = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateVehicleRequest model) {
            super(model);
            vehicles(model.vehicles);
        }

        public final List<UpdateVehicleRequestItem.Builder> getVehicles() {
            List<UpdateVehicleRequestItem.Builder> result = _updateVehicleRequestItemsCopier.copyToBuilder(this.vehicles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVehicles(Collection<UpdateVehicleRequestItem.BuilderImpl> vehicles) {
            this.vehicles = _updateVehicleRequestItemsCopier.copyFromBuilder(vehicles);
        }

        @Override
        public final Builder vehicles(Collection<UpdateVehicleRequestItem> vehicles) {
            this.vehicles = _updateVehicleRequestItemsCopier.copy(vehicles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vehicles(UpdateVehicleRequestItem... vehicles) {
            vehicles(Arrays.asList(vehicles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vehicles(Consumer<UpdateVehicleRequestItem.Builder>... vehicles) {
            vehicles(Stream.of(vehicles).map(c -> UpdateVehicleRequestItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchUpdateVehicleRequest build() {
            return new BatchUpdateVehicleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
