/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A single controller area network (CAN) device interface.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CanInterface implements SdkPojo, Serializable, ToCopyableBuilder<CanInterface.Builder, CanInterface> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CanInterface::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> PROTOCOL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("protocolName").getter(getter(CanInterface::protocolName)).setter(setter(Builder::protocolName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocolName").build()).build();

    private static final SdkField<String> PROTOCOL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("protocolVersion").getter(getter(CanInterface::protocolVersion)).setter(setter(Builder::protocolVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocolVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            PROTOCOL_NAME_FIELD, PROTOCOL_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String protocolName;

    private final String protocolVersion;

    private CanInterface(BuilderImpl builder) {
        this.name = builder.name;
        this.protocolName = builder.protocolName;
        this.protocolVersion = builder.protocolVersion;
    }

    /**
     * <p>
     * The unique name of the interface.
     * </p>
     * 
     * @return The unique name of the interface.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The name of the communication protocol for the interface.
     * </p>
     * 
     * @return The name of the communication protocol for the interface.
     */
    public final String protocolName() {
        return protocolName;
    }

    /**
     * <p>
     * The version of the communication protocol for the interface.
     * </p>
     * 
     * @return The version of the communication protocol for the interface.
     */
    public final String protocolVersion() {
        return protocolVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(protocolName());
        hashCode = 31 * hashCode + Objects.hashCode(protocolVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CanInterface)) {
            return false;
        }
        CanInterface other = (CanInterface) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(protocolName(), other.protocolName())
                && Objects.equals(protocolVersion(), other.protocolVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CanInterface").add("Name", name()).add("ProtocolName", protocolName())
                .add("ProtocolVersion", protocolVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "protocolName":
            return Optional.ofNullable(clazz.cast(protocolName()));
        case "protocolVersion":
            return Optional.ofNullable(clazz.cast(protocolVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("protocolName", PROTOCOL_NAME_FIELD);
        map.put("protocolVersion", PROTOCOL_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CanInterface, T> g) {
        return obj -> g.apply((CanInterface) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CanInterface> {
        /**
         * <p>
         * The unique name of the interface.
         * </p>
         * 
         * @param name
         *        The unique name of the interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the communication protocol for the interface.
         * </p>
         * 
         * @param protocolName
         *        The name of the communication protocol for the interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocolName(String protocolName);

        /**
         * <p>
         * The version of the communication protocol for the interface.
         * </p>
         * 
         * @param protocolVersion
         *        The version of the communication protocol for the interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocolVersion(String protocolVersion);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String protocolName;

        private String protocolVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(CanInterface model) {
            name(model.name);
            protocolName(model.protocolName);
            protocolVersion(model.protocolVersion);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProtocolName() {
            return protocolName;
        }

        public final void setProtocolName(String protocolName) {
            this.protocolName = protocolName;
        }

        @Override
        public final Builder protocolName(String protocolName) {
            this.protocolName = protocolName;
            return this;
        }

        public final String getProtocolVersion() {
            return protocolVersion;
        }

        public final void setProtocolVersion(String protocolVersion) {
            this.protocolVersion = protocolVersion;
        }

        @Override
        public final Builder protocolVersion(String protocolVersion) {
            this.protocolVersion = protocolVersion;
            return this;
        }

        @Override
        public CanInterface build() {
            return new CanInterface(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
