/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateStateTemplateRequest extends IoTFleetWiseRequest implements
        ToCopyableBuilder<CreateStateTemplateRequest.Builder, CreateStateTemplateRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateStateTemplateRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateStateTemplateRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> SIGNAL_CATALOG_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("signalCatalogArn").getter(getter(CreateStateTemplateRequest::signalCatalogArn))
            .setter(setter(Builder::signalCatalogArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signalCatalogArn").build()).build();

    private static final SdkField<List<String>> STATE_TEMPLATE_PROPERTIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("stateTemplateProperties")
            .getter(getter(CreateStateTemplateRequest::stateTemplateProperties))
            .setter(setter(Builder::stateTemplateProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateTemplateProperties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> DATA_EXTRA_DIMENSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("dataExtraDimensions")
            .getter(getter(CreateStateTemplateRequest::dataExtraDimensions))
            .setter(setter(Builder::dataExtraDimensions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataExtraDimensions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> METADATA_EXTRA_DIMENSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("metadataExtraDimensions")
            .getter(getter(CreateStateTemplateRequest::metadataExtraDimensions))
            .setter(setter(Builder::metadataExtraDimensions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadataExtraDimensions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateStateTemplateRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            SIGNAL_CATALOG_ARN_FIELD, STATE_TEMPLATE_PROPERTIES_FIELD, DATA_EXTRA_DIMENSIONS_FIELD,
            METADATA_EXTRA_DIMENSIONS_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String description;

    private final String signalCatalogArn;

    private final List<String> stateTemplateProperties;

    private final List<String> dataExtraDimensions;

    private final List<String> metadataExtraDimensions;

    private final List<Tag> tags;

    private CreateStateTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.signalCatalogArn = builder.signalCatalogArn;
        this.stateTemplateProperties = builder.stateTemplateProperties;
        this.dataExtraDimensions = builder.dataExtraDimensions;
        this.metadataExtraDimensions = builder.metadataExtraDimensions;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the state template.
     * </p>
     * 
     * @return The name of the state template.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A brief description of the state template.
     * </p>
     * 
     * @return A brief description of the state template.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ARN of the signal catalog associated with the state template.
     * </p>
     * 
     * @return The ARN of the signal catalog associated with the state template.
     */
    public final String signalCatalogArn() {
        return signalCatalogArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the StateTemplateProperties property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasStateTemplateProperties() {
        return stateTemplateProperties != null && !(stateTemplateProperties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of signals from which data is collected. The state template properties contain the fully qualified names
     * of the signals.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStateTemplateProperties} method.
     * </p>
     * 
     * @return A list of signals from which data is collected. The state template properties contain the fully qualified
     *         names of the signals.
     */
    public final List<String> stateTemplateProperties() {
        return stateTemplateProperties;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataExtraDimensions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDataExtraDimensions() {
        return dataExtraDimensions != null && !(dataExtraDimensions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of vehicle attributes to associate with the payload published on the state template's MQTT topic. (See <a
     * href=
     * "https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/process-visualize-data.html#process-last-known-state-vehicle-data"
     * > Processing last known state vehicle data using MQTT messaging</a>). For example, if you add
     * <code>Vehicle.Attributes.Make</code> and <code>Vehicle.Attributes.Model</code> attributes, Amazon Web Services
     * IoT FleetWise will enrich the protobuf encoded payload with those attributes in the <code>extraDimensions</code>
     * field.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataExtraDimensions} method.
     * </p>
     * 
     * @return A list of vehicle attributes to associate with the payload published on the state template's MQTT topic.
     *         (See <a href=
     *         "https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/process-visualize-data.html#process-last-known-state-vehicle-data"
     *         > Processing last known state vehicle data using MQTT messaging</a>). For example, if you add
     *         <code>Vehicle.Attributes.Make</code> and <code>Vehicle.Attributes.Model</code> attributes, Amazon Web
     *         Services IoT FleetWise will enrich the protobuf encoded payload with those attributes in the
     *         <code>extraDimensions</code> field.
     */
    public final List<String> dataExtraDimensions() {
        return dataExtraDimensions;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetadataExtraDimensions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasMetadataExtraDimensions() {
        return metadataExtraDimensions != null && !(metadataExtraDimensions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of vehicle attributes to associate with user properties of the messages published on the state template's
     * MQTT topic. (See <a href=
     * "https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/process-visualize-data.html#process-last-known-state-vehicle-data"
     * > Processing last known state vehicle data using MQTT messaging</a>). For example, if you add
     * <code>Vehicle.Attributes.Make</code> and <code>Vehicle.Attributes.Model</code> attributes, Amazon Web Services
     * IoT FleetWise will include these attributes as User Properties with the MQTT message.
     * </p>
     * <p>
     * Default: An empty array
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetadataExtraDimensions} method.
     * </p>
     * 
     * @return A list of vehicle attributes to associate with user properties of the messages published on the state
     *         template's MQTT topic. (See <a href=
     *         "https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/process-visualize-data.html#process-last-known-state-vehicle-data"
     *         > Processing last known state vehicle data using MQTT messaging</a>). For example, if you add
     *         <code>Vehicle.Attributes.Make</code> and <code>Vehicle.Attributes.Model</code> attributes, Amazon Web
     *         Services IoT FleetWise will include these attributes as User Properties with the MQTT message.</p>
     *         <p>
     *         Default: An empty array
     */
    public final List<String> metadataExtraDimensions() {
        return metadataExtraDimensions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Metadata that can be used to manage the state template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Metadata that can be used to manage the state template.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(signalCatalogArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasStateTemplateProperties() ? stateTemplateProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDataExtraDimensions() ? dataExtraDimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMetadataExtraDimensions() ? metadataExtraDimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStateTemplateRequest)) {
            return false;
        }
        CreateStateTemplateRequest other = (CreateStateTemplateRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(signalCatalogArn(), other.signalCatalogArn())
                && hasStateTemplateProperties() == other.hasStateTemplateProperties()
                && Objects.equals(stateTemplateProperties(), other.stateTemplateProperties())
                && hasDataExtraDimensions() == other.hasDataExtraDimensions()
                && Objects.equals(dataExtraDimensions(), other.dataExtraDimensions())
                && hasMetadataExtraDimensions() == other.hasMetadataExtraDimensions()
                && Objects.equals(metadataExtraDimensions(), other.metadataExtraDimensions()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateStateTemplateRequest").add("Name", name()).add("Description", description())
                .add("SignalCatalogArn", signalCatalogArn())
                .add("StateTemplateProperties", hasStateTemplateProperties() ? stateTemplateProperties() : null)
                .add("DataExtraDimensions", hasDataExtraDimensions() ? dataExtraDimensions() : null)
                .add("MetadataExtraDimensions", hasMetadataExtraDimensions() ? metadataExtraDimensions() : null)
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "signalCatalogArn":
            return Optional.ofNullable(clazz.cast(signalCatalogArn()));
        case "stateTemplateProperties":
            return Optional.ofNullable(clazz.cast(stateTemplateProperties()));
        case "dataExtraDimensions":
            return Optional.ofNullable(clazz.cast(dataExtraDimensions()));
        case "metadataExtraDimensions":
            return Optional.ofNullable(clazz.cast(metadataExtraDimensions()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("signalCatalogArn", SIGNAL_CATALOG_ARN_FIELD);
        map.put("stateTemplateProperties", STATE_TEMPLATE_PROPERTIES_FIELD);
        map.put("dataExtraDimensions", DATA_EXTRA_DIMENSIONS_FIELD);
        map.put("metadataExtraDimensions", METADATA_EXTRA_DIMENSIONS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateStateTemplateRequest, T> g) {
        return obj -> g.apply((CreateStateTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTFleetWiseRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateStateTemplateRequest> {
        /**
         * <p>
         * The name of the state template.
         * </p>
         * 
         * @param name
         *        The name of the state template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A brief description of the state template.
         * </p>
         * 
         * @param description
         *        A brief description of the state template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ARN of the signal catalog associated with the state template.
         * </p>
         * 
         * @param signalCatalogArn
         *        The ARN of the signal catalog associated with the state template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signalCatalogArn(String signalCatalogArn);

        /**
         * <p>
         * A list of signals from which data is collected. The state template properties contain the fully qualified
         * names of the signals.
         * </p>
         * 
         * @param stateTemplateProperties
         *        A list of signals from which data is collected. The state template properties contain the fully
         *        qualified names of the signals.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateTemplateProperties(Collection<String> stateTemplateProperties);

        /**
         * <p>
         * A list of signals from which data is collected. The state template properties contain the fully qualified
         * names of the signals.
         * </p>
         * 
         * @param stateTemplateProperties
         *        A list of signals from which data is collected. The state template properties contain the fully
         *        qualified names of the signals.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateTemplateProperties(String... stateTemplateProperties);

        /**
         * <p>
         * A list of vehicle attributes to associate with the payload published on the state template's MQTT topic. (See
         * <a href=
         * "https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/process-visualize-data.html#process-last-known-state-vehicle-data"
         * > Processing last known state vehicle data using MQTT messaging</a>). For example, if you add
         * <code>Vehicle.Attributes.Make</code> and <code>Vehicle.Attributes.Model</code> attributes, Amazon Web
         * Services IoT FleetWise will enrich the protobuf encoded payload with those attributes in the
         * <code>extraDimensions</code> field.
         * </p>
         * 
         * @param dataExtraDimensions
         *        A list of vehicle attributes to associate with the payload published on the state template's MQTT
         *        topic. (See <a href=
         *        "https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/process-visualize-data.html#process-last-known-state-vehicle-data"
         *        > Processing last known state vehicle data using MQTT messaging</a>). For example, if you add
         *        <code>Vehicle.Attributes.Make</code> and <code>Vehicle.Attributes.Model</code> attributes, Amazon Web
         *        Services IoT FleetWise will enrich the protobuf encoded payload with those attributes in the
         *        <code>extraDimensions</code> field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataExtraDimensions(Collection<String> dataExtraDimensions);

        /**
         * <p>
         * A list of vehicle attributes to associate with the payload published on the state template's MQTT topic. (See
         * <a href=
         * "https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/process-visualize-data.html#process-last-known-state-vehicle-data"
         * > Processing last known state vehicle data using MQTT messaging</a>). For example, if you add
         * <code>Vehicle.Attributes.Make</code> and <code>Vehicle.Attributes.Model</code> attributes, Amazon Web
         * Services IoT FleetWise will enrich the protobuf encoded payload with those attributes in the
         * <code>extraDimensions</code> field.
         * </p>
         * 
         * @param dataExtraDimensions
         *        A list of vehicle attributes to associate with the payload published on the state template's MQTT
         *        topic. (See <a href=
         *        "https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/process-visualize-data.html#process-last-known-state-vehicle-data"
         *        > Processing last known state vehicle data using MQTT messaging</a>). For example, if you add
         *        <code>Vehicle.Attributes.Make</code> and <code>Vehicle.Attributes.Model</code> attributes, Amazon Web
         *        Services IoT FleetWise will enrich the protobuf encoded payload with those attributes in the
         *        <code>extraDimensions</code> field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataExtraDimensions(String... dataExtraDimensions);

        /**
         * <p>
         * A list of vehicle attributes to associate with user properties of the messages published on the state
         * template's MQTT topic. (See <a href=
         * "https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/process-visualize-data.html#process-last-known-state-vehicle-data"
         * > Processing last known state vehicle data using MQTT messaging</a>). For example, if you add
         * <code>Vehicle.Attributes.Make</code> and <code>Vehicle.Attributes.Model</code> attributes, Amazon Web
         * Services IoT FleetWise will include these attributes as User Properties with the MQTT message.
         * </p>
         * <p>
         * Default: An empty array
         * </p>
         * 
         * @param metadataExtraDimensions
         *        A list of vehicle attributes to associate with user properties of the messages published on the state
         *        template's MQTT topic. (See <a href=
         *        "https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/process-visualize-data.html#process-last-known-state-vehicle-data"
         *        > Processing last known state vehicle data using MQTT messaging</a>). For example, if you add
         *        <code>Vehicle.Attributes.Make</code> and <code>Vehicle.Attributes.Model</code> attributes, Amazon Web
         *        Services IoT FleetWise will include these attributes as User Properties with the MQTT message.</p>
         *        <p>
         *        Default: An empty array
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataExtraDimensions(Collection<String> metadataExtraDimensions);

        /**
         * <p>
         * A list of vehicle attributes to associate with user properties of the messages published on the state
         * template's MQTT topic. (See <a href=
         * "https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/process-visualize-data.html#process-last-known-state-vehicle-data"
         * > Processing last known state vehicle data using MQTT messaging</a>). For example, if you add
         * <code>Vehicle.Attributes.Make</code> and <code>Vehicle.Attributes.Model</code> attributes, Amazon Web
         * Services IoT FleetWise will include these attributes as User Properties with the MQTT message.
         * </p>
         * <p>
         * Default: An empty array
         * </p>
         * 
         * @param metadataExtraDimensions
         *        A list of vehicle attributes to associate with user properties of the messages published on the state
         *        template's MQTT topic. (See <a href=
         *        "https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/process-visualize-data.html#process-last-known-state-vehicle-data"
         *        > Processing last known state vehicle data using MQTT messaging</a>). For example, if you add
         *        <code>Vehicle.Attributes.Make</code> and <code>Vehicle.Attributes.Model</code> attributes, Amazon Web
         *        Services IoT FleetWise will include these attributes as User Properties with the MQTT message.</p>
         *        <p>
         *        Default: An empty array
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataExtraDimensions(String... metadataExtraDimensions);

        /**
         * <p>
         * Metadata that can be used to manage the state template.
         * </p>
         * 
         * @param tags
         *        Metadata that can be used to manage the state template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Metadata that can be used to manage the state template.
         * </p>
         * 
         * @param tags
         *        Metadata that can be used to manage the state template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Metadata that can be used to manage the state template.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotfleetwise.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.iotfleetwise.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotfleetwise.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotfleetwise.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTFleetWiseRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private String signalCatalogArn;

        private List<String> stateTemplateProperties = DefaultSdkAutoConstructList.getInstance();

        private List<String> dataExtraDimensions = DefaultSdkAutoConstructList.getInstance();

        private List<String> metadataExtraDimensions = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStateTemplateRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            signalCatalogArn(model.signalCatalogArn);
            stateTemplateProperties(model.stateTemplateProperties);
            dataExtraDimensions(model.dataExtraDimensions);
            metadataExtraDimensions(model.metadataExtraDimensions);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getSignalCatalogArn() {
            return signalCatalogArn;
        }

        public final void setSignalCatalogArn(String signalCatalogArn) {
            this.signalCatalogArn = signalCatalogArn;
        }

        @Override
        public final Builder signalCatalogArn(String signalCatalogArn) {
            this.signalCatalogArn = signalCatalogArn;
            return this;
        }

        public final Collection<String> getStateTemplateProperties() {
            if (stateTemplateProperties instanceof SdkAutoConstructList) {
                return null;
            }
            return stateTemplateProperties;
        }

        public final void setStateTemplateProperties(Collection<String> stateTemplateProperties) {
            this.stateTemplateProperties = StateTemplatePropertiesCopier.copy(stateTemplateProperties);
        }

        @Override
        public final Builder stateTemplateProperties(Collection<String> stateTemplateProperties) {
            this.stateTemplateProperties = StateTemplatePropertiesCopier.copy(stateTemplateProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stateTemplateProperties(String... stateTemplateProperties) {
            stateTemplateProperties(Arrays.asList(stateTemplateProperties));
            return this;
        }

        public final Collection<String> getDataExtraDimensions() {
            if (dataExtraDimensions instanceof SdkAutoConstructList) {
                return null;
            }
            return dataExtraDimensions;
        }

        public final void setDataExtraDimensions(Collection<String> dataExtraDimensions) {
            this.dataExtraDimensions = StateTemplateDataExtraDimensionNodePathListCopier.copy(dataExtraDimensions);
        }

        @Override
        public final Builder dataExtraDimensions(Collection<String> dataExtraDimensions) {
            this.dataExtraDimensions = StateTemplateDataExtraDimensionNodePathListCopier.copy(dataExtraDimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataExtraDimensions(String... dataExtraDimensions) {
            dataExtraDimensions(Arrays.asList(dataExtraDimensions));
            return this;
        }

        public final Collection<String> getMetadataExtraDimensions() {
            if (metadataExtraDimensions instanceof SdkAutoConstructList) {
                return null;
            }
            return metadataExtraDimensions;
        }

        public final void setMetadataExtraDimensions(Collection<String> metadataExtraDimensions) {
            this.metadataExtraDimensions = StateTemplateMetadataExtraDimensionNodePathListCopier.copy(metadataExtraDimensions);
        }

        @Override
        public final Builder metadataExtraDimensions(Collection<String> metadataExtraDimensions) {
            this.metadataExtraDimensions = StateTemplateMetadataExtraDimensionNodePathListCopier.copy(metadataExtraDimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metadataExtraDimensions(String... metadataExtraDimensions) {
            metadataExtraDimensions(Arrays.asList(metadataExtraDimensions));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateStateTemplateRequest build() {
            return new CreateStateTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
