/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a created vehicle.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateVehicleResponseItem implements SdkPojo, Serializable,
        ToCopyableBuilder<CreateVehicleResponseItem.Builder, CreateVehicleResponseItem> {
    private static final SdkField<String> VEHICLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vehicleName").getter(getter(CreateVehicleResponseItem::vehicleName))
            .setter(setter(Builder::vehicleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vehicleName").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(CreateVehicleResponseItem::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> THING_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingArn").getter(getter(CreateVehicleResponseItem::thingArn)).setter(setter(Builder::thingArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VEHICLE_NAME_FIELD, ARN_FIELD,
            THING_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String vehicleName;

    private final String arn;

    private final String thingArn;

    private CreateVehicleResponseItem(BuilderImpl builder) {
        this.vehicleName = builder.vehicleName;
        this.arn = builder.arn;
        this.thingArn = builder.thingArn;
    }

    /**
     * <p>
     * The unique ID of the vehicle to create.
     * </p>
     * 
     * @return The unique ID of the vehicle to create.
     */
    public final String vehicleName() {
        return vehicleName;
    }

    /**
     * <p>
     * The ARN of the created vehicle.
     * </p>
     * 
     * @return The ARN of the created vehicle.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The ARN of a created or validated Amazon Web Services IoT thing.
     * </p>
     * 
     * @return The ARN of a created or validated Amazon Web Services IoT thing.
     */
    public final String thingArn() {
        return thingArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vehicleName());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(thingArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVehicleResponseItem)) {
            return false;
        }
        CreateVehicleResponseItem other = (CreateVehicleResponseItem) obj;
        return Objects.equals(vehicleName(), other.vehicleName()) && Objects.equals(arn(), other.arn())
                && Objects.equals(thingArn(), other.thingArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateVehicleResponseItem").add("VehicleName", vehicleName()).add("Arn", arn())
                .add("ThingArn", thingArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "vehicleName":
            return Optional.ofNullable(clazz.cast(vehicleName()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "thingArn":
            return Optional.ofNullable(clazz.cast(thingArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("vehicleName", VEHICLE_NAME_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("thingArn", THING_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateVehicleResponseItem, T> g) {
        return obj -> g.apply((CreateVehicleResponseItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateVehicleResponseItem> {
        /**
         * <p>
         * The unique ID of the vehicle to create.
         * </p>
         * 
         * @param vehicleName
         *        The unique ID of the vehicle to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vehicleName(String vehicleName);

        /**
         * <p>
         * The ARN of the created vehicle.
         * </p>
         * 
         * @param arn
         *        The ARN of the created vehicle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The ARN of a created or validated Amazon Web Services IoT thing.
         * </p>
         * 
         * @param thingArn
         *        The ARN of a created or validated Amazon Web Services IoT thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingArn(String thingArn);
    }

    static final class BuilderImpl implements Builder {
        private String vehicleName;

        private String arn;

        private String thingArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVehicleResponseItem model) {
            vehicleName(model.vehicleName);
            arn(model.arn);
            thingArn(model.thingArn);
        }

        public final String getVehicleName() {
            return vehicleName;
        }

        public final void setVehicleName(String vehicleName) {
            this.vehicleName = vehicleName;
        }

        @Override
        public final Builder vehicleName(String vehicleName) {
            this.vehicleName = vehicleName;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getThingArn() {
            return thingArn;
        }

        public final void setThingArn(String thingArn) {
            this.thingArn = thingArn;
        }

        @Override
        public final Builder thingArn(String thingArn) {
            this.thingArn = thingArn;
            return this;
        }

        @Override
        public CreateVehicleResponseItem build() {
            return new CreateVehicleResponseItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
