/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a member of the complex data structure. The data type of the property can be either primitive or another
 * <code>struct</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomProperty implements SdkPojo, Serializable, ToCopyableBuilder<CustomProperty.Builder, CustomProperty> {
    private static final SdkField<String> FULLY_QUALIFIED_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fullyQualifiedName").getter(getter(CustomProperty::fullyQualifiedName))
            .setter(setter(Builder::fullyQualifiedName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fullyQualifiedName").build())
            .build();

    private static final SdkField<String> DATA_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataType").getter(getter(CustomProperty::dataTypeAsString)).setter(setter(Builder::dataType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataType").build()).build();

    private static final SdkField<String> DATA_ENCODING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataEncoding").getter(getter(CustomProperty::dataEncodingAsString))
            .setter(setter(Builder::dataEncoding))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataEncoding").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CustomProperty::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DEPRECATION_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deprecationMessage").getter(getter(CustomProperty::deprecationMessage))
            .setter(setter(Builder::deprecationMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deprecationMessage").build())
            .build();

    private static final SdkField<String> COMMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("comment")
            .getter(getter(CustomProperty::comment)).setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()).build();

    private static final SdkField<String> STRUCT_FULLY_QUALIFIED_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("structFullyQualifiedName").getter(getter(CustomProperty::structFullyQualifiedName))
            .setter(setter(Builder::structFullyQualifiedName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("structFullyQualifiedName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FULLY_QUALIFIED_NAME_FIELD,
            DATA_TYPE_FIELD, DATA_ENCODING_FIELD, DESCRIPTION_FIELD, DEPRECATION_MESSAGE_FIELD, COMMENT_FIELD,
            STRUCT_FULLY_QUALIFIED_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String fullyQualifiedName;

    private final String dataType;

    private final String dataEncoding;

    private final String description;

    private final String deprecationMessage;

    private final String comment;

    private final String structFullyQualifiedName;

    private CustomProperty(BuilderImpl builder) {
        this.fullyQualifiedName = builder.fullyQualifiedName;
        this.dataType = builder.dataType;
        this.dataEncoding = builder.dataEncoding;
        this.description = builder.description;
        this.deprecationMessage = builder.deprecationMessage;
        this.comment = builder.comment;
        this.structFullyQualifiedName = builder.structFullyQualifiedName;
    }

    /**
     * <p>
     * The fully qualified name of the custom property. For example, the fully qualified name of a custom property might
     * be <code>ComplexDataTypes.VehicleDataTypes.SVMCamera.FPS</code>.
     * </p>
     * 
     * @return The fully qualified name of the custom property. For example, the fully qualified name of a custom
     *         property might be <code>ComplexDataTypes.VehicleDataTypes.SVMCamera.FPS</code>.
     */
    public final String fullyQualifiedName() {
        return fullyQualifiedName;
    }

    /**
     * <p>
     * The data type for the custom property.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataType} will
     * return {@link NodeDataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataTypeAsString}.
     * </p>
     * 
     * @return The data type for the custom property.
     * @see NodeDataType
     */
    public final NodeDataType dataType() {
        return NodeDataType.fromValue(dataType);
    }

    /**
     * <p>
     * The data type for the custom property.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataType} will
     * return {@link NodeDataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataTypeAsString}.
     * </p>
     * 
     * @return The data type for the custom property.
     * @see NodeDataType
     */
    public final String dataTypeAsString() {
        return dataType;
    }

    /**
     * <p>
     * Indicates whether the property is binary data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataEncoding} will
     * return {@link NodeDataEncoding#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataEncodingAsString}.
     * </p>
     * 
     * @return Indicates whether the property is binary data.
     * @see NodeDataEncoding
     */
    public final NodeDataEncoding dataEncoding() {
        return NodeDataEncoding.fromValue(dataEncoding);
    }

    /**
     * <p>
     * Indicates whether the property is binary data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataEncoding} will
     * return {@link NodeDataEncoding#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataEncodingAsString}.
     * </p>
     * 
     * @return Indicates whether the property is binary data.
     * @see NodeDataEncoding
     */
    public final String dataEncodingAsString() {
        return dataEncoding;
    }

    /**
     * <p>
     * A brief description of the custom property.
     * </p>
     * 
     * @return A brief description of the custom property.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The deprecation message for the node or the branch that was moved or deleted.
     * </p>
     * 
     * @return The deprecation message for the node or the branch that was moved or deleted.
     */
    public final String deprecationMessage() {
        return deprecationMessage;
    }

    /**
     * <p>
     * A comment in addition to the description.
     * </p>
     * 
     * @return A comment in addition to the description.
     */
    public final String comment() {
        return comment;
    }

    /**
     * <p>
     * The fully qualified name of the struct node for the custom property if the data type of the custom property is
     * <code>Struct</code> or <code>StructArray</code>.
     * </p>
     * 
     * @return The fully qualified name of the struct node for the custom property if the data type of the custom
     *         property is <code>Struct</code> or <code>StructArray</code>.
     */
    public final String structFullyQualifiedName() {
        return structFullyQualifiedName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fullyQualifiedName());
        hashCode = 31 * hashCode + Objects.hashCode(dataTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dataEncodingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(deprecationMessage());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        hashCode = 31 * hashCode + Objects.hashCode(structFullyQualifiedName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomProperty)) {
            return false;
        }
        CustomProperty other = (CustomProperty) obj;
        return Objects.equals(fullyQualifiedName(), other.fullyQualifiedName())
                && Objects.equals(dataTypeAsString(), other.dataTypeAsString())
                && Objects.equals(dataEncodingAsString(), other.dataEncodingAsString())
                && Objects.equals(description(), other.description())
                && Objects.equals(deprecationMessage(), other.deprecationMessage()) && Objects.equals(comment(), other.comment())
                && Objects.equals(structFullyQualifiedName(), other.structFullyQualifiedName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomProperty").add("FullyQualifiedName", fullyQualifiedName())
                .add("DataType", dataTypeAsString()).add("DataEncoding", dataEncodingAsString())
                .add("Description", description()).add("DeprecationMessage", deprecationMessage()).add("Comment", comment())
                .add("StructFullyQualifiedName", structFullyQualifiedName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fullyQualifiedName":
            return Optional.ofNullable(clazz.cast(fullyQualifiedName()));
        case "dataType":
            return Optional.ofNullable(clazz.cast(dataTypeAsString()));
        case "dataEncoding":
            return Optional.ofNullable(clazz.cast(dataEncodingAsString()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "deprecationMessage":
            return Optional.ofNullable(clazz.cast(deprecationMessage()));
        case "comment":
            return Optional.ofNullable(clazz.cast(comment()));
        case "structFullyQualifiedName":
            return Optional.ofNullable(clazz.cast(structFullyQualifiedName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("fullyQualifiedName", FULLY_QUALIFIED_NAME_FIELD);
        map.put("dataType", DATA_TYPE_FIELD);
        map.put("dataEncoding", DATA_ENCODING_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("deprecationMessage", DEPRECATION_MESSAGE_FIELD);
        map.put("comment", COMMENT_FIELD);
        map.put("structFullyQualifiedName", STRUCT_FULLY_QUALIFIED_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomProperty, T> g) {
        return obj -> g.apply((CustomProperty) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomProperty> {
        /**
         * <p>
         * The fully qualified name of the custom property. For example, the fully qualified name of a custom property
         * might be <code>ComplexDataTypes.VehicleDataTypes.SVMCamera.FPS</code>.
         * </p>
         * 
         * @param fullyQualifiedName
         *        The fully qualified name of the custom property. For example, the fully qualified name of a custom
         *        property might be <code>ComplexDataTypes.VehicleDataTypes.SVMCamera.FPS</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fullyQualifiedName(String fullyQualifiedName);

        /**
         * <p>
         * The data type for the custom property.
         * </p>
         * 
         * @param dataType
         *        The data type for the custom property.
         * @see NodeDataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeDataType
         */
        Builder dataType(String dataType);

        /**
         * <p>
         * The data type for the custom property.
         * </p>
         * 
         * @param dataType
         *        The data type for the custom property.
         * @see NodeDataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeDataType
         */
        Builder dataType(NodeDataType dataType);

        /**
         * <p>
         * Indicates whether the property is binary data.
         * </p>
         * 
         * @param dataEncoding
         *        Indicates whether the property is binary data.
         * @see NodeDataEncoding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeDataEncoding
         */
        Builder dataEncoding(String dataEncoding);

        /**
         * <p>
         * Indicates whether the property is binary data.
         * </p>
         * 
         * @param dataEncoding
         *        Indicates whether the property is binary data.
         * @see NodeDataEncoding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeDataEncoding
         */
        Builder dataEncoding(NodeDataEncoding dataEncoding);

        /**
         * <p>
         * A brief description of the custom property.
         * </p>
         * 
         * @param description
         *        A brief description of the custom property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The deprecation message for the node or the branch that was moved or deleted.
         * </p>
         * 
         * @param deprecationMessage
         *        The deprecation message for the node or the branch that was moved or deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deprecationMessage(String deprecationMessage);

        /**
         * <p>
         * A comment in addition to the description.
         * </p>
         * 
         * @param comment
         *        A comment in addition to the description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * <p>
         * The fully qualified name of the struct node for the custom property if the data type of the custom property
         * is <code>Struct</code> or <code>StructArray</code>.
         * </p>
         * 
         * @param structFullyQualifiedName
         *        The fully qualified name of the struct node for the custom property if the data type of the custom
         *        property is <code>Struct</code> or <code>StructArray</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder structFullyQualifiedName(String structFullyQualifiedName);
    }

    static final class BuilderImpl implements Builder {
        private String fullyQualifiedName;

        private String dataType;

        private String dataEncoding;

        private String description;

        private String deprecationMessage;

        private String comment;

        private String structFullyQualifiedName;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomProperty model) {
            fullyQualifiedName(model.fullyQualifiedName);
            dataType(model.dataType);
            dataEncoding(model.dataEncoding);
            description(model.description);
            deprecationMessage(model.deprecationMessage);
            comment(model.comment);
            structFullyQualifiedName(model.structFullyQualifiedName);
        }

        public final String getFullyQualifiedName() {
            return fullyQualifiedName;
        }

        public final void setFullyQualifiedName(String fullyQualifiedName) {
            this.fullyQualifiedName = fullyQualifiedName;
        }

        @Override
        public final Builder fullyQualifiedName(String fullyQualifiedName) {
            this.fullyQualifiedName = fullyQualifiedName;
            return this;
        }

        public final String getDataType() {
            return dataType;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        @Override
        public final Builder dataType(NodeDataType dataType) {
            this.dataType(dataType == null ? null : dataType.toString());
            return this;
        }

        public final String getDataEncoding() {
            return dataEncoding;
        }

        public final void setDataEncoding(String dataEncoding) {
            this.dataEncoding = dataEncoding;
        }

        @Override
        public final Builder dataEncoding(String dataEncoding) {
            this.dataEncoding = dataEncoding;
            return this;
        }

        @Override
        public final Builder dataEncoding(NodeDataEncoding dataEncoding) {
            this.dataEncoding(dataEncoding == null ? null : dataEncoding.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDeprecationMessage() {
            return deprecationMessage;
        }

        public final void setDeprecationMessage(String deprecationMessage) {
            this.deprecationMessage = deprecationMessage;
        }

        @Override
        public final Builder deprecationMessage(String deprecationMessage) {
            this.deprecationMessage = deprecationMessage;
            return this;
        }

        public final String getComment() {
            return comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final String getStructFullyQualifiedName() {
            return structFullyQualifiedName;
        }

        public final void setStructFullyQualifiedName(String structFullyQualifiedName) {
            this.structFullyQualifiedName = structFullyQualifiedName;
        }

        @Override
        public final Builder structFullyQualifiedName(String structFullyQualifiedName) {
            this.structFullyQualifiedName = structFullyQualifiedName;
            return this;
        }

        @Override
        public CustomProperty build() {
            return new CustomProperty(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
