/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetStateTemplateResponse extends IoTFleetWiseResponse implements
        ToCopyableBuilder<GetStateTemplateResponse.Builder, GetStateTemplateResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetStateTemplateResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(GetStateTemplateResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetStateTemplateResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> SIGNAL_CATALOG_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("signalCatalogArn").getter(getter(GetStateTemplateResponse::signalCatalogArn))
            .setter(setter(Builder::signalCatalogArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signalCatalogArn").build()).build();

    private static final SdkField<List<String>> STATE_TEMPLATE_PROPERTIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("stateTemplateProperties")
            .getter(getter(GetStateTemplateResponse::stateTemplateProperties))
            .setter(setter(Builder::stateTemplateProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateTemplateProperties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> DATA_EXTRA_DIMENSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("dataExtraDimensions")
            .getter(getter(GetStateTemplateResponse::dataExtraDimensions))
            .setter(setter(Builder::dataExtraDimensions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataExtraDimensions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> METADATA_EXTRA_DIMENSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("metadataExtraDimensions")
            .getter(getter(GetStateTemplateResponse::metadataExtraDimensions))
            .setter(setter(Builder::metadataExtraDimensions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadataExtraDimensions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(GetStateTemplateResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModificationTime").getter(getter(GetStateTemplateResponse::lastModificationTime))
            .setter(setter(Builder::lastModificationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModificationTime").build())
            .build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetStateTemplateResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD,
            DESCRIPTION_FIELD, SIGNAL_CATALOG_ARN_FIELD, STATE_TEMPLATE_PROPERTIES_FIELD, DATA_EXTRA_DIMENSIONS_FIELD,
            METADATA_EXTRA_DIMENSIONS_FIELD, CREATION_TIME_FIELD, LAST_MODIFICATION_TIME_FIELD, ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String arn;

    private final String description;

    private final String signalCatalogArn;

    private final List<String> stateTemplateProperties;

    private final List<String> dataExtraDimensions;

    private final List<String> metadataExtraDimensions;

    private final Instant creationTime;

    private final Instant lastModificationTime;

    private final String id;

    private GetStateTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.arn = builder.arn;
        this.description = builder.description;
        this.signalCatalogArn = builder.signalCatalogArn;
        this.stateTemplateProperties = builder.stateTemplateProperties;
        this.dataExtraDimensions = builder.dataExtraDimensions;
        this.metadataExtraDimensions = builder.metadataExtraDimensions;
        this.creationTime = builder.creationTime;
        this.lastModificationTime = builder.lastModificationTime;
        this.id = builder.id;
    }

    /**
     * <p>
     * The name of the state template.
     * </p>
     * 
     * @return The name of the state template.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the state template.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the state template.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * A brief description of the state template.
     * </p>
     * 
     * @return A brief description of the state template.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ARN of the signal catalog associated with the state template.
     * </p>
     * 
     * @return The ARN of the signal catalog associated with the state template.
     */
    public final String signalCatalogArn() {
        return signalCatalogArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the StateTemplateProperties property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasStateTemplateProperties() {
        return stateTemplateProperties != null && !(stateTemplateProperties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of signals from which data is collected. The state template properties contain the fully qualified names
     * of the signals.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStateTemplateProperties} method.
     * </p>
     * 
     * @return A list of signals from which data is collected. The state template properties contain the fully qualified
     *         names of the signals.
     */
    public final List<String> stateTemplateProperties() {
        return stateTemplateProperties;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataExtraDimensions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDataExtraDimensions() {
        return dataExtraDimensions != null && !(dataExtraDimensions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of vehicle attributes associated with the payload published on the state template's MQTT topic.
     * </p>
     * <p>
     * Default: An empty array
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataExtraDimensions} method.
     * </p>
     * 
     * @return A list of vehicle attributes associated with the payload published on the state template's MQTT topic.
     *         </p>
     *         <p>
     *         Default: An empty array
     */
    public final List<String> dataExtraDimensions() {
        return dataExtraDimensions;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetadataExtraDimensions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasMetadataExtraDimensions() {
        return metadataExtraDimensions != null && !(metadataExtraDimensions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of vehicle attributes to associate with user properties of the messages published on the state template's
     * MQTT topic.
     * </p>
     * <p>
     * Default: An empty array
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetadataExtraDimensions} method.
     * </p>
     * 
     * @return A list of vehicle attributes to associate with user properties of the messages published on the state
     *         template's MQTT topic.</p>
     *         <p>
     *         Default: An empty array
     */
    public final List<String> metadataExtraDimensions() {
        return metadataExtraDimensions;
    }

    /**
     * <p>
     * The time the state template was created in seconds since epoch (January 1, 1970 at midnight UTC time).
     * </p>
     * 
     * @return The time the state template was created in seconds since epoch (January 1, 1970 at midnight UTC time).
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time the state template was last updated in seconds since epoch (January 1, 1970 at midnight UTC time).
     * </p>
     * 
     * @return The time the state template was last updated in seconds since epoch (January 1, 1970 at midnight UTC
     *         time).
     */
    public final Instant lastModificationTime() {
        return lastModificationTime;
    }

    /**
     * <p>
     * The unique ID of the state template.
     * </p>
     * 
     * @return The unique ID of the state template.
     */
    public final String id() {
        return id;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(signalCatalogArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasStateTemplateProperties() ? stateTemplateProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDataExtraDimensions() ? dataExtraDimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMetadataExtraDimensions() ? metadataExtraDimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModificationTime());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStateTemplateResponse)) {
            return false;
        }
        GetStateTemplateResponse other = (GetStateTemplateResponse) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn())
                && Objects.equals(description(), other.description())
                && Objects.equals(signalCatalogArn(), other.signalCatalogArn())
                && hasStateTemplateProperties() == other.hasStateTemplateProperties()
                && Objects.equals(stateTemplateProperties(), other.stateTemplateProperties())
                && hasDataExtraDimensions() == other.hasDataExtraDimensions()
                && Objects.equals(dataExtraDimensions(), other.dataExtraDimensions())
                && hasMetadataExtraDimensions() == other.hasMetadataExtraDimensions()
                && Objects.equals(metadataExtraDimensions(), other.metadataExtraDimensions())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModificationTime(), other.lastModificationTime()) && Objects.equals(id(), other.id());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetStateTemplateResponse").add("Name", name()).add("Arn", arn())
                .add("Description", description()).add("SignalCatalogArn", signalCatalogArn())
                .add("StateTemplateProperties", hasStateTemplateProperties() ? stateTemplateProperties() : null)
                .add("DataExtraDimensions", hasDataExtraDimensions() ? dataExtraDimensions() : null)
                .add("MetadataExtraDimensions", hasMetadataExtraDimensions() ? metadataExtraDimensions() : null)
                .add("CreationTime", creationTime()).add("LastModificationTime", lastModificationTime()).add("Id", id()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "signalCatalogArn":
            return Optional.ofNullable(clazz.cast(signalCatalogArn()));
        case "stateTemplateProperties":
            return Optional.ofNullable(clazz.cast(stateTemplateProperties()));
        case "dataExtraDimensions":
            return Optional.ofNullable(clazz.cast(dataExtraDimensions()));
        case "metadataExtraDimensions":
            return Optional.ofNullable(clazz.cast(metadataExtraDimensions()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "lastModificationTime":
            return Optional.ofNullable(clazz.cast(lastModificationTime()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("signalCatalogArn", SIGNAL_CATALOG_ARN_FIELD);
        map.put("stateTemplateProperties", STATE_TEMPLATE_PROPERTIES_FIELD);
        map.put("dataExtraDimensions", DATA_EXTRA_DIMENSIONS_FIELD);
        map.put("metadataExtraDimensions", METADATA_EXTRA_DIMENSIONS_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("lastModificationTime", LAST_MODIFICATION_TIME_FIELD);
        map.put("id", ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetStateTemplateResponse, T> g) {
        return obj -> g.apply((GetStateTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTFleetWiseResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetStateTemplateResponse> {
        /**
         * <p>
         * The name of the state template.
         * </p>
         * 
         * @param name
         *        The name of the state template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the state template.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the state template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * A brief description of the state template.
         * </p>
         * 
         * @param description
         *        A brief description of the state template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ARN of the signal catalog associated with the state template.
         * </p>
         * 
         * @param signalCatalogArn
         *        The ARN of the signal catalog associated with the state template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signalCatalogArn(String signalCatalogArn);

        /**
         * <p>
         * A list of signals from which data is collected. The state template properties contain the fully qualified
         * names of the signals.
         * </p>
         * 
         * @param stateTemplateProperties
         *        A list of signals from which data is collected. The state template properties contain the fully
         *        qualified names of the signals.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateTemplateProperties(Collection<String> stateTemplateProperties);

        /**
         * <p>
         * A list of signals from which data is collected. The state template properties contain the fully qualified
         * names of the signals.
         * </p>
         * 
         * @param stateTemplateProperties
         *        A list of signals from which data is collected. The state template properties contain the fully
         *        qualified names of the signals.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateTemplateProperties(String... stateTemplateProperties);

        /**
         * <p>
         * A list of vehicle attributes associated with the payload published on the state template's MQTT topic.
         * </p>
         * <p>
         * Default: An empty array
         * </p>
         * 
         * @param dataExtraDimensions
         *        A list of vehicle attributes associated with the payload published on the state template's MQTT topic.
         *        </p>
         *        <p>
         *        Default: An empty array
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataExtraDimensions(Collection<String> dataExtraDimensions);

        /**
         * <p>
         * A list of vehicle attributes associated with the payload published on the state template's MQTT topic.
         * </p>
         * <p>
         * Default: An empty array
         * </p>
         * 
         * @param dataExtraDimensions
         *        A list of vehicle attributes associated with the payload published on the state template's MQTT topic.
         *        </p>
         *        <p>
         *        Default: An empty array
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataExtraDimensions(String... dataExtraDimensions);

        /**
         * <p>
         * A list of vehicle attributes to associate with user properties of the messages published on the state
         * template's MQTT topic.
         * </p>
         * <p>
         * Default: An empty array
         * </p>
         * 
         * @param metadataExtraDimensions
         *        A list of vehicle attributes to associate with user properties of the messages published on the state
         *        template's MQTT topic.</p>
         *        <p>
         *        Default: An empty array
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataExtraDimensions(Collection<String> metadataExtraDimensions);

        /**
         * <p>
         * A list of vehicle attributes to associate with user properties of the messages published on the state
         * template's MQTT topic.
         * </p>
         * <p>
         * Default: An empty array
         * </p>
         * 
         * @param metadataExtraDimensions
         *        A list of vehicle attributes to associate with user properties of the messages published on the state
         *        template's MQTT topic.</p>
         *        <p>
         *        Default: An empty array
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataExtraDimensions(String... metadataExtraDimensions);

        /**
         * <p>
         * The time the state template was created in seconds since epoch (January 1, 1970 at midnight UTC time).
         * </p>
         * 
         * @param creationTime
         *        The time the state template was created in seconds since epoch (January 1, 1970 at midnight UTC time).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time the state template was last updated in seconds since epoch (January 1, 1970 at midnight UTC time).
         * </p>
         * 
         * @param lastModificationTime
         *        The time the state template was last updated in seconds since epoch (January 1, 1970 at midnight UTC
         *        time).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModificationTime(Instant lastModificationTime);

        /**
         * <p>
         * The unique ID of the state template.
         * </p>
         * 
         * @param id
         *        The unique ID of the state template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);
    }

    static final class BuilderImpl extends IoTFleetWiseResponse.BuilderImpl implements Builder {
        private String name;

        private String arn;

        private String description;

        private String signalCatalogArn;

        private List<String> stateTemplateProperties = DefaultSdkAutoConstructList.getInstance();

        private List<String> dataExtraDimensions = DefaultSdkAutoConstructList.getInstance();

        private List<String> metadataExtraDimensions = DefaultSdkAutoConstructList.getInstance();

        private Instant creationTime;

        private Instant lastModificationTime;

        private String id;

        private BuilderImpl() {
        }

        private BuilderImpl(GetStateTemplateResponse model) {
            super(model);
            name(model.name);
            arn(model.arn);
            description(model.description);
            signalCatalogArn(model.signalCatalogArn);
            stateTemplateProperties(model.stateTemplateProperties);
            dataExtraDimensions(model.dataExtraDimensions);
            metadataExtraDimensions(model.metadataExtraDimensions);
            creationTime(model.creationTime);
            lastModificationTime(model.lastModificationTime);
            id(model.id);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getSignalCatalogArn() {
            return signalCatalogArn;
        }

        public final void setSignalCatalogArn(String signalCatalogArn) {
            this.signalCatalogArn = signalCatalogArn;
        }

        @Override
        public final Builder signalCatalogArn(String signalCatalogArn) {
            this.signalCatalogArn = signalCatalogArn;
            return this;
        }

        public final Collection<String> getStateTemplateProperties() {
            if (stateTemplateProperties instanceof SdkAutoConstructList) {
                return null;
            }
            return stateTemplateProperties;
        }

        public final void setStateTemplateProperties(Collection<String> stateTemplateProperties) {
            this.stateTemplateProperties = StateTemplatePropertiesCopier.copy(stateTemplateProperties);
        }

        @Override
        public final Builder stateTemplateProperties(Collection<String> stateTemplateProperties) {
            this.stateTemplateProperties = StateTemplatePropertiesCopier.copy(stateTemplateProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stateTemplateProperties(String... stateTemplateProperties) {
            stateTemplateProperties(Arrays.asList(stateTemplateProperties));
            return this;
        }

        public final Collection<String> getDataExtraDimensions() {
            if (dataExtraDimensions instanceof SdkAutoConstructList) {
                return null;
            }
            return dataExtraDimensions;
        }

        public final void setDataExtraDimensions(Collection<String> dataExtraDimensions) {
            this.dataExtraDimensions = StateTemplateDataExtraDimensionNodePathListCopier.copy(dataExtraDimensions);
        }

        @Override
        public final Builder dataExtraDimensions(Collection<String> dataExtraDimensions) {
            this.dataExtraDimensions = StateTemplateDataExtraDimensionNodePathListCopier.copy(dataExtraDimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataExtraDimensions(String... dataExtraDimensions) {
            dataExtraDimensions(Arrays.asList(dataExtraDimensions));
            return this;
        }

        public final Collection<String> getMetadataExtraDimensions() {
            if (metadataExtraDimensions instanceof SdkAutoConstructList) {
                return null;
            }
            return metadataExtraDimensions;
        }

        public final void setMetadataExtraDimensions(Collection<String> metadataExtraDimensions) {
            this.metadataExtraDimensions = StateTemplateMetadataExtraDimensionNodePathListCopier.copy(metadataExtraDimensions);
        }

        @Override
        public final Builder metadataExtraDimensions(Collection<String> metadataExtraDimensions) {
            this.metadataExtraDimensions = StateTemplateMetadataExtraDimensionNodePathListCopier.copy(metadataExtraDimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metadataExtraDimensions(String... metadataExtraDimensions) {
            metadataExtraDimensions(Arrays.asList(metadataExtraDimensions));
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModificationTime() {
            return lastModificationTime;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public GetStateTemplateResponse build() {
            return new GetStateTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
