/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about registering an Identity and Access Management (IAM) resource so Amazon Web Services IoT FleetWise
 * edge agent software can transfer your vehicle data to Amazon Timestream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IamRegistrationResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<IamRegistrationResponse.Builder, IamRegistrationResponse> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(IamRegistrationResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> REGISTRATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registrationStatus").getter(getter(IamRegistrationResponse::registrationStatusAsString))
            .setter(setter(Builder::registrationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registrationStatus").build())
            .build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorMessage").getter(getter(IamRegistrationResponse::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD,
            REGISTRATION_STATUS_FIELD, ERROR_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String roleArn;

    private final String registrationStatus;

    private final String errorMessage;

    private IamRegistrationResponse(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.registrationStatus = builder.registrationStatus;
        this.errorMessage = builder.errorMessage;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role to register.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role to register.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The status of registering your IAM resource. The status can be one of <code>REGISTRATION_SUCCESS</code>,
     * <code>REGISTRATION_PENDING</code>, <code>REGISTRATION_FAILURE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #registrationStatus} will return {@link RegistrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #registrationStatusAsString}.
     * </p>
     * 
     * @return The status of registering your IAM resource. The status can be one of <code>REGISTRATION_SUCCESS</code>,
     *         <code>REGISTRATION_PENDING</code>, <code>REGISTRATION_FAILURE</code>.
     * @see RegistrationStatus
     */
    public final RegistrationStatus registrationStatus() {
        return RegistrationStatus.fromValue(registrationStatus);
    }

    /**
     * <p>
     * The status of registering your IAM resource. The status can be one of <code>REGISTRATION_SUCCESS</code>,
     * <code>REGISTRATION_PENDING</code>, <code>REGISTRATION_FAILURE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #registrationStatus} will return {@link RegistrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #registrationStatusAsString}.
     * </p>
     * 
     * @return The status of registering your IAM resource. The status can be one of <code>REGISTRATION_SUCCESS</code>,
     *         <code>REGISTRATION_PENDING</code>, <code>REGISTRATION_FAILURE</code>.
     * @see RegistrationStatus
     */
    public final String registrationStatusAsString() {
        return registrationStatus;
    }

    /**
     * <p>
     * A message associated with a registration error.
     * </p>
     * 
     * @return A message associated with a registration error.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(registrationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IamRegistrationResponse)) {
            return false;
        }
        IamRegistrationResponse other = (IamRegistrationResponse) obj;
        return Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(registrationStatusAsString(), other.registrationStatusAsString())
                && Objects.equals(errorMessage(), other.errorMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IamRegistrationResponse").add("RoleArn", roleArn())
                .add("RegistrationStatus", registrationStatusAsString()).add("ErrorMessage", errorMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "registrationStatus":
            return Optional.ofNullable(clazz.cast(registrationStatusAsString()));
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("registrationStatus", REGISTRATION_STATUS_FIELD);
        map.put("errorMessage", ERROR_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IamRegistrationResponse, T> g) {
        return obj -> g.apply((IamRegistrationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IamRegistrationResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role to register.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role to register.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The status of registering your IAM resource. The status can be one of <code>REGISTRATION_SUCCESS</code>,
         * <code>REGISTRATION_PENDING</code>, <code>REGISTRATION_FAILURE</code>.
         * </p>
         * 
         * @param registrationStatus
         *        The status of registering your IAM resource. The status can be one of
         *        <code>REGISTRATION_SUCCESS</code>, <code>REGISTRATION_PENDING</code>,
         *        <code>REGISTRATION_FAILURE</code>.
         * @see RegistrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistrationStatus
         */
        Builder registrationStatus(String registrationStatus);

        /**
         * <p>
         * The status of registering your IAM resource. The status can be one of <code>REGISTRATION_SUCCESS</code>,
         * <code>REGISTRATION_PENDING</code>, <code>REGISTRATION_FAILURE</code>.
         * </p>
         * 
         * @param registrationStatus
         *        The status of registering your IAM resource. The status can be one of
         *        <code>REGISTRATION_SUCCESS</code>, <code>REGISTRATION_PENDING</code>,
         *        <code>REGISTRATION_FAILURE</code>.
         * @see RegistrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistrationStatus
         */
        Builder registrationStatus(RegistrationStatus registrationStatus);

        /**
         * <p>
         * A message associated with a registration error.
         * </p>
         * 
         * @param errorMessage
         *        A message associated with a registration error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);
    }

    static final class BuilderImpl implements Builder {
        private String roleArn;

        private String registrationStatus;

        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(IamRegistrationResponse model) {
            roleArn(model.roleArn);
            registrationStatus(model.registrationStatus);
            errorMessage(model.errorMessage);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getRegistrationStatus() {
            return registrationStatus;
        }

        public final void setRegistrationStatus(String registrationStatus) {
            this.registrationStatus = registrationStatus;
        }

        @Override
        public final Builder registrationStatus(String registrationStatus) {
            this.registrationStatus = registrationStatus;
            return this;
        }

        @Override
        public final Builder registrationStatus(RegistrationStatus registrationStatus) {
            this.registrationStatus(registrationStatus == null ? null : registrationStatus.toString());
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        @Override
        public IamRegistrationResponse build() {
            return new IamRegistrationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
