/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDecoderManifestsRequest extends IoTFleetWiseRequest implements
        ToCopyableBuilder<ListDecoderManifestsRequest.Builder, ListDecoderManifestsRequest> {
    private static final SdkField<String> MODEL_MANIFEST_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelManifestArn").getter(getter(ListDecoderManifestsRequest::modelManifestArn))
            .setter(setter(Builder::modelManifestArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelManifestArn").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListDecoderManifestsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListDecoderManifestsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_MANIFEST_ARN_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String modelManifestArn;

    private final String nextToken;

    private final Integer maxResults;

    private ListDecoderManifestsRequest(BuilderImpl builder) {
        super(builder);
        this.modelManifestArn = builder.modelManifestArn;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a vehicle model (model manifest) associated with the decoder manifest.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a vehicle model (model manifest) associated with the decoder manifest.
     */
    public final String modelManifestArn() {
        return modelManifestArn;
    }

    /**
     * <p>
     * A pagination token for the next set of results.
     * </p>
     * <p>
     * If the results of a search are large, only a portion of the results are returned, and a <code>nextToken</code>
     * pagination token is returned in the response. To retrieve the next set of results, reissue the search request and
     * include the returned token. When all results have been returned, the response does not contain a pagination token
     * value.
     * </p>
     * 
     * @return A pagination token for the next set of results.</p>
     *         <p>
     *         If the results of a search are large, only a portion of the results are returned, and a
     *         <code>nextToken</code> pagination token is returned in the response. To retrieve the next set of results,
     *         reissue the search request and include the returned token. When all results have been returned, the
     *         response does not contain a pagination token value.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of items to return, between 1 and 100, inclusive.
     * </p>
     * 
     * @return The maximum number of items to return, between 1 and 100, inclusive.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(modelManifestArn());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDecoderManifestsRequest)) {
            return false;
        }
        ListDecoderManifestsRequest other = (ListDecoderManifestsRequest) obj;
        return Objects.equals(modelManifestArn(), other.modelManifestArn()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDecoderManifestsRequest").add("ModelManifestArn", modelManifestArn())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "modelManifestArn":
            return Optional.ofNullable(clazz.cast(modelManifestArn()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("modelManifestArn", MODEL_MANIFEST_ARN_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDecoderManifestsRequest, T> g) {
        return obj -> g.apply((ListDecoderManifestsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTFleetWiseRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListDecoderManifestsRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of a vehicle model (model manifest) associated with the decoder manifest.
         * </p>
         * 
         * @param modelManifestArn
         *        The Amazon Resource Name (ARN) of a vehicle model (model manifest) associated with the decoder
         *        manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelManifestArn(String modelManifestArn);

        /**
         * <p>
         * A pagination token for the next set of results.
         * </p>
         * <p>
         * If the results of a search are large, only a portion of the results are returned, and a
         * <code>nextToken</code> pagination token is returned in the response. To retrieve the next set of results,
         * reissue the search request and include the returned token. When all results have been returned, the response
         * does not contain a pagination token value.
         * </p>
         * 
         * @param nextToken
         *        A pagination token for the next set of results.</p>
         *        <p>
         *        If the results of a search are large, only a portion of the results are returned, and a
         *        <code>nextToken</code> pagination token is returned in the response. To retrieve the next set of
         *        results, reissue the search request and include the returned token. When all results have been
         *        returned, the response does not contain a pagination token value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of items to return, between 1 and 100, inclusive.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return, between 1 and 100, inclusive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTFleetWiseRequest.BuilderImpl implements Builder {
        private String modelManifestArn;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDecoderManifestsRequest model) {
            super(model);
            modelManifestArn(model.modelManifestArn);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getModelManifestArn() {
            return modelManifestArn;
        }

        public final void setModelManifestArn(String modelManifestArn) {
            this.modelManifestArn = modelManifestArn;
        }

        @Override
        public final Builder modelManifestArn(String modelManifestArn) {
            this.modelManifestArn = modelManifestArn;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDecoderManifestsRequest build() {
            return new ListDecoderManifestsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
