/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a list type node of the complex data structure.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StructuredMessageListDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<StructuredMessageListDefinition.Builder, StructuredMessageListDefinition> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(StructuredMessageListDefinition::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<StructuredMessage> MEMBER_TYPE_FIELD = SdkField
            .<StructuredMessage> builder(MarshallingType.SDK_POJO).memberName("memberType")
            .getter(getter(StructuredMessageListDefinition::memberType)).setter(setter(Builder::memberType))
            .constructor(StructuredMessage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memberType").build()).build();

    private static final SdkField<String> LIST_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("listType").getter(getter(StructuredMessageListDefinition::listTypeAsString))
            .setter(setter(Builder::listType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listType").build()).build();

    private static final SdkField<Integer> CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("capacity").getter(getter(StructuredMessageListDefinition::capacity)).setter(setter(Builder::capacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, MEMBER_TYPE_FIELD,
            LIST_TYPE_FIELD, CAPACITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final StructuredMessage memberType;

    private final String listType;

    private final Integer capacity;

    private StructuredMessageListDefinition(BuilderImpl builder) {
        this.name = builder.name;
        this.memberType = builder.memberType;
        this.listType = builder.listType;
        this.capacity = builder.capacity;
    }

    /**
     * <p>
     * The name of the structured message list definition.
     * </p>
     * 
     * @return The name of the structured message list definition.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The member type of the structured message list definition.
     * </p>
     * 
     * @return The member type of the structured message list definition.
     */
    public final StructuredMessage memberType() {
        return memberType;
    }

    /**
     * <p>
     * The type of list of the structured message list definition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #listType} will
     * return {@link StructuredMessageListType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #listTypeAsString}.
     * </p>
     * 
     * @return The type of list of the structured message list definition.
     * @see StructuredMessageListType
     */
    public final StructuredMessageListType listType() {
        return StructuredMessageListType.fromValue(listType);
    }

    /**
     * <p>
     * The type of list of the structured message list definition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #listType} will
     * return {@link StructuredMessageListType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #listTypeAsString}.
     * </p>
     * 
     * @return The type of list of the structured message list definition.
     * @see StructuredMessageListType
     */
    public final String listTypeAsString() {
        return listType;
    }

    /**
     * <p>
     * The capacity of the structured message list definition when the list type is <code>FIXED_CAPACITY</code> or
     * <code>DYNAMIC_BOUNDED_CAPACITY</code>.
     * </p>
     * 
     * @return The capacity of the structured message list definition when the list type is <code>FIXED_CAPACITY</code>
     *         or <code>DYNAMIC_BOUNDED_CAPACITY</code>.
     */
    public final Integer capacity() {
        return capacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(memberType());
        hashCode = 31 * hashCode + Objects.hashCode(listTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(capacity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StructuredMessageListDefinition)) {
            return false;
        }
        StructuredMessageListDefinition other = (StructuredMessageListDefinition) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(memberType(), other.memberType())
                && Objects.equals(listTypeAsString(), other.listTypeAsString()) && Objects.equals(capacity(), other.capacity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StructuredMessageListDefinition").add("Name", name()).add("MemberType", memberType())
                .add("ListType", listTypeAsString()).add("Capacity", capacity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "memberType":
            return Optional.ofNullable(clazz.cast(memberType()));
        case "listType":
            return Optional.ofNullable(clazz.cast(listTypeAsString()));
        case "capacity":
            return Optional.ofNullable(clazz.cast(capacity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("memberType", MEMBER_TYPE_FIELD);
        map.put("listType", LIST_TYPE_FIELD);
        map.put("capacity", CAPACITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StructuredMessageListDefinition, T> g) {
        return obj -> g.apply((StructuredMessageListDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StructuredMessageListDefinition> {
        /**
         * <p>
         * The name of the structured message list definition.
         * </p>
         * 
         * @param name
         *        The name of the structured message list definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The member type of the structured message list definition.
         * </p>
         * 
         * @param memberType
         *        The member type of the structured message list definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberType(StructuredMessage memberType);

        /**
         * <p>
         * The member type of the structured message list definition.
         * </p>
         * This is a convenience method that creates an instance of the {@link StructuredMessage.Builder} avoiding the
         * need to create one manually via {@link StructuredMessage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StructuredMessage.Builder#build()} is called immediately and its
         * result is passed to {@link #memberType(StructuredMessage)}.
         * 
         * @param memberType
         *        a consumer that will call methods on {@link StructuredMessage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #memberType(StructuredMessage)
         */
        default Builder memberType(Consumer<StructuredMessage.Builder> memberType) {
            return memberType(StructuredMessage.builder().applyMutation(memberType).build());
        }

        /**
         * <p>
         * The type of list of the structured message list definition.
         * </p>
         * 
         * @param listType
         *        The type of list of the structured message list definition.
         * @see StructuredMessageListType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StructuredMessageListType
         */
        Builder listType(String listType);

        /**
         * <p>
         * The type of list of the structured message list definition.
         * </p>
         * 
         * @param listType
         *        The type of list of the structured message list definition.
         * @see StructuredMessageListType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StructuredMessageListType
         */
        Builder listType(StructuredMessageListType listType);

        /**
         * <p>
         * The capacity of the structured message list definition when the list type is <code>FIXED_CAPACITY</code> or
         * <code>DYNAMIC_BOUNDED_CAPACITY</code>.
         * </p>
         * 
         * @param capacity
         *        The capacity of the structured message list definition when the list type is
         *        <code>FIXED_CAPACITY</code> or <code>DYNAMIC_BOUNDED_CAPACITY</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacity(Integer capacity);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private StructuredMessage memberType;

        private String listType;

        private Integer capacity;

        private BuilderImpl() {
        }

        private BuilderImpl(StructuredMessageListDefinition model) {
            name(model.name);
            memberType(model.memberType);
            listType(model.listType);
            capacity(model.capacity);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final StructuredMessage.Builder getMemberType() {
            return memberType != null ? memberType.toBuilder() : null;
        }

        public final void setMemberType(StructuredMessage.BuilderImpl memberType) {
            this.memberType = memberType != null ? memberType.build() : null;
        }

        @Override
        public final Builder memberType(StructuredMessage memberType) {
            this.memberType = memberType;
            return this;
        }

        public final String getListType() {
            return listType;
        }

        public final void setListType(String listType) {
            this.listType = listType;
        }

        @Override
        public final Builder listType(String listType) {
            this.listType = listType;
            return this;
        }

        @Override
        public final Builder listType(StructuredMessageListType listType) {
            this.listType(listType == null ? null : listType.toString());
            return this;
        }

        public final Integer getCapacity() {
            return capacity;
        }

        public final void setCapacity(Integer capacity) {
            this.capacity = capacity;
        }

        @Override
        public final Builder capacity(Integer capacity) {
            this.capacity = capacity;
            return this;
        }

        @Override
        public StructuredMessageListDefinition build() {
            return new StructuredMessageListDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
