/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateStateTemplateRequest extends IoTFleetWiseRequest implements
        ToCopyableBuilder<UpdateStateTemplateRequest.Builder, UpdateStateTemplateRequest> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identifier").getter(getter(UpdateStateTemplateRequest::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifier").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateStateTemplateRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<String>> STATE_TEMPLATE_PROPERTIES_TO_ADD_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("stateTemplatePropertiesToAdd")
            .getter(getter(UpdateStateTemplateRequest::stateTemplatePropertiesToAdd))
            .setter(setter(Builder::stateTemplatePropertiesToAdd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateTemplatePropertiesToAdd")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> STATE_TEMPLATE_PROPERTIES_TO_REMOVE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("stateTemplatePropertiesToRemove")
            .getter(getter(UpdateStateTemplateRequest::stateTemplatePropertiesToRemove))
            .setter(setter(Builder::stateTemplatePropertiesToRemove))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateTemplatePropertiesToRemove")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> DATA_EXTRA_DIMENSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("dataExtraDimensions")
            .getter(getter(UpdateStateTemplateRequest::dataExtraDimensions))
            .setter(setter(Builder::dataExtraDimensions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataExtraDimensions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> METADATA_EXTRA_DIMENSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("metadataExtraDimensions")
            .getter(getter(UpdateStateTemplateRequest::metadataExtraDimensions))
            .setter(setter(Builder::metadataExtraDimensions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadataExtraDimensions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD,
            DESCRIPTION_FIELD, STATE_TEMPLATE_PROPERTIES_TO_ADD_FIELD, STATE_TEMPLATE_PROPERTIES_TO_REMOVE_FIELD,
            DATA_EXTRA_DIMENSIONS_FIELD, METADATA_EXTRA_DIMENSIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String identifier;

    private final String description;

    private final List<String> stateTemplatePropertiesToAdd;

    private final List<String> stateTemplatePropertiesToRemove;

    private final List<String> dataExtraDimensions;

    private final List<String> metadataExtraDimensions;

    private UpdateStateTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.description = builder.description;
        this.stateTemplatePropertiesToAdd = builder.stateTemplatePropertiesToAdd;
        this.stateTemplatePropertiesToRemove = builder.stateTemplatePropertiesToRemove;
        this.dataExtraDimensions = builder.dataExtraDimensions;
        this.metadataExtraDimensions = builder.metadataExtraDimensions;
    }

    /**
     * <p>
     * A unique, service-generated identifier.
     * </p>
     * 
     * @return A unique, service-generated identifier.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * A brief description of the state template.
     * </p>
     * 
     * @return A brief description of the state template.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the StateTemplatePropertiesToAdd property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasStateTemplatePropertiesToAdd() {
        return stateTemplatePropertiesToAdd != null && !(stateTemplatePropertiesToAdd instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Add signals from which data is collected as part of the state template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStateTemplatePropertiesToAdd} method.
     * </p>
     * 
     * @return Add signals from which data is collected as part of the state template.
     */
    public final List<String> stateTemplatePropertiesToAdd() {
        return stateTemplatePropertiesToAdd;
    }

    /**
     * For responses, this returns true if the service returned a value for the StateTemplatePropertiesToRemove
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasStateTemplatePropertiesToRemove() {
        return stateTemplatePropertiesToRemove != null && !(stateTemplatePropertiesToRemove instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Remove signals from which data is collected as part of the state template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStateTemplatePropertiesToRemove}
     * method.
     * </p>
     * 
     * @return Remove signals from which data is collected as part of the state template.
     */
    public final List<String> stateTemplatePropertiesToRemove() {
        return stateTemplatePropertiesToRemove;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataExtraDimensions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDataExtraDimensions() {
        return dataExtraDimensions != null && !(dataExtraDimensions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of vehicle attributes to associate with the payload published on the state template's MQTT topic. (See <a
     * href=
     * "https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/process-visualize-data.html#process-last-known-state-vehicle-data"
     * > Processing last known state vehicle data using MQTT messaging</a>). For example, if you add
     * <code>Vehicle.Attributes.Make</code> and <code>Vehicle.Attributes.Model</code> attributes, Amazon Web Services
     * IoT FleetWise will enrich the protobuf encoded payload with those attributes in the <code>extraDimensions</code>
     * field.
     * </p>
     * <p>
     * Default: An empty array
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataExtraDimensions} method.
     * </p>
     * 
     * @return A list of vehicle attributes to associate with the payload published on the state template's MQTT topic.
     *         (See <a href=
     *         "https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/process-visualize-data.html#process-last-known-state-vehicle-data"
     *         > Processing last known state vehicle data using MQTT messaging</a>). For example, if you add
     *         <code>Vehicle.Attributes.Make</code> and <code>Vehicle.Attributes.Model</code> attributes, Amazon Web
     *         Services IoT FleetWise will enrich the protobuf encoded payload with those attributes in the
     *         <code>extraDimensions</code> field.</p>
     *         <p>
     *         Default: An empty array
     */
    public final List<String> dataExtraDimensions() {
        return dataExtraDimensions;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetadataExtraDimensions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasMetadataExtraDimensions() {
        return metadataExtraDimensions != null && !(metadataExtraDimensions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of vehicle attributes to associate with user properties of the messages published on the state template's
     * MQTT topic. (See <a href=
     * "https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/process-visualize-data.html#process-last-known-state-vehicle-data"
     * > Processing last known state vehicle data using MQTT messaging</a>). For example, if you add
     * <code>Vehicle.Attributes.Make</code> and <code>Vehicle.Attributes.Model</code> attributes, Amazon Web Services
     * IoT FleetWise will include these attributes as User Properties with the MQTT message.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetadataExtraDimensions} method.
     * </p>
     * 
     * @return A list of vehicle attributes to associate with user properties of the messages published on the state
     *         template's MQTT topic. (See <a href=
     *         "https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/process-visualize-data.html#process-last-known-state-vehicle-data"
     *         > Processing last known state vehicle data using MQTT messaging</a>). For example, if you add
     *         <code>Vehicle.Attributes.Make</code> and <code>Vehicle.Attributes.Model</code> attributes, Amazon Web
     *         Services IoT FleetWise will include these attributes as User Properties with the MQTT message.
     */
    public final List<String> metadataExtraDimensions() {
        return metadataExtraDimensions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasStateTemplatePropertiesToAdd() ? stateTemplatePropertiesToAdd() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasStateTemplatePropertiesToRemove() ? stateTemplatePropertiesToRemove() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDataExtraDimensions() ? dataExtraDimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMetadataExtraDimensions() ? metadataExtraDimensions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStateTemplateRequest)) {
            return false;
        }
        UpdateStateTemplateRequest other = (UpdateStateTemplateRequest) obj;
        return Objects.equals(identifier(), other.identifier()) && Objects.equals(description(), other.description())
                && hasStateTemplatePropertiesToAdd() == other.hasStateTemplatePropertiesToAdd()
                && Objects.equals(stateTemplatePropertiesToAdd(), other.stateTemplatePropertiesToAdd())
                && hasStateTemplatePropertiesToRemove() == other.hasStateTemplatePropertiesToRemove()
                && Objects.equals(stateTemplatePropertiesToRemove(), other.stateTemplatePropertiesToRemove())
                && hasDataExtraDimensions() == other.hasDataExtraDimensions()
                && Objects.equals(dataExtraDimensions(), other.dataExtraDimensions())
                && hasMetadataExtraDimensions() == other.hasMetadataExtraDimensions()
                && Objects.equals(metadataExtraDimensions(), other.metadataExtraDimensions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("UpdateStateTemplateRequest")
                .add("Identifier", identifier())
                .add("Description", description())
                .add("StateTemplatePropertiesToAdd", hasStateTemplatePropertiesToAdd() ? stateTemplatePropertiesToAdd() : null)
                .add("StateTemplatePropertiesToRemove",
                        hasStateTemplatePropertiesToRemove() ? stateTemplatePropertiesToRemove() : null)
                .add("DataExtraDimensions", hasDataExtraDimensions() ? dataExtraDimensions() : null)
                .add("MetadataExtraDimensions", hasMetadataExtraDimensions() ? metadataExtraDimensions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "stateTemplatePropertiesToAdd":
            return Optional.ofNullable(clazz.cast(stateTemplatePropertiesToAdd()));
        case "stateTemplatePropertiesToRemove":
            return Optional.ofNullable(clazz.cast(stateTemplatePropertiesToRemove()));
        case "dataExtraDimensions":
            return Optional.ofNullable(clazz.cast(dataExtraDimensions()));
        case "metadataExtraDimensions":
            return Optional.ofNullable(clazz.cast(metadataExtraDimensions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("identifier", IDENTIFIER_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("stateTemplatePropertiesToAdd", STATE_TEMPLATE_PROPERTIES_TO_ADD_FIELD);
        map.put("stateTemplatePropertiesToRemove", STATE_TEMPLATE_PROPERTIES_TO_REMOVE_FIELD);
        map.put("dataExtraDimensions", DATA_EXTRA_DIMENSIONS_FIELD);
        map.put("metadataExtraDimensions", METADATA_EXTRA_DIMENSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateStateTemplateRequest, T> g) {
        return obj -> g.apply((UpdateStateTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTFleetWiseRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateStateTemplateRequest> {
        /**
         * <p>
         * A unique, service-generated identifier.
         * </p>
         * 
         * @param identifier
         *        A unique, service-generated identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * A brief description of the state template.
         * </p>
         * 
         * @param description
         *        A brief description of the state template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Add signals from which data is collected as part of the state template.
         * </p>
         * 
         * @param stateTemplatePropertiesToAdd
         *        Add signals from which data is collected as part of the state template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateTemplatePropertiesToAdd(Collection<String> stateTemplatePropertiesToAdd);

        /**
         * <p>
         * Add signals from which data is collected as part of the state template.
         * </p>
         * 
         * @param stateTemplatePropertiesToAdd
         *        Add signals from which data is collected as part of the state template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateTemplatePropertiesToAdd(String... stateTemplatePropertiesToAdd);

        /**
         * <p>
         * Remove signals from which data is collected as part of the state template.
         * </p>
         * 
         * @param stateTemplatePropertiesToRemove
         *        Remove signals from which data is collected as part of the state template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateTemplatePropertiesToRemove(Collection<String> stateTemplatePropertiesToRemove);

        /**
         * <p>
         * Remove signals from which data is collected as part of the state template.
         * </p>
         * 
         * @param stateTemplatePropertiesToRemove
         *        Remove signals from which data is collected as part of the state template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateTemplatePropertiesToRemove(String... stateTemplatePropertiesToRemove);

        /**
         * <p>
         * A list of vehicle attributes to associate with the payload published on the state template's MQTT topic. (See
         * <a href=
         * "https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/process-visualize-data.html#process-last-known-state-vehicle-data"
         * > Processing last known state vehicle data using MQTT messaging</a>). For example, if you add
         * <code>Vehicle.Attributes.Make</code> and <code>Vehicle.Attributes.Model</code> attributes, Amazon Web
         * Services IoT FleetWise will enrich the protobuf encoded payload with those attributes in the
         * <code>extraDimensions</code> field.
         * </p>
         * <p>
         * Default: An empty array
         * </p>
         * 
         * @param dataExtraDimensions
         *        A list of vehicle attributes to associate with the payload published on the state template's MQTT
         *        topic. (See <a href=
         *        "https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/process-visualize-data.html#process-last-known-state-vehicle-data"
         *        > Processing last known state vehicle data using MQTT messaging</a>). For example, if you add
         *        <code>Vehicle.Attributes.Make</code> and <code>Vehicle.Attributes.Model</code> attributes, Amazon Web
         *        Services IoT FleetWise will enrich the protobuf encoded payload with those attributes in the
         *        <code>extraDimensions</code> field.</p>
         *        <p>
         *        Default: An empty array
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataExtraDimensions(Collection<String> dataExtraDimensions);

        /**
         * <p>
         * A list of vehicle attributes to associate with the payload published on the state template's MQTT topic. (See
         * <a href=
         * "https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/process-visualize-data.html#process-last-known-state-vehicle-data"
         * > Processing last known state vehicle data using MQTT messaging</a>). For example, if you add
         * <code>Vehicle.Attributes.Make</code> and <code>Vehicle.Attributes.Model</code> attributes, Amazon Web
         * Services IoT FleetWise will enrich the protobuf encoded payload with those attributes in the
         * <code>extraDimensions</code> field.
         * </p>
         * <p>
         * Default: An empty array
         * </p>
         * 
         * @param dataExtraDimensions
         *        A list of vehicle attributes to associate with the payload published on the state template's MQTT
         *        topic. (See <a href=
         *        "https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/process-visualize-data.html#process-last-known-state-vehicle-data"
         *        > Processing last known state vehicle data using MQTT messaging</a>). For example, if you add
         *        <code>Vehicle.Attributes.Make</code> and <code>Vehicle.Attributes.Model</code> attributes, Amazon Web
         *        Services IoT FleetWise will enrich the protobuf encoded payload with those attributes in the
         *        <code>extraDimensions</code> field.</p>
         *        <p>
         *        Default: An empty array
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataExtraDimensions(String... dataExtraDimensions);

        /**
         * <p>
         * A list of vehicle attributes to associate with user properties of the messages published on the state
         * template's MQTT topic. (See <a href=
         * "https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/process-visualize-data.html#process-last-known-state-vehicle-data"
         * > Processing last known state vehicle data using MQTT messaging</a>). For example, if you add
         * <code>Vehicle.Attributes.Make</code> and <code>Vehicle.Attributes.Model</code> attributes, Amazon Web
         * Services IoT FleetWise will include these attributes as User Properties with the MQTT message.
         * </p>
         * 
         * @param metadataExtraDimensions
         *        A list of vehicle attributes to associate with user properties of the messages published on the state
         *        template's MQTT topic. (See <a href=
         *        "https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/process-visualize-data.html#process-last-known-state-vehicle-data"
         *        > Processing last known state vehicle data using MQTT messaging</a>). For example, if you add
         *        <code>Vehicle.Attributes.Make</code> and <code>Vehicle.Attributes.Model</code> attributes, Amazon Web
         *        Services IoT FleetWise will include these attributes as User Properties with the MQTT message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataExtraDimensions(Collection<String> metadataExtraDimensions);

        /**
         * <p>
         * A list of vehicle attributes to associate with user properties of the messages published on the state
         * template's MQTT topic. (See <a href=
         * "https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/process-visualize-data.html#process-last-known-state-vehicle-data"
         * > Processing last known state vehicle data using MQTT messaging</a>). For example, if you add
         * <code>Vehicle.Attributes.Make</code> and <code>Vehicle.Attributes.Model</code> attributes, Amazon Web
         * Services IoT FleetWise will include these attributes as User Properties with the MQTT message.
         * </p>
         * 
         * @param metadataExtraDimensions
         *        A list of vehicle attributes to associate with user properties of the messages published on the state
         *        template's MQTT topic. (See <a href=
         *        "https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/process-visualize-data.html#process-last-known-state-vehicle-data"
         *        > Processing last known state vehicle data using MQTT messaging</a>). For example, if you add
         *        <code>Vehicle.Attributes.Make</code> and <code>Vehicle.Attributes.Model</code> attributes, Amazon Web
         *        Services IoT FleetWise will include these attributes as User Properties with the MQTT message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataExtraDimensions(String... metadataExtraDimensions);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTFleetWiseRequest.BuilderImpl implements Builder {
        private String identifier;

        private String description;

        private List<String> stateTemplatePropertiesToAdd = DefaultSdkAutoConstructList.getInstance();

        private List<String> stateTemplatePropertiesToRemove = DefaultSdkAutoConstructList.getInstance();

        private List<String> dataExtraDimensions = DefaultSdkAutoConstructList.getInstance();

        private List<String> metadataExtraDimensions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStateTemplateRequest model) {
            super(model);
            identifier(model.identifier);
            description(model.description);
            stateTemplatePropertiesToAdd(model.stateTemplatePropertiesToAdd);
            stateTemplatePropertiesToRemove(model.stateTemplatePropertiesToRemove);
            dataExtraDimensions(model.dataExtraDimensions);
            metadataExtraDimensions(model.metadataExtraDimensions);
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getStateTemplatePropertiesToAdd() {
            if (stateTemplatePropertiesToAdd instanceof SdkAutoConstructList) {
                return null;
            }
            return stateTemplatePropertiesToAdd;
        }

        public final void setStateTemplatePropertiesToAdd(Collection<String> stateTemplatePropertiesToAdd) {
            this.stateTemplatePropertiesToAdd = StateTemplatePropertiesCopier.copy(stateTemplatePropertiesToAdd);
        }

        @Override
        public final Builder stateTemplatePropertiesToAdd(Collection<String> stateTemplatePropertiesToAdd) {
            this.stateTemplatePropertiesToAdd = StateTemplatePropertiesCopier.copy(stateTemplatePropertiesToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stateTemplatePropertiesToAdd(String... stateTemplatePropertiesToAdd) {
            stateTemplatePropertiesToAdd(Arrays.asList(stateTemplatePropertiesToAdd));
            return this;
        }

        public final Collection<String> getStateTemplatePropertiesToRemove() {
            if (stateTemplatePropertiesToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return stateTemplatePropertiesToRemove;
        }

        public final void setStateTemplatePropertiesToRemove(Collection<String> stateTemplatePropertiesToRemove) {
            this.stateTemplatePropertiesToRemove = StateTemplatePropertiesCopier.copy(stateTemplatePropertiesToRemove);
        }

        @Override
        public final Builder stateTemplatePropertiesToRemove(Collection<String> stateTemplatePropertiesToRemove) {
            this.stateTemplatePropertiesToRemove = StateTemplatePropertiesCopier.copy(stateTemplatePropertiesToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stateTemplatePropertiesToRemove(String... stateTemplatePropertiesToRemove) {
            stateTemplatePropertiesToRemove(Arrays.asList(stateTemplatePropertiesToRemove));
            return this;
        }

        public final Collection<String> getDataExtraDimensions() {
            if (dataExtraDimensions instanceof SdkAutoConstructList) {
                return null;
            }
            return dataExtraDimensions;
        }

        public final void setDataExtraDimensions(Collection<String> dataExtraDimensions) {
            this.dataExtraDimensions = StateTemplateDataExtraDimensionNodePathListCopier.copy(dataExtraDimensions);
        }

        @Override
        public final Builder dataExtraDimensions(Collection<String> dataExtraDimensions) {
            this.dataExtraDimensions = StateTemplateDataExtraDimensionNodePathListCopier.copy(dataExtraDimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataExtraDimensions(String... dataExtraDimensions) {
            dataExtraDimensions(Arrays.asList(dataExtraDimensions));
            return this;
        }

        public final Collection<String> getMetadataExtraDimensions() {
            if (metadataExtraDimensions instanceof SdkAutoConstructList) {
                return null;
            }
            return metadataExtraDimensions;
        }

        public final void setMetadataExtraDimensions(Collection<String> metadataExtraDimensions) {
            this.metadataExtraDimensions = StateTemplateMetadataExtraDimensionNodePathListCopier.copy(metadataExtraDimensions);
        }

        @Override
        public final Builder metadataExtraDimensions(Collection<String> metadataExtraDimensions) {
            this.metadataExtraDimensions = StateTemplateMetadataExtraDimensionNodePathListCopier.copy(metadataExtraDimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metadataExtraDimensions(String... metadataExtraDimensions) {
            metadataExtraDimensions(Arrays.asList(metadataExtraDimensions));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateStateTemplateRequest build() {
            return new UpdateStateTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
