/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An HTTP error resulting from updating the description for a vehicle.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateVehicleError implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateVehicleError.Builder, UpdateVehicleError> {
    private static final SdkField<String> VEHICLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vehicleName").getter(getter(UpdateVehicleError::vehicleName)).setter(setter(Builder::vehicleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vehicleName").build()).build();

    private static final SdkField<Integer> CODE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("code")
            .getter(getter(UpdateVehicleError::code)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(UpdateVehicleError::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VEHICLE_NAME_FIELD,
            CODE_FIELD, MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String vehicleName;

    private final Integer code;

    private final String message;

    private UpdateVehicleError(BuilderImpl builder) {
        this.vehicleName = builder.vehicleName;
        this.code = builder.code;
        this.message = builder.message;
    }

    /**
     * <p>
     * The ID of the vehicle with the error.
     * </p>
     * 
     * @return The ID of the vehicle with the error.
     */
    public final String vehicleName() {
        return vehicleName;
    }

    /**
     * <p>
     * The relevant HTTP error code (400+).
     * </p>
     * 
     * @return The relevant HTTP error code (400+).
     */
    public final Integer code() {
        return code;
    }

    /**
     * <p>
     * A message associated with the error.
     * </p>
     * 
     * @return A message associated with the error.
     */
    public final String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vehicleName());
        hashCode = 31 * hashCode + Objects.hashCode(code());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateVehicleError)) {
            return false;
        }
        UpdateVehicleError other = (UpdateVehicleError) obj;
        return Objects.equals(vehicleName(), other.vehicleName()) && Objects.equals(code(), other.code())
                && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateVehicleError").add("VehicleName", vehicleName()).add("Code", code())
                .add("Message", message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "vehicleName":
            return Optional.ofNullable(clazz.cast(vehicleName()));
        case "code":
            return Optional.ofNullable(clazz.cast(code()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("vehicleName", VEHICLE_NAME_FIELD);
        map.put("code", CODE_FIELD);
        map.put("message", MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateVehicleError, T> g) {
        return obj -> g.apply((UpdateVehicleError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateVehicleError> {
        /**
         * <p>
         * The ID of the vehicle with the error.
         * </p>
         * 
         * @param vehicleName
         *        The ID of the vehicle with the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vehicleName(String vehicleName);

        /**
         * <p>
         * The relevant HTTP error code (400+).
         * </p>
         * 
         * @param code
         *        The relevant HTTP error code (400+).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(Integer code);

        /**
         * <p>
         * A message associated with the error.
         * </p>
         * 
         * @param message
         *        A message associated with the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String vehicleName;

        private Integer code;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateVehicleError model) {
            vehicleName(model.vehicleName);
            code(model.code);
            message(model.message);
        }

        public final String getVehicleName() {
            return vehicleName;
        }

        public final void setVehicleName(String vehicleName) {
            this.vehicleName = vehicleName;
        }

        @Override
        public final Builder vehicleName(String vehicleName) {
            this.vehicleName = vehicleName;
            return this;
        }

        public final Integer getCode() {
            return code;
        }

        public final void setCode(Integer code) {
            this.code = code;
        }

        @Override
        public final Builder code(Integer code) {
            this.code = code;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public UpdateVehicleError build() {
            return new UpdateVehicleError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
