/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A signal that represents static information about the vehicle, such as engine type or manufacturing date.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Attribute implements SdkPojo, Serializable, ToCopyableBuilder<Attribute.Builder, Attribute> {
    private static final SdkField<String> FULLY_QUALIFIED_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fullyQualifiedName").getter(getter(Attribute::fullyQualifiedName))
            .setter(setter(Builder::fullyQualifiedName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fullyQualifiedName").build())
            .build();

    private static final SdkField<String> DATA_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataType").getter(getter(Attribute::dataTypeAsString)).setter(setter(Builder::dataType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataType").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(Attribute::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("unit")
            .getter(getter(Attribute::unit)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unit").build()).build();

    private static final SdkField<List<String>> ALLOWED_VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("allowedValues")
            .getter(getter(Attribute::allowedValues))
            .setter(setter(Builder::allowedValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Double> MIN_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("min")
            .getter(getter(Attribute::min)).setter(setter(Builder::min))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("min").build()).build();

    private static final SdkField<Double> MAX_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("max")
            .getter(getter(Attribute::max)).setter(setter(Builder::max))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("max").build()).build();

    private static final SdkField<String> ASSIGNED_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assignedValue").getter(getter(Attribute::assignedValue)).setter(setter(Builder::assignedValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assignedValue").build()).build();

    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("defaultValue").getter(getter(Attribute::defaultValue)).setter(setter(Builder::defaultValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultValue").build()).build();

    private static final SdkField<String> DEPRECATION_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deprecationMessage").getter(getter(Attribute::deprecationMessage))
            .setter(setter(Builder::deprecationMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deprecationMessage").build())
            .build();

    private static final SdkField<String> COMMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("comment")
            .getter(getter(Attribute::comment)).setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FULLY_QUALIFIED_NAME_FIELD,
            DATA_TYPE_FIELD, DESCRIPTION_FIELD, UNIT_FIELD, ALLOWED_VALUES_FIELD, MIN_FIELD, MAX_FIELD, ASSIGNED_VALUE_FIELD,
            DEFAULT_VALUE_FIELD, DEPRECATION_MESSAGE_FIELD, COMMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String fullyQualifiedName;

    private final String dataType;

    private final String description;

    private final String unit;

    private final List<String> allowedValues;

    private final Double min;

    private final Double max;

    private final String assignedValue;

    private final String defaultValue;

    private final String deprecationMessage;

    private final String comment;

    private Attribute(BuilderImpl builder) {
        this.fullyQualifiedName = builder.fullyQualifiedName;
        this.dataType = builder.dataType;
        this.description = builder.description;
        this.unit = builder.unit;
        this.allowedValues = builder.allowedValues;
        this.min = builder.min;
        this.max = builder.max;
        this.assignedValue = builder.assignedValue;
        this.defaultValue = builder.defaultValue;
        this.deprecationMessage = builder.deprecationMessage;
        this.comment = builder.comment;
    }

    /**
     * <p>
     * The fully qualified name of the attribute. For example, the fully qualified name of an attribute might be
     * <code>Vehicle.Body.Engine.Type</code>.
     * </p>
     * 
     * @return The fully qualified name of the attribute. For example, the fully qualified name of an attribute might be
     *         <code>Vehicle.Body.Engine.Type</code>.
     */
    public final String fullyQualifiedName() {
        return fullyQualifiedName;
    }

    /**
     * <p>
     * The specified data type of the attribute.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataType} will
     * return {@link NodeDataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataTypeAsString}.
     * </p>
     * 
     * @return The specified data type of the attribute.
     * @see NodeDataType
     */
    public final NodeDataType dataType() {
        return NodeDataType.fromValue(dataType);
    }

    /**
     * <p>
     * The specified data type of the attribute.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataType} will
     * return {@link NodeDataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataTypeAsString}.
     * </p>
     * 
     * @return The specified data type of the attribute.
     * @see NodeDataType
     */
    public final String dataTypeAsString() {
        return dataType;
    }

    /**
     * <p>
     * A brief description of the attribute.
     * </p>
     * 
     * @return A brief description of the attribute.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The scientific unit for the attribute.
     * </p>
     * 
     * @return The scientific unit for the attribute.
     */
    public final String unit() {
        return unit;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAllowedValues() {
        return allowedValues != null && !(allowedValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of possible values an attribute can be assigned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedValues} method.
     * </p>
     * 
     * @return A list of possible values an attribute can be assigned.
     */
    public final List<String> allowedValues() {
        return allowedValues;
    }

    /**
     * <p>
     * The specified possible minimum value of the attribute.
     * </p>
     * 
     * @return The specified possible minimum value of the attribute.
     */
    public final Double min() {
        return min;
    }

    /**
     * <p>
     * The specified possible maximum value of the attribute.
     * </p>
     * 
     * @return The specified possible maximum value of the attribute.
     */
    public final Double max() {
        return max;
    }

    /**
     * <p>
     * A specified value for the attribute.
     * </p>
     * 
     * @return A specified value for the attribute.
     * @deprecated assignedValue is no longer in use
     */
    @Deprecated
    public final String assignedValue() {
        return assignedValue;
    }

    /**
     * <p>
     * The default value of the attribute.
     * </p>
     * 
     * @return The default value of the attribute.
     */
    public final String defaultValue() {
        return defaultValue;
    }

    /**
     * <p>
     * The deprecation message for the node or the branch that was moved or deleted.
     * </p>
     * 
     * @return The deprecation message for the node or the branch that was moved or deleted.
     */
    public final String deprecationMessage() {
        return deprecationMessage;
    }

    /**
     * <p>
     * A comment in addition to the description.
     * </p>
     * 
     * @return A comment in addition to the description.
     */
    public final String comment() {
        return comment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fullyQualifiedName());
        hashCode = 31 * hashCode + Objects.hashCode(dataTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(unit());
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedValues() ? allowedValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(min());
        hashCode = 31 * hashCode + Objects.hashCode(max());
        hashCode = 31 * hashCode + Objects.hashCode(assignedValue());
        hashCode = 31 * hashCode + Objects.hashCode(defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(deprecationMessage());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Attribute)) {
            return false;
        }
        Attribute other = (Attribute) obj;
        return Objects.equals(fullyQualifiedName(), other.fullyQualifiedName())
                && Objects.equals(dataTypeAsString(), other.dataTypeAsString())
                && Objects.equals(description(), other.description()) && Objects.equals(unit(), other.unit())
                && hasAllowedValues() == other.hasAllowedValues() && Objects.equals(allowedValues(), other.allowedValues())
                && Objects.equals(min(), other.min()) && Objects.equals(max(), other.max())
                && Objects.equals(assignedValue(), other.assignedValue()) && Objects.equals(defaultValue(), other.defaultValue())
                && Objects.equals(deprecationMessage(), other.deprecationMessage()) && Objects.equals(comment(), other.comment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Attribute").add("FullyQualifiedName", fullyQualifiedName()).add("DataType", dataTypeAsString())
                .add("Description", description()).add("Unit", unit())
                .add("AllowedValues", hasAllowedValues() ? allowedValues() : null).add("Min", min()).add("Max", max())
                .add("AssignedValue", assignedValue()).add("DefaultValue", defaultValue())
                .add("DeprecationMessage", deprecationMessage()).add("Comment", comment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fullyQualifiedName":
            return Optional.ofNullable(clazz.cast(fullyQualifiedName()));
        case "dataType":
            return Optional.ofNullable(clazz.cast(dataTypeAsString()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "unit":
            return Optional.ofNullable(clazz.cast(unit()));
        case "allowedValues":
            return Optional.ofNullable(clazz.cast(allowedValues()));
        case "min":
            return Optional.ofNullable(clazz.cast(min()));
        case "max":
            return Optional.ofNullable(clazz.cast(max()));
        case "assignedValue":
            return Optional.ofNullable(clazz.cast(assignedValue()));
        case "defaultValue":
            return Optional.ofNullable(clazz.cast(defaultValue()));
        case "deprecationMessage":
            return Optional.ofNullable(clazz.cast(deprecationMessage()));
        case "comment":
            return Optional.ofNullable(clazz.cast(comment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("fullyQualifiedName", FULLY_QUALIFIED_NAME_FIELD);
        map.put("dataType", DATA_TYPE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("unit", UNIT_FIELD);
        map.put("allowedValues", ALLOWED_VALUES_FIELD);
        map.put("min", MIN_FIELD);
        map.put("max", MAX_FIELD);
        map.put("assignedValue", ASSIGNED_VALUE_FIELD);
        map.put("defaultValue", DEFAULT_VALUE_FIELD);
        map.put("deprecationMessage", DEPRECATION_MESSAGE_FIELD);
        map.put("comment", COMMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Attribute, T> g) {
        return obj -> g.apply((Attribute) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Attribute> {
        /**
         * <p>
         * The fully qualified name of the attribute. For example, the fully qualified name of an attribute might be
         * <code>Vehicle.Body.Engine.Type</code>.
         * </p>
         * 
         * @param fullyQualifiedName
         *        The fully qualified name of the attribute. For example, the fully qualified name of an attribute might
         *        be <code>Vehicle.Body.Engine.Type</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fullyQualifiedName(String fullyQualifiedName);

        /**
         * <p>
         * The specified data type of the attribute.
         * </p>
         * 
         * @param dataType
         *        The specified data type of the attribute.
         * @see NodeDataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeDataType
         */
        Builder dataType(String dataType);

        /**
         * <p>
         * The specified data type of the attribute.
         * </p>
         * 
         * @param dataType
         *        The specified data type of the attribute.
         * @see NodeDataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeDataType
         */
        Builder dataType(NodeDataType dataType);

        /**
         * <p>
         * A brief description of the attribute.
         * </p>
         * 
         * @param description
         *        A brief description of the attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The scientific unit for the attribute.
         * </p>
         * 
         * @param unit
         *        The scientific unit for the attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unit(String unit);

        /**
         * <p>
         * A list of possible values an attribute can be assigned.
         * </p>
         * 
         * @param allowedValues
         *        A list of possible values an attribute can be assigned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedValues(Collection<String> allowedValues);

        /**
         * <p>
         * A list of possible values an attribute can be assigned.
         * </p>
         * 
         * @param allowedValues
         *        A list of possible values an attribute can be assigned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedValues(String... allowedValues);

        /**
         * <p>
         * The specified possible minimum value of the attribute.
         * </p>
         * 
         * @param min
         *        The specified possible minimum value of the attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder min(Double min);

        /**
         * <p>
         * The specified possible maximum value of the attribute.
         * </p>
         * 
         * @param max
         *        The specified possible maximum value of the attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder max(Double max);

        /**
         * <p>
         * A specified value for the attribute.
         * </p>
         * 
         * @param assignedValue
         *        A specified value for the attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated assignedValue is no longer in use
         */
        @Deprecated
        Builder assignedValue(String assignedValue);

        /**
         * <p>
         * The default value of the attribute.
         * </p>
         * 
         * @param defaultValue
         *        The default value of the attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValue(String defaultValue);

        /**
         * <p>
         * The deprecation message for the node or the branch that was moved or deleted.
         * </p>
         * 
         * @param deprecationMessage
         *        The deprecation message for the node or the branch that was moved or deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deprecationMessage(String deprecationMessage);

        /**
         * <p>
         * A comment in addition to the description.
         * </p>
         * 
         * @param comment
         *        A comment in addition to the description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);
    }

    static final class BuilderImpl implements Builder {
        private String fullyQualifiedName;

        private String dataType;

        private String description;

        private String unit;

        private List<String> allowedValues = DefaultSdkAutoConstructList.getInstance();

        private Double min;

        private Double max;

        private String assignedValue;

        private String defaultValue;

        private String deprecationMessage;

        private String comment;

        private BuilderImpl() {
        }

        private BuilderImpl(Attribute model) {
            fullyQualifiedName(model.fullyQualifiedName);
            dataType(model.dataType);
            description(model.description);
            unit(model.unit);
            allowedValues(model.allowedValues);
            min(model.min);
            max(model.max);
            assignedValue(model.assignedValue);
            defaultValue(model.defaultValue);
            deprecationMessage(model.deprecationMessage);
            comment(model.comment);
        }

        public final String getFullyQualifiedName() {
            return fullyQualifiedName;
        }

        public final void setFullyQualifiedName(String fullyQualifiedName) {
            this.fullyQualifiedName = fullyQualifiedName;
        }

        @Override
        public final Builder fullyQualifiedName(String fullyQualifiedName) {
            this.fullyQualifiedName = fullyQualifiedName;
            return this;
        }

        public final String getDataType() {
            return dataType;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        @Override
        public final Builder dataType(NodeDataType dataType) {
            this.dataType(dataType == null ? null : dataType.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getUnit() {
            return unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public final Collection<String> getAllowedValues() {
            if (allowedValues instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedValues;
        }

        public final void setAllowedValues(Collection<String> allowedValues) {
            this.allowedValues = _listOfStringsCopier.copy(allowedValues);
        }

        @Override
        public final Builder allowedValues(Collection<String> allowedValues) {
            this.allowedValues = _listOfStringsCopier.copy(allowedValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedValues(String... allowedValues) {
            allowedValues(Arrays.asList(allowedValues));
            return this;
        }

        public final Double getMin() {
            return min;
        }

        public final void setMin(Double min) {
            this.min = min;
        }

        @Override
        public final Builder min(Double min) {
            this.min = min;
            return this;
        }

        public final Double getMax() {
            return max;
        }

        public final void setMax(Double max) {
            this.max = max;
        }

        @Override
        public final Builder max(Double max) {
            this.max = max;
            return this;
        }

        @Deprecated
        public final String getAssignedValue() {
            return assignedValue;
        }

        @Deprecated
        public final void setAssignedValue(String assignedValue) {
            this.assignedValue = assignedValue;
        }

        @Override
        @Deprecated
        public final Builder assignedValue(String assignedValue) {
            this.assignedValue = assignedValue;
            return this;
        }

        public final String getDefaultValue() {
            return defaultValue;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final String getDeprecationMessage() {
            return deprecationMessage;
        }

        public final void setDeprecationMessage(String deprecationMessage) {
            this.deprecationMessage = deprecationMessage;
        }

        @Override
        public final Builder deprecationMessage(String deprecationMessage) {
            this.deprecationMessage = deprecationMessage;
            return this;
        }

        public final String getComment() {
            return comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public Attribute build() {
            return new Attribute(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
