/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the condition under which a signal fetch occurs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConditionBasedSignalFetchConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ConditionBasedSignalFetchConfig.Builder, ConditionBasedSignalFetchConfig> {
    private static final SdkField<String> CONDITION_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("conditionExpression").getter(getter(ConditionBasedSignalFetchConfig::conditionExpression))
            .setter(setter(Builder::conditionExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conditionExpression").build())
            .build();

    private static final SdkField<String> TRIGGER_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("triggerMode").getter(getter(ConditionBasedSignalFetchConfig::triggerModeAsString))
            .setter(setter(Builder::triggerMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggerMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONDITION_EXPRESSION_FIELD,
            TRIGGER_MODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String conditionExpression;

    private final String triggerMode;

    private ConditionBasedSignalFetchConfig(BuilderImpl builder) {
        this.conditionExpression = builder.conditionExpression;
        this.triggerMode = builder.triggerMode;
    }

    /**
     * <p>
     * The condition that must be satisfied to trigger a signal fetch.
     * </p>
     * 
     * @return The condition that must be satisfied to trigger a signal fetch.
     */
    public final String conditionExpression() {
        return conditionExpression;
    }

    /**
     * <p>
     * Indicates the mode in which the signal fetch is triggered.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #triggerMode} will
     * return {@link TriggerMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #triggerModeAsString}.
     * </p>
     * 
     * @return Indicates the mode in which the signal fetch is triggered.
     * @see TriggerMode
     */
    public final TriggerMode triggerMode() {
        return TriggerMode.fromValue(triggerMode);
    }

    /**
     * <p>
     * Indicates the mode in which the signal fetch is triggered.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #triggerMode} will
     * return {@link TriggerMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #triggerModeAsString}.
     * </p>
     * 
     * @return Indicates the mode in which the signal fetch is triggered.
     * @see TriggerMode
     */
    public final String triggerModeAsString() {
        return triggerMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(conditionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(triggerModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConditionBasedSignalFetchConfig)) {
            return false;
        }
        ConditionBasedSignalFetchConfig other = (ConditionBasedSignalFetchConfig) obj;
        return Objects.equals(conditionExpression(), other.conditionExpression())
                && Objects.equals(triggerModeAsString(), other.triggerModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConditionBasedSignalFetchConfig")
                .add("ConditionExpression", conditionExpression() == null ? null : "*** Sensitive Data Redacted ***")
                .add("TriggerMode", triggerModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "conditionExpression":
            return Optional.ofNullable(clazz.cast(conditionExpression()));
        case "triggerMode":
            return Optional.ofNullable(clazz.cast(triggerModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("conditionExpression", CONDITION_EXPRESSION_FIELD);
        map.put("triggerMode", TRIGGER_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConditionBasedSignalFetchConfig, T> g) {
        return obj -> g.apply((ConditionBasedSignalFetchConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConditionBasedSignalFetchConfig> {
        /**
         * <p>
         * The condition that must be satisfied to trigger a signal fetch.
         * </p>
         * 
         * @param conditionExpression
         *        The condition that must be satisfied to trigger a signal fetch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditionExpression(String conditionExpression);

        /**
         * <p>
         * Indicates the mode in which the signal fetch is triggered.
         * </p>
         * 
         * @param triggerMode
         *        Indicates the mode in which the signal fetch is triggered.
         * @see TriggerMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TriggerMode
         */
        Builder triggerMode(String triggerMode);

        /**
         * <p>
         * Indicates the mode in which the signal fetch is triggered.
         * </p>
         * 
         * @param triggerMode
         *        Indicates the mode in which the signal fetch is triggered.
         * @see TriggerMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TriggerMode
         */
        Builder triggerMode(TriggerMode triggerMode);
    }

    static final class BuilderImpl implements Builder {
        private String conditionExpression;

        private String triggerMode;

        private BuilderImpl() {
        }

        private BuilderImpl(ConditionBasedSignalFetchConfig model) {
            conditionExpression(model.conditionExpression);
            triggerMode(model.triggerMode);
        }

        public final String getConditionExpression() {
            return conditionExpression;
        }

        public final void setConditionExpression(String conditionExpression) {
            this.conditionExpression = conditionExpression;
        }

        @Override
        public final Builder conditionExpression(String conditionExpression) {
            this.conditionExpression = conditionExpression;
            return this;
        }

        public final String getTriggerMode() {
            return triggerMode;
        }

        public final void setTriggerMode(String triggerMode) {
            this.triggerMode = triggerMode;
        }

        @Override
        public final Builder triggerMode(String triggerMode) {
            this.triggerMode = triggerMode;
            return this;
        }

        @Override
        public final Builder triggerMode(TriggerMode triggerMode) {
            this.triggerMode(triggerMode == null ? null : triggerMode.toString());
            return this;
        }

        @Override
        public ConditionBasedSignalFetchConfig build() {
            return new ConditionBasedSignalFetchConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
