/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request couldn't be completed because it contains signal decoders with one or more validation errors.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DecoderManifestValidationException extends IoTFleetWiseException implements
        ToCopyableBuilder<DecoderManifestValidationException.Builder, DecoderManifestValidationException> {
    private static final SdkField<List<InvalidSignalDecoder>> INVALID_SIGNALS_FIELD = SdkField
            .<List<InvalidSignalDecoder>> builder(MarshallingType.LIST)
            .memberName("invalidSignals")
            .getter(getter(DecoderManifestValidationException::invalidSignals))
            .setter(setter(Builder::invalidSignals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invalidSignals").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InvalidSignalDecoder> builder(MarshallingType.SDK_POJO)
                                            .constructor(InvalidSignalDecoder::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<InvalidNetworkInterface>> INVALID_NETWORK_INTERFACES_FIELD = SdkField
            .<List<InvalidNetworkInterface>> builder(MarshallingType.LIST)
            .memberName("invalidNetworkInterfaces")
            .getter(getter(DecoderManifestValidationException::invalidNetworkInterfaces))
            .setter(setter(Builder::invalidNetworkInterfaces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invalidNetworkInterfaces").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InvalidNetworkInterface> builder(MarshallingType.SDK_POJO)
                                            .constructor(InvalidNetworkInterface::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVALID_SIGNALS_FIELD,
            INVALID_NETWORK_INTERFACES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<InvalidSignalDecoder> invalidSignals;

    private final List<InvalidNetworkInterface> invalidNetworkInterfaces;

    private DecoderManifestValidationException(BuilderImpl builder) {
        super(builder);
        this.invalidSignals = builder.invalidSignals;
        this.invalidNetworkInterfaces = builder.invalidNetworkInterfaces;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * For responses, this returns true if the service returned a value for the InvalidSignals property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public boolean hasInvalidSignals() {
        return invalidSignals != null && !(invalidSignals instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The request couldn't be completed because of invalid signals in the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInvalidSignals} method.
     * </p>
     * 
     * @return The request couldn't be completed because of invalid signals in the request.
     */
    public List<InvalidSignalDecoder> invalidSignals() {
        return invalidSignals;
    }

    /**
     * For responses, this returns true if the service returned a value for the InvalidNetworkInterfaces property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public boolean hasInvalidNetworkInterfaces() {
        return invalidNetworkInterfaces != null && !(invalidNetworkInterfaces instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The request couldn't be completed because of invalid network interfaces in the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInvalidNetworkInterfaces} method.
     * </p>
     * 
     * @return The request couldn't be completed because of invalid network interfaces in the request.
     */
    public List<InvalidNetworkInterface> invalidNetworkInterfaces() {
        return invalidNetworkInterfaces;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("invalidSignals", INVALID_SIGNALS_FIELD);
        map.put("invalidNetworkInterfaces", INVALID_NETWORK_INTERFACES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DecoderManifestValidationException, T> g) {
        return obj -> g.apply((DecoderManifestValidationException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DecoderManifestValidationException>,
            IoTFleetWiseException.Builder {
        /**
         * <p>
         * The request couldn't be completed because of invalid signals in the request.
         * </p>
         * 
         * @param invalidSignals
         *        The request couldn't be completed because of invalid signals in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invalidSignals(Collection<InvalidSignalDecoder> invalidSignals);

        /**
         * <p>
         * The request couldn't be completed because of invalid signals in the request.
         * </p>
         * 
         * @param invalidSignals
         *        The request couldn't be completed because of invalid signals in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invalidSignals(InvalidSignalDecoder... invalidSignals);

        /**
         * <p>
         * The request couldn't be completed because of invalid signals in the request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotfleetwise.model.InvalidSignalDecoder.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.iotfleetwise.model.InvalidSignalDecoder#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotfleetwise.model.InvalidSignalDecoder.Builder#build()} is called
         * immediately and its result is passed to {@link #invalidSignals(List<InvalidSignalDecoder>)}.
         * 
         * @param invalidSignals
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotfleetwise.model.InvalidSignalDecoder.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #invalidSignals(java.util.Collection<InvalidSignalDecoder>)
         */
        Builder invalidSignals(Consumer<InvalidSignalDecoder.Builder>... invalidSignals);

        /**
         * <p>
         * The request couldn't be completed because of invalid network interfaces in the request.
         * </p>
         * 
         * @param invalidNetworkInterfaces
         *        The request couldn't be completed because of invalid network interfaces in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invalidNetworkInterfaces(Collection<InvalidNetworkInterface> invalidNetworkInterfaces);

        /**
         * <p>
         * The request couldn't be completed because of invalid network interfaces in the request.
         * </p>
         * 
         * @param invalidNetworkInterfaces
         *        The request couldn't be completed because of invalid network interfaces in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invalidNetworkInterfaces(InvalidNetworkInterface... invalidNetworkInterfaces);

        /**
         * <p>
         * The request couldn't be completed because of invalid network interfaces in the request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotfleetwise.model.InvalidNetworkInterface.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.iotfleetwise.model.InvalidNetworkInterface#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotfleetwise.model.InvalidNetworkInterface.Builder#build()} is called
         * immediately and its result is passed to {@link #invalidNetworkInterfaces(List<InvalidNetworkInterface>)}.
         * 
         * @param invalidNetworkInterfaces
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotfleetwise.model.InvalidNetworkInterface.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #invalidNetworkInterfaces(java.util.Collection<InvalidNetworkInterface>)
         */
        Builder invalidNetworkInterfaces(Consumer<InvalidNetworkInterface.Builder>... invalidNetworkInterfaces);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);

        @Override
        Builder writableStackTrace(Boolean writableStackTrace);
    }

    static final class BuilderImpl extends IoTFleetWiseException.BuilderImpl implements Builder {
        private List<InvalidSignalDecoder> invalidSignals = DefaultSdkAutoConstructList.getInstance();

        private List<InvalidNetworkInterface> invalidNetworkInterfaces = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DecoderManifestValidationException model) {
            super(model);
            invalidSignals(model.invalidSignals);
            invalidNetworkInterfaces(model.invalidNetworkInterfaces);
        }

        public final List<InvalidSignalDecoder.Builder> getInvalidSignals() {
            List<InvalidSignalDecoder.Builder> result = InvalidSignalDecodersCopier.copyToBuilder(this.invalidSignals);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInvalidSignals(Collection<InvalidSignalDecoder.BuilderImpl> invalidSignals) {
            this.invalidSignals = InvalidSignalDecodersCopier.copyFromBuilder(invalidSignals);
        }

        @Override
        public final Builder invalidSignals(Collection<InvalidSignalDecoder> invalidSignals) {
            this.invalidSignals = InvalidSignalDecodersCopier.copy(invalidSignals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invalidSignals(InvalidSignalDecoder... invalidSignals) {
            invalidSignals(Arrays.asList(invalidSignals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invalidSignals(Consumer<InvalidSignalDecoder.Builder>... invalidSignals) {
            invalidSignals(Stream.of(invalidSignals).map(c -> InvalidSignalDecoder.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<InvalidNetworkInterface.Builder> getInvalidNetworkInterfaces() {
            List<InvalidNetworkInterface.Builder> result = InvalidNetworkInterfacesCopier
                    .copyToBuilder(this.invalidNetworkInterfaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInvalidNetworkInterfaces(Collection<InvalidNetworkInterface.BuilderImpl> invalidNetworkInterfaces) {
            this.invalidNetworkInterfaces = InvalidNetworkInterfacesCopier.copyFromBuilder(invalidNetworkInterfaces);
        }

        @Override
        public final Builder invalidNetworkInterfaces(Collection<InvalidNetworkInterface> invalidNetworkInterfaces) {
            this.invalidNetworkInterfaces = InvalidNetworkInterfacesCopier.copy(invalidNetworkInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invalidNetworkInterfaces(InvalidNetworkInterface... invalidNetworkInterfaces) {
            invalidNetworkInterfaces(Arrays.asList(invalidNetworkInterfaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invalidNetworkInterfaces(Consumer<InvalidNetworkInterface.Builder>... invalidNetworkInterfaces) {
            invalidNetworkInterfaces(Stream.of(invalidNetworkInterfaces)
                    .map(c -> InvalidNetworkInterface.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public DecoderManifestValidationException build() {
            return new DecoderManifestValidationException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
