/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifications for defining a vehicle network.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkFileDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkFileDefinition.Builder, NetworkFileDefinition> {
    private static final SdkField<CanDbcDefinition> CAN_DBC_FIELD = SdkField.<CanDbcDefinition> builder(MarshallingType.SDK_POJO)
            .memberName("canDbc").getter(getter(NetworkFileDefinition::canDbc)).setter(setter(Builder::canDbc))
            .constructor(CanDbcDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("canDbc").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAN_DBC_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CanDbcDefinition canDbc;

    private final Type type;

    private NetworkFileDefinition(BuilderImpl builder) {
        this.canDbc = builder.canDbc;
        this.type = builder.type;
    }

    /**
     * <p>
     * Information, including CAN DBC files, about the configurations used to create a decoder manifest.
     * </p>
     * 
     * @return Information, including CAN DBC files, about the configurations used to create a decoder manifest.
     */
    public final CanDbcDefinition canDbc() {
        return canDbc;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(canDbc());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkFileDefinition)) {
            return false;
        }
        NetworkFileDefinition other = (NetworkFileDefinition) obj;
        return Objects.equals(canDbc(), other.canDbc());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkFileDefinition").add("CanDbc", canDbc()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "canDbc":
            return Optional.ofNullable(clazz.cast(canDbc()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #canDbc()} initialized to the given value.
     *
     * <p>
     * Information, including CAN DBC files, about the configurations used to create a decoder manifest.
     * </p>
     * 
     * @param canDbc
     *        Information, including CAN DBC files, about the configurations used to create a decoder manifest.
     */
    public static NetworkFileDefinition fromCanDbc(CanDbcDefinition canDbc) {
        return builder().canDbc(canDbc).build();
    }

    /**
     * Create an instance of this class with {@link #canDbc()} initialized to the given value.
     *
     * <p>
     * Information, including CAN DBC files, about the configurations used to create a decoder manifest.
     * </p>
     * 
     * @param canDbc
     *        Information, including CAN DBC files, about the configurations used to create a decoder manifest.
     */
    public static NetworkFileDefinition fromCanDbc(Consumer<CanDbcDefinition.Builder> canDbc) {
        CanDbcDefinition.Builder builder = CanDbcDefinition.builder();
        canDbc.accept(builder);
        return fromCanDbc(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("canDbc", CAN_DBC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NetworkFileDefinition, T> g) {
        return obj -> g.apply((NetworkFileDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkFileDefinition> {
        /**
         * <p>
         * Information, including CAN DBC files, about the configurations used to create a decoder manifest.
         * </p>
         * 
         * @param canDbc
         *        Information, including CAN DBC files, about the configurations used to create a decoder manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder canDbc(CanDbcDefinition canDbc);

        /**
         * <p>
         * Information, including CAN DBC files, about the configurations used to create a decoder manifest.
         * </p>
         * This is a convenience method that creates an instance of the {@link CanDbcDefinition.Builder} avoiding the
         * need to create one manually via {@link CanDbcDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CanDbcDefinition.Builder#build()} is called immediately and its
         * result is passed to {@link #canDbc(CanDbcDefinition)}.
         * 
         * @param canDbc
         *        a consumer that will call methods on {@link CanDbcDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #canDbc(CanDbcDefinition)
         */
        default Builder canDbc(Consumer<CanDbcDefinition.Builder> canDbc) {
            return canDbc(CanDbcDefinition.builder().applyMutation(canDbc).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CanDbcDefinition canDbc;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkFileDefinition model) {
            canDbc(model.canDbc);
        }

        public final CanDbcDefinition.Builder getCanDbc() {
            return canDbc != null ? canDbc.toBuilder() : null;
        }

        public final void setCanDbc(CanDbcDefinition.BuilderImpl canDbc) {
            Object oldValue = this.canDbc;
            this.canDbc = canDbc != null ? canDbc.build() : null;
            handleUnionValueChange(Type.CAN_DBC, oldValue, this.canDbc);
        }

        @Override
        public final Builder canDbc(CanDbcDefinition canDbc) {
            Object oldValue = this.canDbc;
            this.canDbc = canDbc;
            handleUnionValueChange(Type.CAN_DBC, oldValue, this.canDbc);
            return this;
        }

        @Override
        public NetworkFileDefinition build() {
            return new NetworkFileDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see NetworkFileDefinition#type()
     */
    public enum Type {
        CAN_DBC,

        UNKNOWN_TO_SDK_VERSION
    }
}
