/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Vehicles associated with the state template will stream telemetry data during a specified time period.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PeriodicStateTemplateUpdateStrategy implements SdkPojo, Serializable,
        ToCopyableBuilder<PeriodicStateTemplateUpdateStrategy.Builder, PeriodicStateTemplateUpdateStrategy> {
    private static final SdkField<TimePeriod> STATE_TEMPLATE_UPDATE_RATE_FIELD = SdkField
            .<TimePeriod> builder(MarshallingType.SDK_POJO).memberName("stateTemplateUpdateRate")
            .getter(getter(PeriodicStateTemplateUpdateStrategy::stateTemplateUpdateRate))
            .setter(setter(Builder::stateTemplateUpdateRate)).constructor(TimePeriod::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateTemplateUpdateRate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(STATE_TEMPLATE_UPDATE_RATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final TimePeriod stateTemplateUpdateRate;

    private PeriodicStateTemplateUpdateStrategy(BuilderImpl builder) {
        this.stateTemplateUpdateRate = builder.stateTemplateUpdateRate;
    }

    /**
     * Returns the value of the StateTemplateUpdateRate property for this object.
     * 
     * @return The value of the StateTemplateUpdateRate property for this object.
     */
    public final TimePeriod stateTemplateUpdateRate() {
        return stateTemplateUpdateRate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stateTemplateUpdateRate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PeriodicStateTemplateUpdateStrategy)) {
            return false;
        }
        PeriodicStateTemplateUpdateStrategy other = (PeriodicStateTemplateUpdateStrategy) obj;
        return Objects.equals(stateTemplateUpdateRate(), other.stateTemplateUpdateRate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PeriodicStateTemplateUpdateStrategy").add("StateTemplateUpdateRate", stateTemplateUpdateRate())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stateTemplateUpdateRate":
            return Optional.ofNullable(clazz.cast(stateTemplateUpdateRate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("stateTemplateUpdateRate", STATE_TEMPLATE_UPDATE_RATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PeriodicStateTemplateUpdateStrategy, T> g) {
        return obj -> g.apply((PeriodicStateTemplateUpdateStrategy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PeriodicStateTemplateUpdateStrategy> {
        /**
         * Sets the value of the StateTemplateUpdateRate property for this object.
         *
         * @param stateTemplateUpdateRate
         *        The new value for the StateTemplateUpdateRate property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateTemplateUpdateRate(TimePeriod stateTemplateUpdateRate);

        /**
         * Sets the value of the StateTemplateUpdateRate property for this object.
         *
         * This is a convenience method that creates an instance of the {@link TimePeriod.Builder} avoiding the need to
         * create one manually via {@link TimePeriod#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimePeriod.Builder#build()} is called immediately and its result
         * is passed to {@link #stateTemplateUpdateRate(TimePeriod)}.
         * 
         * @param stateTemplateUpdateRate
         *        a consumer that will call methods on {@link TimePeriod.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stateTemplateUpdateRate(TimePeriod)
         */
        default Builder stateTemplateUpdateRate(Consumer<TimePeriod.Builder> stateTemplateUpdateRate) {
            return stateTemplateUpdateRate(TimePeriod.builder().applyMutation(stateTemplateUpdateRate).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TimePeriod stateTemplateUpdateRate;

        private BuilderImpl() {
        }

        private BuilderImpl(PeriodicStateTemplateUpdateStrategy model) {
            stateTemplateUpdateRate(model.stateTemplateUpdateRate);
        }

        public final TimePeriod.Builder getStateTemplateUpdateRate() {
            return stateTemplateUpdateRate != null ? stateTemplateUpdateRate.toBuilder() : null;
        }

        public final void setStateTemplateUpdateRate(TimePeriod.BuilderImpl stateTemplateUpdateRate) {
            this.stateTemplateUpdateRate = stateTemplateUpdateRate != null ? stateTemplateUpdateRate.build() : null;
        }

        @Override
        public final Builder stateTemplateUpdateRate(TimePeriod stateTemplateUpdateRate) {
            this.stateTemplateUpdateRate = stateTemplateUpdateRate;
            return this;
        }

        @Override
        public PeriodicStateTemplateUpdateStrategy build() {
            return new PeriodicStateTemplateUpdateStrategy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
