/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutEncryptionConfigurationResponse extends IoTFleetWiseResponse implements
        ToCopyableBuilder<PutEncryptionConfigurationResponse.Builder, PutEncryptionConfigurationResponse> {
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyId").getter(getter(PutEncryptionConfigurationResponse::kmsKeyId))
            .setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()).build();

    private static final SdkField<String> ENCRYPTION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("encryptionStatus").getter(getter(PutEncryptionConfigurationResponse::encryptionStatusAsString))
            .setter(setter(Builder::encryptionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionStatus").build()).build();

    private static final SdkField<String> ENCRYPTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("encryptionType").getter(getter(PutEncryptionConfigurationResponse::encryptionTypeAsString))
            .setter(setter(Builder::encryptionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_KEY_ID_FIELD,
            ENCRYPTION_STATUS_FIELD, ENCRYPTION_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String kmsKeyId;

    private final String encryptionStatus;

    private final String encryptionType;

    private PutEncryptionConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.kmsKeyId = builder.kmsKeyId;
        this.encryptionStatus = builder.encryptionStatus;
        this.encryptionType = builder.encryptionType;
    }

    /**
     * <p>
     * The ID of the KMS key that is used for encryption.
     * </p>
     * 
     * @return The ID of the KMS key that is used for encryption.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The encryption status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionStatus}
     * will return {@link EncryptionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #encryptionStatusAsString}.
     * </p>
     * 
     * @return The encryption status.
     * @see EncryptionStatus
     */
    public final EncryptionStatus encryptionStatus() {
        return EncryptionStatus.fromValue(encryptionStatus);
    }

    /**
     * <p>
     * The encryption status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionStatus}
     * will return {@link EncryptionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #encryptionStatusAsString}.
     * </p>
     * 
     * @return The encryption status.
     * @see EncryptionStatus
     */
    public final String encryptionStatusAsString() {
        return encryptionStatus;
    }

    /**
     * <p>
     * The type of encryption. Set to <code>KMS_BASED_ENCRYPTION</code> to use an KMS key that you own and manage. Set
     * to <code>FLEETWISE_DEFAULT_ENCRYPTION</code> to use an Amazon Web Services managed key that is owned by the
     * Amazon Web Services IoT FleetWise service account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionType}
     * will return {@link EncryptionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #encryptionTypeAsString}.
     * </p>
     * 
     * @return The type of encryption. Set to <code>KMS_BASED_ENCRYPTION</code> to use an KMS key that you own and
     *         manage. Set to <code>FLEETWISE_DEFAULT_ENCRYPTION</code> to use an Amazon Web Services managed key that
     *         is owned by the Amazon Web Services IoT FleetWise service account.
     * @see EncryptionType
     */
    public final EncryptionType encryptionType() {
        return EncryptionType.fromValue(encryptionType);
    }

    /**
     * <p>
     * The type of encryption. Set to <code>KMS_BASED_ENCRYPTION</code> to use an KMS key that you own and manage. Set
     * to <code>FLEETWISE_DEFAULT_ENCRYPTION</code> to use an Amazon Web Services managed key that is owned by the
     * Amazon Web Services IoT FleetWise service account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionType}
     * will return {@link EncryptionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #encryptionTypeAsString}.
     * </p>
     * 
     * @return The type of encryption. Set to <code>KMS_BASED_ENCRYPTION</code> to use an KMS key that you own and
     *         manage. Set to <code>FLEETWISE_DEFAULT_ENCRYPTION</code> to use an Amazon Web Services managed key that
     *         is owned by the Amazon Web Services IoT FleetWise service account.
     * @see EncryptionType
     */
    public final String encryptionTypeAsString() {
        return encryptionType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutEncryptionConfigurationResponse)) {
            return false;
        }
        PutEncryptionConfigurationResponse other = (PutEncryptionConfigurationResponse) obj;
        return Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(encryptionStatusAsString(), other.encryptionStatusAsString())
                && Objects.equals(encryptionTypeAsString(), other.encryptionTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutEncryptionConfigurationResponse").add("KmsKeyId", kmsKeyId())
                .add("EncryptionStatus", encryptionStatusAsString()).add("EncryptionType", encryptionTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "kmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "encryptionStatus":
            return Optional.ofNullable(clazz.cast(encryptionStatusAsString()));
        case "encryptionType":
            return Optional.ofNullable(clazz.cast(encryptionTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("kmsKeyId", KMS_KEY_ID_FIELD);
        map.put("encryptionStatus", ENCRYPTION_STATUS_FIELD);
        map.put("encryptionType", ENCRYPTION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutEncryptionConfigurationResponse, T> g) {
        return obj -> g.apply((PutEncryptionConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTFleetWiseResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, PutEncryptionConfigurationResponse> {
        /**
         * <p>
         * The ID of the KMS key that is used for encryption.
         * </p>
         * 
         * @param kmsKeyId
         *        The ID of the KMS key that is used for encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The encryption status.
         * </p>
         * 
         * @param encryptionStatus
         *        The encryption status.
         * @see EncryptionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionStatus
         */
        Builder encryptionStatus(String encryptionStatus);

        /**
         * <p>
         * The encryption status.
         * </p>
         * 
         * @param encryptionStatus
         *        The encryption status.
         * @see EncryptionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionStatus
         */
        Builder encryptionStatus(EncryptionStatus encryptionStatus);

        /**
         * <p>
         * The type of encryption. Set to <code>KMS_BASED_ENCRYPTION</code> to use an KMS key that you own and manage.
         * Set to <code>FLEETWISE_DEFAULT_ENCRYPTION</code> to use an Amazon Web Services managed key that is owned by
         * the Amazon Web Services IoT FleetWise service account.
         * </p>
         * 
         * @param encryptionType
         *        The type of encryption. Set to <code>KMS_BASED_ENCRYPTION</code> to use an KMS key that you own and
         *        manage. Set to <code>FLEETWISE_DEFAULT_ENCRYPTION</code> to use an Amazon Web Services managed key
         *        that is owned by the Amazon Web Services IoT FleetWise service account.
         * @see EncryptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionType
         */
        Builder encryptionType(String encryptionType);

        /**
         * <p>
         * The type of encryption. Set to <code>KMS_BASED_ENCRYPTION</code> to use an KMS key that you own and manage.
         * Set to <code>FLEETWISE_DEFAULT_ENCRYPTION</code> to use an Amazon Web Services managed key that is owned by
         * the Amazon Web Services IoT FleetWise service account.
         * </p>
         * 
         * @param encryptionType
         *        The type of encryption. Set to <code>KMS_BASED_ENCRYPTION</code> to use an KMS key that you own and
         *        manage. Set to <code>FLEETWISE_DEFAULT_ENCRYPTION</code> to use an Amazon Web Services managed key
         *        that is owned by the Amazon Web Services IoT FleetWise service account.
         * @see EncryptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionType
         */
        Builder encryptionType(EncryptionType encryptionType);
    }

    static final class BuilderImpl extends IoTFleetWiseResponse.BuilderImpl implements Builder {
        private String kmsKeyId;

        private String encryptionStatus;

        private String encryptionType;

        private BuilderImpl() {
        }

        private BuilderImpl(PutEncryptionConfigurationResponse model) {
            super(model);
            kmsKeyId(model.kmsKeyId);
            encryptionStatus(model.encryptionStatus);
            encryptionType(model.encryptionType);
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getEncryptionStatus() {
            return encryptionStatus;
        }

        public final void setEncryptionStatus(String encryptionStatus) {
            this.encryptionStatus = encryptionStatus;
        }

        @Override
        public final Builder encryptionStatus(String encryptionStatus) {
            this.encryptionStatus = encryptionStatus;
            return this;
        }

        @Override
        public final Builder encryptionStatus(EncryptionStatus encryptionStatus) {
            this.encryptionStatus(encryptionStatus == null ? null : encryptionStatus.toString());
            return this;
        }

        public final String getEncryptionType() {
            return encryptionType;
        }

        public final void setEncryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
        }

        @Override
        public final Builder encryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
            return this;
        }

        @Override
        public final Builder encryptionType(EncryptionType encryptionType) {
            this.encryptionType(encryptionType == null ? null : encryptionType.toString());
            return this;
        }

        @Override
        public PutEncryptionConfigurationResponse build() {
            return new PutEncryptionConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
