/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a collection of standardized signals, which can be attributes, branches, sensors, or actuators.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SignalCatalogSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<SignalCatalogSummary.Builder, SignalCatalogSummary> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(SignalCatalogSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(SignalCatalogSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(SignalCatalogSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModificationTime").getter(getter(SignalCatalogSummary::lastModificationTime))
            .setter(setter(Builder::lastModificationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModificationTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD,
            CREATION_TIME_FIELD, LAST_MODIFICATION_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String arn;

    private final Instant creationTime;

    private final Instant lastModificationTime;

    private SignalCatalogSummary(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.creationTime = builder.creationTime;
        this.lastModificationTime = builder.lastModificationTime;
    }

    /**
     * <p>
     * The name of the signal catalog.
     * </p>
     * 
     * @return The name of the signal catalog.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the signal catalog.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the signal catalog.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The time the signal catalog was created in seconds since epoch (January 1, 1970 at midnight UTC time).
     * </p>
     * 
     * @return The time the signal catalog was created in seconds since epoch (January 1, 1970 at midnight UTC time).
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time the signal catalog was last updated in seconds since epoch (January 1, 1970 at midnight UTC time).
     * </p>
     * 
     * @return The time the signal catalog was last updated in seconds since epoch (January 1, 1970 at midnight UTC
     *         time).
     */
    public final Instant lastModificationTime() {
        return lastModificationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModificationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SignalCatalogSummary)) {
            return false;
        }
        SignalCatalogSummary other = (SignalCatalogSummary) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModificationTime(), other.lastModificationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SignalCatalogSummary").add("Name", name()).add("Arn", arn()).add("CreationTime", creationTime())
                .add("LastModificationTime", lastModificationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "lastModificationTime":
            return Optional.ofNullable(clazz.cast(lastModificationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("lastModificationTime", LAST_MODIFICATION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SignalCatalogSummary, T> g) {
        return obj -> g.apply((SignalCatalogSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SignalCatalogSummary> {
        /**
         * <p>
         * The name of the signal catalog.
         * </p>
         * 
         * @param name
         *        The name of the signal catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the signal catalog.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the signal catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The time the signal catalog was created in seconds since epoch (January 1, 1970 at midnight UTC time).
         * </p>
         * 
         * @param creationTime
         *        The time the signal catalog was created in seconds since epoch (January 1, 1970 at midnight UTC time).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time the signal catalog was last updated in seconds since epoch (January 1, 1970 at midnight UTC time).
         * </p>
         * 
         * @param lastModificationTime
         *        The time the signal catalog was last updated in seconds since epoch (January 1, 1970 at midnight UTC
         *        time).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModificationTime(Instant lastModificationTime);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String arn;

        private Instant creationTime;

        private Instant lastModificationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(SignalCatalogSummary model) {
            name(model.name);
            arn(model.arn);
            creationTime(model.creationTime);
            lastModificationTime(model.lastModificationTime);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModificationTime() {
            return lastModificationTime;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        @Override
        public SignalCatalogSummary build() {
            return new SignalCatalogSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
