/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the signal to be fetched.
 * </p>
 * <important>
 * <p>
 * Access to certain Amazon Web Services IoT FleetWise features is currently gated. For more information, see <a
 * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/fleetwise-regions.html">Amazon Web Services
 * Region and feature availability</a> in the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.
 * </p>
 * </important>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SignalFetchInformation implements SdkPojo, Serializable,
        ToCopyableBuilder<SignalFetchInformation.Builder, SignalFetchInformation> {
    private static final SdkField<String> FULLY_QUALIFIED_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fullyQualifiedName").getter(getter(SignalFetchInformation::fullyQualifiedName))
            .setter(setter(Builder::fullyQualifiedName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fullyQualifiedName").build())
            .build();

    private static final SdkField<SignalFetchConfig> SIGNAL_FETCH_CONFIG_FIELD = SdkField
            .<SignalFetchConfig> builder(MarshallingType.SDK_POJO).memberName("signalFetchConfig")
            .getter(getter(SignalFetchInformation::signalFetchConfig)).setter(setter(Builder::signalFetchConfig))
            .constructor(SignalFetchConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signalFetchConfig").build()).build();

    private static final SdkField<Integer> CONDITION_LANGUAGE_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("conditionLanguageVersion").getter(getter(SignalFetchInformation::conditionLanguageVersion))
            .setter(setter(Builder::conditionLanguageVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conditionLanguageVersion").build())
            .build();

    private static final SdkField<List<String>> ACTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("actions")
            .getter(getter(SignalFetchInformation::actions))
            .setter(setter(Builder::actions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FULLY_QUALIFIED_NAME_FIELD,
            SIGNAL_FETCH_CONFIG_FIELD, CONDITION_LANGUAGE_VERSION_FIELD, ACTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String fullyQualifiedName;

    private final SignalFetchConfig signalFetchConfig;

    private final Integer conditionLanguageVersion;

    private final List<String> actions;

    private SignalFetchInformation(BuilderImpl builder) {
        this.fullyQualifiedName = builder.fullyQualifiedName;
        this.signalFetchConfig = builder.signalFetchConfig;
        this.conditionLanguageVersion = builder.conditionLanguageVersion;
        this.actions = builder.actions;
    }

    /**
     * <p>
     * The fully qualified name of the signal to be fetched.
     * </p>
     * 
     * @return The fully qualified name of the signal to be fetched.
     */
    public final String fullyQualifiedName() {
        return fullyQualifiedName;
    }

    /**
     * <p>
     * The configuration of the signal fetch operation.
     * </p>
     * 
     * @return The configuration of the signal fetch operation.
     */
    public final SignalFetchConfig signalFetchConfig() {
        return signalFetchConfig;
    }

    /**
     * <p>
     * The version of the condition language used.
     * </p>
     * 
     * @return The version of the condition language used.
     */
    public final Integer conditionLanguageVersion() {
        return conditionLanguageVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the Actions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasActions() {
        return actions != null && !(actions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The actions to be performed by the signal fetch.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActions} method.
     * </p>
     * 
     * @return The actions to be performed by the signal fetch.
     */
    public final List<String> actions() {
        return actions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fullyQualifiedName());
        hashCode = 31 * hashCode + Objects.hashCode(signalFetchConfig());
        hashCode = 31 * hashCode + Objects.hashCode(conditionLanguageVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasActions() ? actions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SignalFetchInformation)) {
            return false;
        }
        SignalFetchInformation other = (SignalFetchInformation) obj;
        return Objects.equals(fullyQualifiedName(), other.fullyQualifiedName())
                && Objects.equals(signalFetchConfig(), other.signalFetchConfig())
                && Objects.equals(conditionLanguageVersion(), other.conditionLanguageVersion())
                && hasActions() == other.hasActions() && Objects.equals(actions(), other.actions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SignalFetchInformation").add("FullyQualifiedName", fullyQualifiedName())
                .add("SignalFetchConfig", signalFetchConfig()).add("ConditionLanguageVersion", conditionLanguageVersion())
                .add("Actions", actions() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fullyQualifiedName":
            return Optional.ofNullable(clazz.cast(fullyQualifiedName()));
        case "signalFetchConfig":
            return Optional.ofNullable(clazz.cast(signalFetchConfig()));
        case "conditionLanguageVersion":
            return Optional.ofNullable(clazz.cast(conditionLanguageVersion()));
        case "actions":
            return Optional.ofNullable(clazz.cast(actions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("fullyQualifiedName", FULLY_QUALIFIED_NAME_FIELD);
        map.put("signalFetchConfig", SIGNAL_FETCH_CONFIG_FIELD);
        map.put("conditionLanguageVersion", CONDITION_LANGUAGE_VERSION_FIELD);
        map.put("actions", ACTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SignalFetchInformation, T> g) {
        return obj -> g.apply((SignalFetchInformation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SignalFetchInformation> {
        /**
         * <p>
         * The fully qualified name of the signal to be fetched.
         * </p>
         * 
         * @param fullyQualifiedName
         *        The fully qualified name of the signal to be fetched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fullyQualifiedName(String fullyQualifiedName);

        /**
         * <p>
         * The configuration of the signal fetch operation.
         * </p>
         * 
         * @param signalFetchConfig
         *        The configuration of the signal fetch operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signalFetchConfig(SignalFetchConfig signalFetchConfig);

        /**
         * <p>
         * The configuration of the signal fetch operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link SignalFetchConfig.Builder} avoiding the
         * need to create one manually via {@link SignalFetchConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SignalFetchConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #signalFetchConfig(SignalFetchConfig)}.
         * 
         * @param signalFetchConfig
         *        a consumer that will call methods on {@link SignalFetchConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #signalFetchConfig(SignalFetchConfig)
         */
        default Builder signalFetchConfig(Consumer<SignalFetchConfig.Builder> signalFetchConfig) {
            return signalFetchConfig(SignalFetchConfig.builder().applyMutation(signalFetchConfig).build());
        }

        /**
         * <p>
         * The version of the condition language used.
         * </p>
         * 
         * @param conditionLanguageVersion
         *        The version of the condition language used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditionLanguageVersion(Integer conditionLanguageVersion);

        /**
         * <p>
         * The actions to be performed by the signal fetch.
         * </p>
         * 
         * @param actions
         *        The actions to be performed by the signal fetch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Collection<String> actions);

        /**
         * <p>
         * The actions to be performed by the signal fetch.
         * </p>
         * 
         * @param actions
         *        The actions to be performed by the signal fetch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(String... actions);
    }

    static final class BuilderImpl implements Builder {
        private String fullyQualifiedName;

        private SignalFetchConfig signalFetchConfig;

        private Integer conditionLanguageVersion;

        private List<String> actions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SignalFetchInformation model) {
            fullyQualifiedName(model.fullyQualifiedName);
            signalFetchConfig(model.signalFetchConfig);
            conditionLanguageVersion(model.conditionLanguageVersion);
            actions(model.actions);
        }

        public final String getFullyQualifiedName() {
            return fullyQualifiedName;
        }

        public final void setFullyQualifiedName(String fullyQualifiedName) {
            this.fullyQualifiedName = fullyQualifiedName;
        }

        @Override
        public final Builder fullyQualifiedName(String fullyQualifiedName) {
            this.fullyQualifiedName = fullyQualifiedName;
            return this;
        }

        public final SignalFetchConfig.Builder getSignalFetchConfig() {
            return signalFetchConfig != null ? signalFetchConfig.toBuilder() : null;
        }

        public final void setSignalFetchConfig(SignalFetchConfig.BuilderImpl signalFetchConfig) {
            this.signalFetchConfig = signalFetchConfig != null ? signalFetchConfig.build() : null;
        }

        @Override
        public final Builder signalFetchConfig(SignalFetchConfig signalFetchConfig) {
            this.signalFetchConfig = signalFetchConfig;
            return this;
        }

        public final Integer getConditionLanguageVersion() {
            return conditionLanguageVersion;
        }

        public final void setConditionLanguageVersion(Integer conditionLanguageVersion) {
            this.conditionLanguageVersion = conditionLanguageVersion;
        }

        @Override
        public final Builder conditionLanguageVersion(Integer conditionLanguageVersion) {
            this.conditionLanguageVersion = conditionLanguageVersion;
            return this;
        }

        public final Collection<String> getActions() {
            if (actions instanceof SdkAutoConstructList) {
                return null;
            }
            return actions;
        }

        public final void setActions(Collection<String> actions) {
            this.actions = EventExpressionListCopier.copy(actions);
        }

        @Override
        public final Builder actions(Collection<String> actions) {
            this.actions = EventExpressionListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(String... actions) {
            actions(Arrays.asList(actions));
            return this;
        }

        @Override
        public SignalFetchInformation build() {
            return new SignalFetchInformation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
