/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a <code>StructureMessageName</code> to <code>DataType</code> map element.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StructuredMessageFieldNameAndDataTypePair implements SdkPojo, Serializable,
        ToCopyableBuilder<StructuredMessageFieldNameAndDataTypePair.Builder, StructuredMessageFieldNameAndDataTypePair> {
    private static final SdkField<String> FIELD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fieldName").getter(getter(StructuredMessageFieldNameAndDataTypePair::fieldName))
            .setter(setter(Builder::fieldName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldName").build()).build();

    private static final SdkField<StructuredMessage> DATA_TYPE_FIELD = SdkField
            .<StructuredMessage> builder(MarshallingType.SDK_POJO).memberName("dataType")
            .getter(getter(StructuredMessageFieldNameAndDataTypePair::dataType)).setter(setter(Builder::dataType))
            .constructor(StructuredMessage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_NAME_FIELD,
            DATA_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String fieldName;

    private final StructuredMessage dataType;

    private StructuredMessageFieldNameAndDataTypePair(BuilderImpl builder) {
        this.fieldName = builder.fieldName;
        this.dataType = builder.dataType;
    }

    /**
     * <p>
     * The field name of the structured message. It determines how a data value is referenced in the target language.
     * </p>
     * 
     * @return The field name of the structured message. It determines how a data value is referenced in the target
     *         language.
     */
    public final String fieldName() {
        return fieldName;
    }

    /**
     * <p>
     * The data type.
     * </p>
     * 
     * @return The data type.
     */
    public final StructuredMessage dataType() {
        return dataType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldName());
        hashCode = 31 * hashCode + Objects.hashCode(dataType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StructuredMessageFieldNameAndDataTypePair)) {
            return false;
        }
        StructuredMessageFieldNameAndDataTypePair other = (StructuredMessageFieldNameAndDataTypePair) obj;
        return Objects.equals(fieldName(), other.fieldName()) && Objects.equals(dataType(), other.dataType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StructuredMessageFieldNameAndDataTypePair").add("FieldName", fieldName())
                .add("DataType", dataType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fieldName":
            return Optional.ofNullable(clazz.cast(fieldName()));
        case "dataType":
            return Optional.ofNullable(clazz.cast(dataType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("fieldName", FIELD_NAME_FIELD);
        map.put("dataType", DATA_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StructuredMessageFieldNameAndDataTypePair, T> g) {
        return obj -> g.apply((StructuredMessageFieldNameAndDataTypePair) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StructuredMessageFieldNameAndDataTypePair> {
        /**
         * <p>
         * The field name of the structured message. It determines how a data value is referenced in the target
         * language.
         * </p>
         * 
         * @param fieldName
         *        The field name of the structured message. It determines how a data value is referenced in the target
         *        language.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldName(String fieldName);

        /**
         * <p>
         * The data type.
         * </p>
         * 
         * @param dataType
         *        The data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataType(StructuredMessage dataType);

        /**
         * <p>
         * The data type.
         * </p>
         * This is a convenience method that creates an instance of the {@link StructuredMessage.Builder} avoiding the
         * need to create one manually via {@link StructuredMessage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StructuredMessage.Builder#build()} is called immediately and its
         * result is passed to {@link #dataType(StructuredMessage)}.
         * 
         * @param dataType
         *        a consumer that will call methods on {@link StructuredMessage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataType(StructuredMessage)
         */
        default Builder dataType(Consumer<StructuredMessage.Builder> dataType) {
            return dataType(StructuredMessage.builder().applyMutation(dataType).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String fieldName;

        private StructuredMessage dataType;

        private BuilderImpl() {
        }

        private BuilderImpl(StructuredMessageFieldNameAndDataTypePair model) {
            fieldName(model.fieldName);
            dataType(model.dataType);
        }

        public final String getFieldName() {
            return fieldName;
        }

        public final void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public final Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public final StructuredMessage.Builder getDataType() {
            return dataType != null ? dataType.toBuilder() : null;
        }

        public final void setDataType(StructuredMessage.BuilderImpl dataType) {
            this.dataType = dataType != null ? dataType.build() : null;
        }

        @Override
        public final Builder dataType(StructuredMessage dataType) {
            this.dataType = dataType;
            return this;
        }

        @Override
        public StructuredMessageFieldNameAndDataTypePair build() {
            return new StructuredMessageFieldNameAndDataTypePair(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
