/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for signal data storage and upload options. You can only specify these options when the campaign's
 * spooling mode is <code>TO_DISK</code>.
 * </p>
 * <important>
 * <p>
 * Access to certain Amazon Web Services IoT FleetWise features is currently gated. For more information, see <a
 * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/fleetwise-regions.html">Amazon Web Services
 * Region and feature availability</a> in the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.
 * </p>
 * </important>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataPartition implements SdkPojo, Serializable, ToCopyableBuilder<DataPartition.Builder, DataPartition> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(DataPartition::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<DataPartitionStorageOptions> STORAGE_OPTIONS_FIELD = SdkField
            .<DataPartitionStorageOptions> builder(MarshallingType.SDK_POJO).memberName("storageOptions")
            .getter(getter(DataPartition::storageOptions)).setter(setter(Builder::storageOptions))
            .constructor(DataPartitionStorageOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageOptions").build()).build();

    private static final SdkField<DataPartitionUploadOptions> UPLOAD_OPTIONS_FIELD = SdkField
            .<DataPartitionUploadOptions> builder(MarshallingType.SDK_POJO).memberName("uploadOptions")
            .getter(getter(DataPartition::uploadOptions)).setter(setter(Builder::uploadOptions))
            .constructor(DataPartitionUploadOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uploadOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            STORAGE_OPTIONS_FIELD, UPLOAD_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final DataPartitionStorageOptions storageOptions;

    private final DataPartitionUploadOptions uploadOptions;

    private DataPartition(BuilderImpl builder) {
        this.id = builder.id;
        this.storageOptions = builder.storageOptions;
        this.uploadOptions = builder.uploadOptions;
    }

    /**
     * <p>
     * The ID of the data partition. The data partition ID must be unique within a campaign. You can establish a data
     * partition as the default partition for a campaign by using <code>default</code> as the ID.
     * </p>
     * 
     * @return The ID of the data partition. The data partition ID must be unique within a campaign. You can establish a
     *         data partition as the default partition for a campaign by using <code>default</code> as the ID.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The storage options for a data partition.
     * </p>
     * 
     * @return The storage options for a data partition.
     */
    public final DataPartitionStorageOptions storageOptions() {
        return storageOptions;
    }

    /**
     * <p>
     * The upload options for the data partition.
     * </p>
     * 
     * @return The upload options for the data partition.
     */
    public final DataPartitionUploadOptions uploadOptions() {
        return uploadOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(storageOptions());
        hashCode = 31 * hashCode + Objects.hashCode(uploadOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataPartition)) {
            return false;
        }
        DataPartition other = (DataPartition) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(storageOptions(), other.storageOptions())
                && Objects.equals(uploadOptions(), other.uploadOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataPartition").add("Id", id()).add("StorageOptions", storageOptions())
                .add("UploadOptions", uploadOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "storageOptions":
            return Optional.ofNullable(clazz.cast(storageOptions()));
        case "uploadOptions":
            return Optional.ofNullable(clazz.cast(uploadOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("storageOptions", STORAGE_OPTIONS_FIELD);
        map.put("uploadOptions", UPLOAD_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataPartition, T> g) {
        return obj -> g.apply((DataPartition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataPartition> {
        /**
         * <p>
         * The ID of the data partition. The data partition ID must be unique within a campaign. You can establish a
         * data partition as the default partition for a campaign by using <code>default</code> as the ID.
         * </p>
         * 
         * @param id
         *        The ID of the data partition. The data partition ID must be unique within a campaign. You can
         *        establish a data partition as the default partition for a campaign by using <code>default</code> as
         *        the ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The storage options for a data partition.
         * </p>
         * 
         * @param storageOptions
         *        The storage options for a data partition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageOptions(DataPartitionStorageOptions storageOptions);

        /**
         * <p>
         * The storage options for a data partition.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataPartitionStorageOptions.Builder}
         * avoiding the need to create one manually via {@link DataPartitionStorageOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataPartitionStorageOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #storageOptions(DataPartitionStorageOptions)}.
         * 
         * @param storageOptions
         *        a consumer that will call methods on {@link DataPartitionStorageOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storageOptions(DataPartitionStorageOptions)
         */
        default Builder storageOptions(Consumer<DataPartitionStorageOptions.Builder> storageOptions) {
            return storageOptions(DataPartitionStorageOptions.builder().applyMutation(storageOptions).build());
        }

        /**
         * <p>
         * The upload options for the data partition.
         * </p>
         * 
         * @param uploadOptions
         *        The upload options for the data partition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadOptions(DataPartitionUploadOptions uploadOptions);

        /**
         * <p>
         * The upload options for the data partition.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataPartitionUploadOptions.Builder}
         * avoiding the need to create one manually via {@link DataPartitionUploadOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataPartitionUploadOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #uploadOptions(DataPartitionUploadOptions)}.
         * 
         * @param uploadOptions
         *        a consumer that will call methods on {@link DataPartitionUploadOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #uploadOptions(DataPartitionUploadOptions)
         */
        default Builder uploadOptions(Consumer<DataPartitionUploadOptions.Builder> uploadOptions) {
            return uploadOptions(DataPartitionUploadOptions.builder().applyMutation(uploadOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private DataPartitionStorageOptions storageOptions;

        private DataPartitionUploadOptions uploadOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(DataPartition model) {
            id(model.id);
            storageOptions(model.storageOptions);
            uploadOptions(model.uploadOptions);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final DataPartitionStorageOptions.Builder getStorageOptions() {
            return storageOptions != null ? storageOptions.toBuilder() : null;
        }

        public final void setStorageOptions(DataPartitionStorageOptions.BuilderImpl storageOptions) {
            this.storageOptions = storageOptions != null ? storageOptions.build() : null;
        }

        @Override
        public final Builder storageOptions(DataPartitionStorageOptions storageOptions) {
            this.storageOptions = storageOptions;
            return this;
        }

        public final DataPartitionUploadOptions.Builder getUploadOptions() {
            return uploadOptions != null ? uploadOptions.toBuilder() : null;
        }

        public final void setUploadOptions(DataPartitionUploadOptions.BuilderImpl uploadOptions) {
            this.uploadOptions = uploadOptions != null ? uploadOptions.build() : null;
        }

        @Override
        public final Builder uploadOptions(DataPartitionUploadOptions uploadOptions) {
            this.uploadOptions = uploadOptions;
            return this;
        }

        @Override
        public DataPartition build() {
            return new DataPartition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
