/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Size, time, and location options for the data partition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataPartitionStorageOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<DataPartitionStorageOptions.Builder, DataPartitionStorageOptions> {
    private static final SdkField<StorageMaximumSize> MAXIMUM_SIZE_FIELD = SdkField
            .<StorageMaximumSize> builder(MarshallingType.SDK_POJO).memberName("maximumSize")
            .getter(getter(DataPartitionStorageOptions::maximumSize)).setter(setter(Builder::maximumSize))
            .constructor(StorageMaximumSize::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumSize").build()).build();

    private static final SdkField<String> STORAGE_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("storageLocation").getter(getter(DataPartitionStorageOptions::storageLocation))
            .setter(setter(Builder::storageLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageLocation").build()).build();

    private static final SdkField<StorageMinimumTimeToLive> MINIMUM_TIME_TO_LIVE_FIELD = SdkField
            .<StorageMinimumTimeToLive> builder(MarshallingType.SDK_POJO).memberName("minimumTimeToLive")
            .getter(getter(DataPartitionStorageOptions::minimumTimeToLive)).setter(setter(Builder::minimumTimeToLive))
            .constructor(StorageMinimumTimeToLive::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumTimeToLive").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAXIMUM_SIZE_FIELD,
            STORAGE_LOCATION_FIELD, MINIMUM_TIME_TO_LIVE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final StorageMaximumSize maximumSize;

    private final String storageLocation;

    private final StorageMinimumTimeToLive minimumTimeToLive;

    private DataPartitionStorageOptions(BuilderImpl builder) {
        this.maximumSize = builder.maximumSize;
        this.storageLocation = builder.storageLocation;
        this.minimumTimeToLive = builder.minimumTimeToLive;
    }

    /**
     * <p>
     * The maximum storage size of the data stored in the data partition.
     * </p>
     * <note>
     * <p>
     * Newer data overwrites older data when the partition reaches the maximum size.
     * </p>
     * </note>
     * 
     * @return The maximum storage size of the data stored in the data partition.</p> <note>
     *         <p>
     *         Newer data overwrites older data when the partition reaches the maximum size.
     *         </p>
     */
    public final StorageMaximumSize maximumSize() {
        return maximumSize;
    }

    /**
     * <p>
     * The folder name for the data partition under the campaign storage folder.
     * </p>
     * 
     * @return The folder name for the data partition under the campaign storage folder.
     */
    public final String storageLocation() {
        return storageLocation;
    }

    /**
     * <p>
     * The amount of time that data in this partition will be kept on disk.
     * </p>
     * <ul>
     * <li>
     * <p>
     * After the designated amount of time passes, the data can be removed, but it's not guaranteed to be removed.
     * </p>
     * </li>
     * <li>
     * <p>
     * Before the time expires, data in this partition can still be deleted if the partition reaches its configured
     * maximum size.
     * </p>
     * </li>
     * <li>
     * <p>
     * Newer data will overwrite older data when the partition reaches the maximum size.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The amount of time that data in this partition will be kept on disk.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         After the designated amount of time passes, the data can be removed, but it's not guaranteed to be
     *         removed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Before the time expires, data in this partition can still be deleted if the partition reaches its
     *         configured maximum size.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Newer data will overwrite older data when the partition reaches the maximum size.
     *         </p>
     *         </li>
     */
    public final StorageMinimumTimeToLive minimumTimeToLive() {
        return minimumTimeToLive;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maximumSize());
        hashCode = 31 * hashCode + Objects.hashCode(storageLocation());
        hashCode = 31 * hashCode + Objects.hashCode(minimumTimeToLive());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataPartitionStorageOptions)) {
            return false;
        }
        DataPartitionStorageOptions other = (DataPartitionStorageOptions) obj;
        return Objects.equals(maximumSize(), other.maximumSize()) && Objects.equals(storageLocation(), other.storageLocation())
                && Objects.equals(minimumTimeToLive(), other.minimumTimeToLive());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataPartitionStorageOptions").add("MaximumSize", maximumSize())
                .add("StorageLocation", storageLocation() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MinimumTimeToLive", minimumTimeToLive()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "maximumSize":
            return Optional.ofNullable(clazz.cast(maximumSize()));
        case "storageLocation":
            return Optional.ofNullable(clazz.cast(storageLocation()));
        case "minimumTimeToLive":
            return Optional.ofNullable(clazz.cast(minimumTimeToLive()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("maximumSize", MAXIMUM_SIZE_FIELD);
        map.put("storageLocation", STORAGE_LOCATION_FIELD);
        map.put("minimumTimeToLive", MINIMUM_TIME_TO_LIVE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataPartitionStorageOptions, T> g) {
        return obj -> g.apply((DataPartitionStorageOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataPartitionStorageOptions> {
        /**
         * <p>
         * The maximum storage size of the data stored in the data partition.
         * </p>
         * <note>
         * <p>
         * Newer data overwrites older data when the partition reaches the maximum size.
         * </p>
         * </note>
         * 
         * @param maximumSize
         *        The maximum storage size of the data stored in the data partition.</p> <note>
         *        <p>
         *        Newer data overwrites older data when the partition reaches the maximum size.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumSize(StorageMaximumSize maximumSize);

        /**
         * <p>
         * The maximum storage size of the data stored in the data partition.
         * </p>
         * <note>
         * <p>
         * Newer data overwrites older data when the partition reaches the maximum size.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link StorageMaximumSize.Builder}
         * avoiding the need to create one manually via {@link StorageMaximumSize#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StorageMaximumSize.Builder#build()} is called immediately and its
         * result is passed to {@link #maximumSize(StorageMaximumSize)}.
         * 
         * @param maximumSize
         *        a consumer that will call methods on {@link StorageMaximumSize.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #maximumSize(StorageMaximumSize)
         */
        default Builder maximumSize(Consumer<StorageMaximumSize.Builder> maximumSize) {
            return maximumSize(StorageMaximumSize.builder().applyMutation(maximumSize).build());
        }

        /**
         * <p>
         * The folder name for the data partition under the campaign storage folder.
         * </p>
         * 
         * @param storageLocation
         *        The folder name for the data partition under the campaign storage folder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageLocation(String storageLocation);

        /**
         * <p>
         * The amount of time that data in this partition will be kept on disk.
         * </p>
         * <ul>
         * <li>
         * <p>
         * After the designated amount of time passes, the data can be removed, but it's not guaranteed to be removed.
         * </p>
         * </li>
         * <li>
         * <p>
         * Before the time expires, data in this partition can still be deleted if the partition reaches its configured
         * maximum size.
         * </p>
         * </li>
         * <li>
         * <p>
         * Newer data will overwrite older data when the partition reaches the maximum size.
         * </p>
         * </li>
         * </ul>
         * 
         * @param minimumTimeToLive
         *        The amount of time that data in this partition will be kept on disk.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        After the designated amount of time passes, the data can be removed, but it's not guaranteed to be
         *        removed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Before the time expires, data in this partition can still be deleted if the partition reaches its
         *        configured maximum size.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Newer data will overwrite older data when the partition reaches the maximum size.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumTimeToLive(StorageMinimumTimeToLive minimumTimeToLive);

        /**
         * <p>
         * The amount of time that data in this partition will be kept on disk.
         * </p>
         * <ul>
         * <li>
         * <p>
         * After the designated amount of time passes, the data can be removed, but it's not guaranteed to be removed.
         * </p>
         * </li>
         * <li>
         * <p>
         * Before the time expires, data in this partition can still be deleted if the partition reaches its configured
         * maximum size.
         * </p>
         * </li>
         * <li>
         * <p>
         * Newer data will overwrite older data when the partition reaches the maximum size.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link StorageMinimumTimeToLive.Builder}
         * avoiding the need to create one manually via {@link StorageMinimumTimeToLive#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StorageMinimumTimeToLive.Builder#build()} is called immediately
         * and its result is passed to {@link #minimumTimeToLive(StorageMinimumTimeToLive)}.
         * 
         * @param minimumTimeToLive
         *        a consumer that will call methods on {@link StorageMinimumTimeToLive.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #minimumTimeToLive(StorageMinimumTimeToLive)
         */
        default Builder minimumTimeToLive(Consumer<StorageMinimumTimeToLive.Builder> minimumTimeToLive) {
            return minimumTimeToLive(StorageMinimumTimeToLive.builder().applyMutation(minimumTimeToLive).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private StorageMaximumSize maximumSize;

        private String storageLocation;

        private StorageMinimumTimeToLive minimumTimeToLive;

        private BuilderImpl() {
        }

        private BuilderImpl(DataPartitionStorageOptions model) {
            maximumSize(model.maximumSize);
            storageLocation(model.storageLocation);
            minimumTimeToLive(model.minimumTimeToLive);
        }

        public final StorageMaximumSize.Builder getMaximumSize() {
            return maximumSize != null ? maximumSize.toBuilder() : null;
        }

        public final void setMaximumSize(StorageMaximumSize.BuilderImpl maximumSize) {
            this.maximumSize = maximumSize != null ? maximumSize.build() : null;
        }

        @Override
        public final Builder maximumSize(StorageMaximumSize maximumSize) {
            this.maximumSize = maximumSize;
            return this;
        }

        public final String getStorageLocation() {
            return storageLocation;
        }

        public final void setStorageLocation(String storageLocation) {
            this.storageLocation = storageLocation;
        }

        @Override
        public final Builder storageLocation(String storageLocation) {
            this.storageLocation = storageLocation;
            return this;
        }

        public final StorageMinimumTimeToLive.Builder getMinimumTimeToLive() {
            return minimumTimeToLive != null ? minimumTimeToLive.toBuilder() : null;
        }

        public final void setMinimumTimeToLive(StorageMinimumTimeToLive.BuilderImpl minimumTimeToLive) {
            this.minimumTimeToLive = minimumTimeToLive != null ? minimumTimeToLive.build() : null;
        }

        @Override
        public final Builder minimumTimeToLive(StorageMinimumTimeToLive minimumTimeToLive) {
            this.minimumTimeToLive = minimumTimeToLive;
            return this;
        }

        @Override
        public DataPartitionStorageOptions build() {
            return new DataPartitionStorageOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
