/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCampaignResponse extends IoTFleetWiseResponse implements
        ToCopyableBuilder<GetCampaignResponse.Builder, GetCampaignResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetCampaignResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(GetCampaignResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetCampaignResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> SIGNAL_CATALOG_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("signalCatalogArn").getter(getter(GetCampaignResponse::signalCatalogArn))
            .setter(setter(Builder::signalCatalogArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signalCatalogArn").build()).build();

    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetArn").getter(getter(GetCampaignResponse::targetArn)).setter(setter(Builder::targetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetCampaignResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(GetCampaignResponse::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<Instant> EXPIRY_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("expiryTime").getter(getter(GetCampaignResponse::expiryTime)).setter(setter(Builder::expiryTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiryTime").build()).build();

    private static final SdkField<Long> POST_TRIGGER_COLLECTION_DURATION_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("postTriggerCollectionDuration")
            .getter(getter(GetCampaignResponse::postTriggerCollectionDuration))
            .setter(setter(Builder::postTriggerCollectionDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("postTriggerCollectionDuration")
                    .build()).build();

    private static final SdkField<String> DIAGNOSTICS_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("diagnosticsMode").getter(getter(GetCampaignResponse::diagnosticsModeAsString))
            .setter(setter(Builder::diagnosticsMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("diagnosticsMode").build()).build();

    private static final SdkField<String> SPOOLING_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("spoolingMode").getter(getter(GetCampaignResponse::spoolingModeAsString))
            .setter(setter(Builder::spoolingMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spoolingMode").build()).build();

    private static final SdkField<String> COMPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("compression").getter(getter(GetCampaignResponse::compressionAsString))
            .setter(setter(Builder::compression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compression").build()).build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("priority").getter(getter(GetCampaignResponse::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()).build();

    private static final SdkField<List<SignalInformation>> SIGNALS_TO_COLLECT_FIELD = SdkField
            .<List<SignalInformation>> builder(MarshallingType.LIST)
            .memberName("signalsToCollect")
            .getter(getter(GetCampaignResponse::signalsToCollect))
            .setter(setter(Builder::signalsToCollect))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signalsToCollect").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SignalInformation> builder(MarshallingType.SDK_POJO)
                                            .constructor(SignalInformation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<CollectionScheme> COLLECTION_SCHEME_FIELD = SdkField
            .<CollectionScheme> builder(MarshallingType.SDK_POJO).memberName("collectionScheme")
            .getter(getter(GetCampaignResponse::collectionScheme)).setter(setter(Builder::collectionScheme))
            .constructor(CollectionScheme::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collectionScheme").build()).build();

    private static final SdkField<List<String>> DATA_EXTRA_DIMENSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("dataExtraDimensions")
            .getter(getter(GetCampaignResponse::dataExtraDimensions))
            .setter(setter(Builder::dataExtraDimensions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataExtraDimensions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(GetCampaignResponse::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModificationTime").getter(getter(GetCampaignResponse::lastModificationTime))
            .setter(setter(Builder::lastModificationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModificationTime").build())
            .build();

    private static final SdkField<List<DataDestinationConfig>> DATA_DESTINATION_CONFIGS_FIELD = SdkField
            .<List<DataDestinationConfig>> builder(MarshallingType.LIST)
            .memberName("dataDestinationConfigs")
            .getter(getter(GetCampaignResponse::dataDestinationConfigs))
            .setter(setter(Builder::dataDestinationConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataDestinationConfigs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataDestinationConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataDestinationConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DataPartition>> DATA_PARTITIONS_FIELD = SdkField
            .<List<DataPartition>> builder(MarshallingType.LIST)
            .memberName("dataPartitions")
            .getter(getter(GetCampaignResponse::dataPartitions))
            .setter(setter(Builder::dataPartitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataPartitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataPartition> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataPartition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SignalFetchInformation>> SIGNALS_TO_FETCH_FIELD = SdkField
            .<List<SignalFetchInformation>> builder(MarshallingType.LIST)
            .memberName("signalsToFetch")
            .getter(getter(GetCampaignResponse::signalsToFetch))
            .setter(setter(Builder::signalsToFetch))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signalsToFetch").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SignalFetchInformation> builder(MarshallingType.SDK_POJO)
                                            .constructor(SignalFetchInformation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD,
            DESCRIPTION_FIELD, SIGNAL_CATALOG_ARN_FIELD, TARGET_ARN_FIELD, STATUS_FIELD, START_TIME_FIELD, EXPIRY_TIME_FIELD,
            POST_TRIGGER_COLLECTION_DURATION_FIELD, DIAGNOSTICS_MODE_FIELD, SPOOLING_MODE_FIELD, COMPRESSION_FIELD,
            PRIORITY_FIELD, SIGNALS_TO_COLLECT_FIELD, COLLECTION_SCHEME_FIELD, DATA_EXTRA_DIMENSIONS_FIELD, CREATION_TIME_FIELD,
            LAST_MODIFICATION_TIME_FIELD, DATA_DESTINATION_CONFIGS_FIELD, DATA_PARTITIONS_FIELD, SIGNALS_TO_FETCH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String arn;

    private final String description;

    private final String signalCatalogArn;

    private final String targetArn;

    private final String status;

    private final Instant startTime;

    private final Instant expiryTime;

    private final Long postTriggerCollectionDuration;

    private final String diagnosticsMode;

    private final String spoolingMode;

    private final String compression;

    private final Integer priority;

    private final List<SignalInformation> signalsToCollect;

    private final CollectionScheme collectionScheme;

    private final List<String> dataExtraDimensions;

    private final Instant creationTime;

    private final Instant lastModificationTime;

    private final List<DataDestinationConfig> dataDestinationConfigs;

    private final List<DataPartition> dataPartitions;

    private final List<SignalFetchInformation> signalsToFetch;

    private GetCampaignResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.arn = builder.arn;
        this.description = builder.description;
        this.signalCatalogArn = builder.signalCatalogArn;
        this.targetArn = builder.targetArn;
        this.status = builder.status;
        this.startTime = builder.startTime;
        this.expiryTime = builder.expiryTime;
        this.postTriggerCollectionDuration = builder.postTriggerCollectionDuration;
        this.diagnosticsMode = builder.diagnosticsMode;
        this.spoolingMode = builder.spoolingMode;
        this.compression = builder.compression;
        this.priority = builder.priority;
        this.signalsToCollect = builder.signalsToCollect;
        this.collectionScheme = builder.collectionScheme;
        this.dataExtraDimensions = builder.dataExtraDimensions;
        this.creationTime = builder.creationTime;
        this.lastModificationTime = builder.lastModificationTime;
        this.dataDestinationConfigs = builder.dataDestinationConfigs;
        this.dataPartitions = builder.dataPartitions;
        this.signalsToFetch = builder.signalsToFetch;
    }

    /**
     * <p>
     * The name of the campaign.
     * </p>
     * 
     * @return The name of the campaign.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the campaign.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the campaign.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The description of the campaign.
     * </p>
     * 
     * @return The description of the campaign.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ARN of a signal catalog.
     * </p>
     * 
     * @return The ARN of a signal catalog.
     */
    public final String signalCatalogArn() {
        return signalCatalogArn;
    }

    /**
     * <p>
     * The ARN of the vehicle or the fleet targeted by the campaign.
     * </p>
     * 
     * @return The ARN of the vehicle or the fleet targeted by the campaign.
     */
    public final String targetArn() {
        return targetArn;
    }

    /**
     * <p>
     * The state of the campaign. The status can be one of: <code>CREATING</code>, <code>WAITING_FOR_APPROVAL</code>,
     * <code>RUNNING</code>, and <code>SUSPENDED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CampaignStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The state of the campaign. The status can be one of: <code>CREATING</code>,
     *         <code>WAITING_FOR_APPROVAL</code>, <code>RUNNING</code>, and <code>SUSPENDED</code>.
     * @see CampaignStatus
     */
    public final CampaignStatus status() {
        return CampaignStatus.fromValue(status);
    }

    /**
     * <p>
     * The state of the campaign. The status can be one of: <code>CREATING</code>, <code>WAITING_FOR_APPROVAL</code>,
     * <code>RUNNING</code>, and <code>SUSPENDED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CampaignStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The state of the campaign. The status can be one of: <code>CREATING</code>,
     *         <code>WAITING_FOR_APPROVAL</code>, <code>RUNNING</code>, and <code>SUSPENDED</code>.
     * @see CampaignStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The time, in milliseconds, to deliver a campaign after it was approved.
     * </p>
     * 
     * @return The time, in milliseconds, to deliver a campaign after it was approved.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The time the campaign expires, in seconds since epoch (January 1, 1970 at midnight UTC time). Vehicle data won't
     * be collected after the campaign expires.
     * </p>
     * 
     * @return The time the campaign expires, in seconds since epoch (January 1, 1970 at midnight UTC time). Vehicle
     *         data won't be collected after the campaign expires.
     */
    public final Instant expiryTime() {
        return expiryTime;
    }

    /**
     * <p>
     * How long (in seconds) to collect raw data after a triggering event initiates the collection.
     * </p>
     * 
     * @return How long (in seconds) to collect raw data after a triggering event initiates the collection.
     */
    public final Long postTriggerCollectionDuration() {
        return postTriggerCollectionDuration;
    }

    /**
     * <p>
     * Option for a vehicle to send diagnostic trouble codes to Amazon Web Services IoT FleetWise.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #diagnosticsMode}
     * will return {@link DiagnosticsMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #diagnosticsModeAsString}.
     * </p>
     * 
     * @return Option for a vehicle to send diagnostic trouble codes to Amazon Web Services IoT FleetWise.
     * @see DiagnosticsMode
     */
    public final DiagnosticsMode diagnosticsMode() {
        return DiagnosticsMode.fromValue(diagnosticsMode);
    }

    /**
     * <p>
     * Option for a vehicle to send diagnostic trouble codes to Amazon Web Services IoT FleetWise.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #diagnosticsMode}
     * will return {@link DiagnosticsMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #diagnosticsModeAsString}.
     * </p>
     * 
     * @return Option for a vehicle to send diagnostic trouble codes to Amazon Web Services IoT FleetWise.
     * @see DiagnosticsMode
     */
    public final String diagnosticsModeAsString() {
        return diagnosticsMode;
    }

    /**
     * <p>
     * Whether to store collected data after a vehicle lost a connection with the cloud. After a connection is
     * re-established, the data is automatically forwarded to Amazon Web Services IoT FleetWise.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #spoolingMode} will
     * return {@link SpoolingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #spoolingModeAsString}.
     * </p>
     * 
     * @return Whether to store collected data after a vehicle lost a connection with the cloud. After a connection is
     *         re-established, the data is automatically forwarded to Amazon Web Services IoT FleetWise.
     * @see SpoolingMode
     */
    public final SpoolingMode spoolingMode() {
        return SpoolingMode.fromValue(spoolingMode);
    }

    /**
     * <p>
     * Whether to store collected data after a vehicle lost a connection with the cloud. After a connection is
     * re-established, the data is automatically forwarded to Amazon Web Services IoT FleetWise.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #spoolingMode} will
     * return {@link SpoolingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #spoolingModeAsString}.
     * </p>
     * 
     * @return Whether to store collected data after a vehicle lost a connection with the cloud. After a connection is
     *         re-established, the data is automatically forwarded to Amazon Web Services IoT FleetWise.
     * @see SpoolingMode
     */
    public final String spoolingModeAsString() {
        return spoolingMode;
    }

    /**
     * <p>
     * Whether to compress signals before transmitting data to Amazon Web Services IoT FleetWise. If <code>OFF</code> is
     * specified, the signals aren't compressed. If it's not specified, <code>SNAPPY</code> is used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #compression} will
     * return {@link Compression#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #compressionAsString}.
     * </p>
     * 
     * @return Whether to compress signals before transmitting data to Amazon Web Services IoT FleetWise. If
     *         <code>OFF</code> is specified, the signals aren't compressed. If it's not specified, <code>SNAPPY</code>
     *         is used.
     * @see Compression
     */
    public final Compression compression() {
        return Compression.fromValue(compression);
    }

    /**
     * <p>
     * Whether to compress signals before transmitting data to Amazon Web Services IoT FleetWise. If <code>OFF</code> is
     * specified, the signals aren't compressed. If it's not specified, <code>SNAPPY</code> is used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #compression} will
     * return {@link Compression#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #compressionAsString}.
     * </p>
     * 
     * @return Whether to compress signals before transmitting data to Amazon Web Services IoT FleetWise. If
     *         <code>OFF</code> is specified, the signals aren't compressed. If it's not specified, <code>SNAPPY</code>
     *         is used.
     * @see Compression
     */
    public final String compressionAsString() {
        return compression;
    }

    /**
     * <p>
     * A number indicating the priority of one campaign over another campaign for a certain vehicle or fleet. A campaign
     * with the lowest value is deployed to vehicles before any other campaigns.
     * </p>
     * 
     * @return A number indicating the priority of one campaign over another campaign for a certain vehicle or fleet. A
     *         campaign with the lowest value is deployed to vehicles before any other campaigns.
     */
    public final Integer priority() {
        return priority;
    }

    /**
     * For responses, this returns true if the service returned a value for the SignalsToCollect property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSignalsToCollect() {
        return signalsToCollect != null && !(signalsToCollect instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about a list of signals to collect data on.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSignalsToCollect} method.
     * </p>
     * 
     * @return Information about a list of signals to collect data on.
     */
    public final List<SignalInformation> signalsToCollect() {
        return signalsToCollect;
    }

    /**
     * <p>
     * Information about the data collection scheme associated with the campaign.
     * </p>
     * 
     * @return Information about the data collection scheme associated with the campaign.
     */
    public final CollectionScheme collectionScheme() {
        return collectionScheme;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataExtraDimensions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDataExtraDimensions() {
        return dataExtraDimensions != null && !(dataExtraDimensions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of vehicle attributes associated with the campaign.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataExtraDimensions} method.
     * </p>
     * 
     * @return A list of vehicle attributes associated with the campaign.
     */
    public final List<String> dataExtraDimensions() {
        return dataExtraDimensions;
    }

    /**
     * <p>
     * The time the campaign was created in seconds since epoch (January 1, 1970 at midnight UTC time).
     * </p>
     * 
     * @return The time the campaign was created in seconds since epoch (January 1, 1970 at midnight UTC time).
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The last time the campaign was modified.
     * </p>
     * 
     * @return The last time the campaign was modified.
     */
    public final Instant lastModificationTime() {
        return lastModificationTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataDestinationConfigs property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDataDestinationConfigs() {
        return dataDestinationConfigs != null && !(dataDestinationConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The destination where the campaign sends data. You can send data to an MQTT topic, or store it in Amazon S3 or
     * Amazon Timestream.
     * </p>
     * <p>
     * MQTT is the publish/subscribe messaging protocol used by Amazon Web Services IoT to communicate with your
     * devices.
     * </p>
     * <p>
     * Amazon S3 optimizes the cost of data storage and provides additional mechanisms to use vehicle data, such as data
     * lakes, centralized data storage, data processing pipelines, and analytics.
     * </p>
     * <p>
     * You can use Amazon Timestream to access and analyze time series data, and Timestream to query vehicle data so
     * that you can identify trends and patterns.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataDestinationConfigs} method.
     * </p>
     * 
     * @return The destination where the campaign sends data. You can send data to an MQTT topic, or store it in Amazon
     *         S3 or Amazon Timestream.</p>
     *         <p>
     *         MQTT is the publish/subscribe messaging protocol used by Amazon Web Services IoT to communicate with your
     *         devices.
     *         </p>
     *         <p>
     *         Amazon S3 optimizes the cost of data storage and provides additional mechanisms to use vehicle data, such
     *         as data lakes, centralized data storage, data processing pipelines, and analytics.
     *         </p>
     *         <p>
     *         You can use Amazon Timestream to access and analyze time series data, and Timestream to query vehicle
     *         data so that you can identify trends and patterns.
     */
    public final List<DataDestinationConfig> dataDestinationConfigs() {
        return dataDestinationConfigs;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataPartitions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDataPartitions() {
        return dataPartitions != null && !(dataPartitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The data partitions associated with the signals collected from the vehicle.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataPartitions} method.
     * </p>
     * 
     * @return The data partitions associated with the signals collected from the vehicle.
     */
    public final List<DataPartition> dataPartitions() {
        return dataPartitions;
    }

    /**
     * For responses, this returns true if the service returned a value for the SignalsToFetch property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSignalsToFetch() {
        return signalsToFetch != null && !(signalsToFetch instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about a list of signals to fetch data from.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSignalsToFetch} method.
     * </p>
     * 
     * @return Information about a list of signals to fetch data from.
     */
    public final List<SignalFetchInformation> signalsToFetch() {
        return signalsToFetch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(signalCatalogArn());
        hashCode = 31 * hashCode + Objects.hashCode(targetArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(expiryTime());
        hashCode = 31 * hashCode + Objects.hashCode(postTriggerCollectionDuration());
        hashCode = 31 * hashCode + Objects.hashCode(diagnosticsModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(spoolingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(compressionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(hasSignalsToCollect() ? signalsToCollect() : null);
        hashCode = 31 * hashCode + Objects.hashCode(collectionScheme());
        hashCode = 31 * hashCode + Objects.hashCode(hasDataExtraDimensions() ? dataExtraDimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModificationTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasDataDestinationConfigs() ? dataDestinationConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDataPartitions() ? dataPartitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSignalsToFetch() ? signalsToFetch() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCampaignResponse)) {
            return false;
        }
        GetCampaignResponse other = (GetCampaignResponse) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn())
                && Objects.equals(description(), other.description())
                && Objects.equals(signalCatalogArn(), other.signalCatalogArn()) && Objects.equals(targetArn(), other.targetArn())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(expiryTime(), other.expiryTime())
                && Objects.equals(postTriggerCollectionDuration(), other.postTriggerCollectionDuration())
                && Objects.equals(diagnosticsModeAsString(), other.diagnosticsModeAsString())
                && Objects.equals(spoolingModeAsString(), other.spoolingModeAsString())
                && Objects.equals(compressionAsString(), other.compressionAsString())
                && Objects.equals(priority(), other.priority()) && hasSignalsToCollect() == other.hasSignalsToCollect()
                && Objects.equals(signalsToCollect(), other.signalsToCollect())
                && Objects.equals(collectionScheme(), other.collectionScheme())
                && hasDataExtraDimensions() == other.hasDataExtraDimensions()
                && Objects.equals(dataExtraDimensions(), other.dataExtraDimensions())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModificationTime(), other.lastModificationTime())
                && hasDataDestinationConfigs() == other.hasDataDestinationConfigs()
                && Objects.equals(dataDestinationConfigs(), other.dataDestinationConfigs())
                && hasDataPartitions() == other.hasDataPartitions() && Objects.equals(dataPartitions(), other.dataPartitions())
                && hasSignalsToFetch() == other.hasSignalsToFetch() && Objects.equals(signalsToFetch(), other.signalsToFetch());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCampaignResponse").add("Name", name()).add("Arn", arn()).add("Description", description())
                .add("SignalCatalogArn", signalCatalogArn()).add("TargetArn", targetArn()).add("Status", statusAsString())
                .add("StartTime", startTime()).add("ExpiryTime", expiryTime())
                .add("PostTriggerCollectionDuration", postTriggerCollectionDuration())
                .add("DiagnosticsMode", diagnosticsModeAsString()).add("SpoolingMode", spoolingModeAsString())
                .add("Compression", compressionAsString()).add("Priority", priority())
                .add("SignalsToCollect", signalsToCollect() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CollectionScheme", collectionScheme())
                .add("DataExtraDimensions", dataExtraDimensions() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CreationTime", creationTime()).add("LastModificationTime", lastModificationTime())
                .add("DataDestinationConfigs", hasDataDestinationConfigs() ? dataDestinationConfigs() : null)
                .add("DataPartitions", hasDataPartitions() ? dataPartitions() : null)
                .add("SignalsToFetch", signalsToFetch() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "signalCatalogArn":
            return Optional.ofNullable(clazz.cast(signalCatalogArn()));
        case "targetArn":
            return Optional.ofNullable(clazz.cast(targetArn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "expiryTime":
            return Optional.ofNullable(clazz.cast(expiryTime()));
        case "postTriggerCollectionDuration":
            return Optional.ofNullable(clazz.cast(postTriggerCollectionDuration()));
        case "diagnosticsMode":
            return Optional.ofNullable(clazz.cast(diagnosticsModeAsString()));
        case "spoolingMode":
            return Optional.ofNullable(clazz.cast(spoolingModeAsString()));
        case "compression":
            return Optional.ofNullable(clazz.cast(compressionAsString()));
        case "priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "signalsToCollect":
            return Optional.ofNullable(clazz.cast(signalsToCollect()));
        case "collectionScheme":
            return Optional.ofNullable(clazz.cast(collectionScheme()));
        case "dataExtraDimensions":
            return Optional.ofNullable(clazz.cast(dataExtraDimensions()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "lastModificationTime":
            return Optional.ofNullable(clazz.cast(lastModificationTime()));
        case "dataDestinationConfigs":
            return Optional.ofNullable(clazz.cast(dataDestinationConfigs()));
        case "dataPartitions":
            return Optional.ofNullable(clazz.cast(dataPartitions()));
        case "signalsToFetch":
            return Optional.ofNullable(clazz.cast(signalsToFetch()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("signalCatalogArn", SIGNAL_CATALOG_ARN_FIELD);
        map.put("targetArn", TARGET_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("expiryTime", EXPIRY_TIME_FIELD);
        map.put("postTriggerCollectionDuration", POST_TRIGGER_COLLECTION_DURATION_FIELD);
        map.put("diagnosticsMode", DIAGNOSTICS_MODE_FIELD);
        map.put("spoolingMode", SPOOLING_MODE_FIELD);
        map.put("compression", COMPRESSION_FIELD);
        map.put("priority", PRIORITY_FIELD);
        map.put("signalsToCollect", SIGNALS_TO_COLLECT_FIELD);
        map.put("collectionScheme", COLLECTION_SCHEME_FIELD);
        map.put("dataExtraDimensions", DATA_EXTRA_DIMENSIONS_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("lastModificationTime", LAST_MODIFICATION_TIME_FIELD);
        map.put("dataDestinationConfigs", DATA_DESTINATION_CONFIGS_FIELD);
        map.put("dataPartitions", DATA_PARTITIONS_FIELD);
        map.put("signalsToFetch", SIGNALS_TO_FETCH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCampaignResponse, T> g) {
        return obj -> g.apply((GetCampaignResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IoTFleetWiseResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetCampaignResponse> {
        /**
         * <p>
         * The name of the campaign.
         * </p>
         * 
         * @param name
         *        The name of the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the campaign.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The description of the campaign.
         * </p>
         * 
         * @param description
         *        The description of the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ARN of a signal catalog.
         * </p>
         * 
         * @param signalCatalogArn
         *        The ARN of a signal catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signalCatalogArn(String signalCatalogArn);

        /**
         * <p>
         * The ARN of the vehicle or the fleet targeted by the campaign.
         * </p>
         * 
         * @param targetArn
         *        The ARN of the vehicle or the fleet targeted by the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetArn(String targetArn);

        /**
         * <p>
         * The state of the campaign. The status can be one of: <code>CREATING</code>, <code>WAITING_FOR_APPROVAL</code>, <code>RUNNING</code>, and <code>SUSPENDED</code>.
         * </p>
         * 
         * @param status
         *        The state of the campaign. The status can be one of: <code>CREATING</code>,
         *        <code>WAITING_FOR_APPROVAL</code>, <code>RUNNING</code>, and <code>SUSPENDED</code>.
         * @see CampaignStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CampaignStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The state of the campaign. The status can be one of: <code>CREATING</code>, <code>WAITING_FOR_APPROVAL</code>, <code>RUNNING</code>, and <code>SUSPENDED</code>.
         * </p>
         * 
         * @param status
         *        The state of the campaign. The status can be one of: <code>CREATING</code>,
         *        <code>WAITING_FOR_APPROVAL</code>, <code>RUNNING</code>, and <code>SUSPENDED</code>.
         * @see CampaignStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CampaignStatus
         */
        Builder status(CampaignStatus status);

        /**
         * <p>
         * The time, in milliseconds, to deliver a campaign after it was approved.
         * </p>
         * 
         * @param startTime
         *        The time, in milliseconds, to deliver a campaign after it was approved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The time the campaign expires, in seconds since epoch (January 1, 1970 at midnight UTC time). Vehicle data
         * won't be collected after the campaign expires.
         * </p>
         * 
         * @param expiryTime
         *        The time the campaign expires, in seconds since epoch (January 1, 1970 at midnight UTC time). Vehicle
         *        data won't be collected after the campaign expires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiryTime(Instant expiryTime);

        /**
         * <p>
         * How long (in seconds) to collect raw data after a triggering event initiates the collection.
         * </p>
         * 
         * @param postTriggerCollectionDuration
         *        How long (in seconds) to collect raw data after a triggering event initiates the collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postTriggerCollectionDuration(Long postTriggerCollectionDuration);

        /**
         * <p>
         * Option for a vehicle to send diagnostic trouble codes to Amazon Web Services IoT FleetWise.
         * </p>
         * 
         * @param diagnosticsMode
         *        Option for a vehicle to send diagnostic trouble codes to Amazon Web Services IoT FleetWise.
         * @see DiagnosticsMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiagnosticsMode
         */
        Builder diagnosticsMode(String diagnosticsMode);

        /**
         * <p>
         * Option for a vehicle to send diagnostic trouble codes to Amazon Web Services IoT FleetWise.
         * </p>
         * 
         * @param diagnosticsMode
         *        Option for a vehicle to send diagnostic trouble codes to Amazon Web Services IoT FleetWise.
         * @see DiagnosticsMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiagnosticsMode
         */
        Builder diagnosticsMode(DiagnosticsMode diagnosticsMode);

        /**
         * <p>
         * Whether to store collected data after a vehicle lost a connection with the cloud. After a connection is
         * re-established, the data is automatically forwarded to Amazon Web Services IoT FleetWise.
         * </p>
         * 
         * @param spoolingMode
         *        Whether to store collected data after a vehicle lost a connection with the cloud. After a connection
         *        is re-established, the data is automatically forwarded to Amazon Web Services IoT FleetWise.
         * @see SpoolingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SpoolingMode
         */
        Builder spoolingMode(String spoolingMode);

        /**
         * <p>
         * Whether to store collected data after a vehicle lost a connection with the cloud. After a connection is
         * re-established, the data is automatically forwarded to Amazon Web Services IoT FleetWise.
         * </p>
         * 
         * @param spoolingMode
         *        Whether to store collected data after a vehicle lost a connection with the cloud. After a connection
         *        is re-established, the data is automatically forwarded to Amazon Web Services IoT FleetWise.
         * @see SpoolingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SpoolingMode
         */
        Builder spoolingMode(SpoolingMode spoolingMode);

        /**
         * <p>
         * Whether to compress signals before transmitting data to Amazon Web Services IoT FleetWise. If
         * <code>OFF</code> is specified, the signals aren't compressed. If it's not specified, <code>SNAPPY</code> is
         * used.
         * </p>
         * 
         * @param compression
         *        Whether to compress signals before transmitting data to Amazon Web Services IoT FleetWise. If
         *        <code>OFF</code> is specified, the signals aren't compressed. If it's not specified,
         *        <code>SNAPPY</code> is used.
         * @see Compression
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Compression
         */
        Builder compression(String compression);

        /**
         * <p>
         * Whether to compress signals before transmitting data to Amazon Web Services IoT FleetWise. If
         * <code>OFF</code> is specified, the signals aren't compressed. If it's not specified, <code>SNAPPY</code> is
         * used.
         * </p>
         * 
         * @param compression
         *        Whether to compress signals before transmitting data to Amazon Web Services IoT FleetWise. If
         *        <code>OFF</code> is specified, the signals aren't compressed. If it's not specified,
         *        <code>SNAPPY</code> is used.
         * @see Compression
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Compression
         */
        Builder compression(Compression compression);

        /**
         * <p>
         * A number indicating the priority of one campaign over another campaign for a certain vehicle or fleet. A
         * campaign with the lowest value is deployed to vehicles before any other campaigns.
         * </p>
         * 
         * @param priority
         *        A number indicating the priority of one campaign over another campaign for a certain vehicle or fleet.
         *        A campaign with the lowest value is deployed to vehicles before any other campaigns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * <p>
         * Information about a list of signals to collect data on.
         * </p>
         * 
         * @param signalsToCollect
         *        Information about a list of signals to collect data on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signalsToCollect(Collection<SignalInformation> signalsToCollect);

        /**
         * <p>
         * Information about a list of signals to collect data on.
         * </p>
         * 
         * @param signalsToCollect
         *        Information about a list of signals to collect data on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signalsToCollect(SignalInformation... signalsToCollect);

        /**
         * <p>
         * Information about a list of signals to collect data on.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotfleetwise.model.SignalInformation.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.iotfleetwise.model.SignalInformation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotfleetwise.model.SignalInformation.Builder#build()} is called
         * immediately and its result is passed to {@link #signalsToCollect(List<SignalInformation>)}.
         * 
         * @param signalsToCollect
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotfleetwise.model.SignalInformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #signalsToCollect(java.util.Collection<SignalInformation>)
         */
        Builder signalsToCollect(Consumer<SignalInformation.Builder>... signalsToCollect);

        /**
         * <p>
         * Information about the data collection scheme associated with the campaign.
         * </p>
         * 
         * @param collectionScheme
         *        Information about the data collection scheme associated with the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionScheme(CollectionScheme collectionScheme);

        /**
         * <p>
         * Information about the data collection scheme associated with the campaign.
         * </p>
         * This is a convenience method that creates an instance of the {@link CollectionScheme.Builder} avoiding the
         * need to create one manually via {@link CollectionScheme#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CollectionScheme.Builder#build()} is called immediately and its
         * result is passed to {@link #collectionScheme(CollectionScheme)}.
         * 
         * @param collectionScheme
         *        a consumer that will call methods on {@link CollectionScheme.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #collectionScheme(CollectionScheme)
         */
        default Builder collectionScheme(Consumer<CollectionScheme.Builder> collectionScheme) {
            return collectionScheme(CollectionScheme.builder().applyMutation(collectionScheme).build());
        }

        /**
         * <p>
         * A list of vehicle attributes associated with the campaign.
         * </p>
         * 
         * @param dataExtraDimensions
         *        A list of vehicle attributes associated with the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataExtraDimensions(Collection<String> dataExtraDimensions);

        /**
         * <p>
         * A list of vehicle attributes associated with the campaign.
         * </p>
         * 
         * @param dataExtraDimensions
         *        A list of vehicle attributes associated with the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataExtraDimensions(String... dataExtraDimensions);

        /**
         * <p>
         * The time the campaign was created in seconds since epoch (January 1, 1970 at midnight UTC time).
         * </p>
         * 
         * @param creationTime
         *        The time the campaign was created in seconds since epoch (January 1, 1970 at midnight UTC time).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The last time the campaign was modified.
         * </p>
         * 
         * @param lastModificationTime
         *        The last time the campaign was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModificationTime(Instant lastModificationTime);

        /**
         * <p>
         * The destination where the campaign sends data. You can send data to an MQTT topic, or store it in Amazon S3
         * or Amazon Timestream.
         * </p>
         * <p>
         * MQTT is the publish/subscribe messaging protocol used by Amazon Web Services IoT to communicate with your
         * devices.
         * </p>
         * <p>
         * Amazon S3 optimizes the cost of data storage and provides additional mechanisms to use vehicle data, such as
         * data lakes, centralized data storage, data processing pipelines, and analytics.
         * </p>
         * <p>
         * You can use Amazon Timestream to access and analyze time series data, and Timestream to query vehicle data so
         * that you can identify trends and patterns.
         * </p>
         * 
         * @param dataDestinationConfigs
         *        The destination where the campaign sends data. You can send data to an MQTT topic, or store it in
         *        Amazon S3 or Amazon Timestream.</p>
         *        <p>
         *        MQTT is the publish/subscribe messaging protocol used by Amazon Web Services IoT to communicate with
         *        your devices.
         *        </p>
         *        <p>
         *        Amazon S3 optimizes the cost of data storage and provides additional mechanisms to use vehicle data,
         *        such as data lakes, centralized data storage, data processing pipelines, and analytics.
         *        </p>
         *        <p>
         *        You can use Amazon Timestream to access and analyze time series data, and Timestream to query vehicle
         *        data so that you can identify trends and patterns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataDestinationConfigs(Collection<DataDestinationConfig> dataDestinationConfigs);

        /**
         * <p>
         * The destination where the campaign sends data. You can send data to an MQTT topic, or store it in Amazon S3
         * or Amazon Timestream.
         * </p>
         * <p>
         * MQTT is the publish/subscribe messaging protocol used by Amazon Web Services IoT to communicate with your
         * devices.
         * </p>
         * <p>
         * Amazon S3 optimizes the cost of data storage and provides additional mechanisms to use vehicle data, such as
         * data lakes, centralized data storage, data processing pipelines, and analytics.
         * </p>
         * <p>
         * You can use Amazon Timestream to access and analyze time series data, and Timestream to query vehicle data so
         * that you can identify trends and patterns.
         * </p>
         * 
         * @param dataDestinationConfigs
         *        The destination where the campaign sends data. You can send data to an MQTT topic, or store it in
         *        Amazon S3 or Amazon Timestream.</p>
         *        <p>
         *        MQTT is the publish/subscribe messaging protocol used by Amazon Web Services IoT to communicate with
         *        your devices.
         *        </p>
         *        <p>
         *        Amazon S3 optimizes the cost of data storage and provides additional mechanisms to use vehicle data,
         *        such as data lakes, centralized data storage, data processing pipelines, and analytics.
         *        </p>
         *        <p>
         *        You can use Amazon Timestream to access and analyze time series data, and Timestream to query vehicle
         *        data so that you can identify trends and patterns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataDestinationConfigs(DataDestinationConfig... dataDestinationConfigs);

        /**
         * <p>
         * The destination where the campaign sends data. You can send data to an MQTT topic, or store it in Amazon S3
         * or Amazon Timestream.
         * </p>
         * <p>
         * MQTT is the publish/subscribe messaging protocol used by Amazon Web Services IoT to communicate with your
         * devices.
         * </p>
         * <p>
         * Amazon S3 optimizes the cost of data storage and provides additional mechanisms to use vehicle data, such as
         * data lakes, centralized data storage, data processing pipelines, and analytics.
         * </p>
         * <p>
         * You can use Amazon Timestream to access and analyze time series data, and Timestream to query vehicle data so
         * that you can identify trends and patterns.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotfleetwise.model.DataDestinationConfig.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.iotfleetwise.model.DataDestinationConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotfleetwise.model.DataDestinationConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #dataDestinationConfigs(List<DataDestinationConfig>)}.
         * 
         * @param dataDestinationConfigs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotfleetwise.model.DataDestinationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataDestinationConfigs(java.util.Collection<DataDestinationConfig>)
         */
        Builder dataDestinationConfigs(Consumer<DataDestinationConfig.Builder>... dataDestinationConfigs);

        /**
         * <p>
         * The data partitions associated with the signals collected from the vehicle.
         * </p>
         * 
         * @param dataPartitions
         *        The data partitions associated with the signals collected from the vehicle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataPartitions(Collection<DataPartition> dataPartitions);

        /**
         * <p>
         * The data partitions associated with the signals collected from the vehicle.
         * </p>
         * 
         * @param dataPartitions
         *        The data partitions associated with the signals collected from the vehicle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataPartitions(DataPartition... dataPartitions);

        /**
         * <p>
         * The data partitions associated with the signals collected from the vehicle.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotfleetwise.model.DataPartition.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.iotfleetwise.model.DataPartition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotfleetwise.model.DataPartition.Builder#build()} is called
         * immediately and its result is passed to {@link #dataPartitions(List<DataPartition>)}.
         * 
         * @param dataPartitions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotfleetwise.model.DataPartition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataPartitions(java.util.Collection<DataPartition>)
         */
        Builder dataPartitions(Consumer<DataPartition.Builder>... dataPartitions);

        /**
         * <p>
         * Information about a list of signals to fetch data from.
         * </p>
         * 
         * @param signalsToFetch
         *        Information about a list of signals to fetch data from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signalsToFetch(Collection<SignalFetchInformation> signalsToFetch);

        /**
         * <p>
         * Information about a list of signals to fetch data from.
         * </p>
         * 
         * @param signalsToFetch
         *        Information about a list of signals to fetch data from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signalsToFetch(SignalFetchInformation... signalsToFetch);

        /**
         * <p>
         * Information about a list of signals to fetch data from.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotfleetwise.model.SignalFetchInformation.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.iotfleetwise.model.SignalFetchInformation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotfleetwise.model.SignalFetchInformation.Builder#build()} is called
         * immediately and its result is passed to {@link #signalsToFetch(List<SignalFetchInformation>)}.
         * 
         * @param signalsToFetch
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotfleetwise.model.SignalFetchInformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #signalsToFetch(java.util.Collection<SignalFetchInformation>)
         */
        Builder signalsToFetch(Consumer<SignalFetchInformation.Builder>... signalsToFetch);
    }

    static final class BuilderImpl extends IoTFleetWiseResponse.BuilderImpl implements Builder {
        private String name;

        private String arn;

        private String description;

        private String signalCatalogArn;

        private String targetArn;

        private String status;

        private Instant startTime;

        private Instant expiryTime;

        private Long postTriggerCollectionDuration;

        private String diagnosticsMode;

        private String spoolingMode;

        private String compression;

        private Integer priority;

        private List<SignalInformation> signalsToCollect = DefaultSdkAutoConstructList.getInstance();

        private CollectionScheme collectionScheme;

        private List<String> dataExtraDimensions = DefaultSdkAutoConstructList.getInstance();

        private Instant creationTime;

        private Instant lastModificationTime;

        private List<DataDestinationConfig> dataDestinationConfigs = DefaultSdkAutoConstructList.getInstance();

        private List<DataPartition> dataPartitions = DefaultSdkAutoConstructList.getInstance();

        private List<SignalFetchInformation> signalsToFetch = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetCampaignResponse model) {
            super(model);
            name(model.name);
            arn(model.arn);
            description(model.description);
            signalCatalogArn(model.signalCatalogArn);
            targetArn(model.targetArn);
            status(model.status);
            startTime(model.startTime);
            expiryTime(model.expiryTime);
            postTriggerCollectionDuration(model.postTriggerCollectionDuration);
            diagnosticsMode(model.diagnosticsMode);
            spoolingMode(model.spoolingMode);
            compression(model.compression);
            priority(model.priority);
            signalsToCollect(model.signalsToCollect);
            collectionScheme(model.collectionScheme);
            dataExtraDimensions(model.dataExtraDimensions);
            creationTime(model.creationTime);
            lastModificationTime(model.lastModificationTime);
            dataDestinationConfigs(model.dataDestinationConfigs);
            dataPartitions(model.dataPartitions);
            signalsToFetch(model.signalsToFetch);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getSignalCatalogArn() {
            return signalCatalogArn;
        }

        public final void setSignalCatalogArn(String signalCatalogArn) {
            this.signalCatalogArn = signalCatalogArn;
        }

        @Override
        public final Builder signalCatalogArn(String signalCatalogArn) {
            this.signalCatalogArn = signalCatalogArn;
            return this;
        }

        public final String getTargetArn() {
            return targetArn;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CampaignStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getExpiryTime() {
            return expiryTime;
        }

        public final void setExpiryTime(Instant expiryTime) {
            this.expiryTime = expiryTime;
        }

        @Override
        public final Builder expiryTime(Instant expiryTime) {
            this.expiryTime = expiryTime;
            return this;
        }

        public final Long getPostTriggerCollectionDuration() {
            return postTriggerCollectionDuration;
        }

        public final void setPostTriggerCollectionDuration(Long postTriggerCollectionDuration) {
            this.postTriggerCollectionDuration = postTriggerCollectionDuration;
        }

        @Override
        public final Builder postTriggerCollectionDuration(Long postTriggerCollectionDuration) {
            this.postTriggerCollectionDuration = postTriggerCollectionDuration;
            return this;
        }

        public final String getDiagnosticsMode() {
            return diagnosticsMode;
        }

        public final void setDiagnosticsMode(String diagnosticsMode) {
            this.diagnosticsMode = diagnosticsMode;
        }

        @Override
        public final Builder diagnosticsMode(String diagnosticsMode) {
            this.diagnosticsMode = diagnosticsMode;
            return this;
        }

        @Override
        public final Builder diagnosticsMode(DiagnosticsMode diagnosticsMode) {
            this.diagnosticsMode(diagnosticsMode == null ? null : diagnosticsMode.toString());
            return this;
        }

        public final String getSpoolingMode() {
            return spoolingMode;
        }

        public final void setSpoolingMode(String spoolingMode) {
            this.spoolingMode = spoolingMode;
        }

        @Override
        public final Builder spoolingMode(String spoolingMode) {
            this.spoolingMode = spoolingMode;
            return this;
        }

        @Override
        public final Builder spoolingMode(SpoolingMode spoolingMode) {
            this.spoolingMode(spoolingMode == null ? null : spoolingMode.toString());
            return this;
        }

        public final String getCompression() {
            return compression;
        }

        public final void setCompression(String compression) {
            this.compression = compression;
        }

        @Override
        public final Builder compression(String compression) {
            this.compression = compression;
            return this;
        }

        @Override
        public final Builder compression(Compression compression) {
            this.compression(compression == null ? null : compression.toString());
            return this;
        }

        public final Integer getPriority() {
            return priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final List<SignalInformation.Builder> getSignalsToCollect() {
            List<SignalInformation.Builder> result = SignalInformationListCopier.copyToBuilder(this.signalsToCollect);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSignalsToCollect(Collection<SignalInformation.BuilderImpl> signalsToCollect) {
            this.signalsToCollect = SignalInformationListCopier.copyFromBuilder(signalsToCollect);
        }

        @Override
        public final Builder signalsToCollect(Collection<SignalInformation> signalsToCollect) {
            this.signalsToCollect = SignalInformationListCopier.copy(signalsToCollect);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder signalsToCollect(SignalInformation... signalsToCollect) {
            signalsToCollect(Arrays.asList(signalsToCollect));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder signalsToCollect(Consumer<SignalInformation.Builder>... signalsToCollect) {
            signalsToCollect(Stream.of(signalsToCollect).map(c -> SignalInformation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final CollectionScheme.Builder getCollectionScheme() {
            return collectionScheme != null ? collectionScheme.toBuilder() : null;
        }

        public final void setCollectionScheme(CollectionScheme.BuilderImpl collectionScheme) {
            this.collectionScheme = collectionScheme != null ? collectionScheme.build() : null;
        }

        @Override
        public final Builder collectionScheme(CollectionScheme collectionScheme) {
            this.collectionScheme = collectionScheme;
            return this;
        }

        public final Collection<String> getDataExtraDimensions() {
            if (dataExtraDimensions instanceof SdkAutoConstructList) {
                return null;
            }
            return dataExtraDimensions;
        }

        public final void setDataExtraDimensions(Collection<String> dataExtraDimensions) {
            this.dataExtraDimensions = DataExtraDimensionNodePathListCopier.copy(dataExtraDimensions);
        }

        @Override
        public final Builder dataExtraDimensions(Collection<String> dataExtraDimensions) {
            this.dataExtraDimensions = DataExtraDimensionNodePathListCopier.copy(dataExtraDimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataExtraDimensions(String... dataExtraDimensions) {
            dataExtraDimensions(Arrays.asList(dataExtraDimensions));
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModificationTime() {
            return lastModificationTime;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        public final List<DataDestinationConfig.Builder> getDataDestinationConfigs() {
            List<DataDestinationConfig.Builder> result = DataDestinationConfigsCopier.copyToBuilder(this.dataDestinationConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataDestinationConfigs(Collection<DataDestinationConfig.BuilderImpl> dataDestinationConfigs) {
            this.dataDestinationConfigs = DataDestinationConfigsCopier.copyFromBuilder(dataDestinationConfigs);
        }

        @Override
        public final Builder dataDestinationConfigs(Collection<DataDestinationConfig> dataDestinationConfigs) {
            this.dataDestinationConfigs = DataDestinationConfigsCopier.copy(dataDestinationConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataDestinationConfigs(DataDestinationConfig... dataDestinationConfigs) {
            dataDestinationConfigs(Arrays.asList(dataDestinationConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataDestinationConfigs(Consumer<DataDestinationConfig.Builder>... dataDestinationConfigs) {
            dataDestinationConfigs(Stream.of(dataDestinationConfigs)
                    .map(c -> DataDestinationConfig.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DataPartition.Builder> getDataPartitions() {
            List<DataPartition.Builder> result = DataPartitionsCopier.copyToBuilder(this.dataPartitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataPartitions(Collection<DataPartition.BuilderImpl> dataPartitions) {
            this.dataPartitions = DataPartitionsCopier.copyFromBuilder(dataPartitions);
        }

        @Override
        public final Builder dataPartitions(Collection<DataPartition> dataPartitions) {
            this.dataPartitions = DataPartitionsCopier.copy(dataPartitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataPartitions(DataPartition... dataPartitions) {
            dataPartitions(Arrays.asList(dataPartitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataPartitions(Consumer<DataPartition.Builder>... dataPartitions) {
            dataPartitions(Stream.of(dataPartitions).map(c -> DataPartition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<SignalFetchInformation.Builder> getSignalsToFetch() {
            List<SignalFetchInformation.Builder> result = SignalFetchInformationListCopier.copyToBuilder(this.signalsToFetch);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSignalsToFetch(Collection<SignalFetchInformation.BuilderImpl> signalsToFetch) {
            this.signalsToFetch = SignalFetchInformationListCopier.copyFromBuilder(signalsToFetch);
        }

        @Override
        public final Builder signalsToFetch(Collection<SignalFetchInformation> signalsToFetch) {
            this.signalsToFetch = SignalFetchInformationListCopier.copy(signalsToFetch);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder signalsToFetch(SignalFetchInformation... signalsToFetch) {
            signalsToFetch(Arrays.asList(signalsToFetch));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder signalsToFetch(Consumer<SignalFetchInformation.Builder>... signalsToFetch) {
            signalsToFetch(Stream.of(signalsToFetch).map(c -> SignalFetchInformation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetCampaignResponse build() {
            return new GetCampaignResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
