/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetVehicleResponse extends IoTFleetWiseResponse implements
        ToCopyableBuilder<GetVehicleResponse.Builder, GetVehicleResponse> {
    private static final SdkField<String> VEHICLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vehicleName").getter(getter(GetVehicleResponse::vehicleName)).setter(setter(Builder::vehicleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vehicleName").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(GetVehicleResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> MODEL_MANIFEST_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelManifestArn").getter(getter(GetVehicleResponse::modelManifestArn))
            .setter(setter(Builder::modelManifestArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelManifestArn").build()).build();

    private static final SdkField<String> DECODER_MANIFEST_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("decoderManifestArn").getter(getter(GetVehicleResponse::decoderManifestArn))
            .setter(setter(Builder::decoderManifestArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decoderManifestArn").build())
            .build();

    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("attributes")
            .getter(getter(GetVehicleResponse::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<StateTemplateAssociation>> STATE_TEMPLATES_FIELD = SdkField
            .<List<StateTemplateAssociation>> builder(MarshallingType.LIST)
            .memberName("stateTemplates")
            .getter(getter(GetVehicleResponse::stateTemplates))
            .setter(setter(Builder::stateTemplates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateTemplates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StateTemplateAssociation> builder(MarshallingType.SDK_POJO)
                                            .constructor(StateTemplateAssociation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(GetVehicleResponse::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModificationTime").getter(getter(GetVehicleResponse::lastModificationTime))
            .setter(setter(Builder::lastModificationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModificationTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VEHICLE_NAME_FIELD, ARN_FIELD,
            MODEL_MANIFEST_ARN_FIELD, DECODER_MANIFEST_ARN_FIELD, ATTRIBUTES_FIELD, STATE_TEMPLATES_FIELD, CREATION_TIME_FIELD,
            LAST_MODIFICATION_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String vehicleName;

    private final String arn;

    private final String modelManifestArn;

    private final String decoderManifestArn;

    private final Map<String, String> attributes;

    private final List<StateTemplateAssociation> stateTemplates;

    private final Instant creationTime;

    private final Instant lastModificationTime;

    private GetVehicleResponse(BuilderImpl builder) {
        super(builder);
        this.vehicleName = builder.vehicleName;
        this.arn = builder.arn;
        this.modelManifestArn = builder.modelManifestArn;
        this.decoderManifestArn = builder.decoderManifestArn;
        this.attributes = builder.attributes;
        this.stateTemplates = builder.stateTemplates;
        this.creationTime = builder.creationTime;
        this.lastModificationTime = builder.lastModificationTime;
    }

    /**
     * <p>
     * The ID of the vehicle.
     * </p>
     * 
     * @return The ID of the vehicle.
     */
    public final String vehicleName() {
        return vehicleName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the vehicle to retrieve information about.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the vehicle to retrieve information about.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The ARN of a vehicle model (model manifest) associated with the vehicle.
     * </p>
     * 
     * @return The ARN of a vehicle model (model manifest) associated with the vehicle.
     */
    public final String modelManifestArn() {
        return modelManifestArn;
    }

    /**
     * <p>
     * The ARN of a decoder manifest associated with the vehicle.
     * </p>
     * 
     * @return The ARN of a decoder manifest associated with the vehicle.
     */
    public final String decoderManifestArn() {
        return decoderManifestArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attributes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Static information about a vehicle in a key-value pair. For example:
     * </p>
     * <p>
     * <code>"engineType"</code> : <code>"1.3 L R2"</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributes} method.
     * </p>
     * 
     * @return Static information about a vehicle in a key-value pair. For example:</p>
     *         <p>
     *         <code>"engineType"</code> : <code>"1.3 L R2"</code>
     */
    public final Map<String, String> attributes() {
        return attributes;
    }

    /**
     * For responses, this returns true if the service returned a value for the StateTemplates property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStateTemplates() {
        return stateTemplates != null && !(stateTemplates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * State templates associated with the vehicle.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStateTemplates} method.
     * </p>
     * 
     * @return State templates associated with the vehicle.
     */
    public final List<StateTemplateAssociation> stateTemplates() {
        return stateTemplates;
    }

    /**
     * <p>
     * The time the vehicle was created in seconds since epoch (January 1, 1970 at midnight UTC time).
     * </p>
     * 
     * @return The time the vehicle was created in seconds since epoch (January 1, 1970 at midnight UTC time).
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time the vehicle was last updated in seconds since epoch (January 1, 1970 at midnight UTC time).
     * </p>
     * 
     * @return The time the vehicle was last updated in seconds since epoch (January 1, 1970 at midnight UTC time).
     */
    public final Instant lastModificationTime() {
        return lastModificationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vehicleName());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(modelManifestArn());
        hashCode = 31 * hashCode + Objects.hashCode(decoderManifestArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStateTemplates() ? stateTemplates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModificationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetVehicleResponse)) {
            return false;
        }
        GetVehicleResponse other = (GetVehicleResponse) obj;
        return Objects.equals(vehicleName(), other.vehicleName()) && Objects.equals(arn(), other.arn())
                && Objects.equals(modelManifestArn(), other.modelManifestArn())
                && Objects.equals(decoderManifestArn(), other.decoderManifestArn()) && hasAttributes() == other.hasAttributes()
                && Objects.equals(attributes(), other.attributes()) && hasStateTemplates() == other.hasStateTemplates()
                && Objects.equals(stateTemplates(), other.stateTemplates())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModificationTime(), other.lastModificationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetVehicleResponse").add("VehicleName", vehicleName()).add("Arn", arn())
                .add("ModelManifestArn", modelManifestArn()).add("DecoderManifestArn", decoderManifestArn())
                .add("Attributes", hasAttributes() ? attributes() : null)
                .add("StateTemplates", hasStateTemplates() ? stateTemplates() : null).add("CreationTime", creationTime())
                .add("LastModificationTime", lastModificationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "vehicleName":
            return Optional.ofNullable(clazz.cast(vehicleName()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "modelManifestArn":
            return Optional.ofNullable(clazz.cast(modelManifestArn()));
        case "decoderManifestArn":
            return Optional.ofNullable(clazz.cast(decoderManifestArn()));
        case "attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "stateTemplates":
            return Optional.ofNullable(clazz.cast(stateTemplates()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "lastModificationTime":
            return Optional.ofNullable(clazz.cast(lastModificationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("vehicleName", VEHICLE_NAME_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("modelManifestArn", MODEL_MANIFEST_ARN_FIELD);
        map.put("decoderManifestArn", DECODER_MANIFEST_ARN_FIELD);
        map.put("attributes", ATTRIBUTES_FIELD);
        map.put("stateTemplates", STATE_TEMPLATES_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("lastModificationTime", LAST_MODIFICATION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetVehicleResponse, T> g) {
        return obj -> g.apply((GetVehicleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IoTFleetWiseResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetVehicleResponse> {
        /**
         * <p>
         * The ID of the vehicle.
         * </p>
         * 
         * @param vehicleName
         *        The ID of the vehicle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vehicleName(String vehicleName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the vehicle to retrieve information about.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the vehicle to retrieve information about.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The ARN of a vehicle model (model manifest) associated with the vehicle.
         * </p>
         * 
         * @param modelManifestArn
         *        The ARN of a vehicle model (model manifest) associated with the vehicle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelManifestArn(String modelManifestArn);

        /**
         * <p>
         * The ARN of a decoder manifest associated with the vehicle.
         * </p>
         * 
         * @param decoderManifestArn
         *        The ARN of a decoder manifest associated with the vehicle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decoderManifestArn(String decoderManifestArn);

        /**
         * <p>
         * Static information about a vehicle in a key-value pair. For example:
         * </p>
         * <p>
         * <code>"engineType"</code> : <code>"1.3 L R2"</code>
         * </p>
         * 
         * @param attributes
         *        Static information about a vehicle in a key-value pair. For example:</p>
         *        <p>
         *        <code>"engineType"</code> : <code>"1.3 L R2"</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        /**
         * <p>
         * State templates associated with the vehicle.
         * </p>
         * 
         * @param stateTemplates
         *        State templates associated with the vehicle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateTemplates(Collection<StateTemplateAssociation> stateTemplates);

        /**
         * <p>
         * State templates associated with the vehicle.
         * </p>
         * 
         * @param stateTemplates
         *        State templates associated with the vehicle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateTemplates(StateTemplateAssociation... stateTemplates);

        /**
         * <p>
         * State templates associated with the vehicle.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotfleetwise.model.StateTemplateAssociation.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.iotfleetwise.model.StateTemplateAssociation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotfleetwise.model.StateTemplateAssociation.Builder#build()} is called
         * immediately and its result is passed to {@link #stateTemplates(List<StateTemplateAssociation>)}.
         * 
         * @param stateTemplates
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotfleetwise.model.StateTemplateAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stateTemplates(java.util.Collection<StateTemplateAssociation>)
         */
        Builder stateTemplates(Consumer<StateTemplateAssociation.Builder>... stateTemplates);

        /**
         * <p>
         * The time the vehicle was created in seconds since epoch (January 1, 1970 at midnight UTC time).
         * </p>
         * 
         * @param creationTime
         *        The time the vehicle was created in seconds since epoch (January 1, 1970 at midnight UTC time).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time the vehicle was last updated in seconds since epoch (January 1, 1970 at midnight UTC time).
         * </p>
         * 
         * @param lastModificationTime
         *        The time the vehicle was last updated in seconds since epoch (January 1, 1970 at midnight UTC time).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModificationTime(Instant lastModificationTime);
    }

    static final class BuilderImpl extends IoTFleetWiseResponse.BuilderImpl implements Builder {
        private String vehicleName;

        private String arn;

        private String modelManifestArn;

        private String decoderManifestArn;

        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private List<StateTemplateAssociation> stateTemplates = DefaultSdkAutoConstructList.getInstance();

        private Instant creationTime;

        private Instant lastModificationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetVehicleResponse model) {
            super(model);
            vehicleName(model.vehicleName);
            arn(model.arn);
            modelManifestArn(model.modelManifestArn);
            decoderManifestArn(model.decoderManifestArn);
            attributes(model.attributes);
            stateTemplates(model.stateTemplates);
            creationTime(model.creationTime);
            lastModificationTime(model.lastModificationTime);
        }

        public final String getVehicleName() {
            return vehicleName;
        }

        public final void setVehicleName(String vehicleName) {
            this.vehicleName = vehicleName;
        }

        @Override
        public final Builder vehicleName(String vehicleName) {
            this.vehicleName = vehicleName;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getModelManifestArn() {
            return modelManifestArn;
        }

        public final void setModelManifestArn(String modelManifestArn) {
            this.modelManifestArn = modelManifestArn;
        }

        @Override
        public final Builder modelManifestArn(String modelManifestArn) {
            this.modelManifestArn = modelManifestArn;
            return this;
        }

        public final String getDecoderManifestArn() {
            return decoderManifestArn;
        }

        public final void setDecoderManifestArn(String decoderManifestArn) {
            this.decoderManifestArn = decoderManifestArn;
        }

        @Override
        public final Builder decoderManifestArn(String decoderManifestArn) {
            this.decoderManifestArn = decoderManifestArn;
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = _attributesMapCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = _attributesMapCopier.copy(attributes);
            return this;
        }

        public final List<StateTemplateAssociation.Builder> getStateTemplates() {
            List<StateTemplateAssociation.Builder> result = StateTemplateAssociationsCopier.copyToBuilder(this.stateTemplates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStateTemplates(Collection<StateTemplateAssociation.BuilderImpl> stateTemplates) {
            this.stateTemplates = StateTemplateAssociationsCopier.copyFromBuilder(stateTemplates);
        }

        @Override
        public final Builder stateTemplates(Collection<StateTemplateAssociation> stateTemplates) {
            this.stateTemplates = StateTemplateAssociationsCopier.copy(stateTemplates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stateTemplates(StateTemplateAssociation... stateTemplates) {
            stateTemplates(Arrays.asList(stateTemplates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stateTemplates(Consumer<StateTemplateAssociation.Builder>... stateTemplates) {
            stateTemplates(Stream.of(stateTemplates).map(c -> StateTemplateAssociation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModificationTime() {
            return lastModificationTime;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        @Override
        public GetVehicleResponse build() {
            return new GetVehicleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
