/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A reason that a signal decoder isn't valid.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvalidSignalDecoder implements SdkPojo, Serializable,
        ToCopyableBuilder<InvalidSignalDecoder.Builder, InvalidSignalDecoder> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(InvalidSignalDecoder::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("reason")
            .getter(getter(InvalidSignalDecoder::reasonAsString)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()).build();

    private static final SdkField<String> HINT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("hint")
            .getter(getter(InvalidSignalDecoder::hint)).setter(setter(Builder::hint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hint").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, REASON_FIELD,
            HINT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String reason;

    private final String hint;

    private InvalidSignalDecoder(BuilderImpl builder) {
        this.name = builder.name;
        this.reason = builder.reason;
        this.hint = builder.hint;
    }

    /**
     * <p>
     * The name of a signal decoder that isn't valid.
     * </p>
     * 
     * @return The name of a signal decoder that isn't valid.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A message about why the signal decoder isn't valid.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link SignalDecoderFailureReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #reasonAsString}.
     * </p>
     * 
     * @return A message about why the signal decoder isn't valid.
     * @see SignalDecoderFailureReason
     */
    public final SignalDecoderFailureReason reason() {
        return SignalDecoderFailureReason.fromValue(reason);
    }

    /**
     * <p>
     * A message about why the signal decoder isn't valid.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link SignalDecoderFailureReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #reasonAsString}.
     * </p>
     * 
     * @return A message about why the signal decoder isn't valid.
     * @see SignalDecoderFailureReason
     */
    public final String reasonAsString() {
        return reason;
    }

    /**
     * <p>
     * The possible cause for the invalid signal decoder.
     * </p>
     * 
     * @return The possible cause for the invalid signal decoder.
     */
    public final String hint() {
        return hint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(reasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvalidSignalDecoder)) {
            return false;
        }
        InvalidSignalDecoder other = (InvalidSignalDecoder) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(reasonAsString(), other.reasonAsString())
                && Objects.equals(hint(), other.hint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InvalidSignalDecoder").add("Name", name()).add("Reason", reasonAsString()).add("Hint", hint())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "reason":
            return Optional.ofNullable(clazz.cast(reasonAsString()));
        case "hint":
            return Optional.ofNullable(clazz.cast(hint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("reason", REASON_FIELD);
        map.put("hint", HINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvalidSignalDecoder, T> g) {
        return obj -> g.apply((InvalidSignalDecoder) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InvalidSignalDecoder> {
        /**
         * <p>
         * The name of a signal decoder that isn't valid.
         * </p>
         * 
         * @param name
         *        The name of a signal decoder that isn't valid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A message about why the signal decoder isn't valid.
         * </p>
         * 
         * @param reason
         *        A message about why the signal decoder isn't valid.
         * @see SignalDecoderFailureReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SignalDecoderFailureReason
         */
        Builder reason(String reason);

        /**
         * <p>
         * A message about why the signal decoder isn't valid.
         * </p>
         * 
         * @param reason
         *        A message about why the signal decoder isn't valid.
         * @see SignalDecoderFailureReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SignalDecoderFailureReason
         */
        Builder reason(SignalDecoderFailureReason reason);

        /**
         * <p>
         * The possible cause for the invalid signal decoder.
         * </p>
         * 
         * @param hint
         *        The possible cause for the invalid signal decoder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hint(String hint);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String reason;

        private String hint;

        private BuilderImpl() {
        }

        private BuilderImpl(InvalidSignalDecoder model) {
            name(model.name);
            reason(model.reason);
            hint(model.hint);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(SignalDecoderFailureReason reason) {
            this.reason(reason == null ? null : reason.toString());
            return this;
        }

        public final String getHint() {
            return hint;
        }

        public final void setHint(String hint) {
            this.hint = hint;
        }

        @Override
        public final Builder hint(String hint) {
            this.hint = hint;
            return this;
        }

        @Override
        public InvalidSignalDecoder build() {
            return new InvalidSignalDecoder(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
