/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCampaignsResponse extends IoTFleetWiseResponse implements
        ToCopyableBuilder<ListCampaignsResponse.Builder, ListCampaignsResponse> {
    private static final SdkField<List<CampaignSummary>> CAMPAIGN_SUMMARIES_FIELD = SdkField
            .<List<CampaignSummary>> builder(MarshallingType.LIST)
            .memberName("campaignSummaries")
            .getter(getter(ListCampaignsResponse::campaignSummaries))
            .setter(setter(Builder::campaignSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("campaignSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CampaignSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(CampaignSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListCampaignsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAMPAIGN_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<CampaignSummary> campaignSummaries;

    private final String nextToken;

    private ListCampaignsResponse(BuilderImpl builder) {
        super(builder);
        this.campaignSummaries = builder.campaignSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the CampaignSummaries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCampaignSummaries() {
        return campaignSummaries != null && !(campaignSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A summary of information about each campaign.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCampaignSummaries} method.
     * </p>
     * 
     * @return A summary of information about each campaign.
     */
    public final List<CampaignSummary> campaignSummaries() {
        return campaignSummaries;
    }

    /**
     * <p>
     * The token to retrieve the next set of results, or <code>null</code> if there are no more results.
     * </p>
     * 
     * @return The token to retrieve the next set of results, or <code>null</code> if there are no more results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCampaignSummaries() ? campaignSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCampaignsResponse)) {
            return false;
        }
        ListCampaignsResponse other = (ListCampaignsResponse) obj;
        return hasCampaignSummaries() == other.hasCampaignSummaries()
                && Objects.equals(campaignSummaries(), other.campaignSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCampaignsResponse")
                .add("CampaignSummaries", hasCampaignSummaries() ? campaignSummaries() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "campaignSummaries":
            return Optional.ofNullable(clazz.cast(campaignSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("campaignSummaries", CAMPAIGN_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCampaignsResponse, T> g) {
        return obj -> g.apply((ListCampaignsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IoTFleetWiseResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListCampaignsResponse> {
        /**
         * <p>
         * A summary of information about each campaign.
         * </p>
         * 
         * @param campaignSummaries
         *        A summary of information about each campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder campaignSummaries(Collection<CampaignSummary> campaignSummaries);

        /**
         * <p>
         * A summary of information about each campaign.
         * </p>
         * 
         * @param campaignSummaries
         *        A summary of information about each campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder campaignSummaries(CampaignSummary... campaignSummaries);

        /**
         * <p>
         * A summary of information about each campaign.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotfleetwise.model.CampaignSummary.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.iotfleetwise.model.CampaignSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotfleetwise.model.CampaignSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #campaignSummaries(List<CampaignSummary>)}.
         * 
         * @param campaignSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotfleetwise.model.CampaignSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #campaignSummaries(java.util.Collection<CampaignSummary>)
         */
        Builder campaignSummaries(Consumer<CampaignSummary.Builder>... campaignSummaries);

        /**
         * <p>
         * The token to retrieve the next set of results, or <code>null</code> if there are no more results.
         * </p>
         * 
         * @param nextToken
         *        The token to retrieve the next set of results, or <code>null</code> if there are no more results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IoTFleetWiseResponse.BuilderImpl implements Builder {
        private List<CampaignSummary> campaignSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCampaignsResponse model) {
            super(model);
            campaignSummaries(model.campaignSummaries);
            nextToken(model.nextToken);
        }

        public final List<CampaignSummary.Builder> getCampaignSummaries() {
            List<CampaignSummary.Builder> result = _campaignSummariesCopier.copyToBuilder(this.campaignSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCampaignSummaries(Collection<CampaignSummary.BuilderImpl> campaignSummaries) {
            this.campaignSummaries = _campaignSummariesCopier.copyFromBuilder(campaignSummaries);
        }

        @Override
        public final Builder campaignSummaries(Collection<CampaignSummary> campaignSummaries) {
            this.campaignSummaries = _campaignSummariesCopier.copy(campaignSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder campaignSummaries(CampaignSummary... campaignSummaries) {
            campaignSummaries(Arrays.asList(campaignSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder campaignSummaries(Consumer<CampaignSummary.Builder>... campaignSummaries) {
            campaignSummaries(Stream.of(campaignSummaries).map(c -> CampaignSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCampaignsResponse build() {
            return new ListCampaignsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
