/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The MQTT topic to which the Amazon Web Services IoT FleetWise campaign routes data. For more information, see <a
 * href="https://docs.aws.amazon.com/iot/latest/developerguide/protocols.html">Device communication protocols</a> in the
 * <i>Amazon Web Services IoT Core Developer Guide</i>.
 * </p>
 * <important>
 * <p>
 * Access to certain Amazon Web Services IoT FleetWise features is currently gated. For more information, see <a
 * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/fleetwise-regions.html">Amazon Web Services
 * Region and feature availability</a> in the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.
 * </p>
 * </important>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MqttTopicConfig implements SdkPojo, Serializable, ToCopyableBuilder<MqttTopicConfig.Builder, MqttTopicConfig> {
    private static final SdkField<String> MQTT_TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mqttTopicArn").getter(getter(MqttTopicConfig::mqttTopicArn)).setter(setter(Builder::mqttTopicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mqttTopicArn").build()).build();

    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionRoleArn").getter(getter(MqttTopicConfig::executionRoleArn))
            .setter(setter(Builder::executionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MQTT_TOPIC_ARN_FIELD,
            EXECUTION_ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String mqttTopicArn;

    private final String executionRoleArn;

    private MqttTopicConfig(BuilderImpl builder) {
        this.mqttTopicArn = builder.mqttTopicArn;
        this.executionRoleArn = builder.executionRoleArn;
    }

    /**
     * <p>
     * The ARN of the MQTT topic.
     * </p>
     * 
     * @return The ARN of the MQTT topic.
     */
    public final String mqttTopicArn() {
        return mqttTopicArn;
    }

    /**
     * <p>
     * The ARN of the role that grants Amazon Web Services IoT FleetWise permission to access and act on messages sent
     * to the MQTT topic.
     * </p>
     * 
     * @return The ARN of the role that grants Amazon Web Services IoT FleetWise permission to access and act on
     *         messages sent to the MQTT topic.
     */
    public final String executionRoleArn() {
        return executionRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mqttTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MqttTopicConfig)) {
            return false;
        }
        MqttTopicConfig other = (MqttTopicConfig) obj;
        return Objects.equals(mqttTopicArn(), other.mqttTopicArn())
                && Objects.equals(executionRoleArn(), other.executionRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MqttTopicConfig").add("MqttTopicArn", mqttTopicArn())
                .add("ExecutionRoleArn", executionRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "mqttTopicArn":
            return Optional.ofNullable(clazz.cast(mqttTopicArn()));
        case "executionRoleArn":
            return Optional.ofNullable(clazz.cast(executionRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("mqttTopicArn", MQTT_TOPIC_ARN_FIELD);
        map.put("executionRoleArn", EXECUTION_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MqttTopicConfig, T> g) {
        return obj -> g.apply((MqttTopicConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MqttTopicConfig> {
        /**
         * <p>
         * The ARN of the MQTT topic.
         * </p>
         * 
         * @param mqttTopicArn
         *        The ARN of the MQTT topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mqttTopicArn(String mqttTopicArn);

        /**
         * <p>
         * The ARN of the role that grants Amazon Web Services IoT FleetWise permission to access and act on messages
         * sent to the MQTT topic.
         * </p>
         * 
         * @param executionRoleArn
         *        The ARN of the role that grants Amazon Web Services IoT FleetWise permission to access and act on
         *        messages sent to the MQTT topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleArn(String executionRoleArn);
    }

    static final class BuilderImpl implements Builder {
        private String mqttTopicArn;

        private String executionRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(MqttTopicConfig model) {
            mqttTopicArn(model.mqttTopicArn);
            executionRoleArn(model.executionRoleArn);
        }

        public final String getMqttTopicArn() {
            return mqttTopicArn;
        }

        public final void setMqttTopicArn(String mqttTopicArn) {
            this.mqttTopicArn = mqttTopicArn;
        }

        @Override
        public final Builder mqttTopicArn(String mqttTopicArn) {
            this.mqttTopicArn = mqttTopicArn;
            return this;
        }

        public final String getExecutionRoleArn() {
            return executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        @Override
        public MqttTopicConfig build() {
            return new MqttTopicConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
