/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a primitive type node of the complex data structure.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PrimitiveMessageDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<PrimitiveMessageDefinition.Builder, PrimitiveMessageDefinition> {
    private static final SdkField<ROS2PrimitiveMessageDefinition> ROS2_PRIMITIVE_MESSAGE_DEFINITION_FIELD = SdkField
            .<ROS2PrimitiveMessageDefinition> builder(MarshallingType.SDK_POJO)
            .memberName("ros2PrimitiveMessageDefinition")
            .getter(getter(PrimitiveMessageDefinition::ros2PrimitiveMessageDefinition))
            .setter(setter(Builder::ros2PrimitiveMessageDefinition))
            .constructor(ROS2PrimitiveMessageDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ros2PrimitiveMessageDefinition")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ROS2_PRIMITIVE_MESSAGE_DEFINITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ROS2PrimitiveMessageDefinition ros2PrimitiveMessageDefinition;

    private final Type type;

    private PrimitiveMessageDefinition(BuilderImpl builder) {
        this.ros2PrimitiveMessageDefinition = builder.ros2PrimitiveMessageDefinition;
        this.type = builder.type;
    }

    /**
     * <p>
     * Information about a <code>PrimitiveMessage</code> using a ROS 2 compliant primitive type message of the complex
     * data structure.
     * </p>
     * 
     * @return Information about a <code>PrimitiveMessage</code> using a ROS 2 compliant primitive type message of the
     *         complex data structure.
     */
    public final ROS2PrimitiveMessageDefinition ros2PrimitiveMessageDefinition() {
        return ros2PrimitiveMessageDefinition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ros2PrimitiveMessageDefinition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrimitiveMessageDefinition)) {
            return false;
        }
        PrimitiveMessageDefinition other = (PrimitiveMessageDefinition) obj;
        return Objects.equals(ros2PrimitiveMessageDefinition(), other.ros2PrimitiveMessageDefinition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PrimitiveMessageDefinition")
                .add("Ros2PrimitiveMessageDefinition", ros2PrimitiveMessageDefinition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ros2PrimitiveMessageDefinition":
            return Optional.ofNullable(clazz.cast(ros2PrimitiveMessageDefinition()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #ros2PrimitiveMessageDefinition()} initialized to the given value.
     *
     * <p>
     * Information about a <code>PrimitiveMessage</code> using a ROS 2 compliant primitive type message of the complex
     * data structure.
     * </p>
     * 
     * @param ros2PrimitiveMessageDefinition
     *        Information about a <code>PrimitiveMessage</code> using a ROS 2 compliant primitive type message of the
     *        complex data structure.
     */
    public static PrimitiveMessageDefinition fromRos2PrimitiveMessageDefinition(
            ROS2PrimitiveMessageDefinition ros2PrimitiveMessageDefinition) {
        return builder().ros2PrimitiveMessageDefinition(ros2PrimitiveMessageDefinition).build();
    }

    /**
     * Create an instance of this class with {@link #ros2PrimitiveMessageDefinition()} initialized to the given value.
     *
     * <p>
     * Information about a <code>PrimitiveMessage</code> using a ROS 2 compliant primitive type message of the complex
     * data structure.
     * </p>
     * 
     * @param ros2PrimitiveMessageDefinition
     *        Information about a <code>PrimitiveMessage</code> using a ROS 2 compliant primitive type message of the
     *        complex data structure.
     */
    public static PrimitiveMessageDefinition fromRos2PrimitiveMessageDefinition(
            Consumer<ROS2PrimitiveMessageDefinition.Builder> ros2PrimitiveMessageDefinition) {
        ROS2PrimitiveMessageDefinition.Builder builder = ROS2PrimitiveMessageDefinition.builder();
        ros2PrimitiveMessageDefinition.accept(builder);
        return fromRos2PrimitiveMessageDefinition(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ros2PrimitiveMessageDefinition", ROS2_PRIMITIVE_MESSAGE_DEFINITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PrimitiveMessageDefinition, T> g) {
        return obj -> g.apply((PrimitiveMessageDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PrimitiveMessageDefinition> {
        /**
         * <p>
         * Information about a <code>PrimitiveMessage</code> using a ROS 2 compliant primitive type message of the
         * complex data structure.
         * </p>
         * 
         * @param ros2PrimitiveMessageDefinition
         *        Information about a <code>PrimitiveMessage</code> using a ROS 2 compliant primitive type message of
         *        the complex data structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ros2PrimitiveMessageDefinition(ROS2PrimitiveMessageDefinition ros2PrimitiveMessageDefinition);

        /**
         * <p>
         * Information about a <code>PrimitiveMessage</code> using a ROS 2 compliant primitive type message of the
         * complex data structure.
         * </p>
         * This is a convenience method that creates an instance of the {@link ROS2PrimitiveMessageDefinition.Builder}
         * avoiding the need to create one manually via {@link ROS2PrimitiveMessageDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ROS2PrimitiveMessageDefinition.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #ros2PrimitiveMessageDefinition(ROS2PrimitiveMessageDefinition)}.
         * 
         * @param ros2PrimitiveMessageDefinition
         *        a consumer that will call methods on {@link ROS2PrimitiveMessageDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ros2PrimitiveMessageDefinition(ROS2PrimitiveMessageDefinition)
         */
        default Builder ros2PrimitiveMessageDefinition(
                Consumer<ROS2PrimitiveMessageDefinition.Builder> ros2PrimitiveMessageDefinition) {
            return ros2PrimitiveMessageDefinition(ROS2PrimitiveMessageDefinition.builder()
                    .applyMutation(ros2PrimitiveMessageDefinition).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ROS2PrimitiveMessageDefinition ros2PrimitiveMessageDefinition;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(PrimitiveMessageDefinition model) {
            ros2PrimitiveMessageDefinition(model.ros2PrimitiveMessageDefinition);
        }

        public final ROS2PrimitiveMessageDefinition.Builder getRos2PrimitiveMessageDefinition() {
            return ros2PrimitiveMessageDefinition != null ? ros2PrimitiveMessageDefinition.toBuilder() : null;
        }

        public final void setRos2PrimitiveMessageDefinition(
                ROS2PrimitiveMessageDefinition.BuilderImpl ros2PrimitiveMessageDefinition) {
            Object oldValue = this.ros2PrimitiveMessageDefinition;
            this.ros2PrimitiveMessageDefinition = ros2PrimitiveMessageDefinition != null ? ros2PrimitiveMessageDefinition.build()
                    : null;
            handleUnionValueChange(Type.ROS2_PRIMITIVE_MESSAGE_DEFINITION, oldValue, this.ros2PrimitiveMessageDefinition);
        }

        @Override
        public final Builder ros2PrimitiveMessageDefinition(ROS2PrimitiveMessageDefinition ros2PrimitiveMessageDefinition) {
            Object oldValue = this.ros2PrimitiveMessageDefinition;
            this.ros2PrimitiveMessageDefinition = ros2PrimitiveMessageDefinition;
            handleUnionValueChange(Type.ROS2_PRIMITIVE_MESSAGE_DEFINITION, oldValue, this.ros2PrimitiveMessageDefinition);
            return this;
        }

        @Override
        public PrimitiveMessageDefinition build() {
            return new PrimitiveMessageDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see PrimitiveMessageDefinition#type()
     */
    public enum Type {
        ROS2_PRIMITIVE_MESSAGE_DEFINITION,

        UNKNOWN_TO_SDK_VERSION
    }
}
