/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of the signal fetch operation.
 * </p>
 * <important>
 * <p>
 * Access to certain Amazon Web Services IoT FleetWise features is currently gated. For more information, see <a
 * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/fleetwise-regions.html">Amazon Web Services
 * Region and feature availability</a> in the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.
 * </p>
 * </important>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SignalFetchConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<SignalFetchConfig.Builder, SignalFetchConfig> {
    private static final SdkField<TimeBasedSignalFetchConfig> TIME_BASED_FIELD = SdkField
            .<TimeBasedSignalFetchConfig> builder(MarshallingType.SDK_POJO).memberName("timeBased")
            .getter(getter(SignalFetchConfig::timeBased)).setter(setter(Builder::timeBased))
            .constructor(TimeBasedSignalFetchConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeBased").build()).build();

    private static final SdkField<ConditionBasedSignalFetchConfig> CONDITION_BASED_FIELD = SdkField
            .<ConditionBasedSignalFetchConfig> builder(MarshallingType.SDK_POJO).memberName("conditionBased")
            .getter(getter(SignalFetchConfig::conditionBased)).setter(setter(Builder::conditionBased))
            .constructor(ConditionBasedSignalFetchConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conditionBased").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_BASED_FIELD,
            CONDITION_BASED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final TimeBasedSignalFetchConfig timeBased;

    private final ConditionBasedSignalFetchConfig conditionBased;

    private final Type type;

    private SignalFetchConfig(BuilderImpl builder) {
        this.timeBased = builder.timeBased;
        this.conditionBased = builder.conditionBased;
        this.type = builder.type;
    }

    /**
     * <p>
     * The configuration of a time-based signal fetch operation.
     * </p>
     * 
     * @return The configuration of a time-based signal fetch operation.
     */
    public final TimeBasedSignalFetchConfig timeBased() {
        return timeBased;
    }

    /**
     * <p>
     * The configuration of a condition-based signal fetch operation.
     * </p>
     * 
     * @return The configuration of a condition-based signal fetch operation.
     */
    public final ConditionBasedSignalFetchConfig conditionBased() {
        return conditionBased;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timeBased());
        hashCode = 31 * hashCode + Objects.hashCode(conditionBased());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SignalFetchConfig)) {
            return false;
        }
        SignalFetchConfig other = (SignalFetchConfig) obj;
        return Objects.equals(timeBased(), other.timeBased()) && Objects.equals(conditionBased(), other.conditionBased());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SignalFetchConfig").add("TimeBased", timeBased()).add("ConditionBased", conditionBased())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "timeBased":
            return Optional.ofNullable(clazz.cast(timeBased()));
        case "conditionBased":
            return Optional.ofNullable(clazz.cast(conditionBased()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #timeBased()} initialized to the given value.
     *
     * <p>
     * The configuration of a time-based signal fetch operation.
     * </p>
     * 
     * @param timeBased
     *        The configuration of a time-based signal fetch operation.
     */
    public static SignalFetchConfig fromTimeBased(TimeBasedSignalFetchConfig timeBased) {
        return builder().timeBased(timeBased).build();
    }

    /**
     * Create an instance of this class with {@link #timeBased()} initialized to the given value.
     *
     * <p>
     * The configuration of a time-based signal fetch operation.
     * </p>
     * 
     * @param timeBased
     *        The configuration of a time-based signal fetch operation.
     */
    public static SignalFetchConfig fromTimeBased(Consumer<TimeBasedSignalFetchConfig.Builder> timeBased) {
        TimeBasedSignalFetchConfig.Builder builder = TimeBasedSignalFetchConfig.builder();
        timeBased.accept(builder);
        return fromTimeBased(builder.build());
    }

    /**
     * Create an instance of this class with {@link #conditionBased()} initialized to the given value.
     *
     * <p>
     * The configuration of a condition-based signal fetch operation.
     * </p>
     * 
     * @param conditionBased
     *        The configuration of a condition-based signal fetch operation.
     */
    public static SignalFetchConfig fromConditionBased(ConditionBasedSignalFetchConfig conditionBased) {
        return builder().conditionBased(conditionBased).build();
    }

    /**
     * Create an instance of this class with {@link #conditionBased()} initialized to the given value.
     *
     * <p>
     * The configuration of a condition-based signal fetch operation.
     * </p>
     * 
     * @param conditionBased
     *        The configuration of a condition-based signal fetch operation.
     */
    public static SignalFetchConfig fromConditionBased(Consumer<ConditionBasedSignalFetchConfig.Builder> conditionBased) {
        ConditionBasedSignalFetchConfig.Builder builder = ConditionBasedSignalFetchConfig.builder();
        conditionBased.accept(builder);
        return fromConditionBased(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("timeBased", TIME_BASED_FIELD);
        map.put("conditionBased", CONDITION_BASED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SignalFetchConfig, T> g) {
        return obj -> g.apply((SignalFetchConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SignalFetchConfig> {
        /**
         * <p>
         * The configuration of a time-based signal fetch operation.
         * </p>
         * 
         * @param timeBased
         *        The configuration of a time-based signal fetch operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeBased(TimeBasedSignalFetchConfig timeBased);

        /**
         * <p>
         * The configuration of a time-based signal fetch operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link TimeBasedSignalFetchConfig.Builder}
         * avoiding the need to create one manually via {@link TimeBasedSignalFetchConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimeBasedSignalFetchConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #timeBased(TimeBasedSignalFetchConfig)}.
         * 
         * @param timeBased
         *        a consumer that will call methods on {@link TimeBasedSignalFetchConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeBased(TimeBasedSignalFetchConfig)
         */
        default Builder timeBased(Consumer<TimeBasedSignalFetchConfig.Builder> timeBased) {
            return timeBased(TimeBasedSignalFetchConfig.builder().applyMutation(timeBased).build());
        }

        /**
         * <p>
         * The configuration of a condition-based signal fetch operation.
         * </p>
         * 
         * @param conditionBased
         *        The configuration of a condition-based signal fetch operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditionBased(ConditionBasedSignalFetchConfig conditionBased);

        /**
         * <p>
         * The configuration of a condition-based signal fetch operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConditionBasedSignalFetchConfig.Builder}
         * avoiding the need to create one manually via {@link ConditionBasedSignalFetchConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConditionBasedSignalFetchConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #conditionBased(ConditionBasedSignalFetchConfig)}.
         * 
         * @param conditionBased
         *        a consumer that will call methods on {@link ConditionBasedSignalFetchConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conditionBased(ConditionBasedSignalFetchConfig)
         */
        default Builder conditionBased(Consumer<ConditionBasedSignalFetchConfig.Builder> conditionBased) {
            return conditionBased(ConditionBasedSignalFetchConfig.builder().applyMutation(conditionBased).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TimeBasedSignalFetchConfig timeBased;

        private ConditionBasedSignalFetchConfig conditionBased;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(SignalFetchConfig model) {
            timeBased(model.timeBased);
            conditionBased(model.conditionBased);
        }

        public final TimeBasedSignalFetchConfig.Builder getTimeBased() {
            return timeBased != null ? timeBased.toBuilder() : null;
        }

        public final void setTimeBased(TimeBasedSignalFetchConfig.BuilderImpl timeBased) {
            Object oldValue = this.timeBased;
            this.timeBased = timeBased != null ? timeBased.build() : null;
            handleUnionValueChange(Type.TIME_BASED, oldValue, this.timeBased);
        }

        @Override
        public final Builder timeBased(TimeBasedSignalFetchConfig timeBased) {
            Object oldValue = this.timeBased;
            this.timeBased = timeBased;
            handleUnionValueChange(Type.TIME_BASED, oldValue, this.timeBased);
            return this;
        }

        public final ConditionBasedSignalFetchConfig.Builder getConditionBased() {
            return conditionBased != null ? conditionBased.toBuilder() : null;
        }

        public final void setConditionBased(ConditionBasedSignalFetchConfig.BuilderImpl conditionBased) {
            Object oldValue = this.conditionBased;
            this.conditionBased = conditionBased != null ? conditionBased.build() : null;
            handleUnionValueChange(Type.CONDITION_BASED, oldValue, this.conditionBased);
        }

        @Override
        public final Builder conditionBased(ConditionBasedSignalFetchConfig conditionBased) {
            Object oldValue = this.conditionBased;
            this.conditionBased = conditionBased;
            handleUnionValueChange(Type.CONDITION_BASED, oldValue, this.conditionBased);
            return this;
        }

        @Override
        public SignalFetchConfig build() {
            return new SignalFetchConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see SignalFetchConfig#type()
     */
    public enum Type {
        TIME_BASED,

        CONDITION_BASED,

        UNKNOWN_TO_SDK_VERSION
    }
}
