/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The update strategy for the state template. Vehicles associated with the state template can stream telemetry data
 * with either an <code>onChange</code> or <code>periodic</code> update strategy.
 * </p>
 * <important>
 * <p>
 * Access to certain Amazon Web Services IoT FleetWise features is currently gated. For more information, see <a
 * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/fleetwise-regions.html">Amazon Web Services
 * Region and feature availability</a> in the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.
 * </p>
 * </important>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StateTemplateUpdateStrategy implements SdkPojo, Serializable,
        ToCopyableBuilder<StateTemplateUpdateStrategy.Builder, StateTemplateUpdateStrategy> {
    private static final SdkField<PeriodicStateTemplateUpdateStrategy> PERIODIC_FIELD = SdkField
            .<PeriodicStateTemplateUpdateStrategy> builder(MarshallingType.SDK_POJO).memberName("periodic")
            .getter(getter(StateTemplateUpdateStrategy::periodic)).setter(setter(Builder::periodic))
            .constructor(PeriodicStateTemplateUpdateStrategy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("periodic").build()).build();

    private static final SdkField<OnChangeStateTemplateUpdateStrategy> ON_CHANGE_FIELD = SdkField
            .<OnChangeStateTemplateUpdateStrategy> builder(MarshallingType.SDK_POJO).memberName("onChange")
            .getter(getter(StateTemplateUpdateStrategy::onChange)).setter(setter(Builder::onChange))
            .constructor(OnChangeStateTemplateUpdateStrategy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onChange").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERIODIC_FIELD,
            ON_CHANGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final PeriodicStateTemplateUpdateStrategy periodic;

    private final OnChangeStateTemplateUpdateStrategy onChange;

    private final Type type;

    private StateTemplateUpdateStrategy(BuilderImpl builder) {
        this.periodic = builder.periodic;
        this.onChange = builder.onChange;
        this.type = builder.type;
    }

    /**
     * Returns the value of the Periodic property for this object.
     * 
     * @return The value of the Periodic property for this object.
     */
    public final PeriodicStateTemplateUpdateStrategy periodic() {
        return periodic;
    }

    /**
     * Returns the value of the OnChange property for this object.
     * 
     * @return The value of the OnChange property for this object.
     */
    public final OnChangeStateTemplateUpdateStrategy onChange() {
        return onChange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(periodic());
        hashCode = 31 * hashCode + Objects.hashCode(onChange());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StateTemplateUpdateStrategy)) {
            return false;
        }
        StateTemplateUpdateStrategy other = (StateTemplateUpdateStrategy) obj;
        return Objects.equals(periodic(), other.periodic()) && Objects.equals(onChange(), other.onChange());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StateTemplateUpdateStrategy").add("Periodic", periodic()).add("OnChange", onChange()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "periodic":
            return Optional.ofNullable(clazz.cast(periodic()));
        case "onChange":
            return Optional.ofNullable(clazz.cast(onChange()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #periodic()} initialized to the given value.
     *
     * Sets the value of the Periodic property for this object.
     *
     * @param periodic
     *        The new value for the Periodic property for this object.
     */
    public static StateTemplateUpdateStrategy fromPeriodic(PeriodicStateTemplateUpdateStrategy periodic) {
        return builder().periodic(periodic).build();
    }

    /**
     * Create an instance of this class with {@link #periodic()} initialized to the given value.
     *
     * Sets the value of the Periodic property for this object.
     *
     * @param periodic
     *        The new value for the Periodic property for this object.
     */
    public static StateTemplateUpdateStrategy fromPeriodic(Consumer<PeriodicStateTemplateUpdateStrategy.Builder> periodic) {
        PeriodicStateTemplateUpdateStrategy.Builder builder = PeriodicStateTemplateUpdateStrategy.builder();
        periodic.accept(builder);
        return fromPeriodic(builder.build());
    }

    /**
     * Create an instance of this class with {@link #onChange()} initialized to the given value.
     *
     * Sets the value of the OnChange property for this object.
     *
     * @param onChange
     *        The new value for the OnChange property for this object.
     */
    public static StateTemplateUpdateStrategy fromOnChange(OnChangeStateTemplateUpdateStrategy onChange) {
        return builder().onChange(onChange).build();
    }

    /**
     * Create an instance of this class with {@link #onChange()} initialized to the given value.
     *
     * Sets the value of the OnChange property for this object.
     *
     * @param onChange
     *        The new value for the OnChange property for this object.
     */
    public static StateTemplateUpdateStrategy fromOnChange(Consumer<OnChangeStateTemplateUpdateStrategy.Builder> onChange) {
        OnChangeStateTemplateUpdateStrategy.Builder builder = OnChangeStateTemplateUpdateStrategy.builder();
        onChange.accept(builder);
        return fromOnChange(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("periodic", PERIODIC_FIELD);
        map.put("onChange", ON_CHANGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StateTemplateUpdateStrategy, T> g) {
        return obj -> g.apply((StateTemplateUpdateStrategy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StateTemplateUpdateStrategy> {
        /**
         * Sets the value of the Periodic property for this object.
         *
         * @param periodic
         *        The new value for the Periodic property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder periodic(PeriodicStateTemplateUpdateStrategy periodic);

        /**
         * Sets the value of the Periodic property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link PeriodicStateTemplateUpdateStrategy.Builder} avoiding the need to create one manually via
         * {@link PeriodicStateTemplateUpdateStrategy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PeriodicStateTemplateUpdateStrategy.Builder#build()} is called
         * immediately and its result is passed to {@link #periodic(PeriodicStateTemplateUpdateStrategy)}.
         * 
         * @param periodic
         *        a consumer that will call methods on {@link PeriodicStateTemplateUpdateStrategy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #periodic(PeriodicStateTemplateUpdateStrategy)
         */
        default Builder periodic(Consumer<PeriodicStateTemplateUpdateStrategy.Builder> periodic) {
            return periodic(PeriodicStateTemplateUpdateStrategy.builder().applyMutation(periodic).build());
        }

        /**
         * Sets the value of the OnChange property for this object.
         *
         * @param onChange
         *        The new value for the OnChange property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onChange(OnChangeStateTemplateUpdateStrategy onChange);

        /**
         * Sets the value of the OnChange property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link OnChangeStateTemplateUpdateStrategy.Builder} avoiding the need to create one manually via
         * {@link OnChangeStateTemplateUpdateStrategy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OnChangeStateTemplateUpdateStrategy.Builder#build()} is called
         * immediately and its result is passed to {@link #onChange(OnChangeStateTemplateUpdateStrategy)}.
         * 
         * @param onChange
         *        a consumer that will call methods on {@link OnChangeStateTemplateUpdateStrategy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #onChange(OnChangeStateTemplateUpdateStrategy)
         */
        default Builder onChange(Consumer<OnChangeStateTemplateUpdateStrategy.Builder> onChange) {
            return onChange(OnChangeStateTemplateUpdateStrategy.builder().applyMutation(onChange).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private PeriodicStateTemplateUpdateStrategy periodic;

        private OnChangeStateTemplateUpdateStrategy onChange;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(StateTemplateUpdateStrategy model) {
            periodic(model.periodic);
            onChange(model.onChange);
        }

        public final PeriodicStateTemplateUpdateStrategy.Builder getPeriodic() {
            return periodic != null ? periodic.toBuilder() : null;
        }

        public final void setPeriodic(PeriodicStateTemplateUpdateStrategy.BuilderImpl periodic) {
            Object oldValue = this.periodic;
            this.periodic = periodic != null ? periodic.build() : null;
            handleUnionValueChange(Type.PERIODIC, oldValue, this.periodic);
        }

        @Override
        public final Builder periodic(PeriodicStateTemplateUpdateStrategy periodic) {
            Object oldValue = this.periodic;
            this.periodic = periodic;
            handleUnionValueChange(Type.PERIODIC, oldValue, this.periodic);
            return this;
        }

        public final OnChangeStateTemplateUpdateStrategy.Builder getOnChange() {
            return onChange != null ? onChange.toBuilder() : null;
        }

        public final void setOnChange(OnChangeStateTemplateUpdateStrategy.BuilderImpl onChange) {
            Object oldValue = this.onChange;
            this.onChange = onChange != null ? onChange.build() : null;
            handleUnionValueChange(Type.ON_CHANGE, oldValue, this.onChange);
        }

        @Override
        public final Builder onChange(OnChangeStateTemplateUpdateStrategy onChange) {
            Object oldValue = this.onChange;
            this.onChange = onChange;
            handleUnionValueChange(Type.ON_CHANGE, oldValue, this.onChange);
            return this;
        }

        @Override
        public StateTemplateUpdateStrategy build() {
            return new StateTemplateUpdateStrategy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see StateTemplateUpdateStrategy#type()
     */
    public enum Type {
        PERIODIC,

        ON_CHANGE,

        UNKNOWN_TO_SDK_VERSION
    }
}
