/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the registered Amazon Timestream resources or errors, if any.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimestreamRegistrationResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<TimestreamRegistrationResponse.Builder, TimestreamRegistrationResponse> {
    private static final SdkField<String> TIMESTREAM_DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("timestreamDatabaseName").getter(getter(TimestreamRegistrationResponse::timestreamDatabaseName))
            .setter(setter(Builder::timestreamDatabaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestreamDatabaseName").build())
            .build();

    private static final SdkField<String> TIMESTREAM_TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("timestreamTableName").getter(getter(TimestreamRegistrationResponse::timestreamTableName))
            .setter(setter(Builder::timestreamTableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestreamTableName").build())
            .build();

    private static final SdkField<String> TIMESTREAM_DATABASE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("timestreamDatabaseArn").getter(getter(TimestreamRegistrationResponse::timestreamDatabaseArn))
            .setter(setter(Builder::timestreamDatabaseArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestreamDatabaseArn").build())
            .build();

    private static final SdkField<String> TIMESTREAM_TABLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("timestreamTableArn").getter(getter(TimestreamRegistrationResponse::timestreamTableArn))
            .setter(setter(Builder::timestreamTableArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestreamTableArn").build())
            .build();

    private static final SdkField<String> REGISTRATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registrationStatus").getter(getter(TimestreamRegistrationResponse::registrationStatusAsString))
            .setter(setter(Builder::registrationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registrationStatus").build())
            .build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorMessage").getter(getter(TimestreamRegistrationResponse::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TIMESTREAM_DATABASE_NAME_FIELD, TIMESTREAM_TABLE_NAME_FIELD, TIMESTREAM_DATABASE_ARN_FIELD,
            TIMESTREAM_TABLE_ARN_FIELD, REGISTRATION_STATUS_FIELD, ERROR_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String timestreamDatabaseName;

    private final String timestreamTableName;

    private final String timestreamDatabaseArn;

    private final String timestreamTableArn;

    private final String registrationStatus;

    private final String errorMessage;

    private TimestreamRegistrationResponse(BuilderImpl builder) {
        this.timestreamDatabaseName = builder.timestreamDatabaseName;
        this.timestreamTableName = builder.timestreamTableName;
        this.timestreamDatabaseArn = builder.timestreamDatabaseArn;
        this.timestreamTableArn = builder.timestreamTableArn;
        this.registrationStatus = builder.registrationStatus;
        this.errorMessage = builder.errorMessage;
    }

    /**
     * <p>
     * The name of the Timestream database.
     * </p>
     * 
     * @return The name of the Timestream database.
     */
    public final String timestreamDatabaseName() {
        return timestreamDatabaseName;
    }

    /**
     * <p>
     * The name of the Timestream database table.
     * </p>
     * 
     * @return The name of the Timestream database table.
     */
    public final String timestreamTableName() {
        return timestreamTableName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Timestream database.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Timestream database.
     */
    public final String timestreamDatabaseArn() {
        return timestreamDatabaseArn;
    }

    /**
     * <p>
     * The ARN of the Timestream database table.
     * </p>
     * 
     * @return The ARN of the Timestream database table.
     */
    public final String timestreamTableArn() {
        return timestreamTableArn;
    }

    /**
     * <p>
     * The status of registering your Amazon Timestream resources. The status can be one of
     * <code>REGISTRATION_SUCCESS</code>, <code>REGISTRATION_PENDING</code>, <code>REGISTRATION_FAILURE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #registrationStatus} will return {@link RegistrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #registrationStatusAsString}.
     * </p>
     * 
     * @return The status of registering your Amazon Timestream resources. The status can be one of
     *         <code>REGISTRATION_SUCCESS</code>, <code>REGISTRATION_PENDING</code>, <code>REGISTRATION_FAILURE</code>.
     * @see RegistrationStatus
     */
    public final RegistrationStatus registrationStatus() {
        return RegistrationStatus.fromValue(registrationStatus);
    }

    /**
     * <p>
     * The status of registering your Amazon Timestream resources. The status can be one of
     * <code>REGISTRATION_SUCCESS</code>, <code>REGISTRATION_PENDING</code>, <code>REGISTRATION_FAILURE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #registrationStatus} will return {@link RegistrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #registrationStatusAsString}.
     * </p>
     * 
     * @return The status of registering your Amazon Timestream resources. The status can be one of
     *         <code>REGISTRATION_SUCCESS</code>, <code>REGISTRATION_PENDING</code>, <code>REGISTRATION_FAILURE</code>.
     * @see RegistrationStatus
     */
    public final String registrationStatusAsString() {
        return registrationStatus;
    }

    /**
     * <p>
     * A message associated with a registration error.
     * </p>
     * 
     * @return A message associated with a registration error.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timestreamDatabaseName());
        hashCode = 31 * hashCode + Objects.hashCode(timestreamTableName());
        hashCode = 31 * hashCode + Objects.hashCode(timestreamDatabaseArn());
        hashCode = 31 * hashCode + Objects.hashCode(timestreamTableArn());
        hashCode = 31 * hashCode + Objects.hashCode(registrationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimestreamRegistrationResponse)) {
            return false;
        }
        TimestreamRegistrationResponse other = (TimestreamRegistrationResponse) obj;
        return Objects.equals(timestreamDatabaseName(), other.timestreamDatabaseName())
                && Objects.equals(timestreamTableName(), other.timestreamTableName())
                && Objects.equals(timestreamDatabaseArn(), other.timestreamDatabaseArn())
                && Objects.equals(timestreamTableArn(), other.timestreamTableArn())
                && Objects.equals(registrationStatusAsString(), other.registrationStatusAsString())
                && Objects.equals(errorMessage(), other.errorMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TimestreamRegistrationResponse").add("TimestreamDatabaseName", timestreamDatabaseName())
                .add("TimestreamTableName", timestreamTableName()).add("TimestreamDatabaseArn", timestreamDatabaseArn())
                .add("TimestreamTableArn", timestreamTableArn()).add("RegistrationStatus", registrationStatusAsString())
                .add("ErrorMessage", errorMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "timestreamDatabaseName":
            return Optional.ofNullable(clazz.cast(timestreamDatabaseName()));
        case "timestreamTableName":
            return Optional.ofNullable(clazz.cast(timestreamTableName()));
        case "timestreamDatabaseArn":
            return Optional.ofNullable(clazz.cast(timestreamDatabaseArn()));
        case "timestreamTableArn":
            return Optional.ofNullable(clazz.cast(timestreamTableArn()));
        case "registrationStatus":
            return Optional.ofNullable(clazz.cast(registrationStatusAsString()));
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("timestreamDatabaseName", TIMESTREAM_DATABASE_NAME_FIELD);
        map.put("timestreamTableName", TIMESTREAM_TABLE_NAME_FIELD);
        map.put("timestreamDatabaseArn", TIMESTREAM_DATABASE_ARN_FIELD);
        map.put("timestreamTableArn", TIMESTREAM_TABLE_ARN_FIELD);
        map.put("registrationStatus", REGISTRATION_STATUS_FIELD);
        map.put("errorMessage", ERROR_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TimestreamRegistrationResponse, T> g) {
        return obj -> g.apply((TimestreamRegistrationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimestreamRegistrationResponse> {
        /**
         * <p>
         * The name of the Timestream database.
         * </p>
         * 
         * @param timestreamDatabaseName
         *        The name of the Timestream database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestreamDatabaseName(String timestreamDatabaseName);

        /**
         * <p>
         * The name of the Timestream database table.
         * </p>
         * 
         * @param timestreamTableName
         *        The name of the Timestream database table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestreamTableName(String timestreamTableName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Timestream database.
         * </p>
         * 
         * @param timestreamDatabaseArn
         *        The Amazon Resource Name (ARN) of the Timestream database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestreamDatabaseArn(String timestreamDatabaseArn);

        /**
         * <p>
         * The ARN of the Timestream database table.
         * </p>
         * 
         * @param timestreamTableArn
         *        The ARN of the Timestream database table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestreamTableArn(String timestreamTableArn);

        /**
         * <p>
         * The status of registering your Amazon Timestream resources. The status can be one of
         * <code>REGISTRATION_SUCCESS</code>, <code>REGISTRATION_PENDING</code>, <code>REGISTRATION_FAILURE</code>.
         * </p>
         * 
         * @param registrationStatus
         *        The status of registering your Amazon Timestream resources. The status can be one of
         *        <code>REGISTRATION_SUCCESS</code>, <code>REGISTRATION_PENDING</code>,
         *        <code>REGISTRATION_FAILURE</code>.
         * @see RegistrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistrationStatus
         */
        Builder registrationStatus(String registrationStatus);

        /**
         * <p>
         * The status of registering your Amazon Timestream resources. The status can be one of
         * <code>REGISTRATION_SUCCESS</code>, <code>REGISTRATION_PENDING</code>, <code>REGISTRATION_FAILURE</code>.
         * </p>
         * 
         * @param registrationStatus
         *        The status of registering your Amazon Timestream resources. The status can be one of
         *        <code>REGISTRATION_SUCCESS</code>, <code>REGISTRATION_PENDING</code>,
         *        <code>REGISTRATION_FAILURE</code>.
         * @see RegistrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistrationStatus
         */
        Builder registrationStatus(RegistrationStatus registrationStatus);

        /**
         * <p>
         * A message associated with a registration error.
         * </p>
         * 
         * @param errorMessage
         *        A message associated with a registration error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);
    }

    static final class BuilderImpl implements Builder {
        private String timestreamDatabaseName;

        private String timestreamTableName;

        private String timestreamDatabaseArn;

        private String timestreamTableArn;

        private String registrationStatus;

        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(TimestreamRegistrationResponse model) {
            timestreamDatabaseName(model.timestreamDatabaseName);
            timestreamTableName(model.timestreamTableName);
            timestreamDatabaseArn(model.timestreamDatabaseArn);
            timestreamTableArn(model.timestreamTableArn);
            registrationStatus(model.registrationStatus);
            errorMessage(model.errorMessage);
        }

        public final String getTimestreamDatabaseName() {
            return timestreamDatabaseName;
        }

        public final void setTimestreamDatabaseName(String timestreamDatabaseName) {
            this.timestreamDatabaseName = timestreamDatabaseName;
        }

        @Override
        public final Builder timestreamDatabaseName(String timestreamDatabaseName) {
            this.timestreamDatabaseName = timestreamDatabaseName;
            return this;
        }

        public final String getTimestreamTableName() {
            return timestreamTableName;
        }

        public final void setTimestreamTableName(String timestreamTableName) {
            this.timestreamTableName = timestreamTableName;
        }

        @Override
        public final Builder timestreamTableName(String timestreamTableName) {
            this.timestreamTableName = timestreamTableName;
            return this;
        }

        public final String getTimestreamDatabaseArn() {
            return timestreamDatabaseArn;
        }

        public final void setTimestreamDatabaseArn(String timestreamDatabaseArn) {
            this.timestreamDatabaseArn = timestreamDatabaseArn;
        }

        @Override
        public final Builder timestreamDatabaseArn(String timestreamDatabaseArn) {
            this.timestreamDatabaseArn = timestreamDatabaseArn;
            return this;
        }

        public final String getTimestreamTableArn() {
            return timestreamTableArn;
        }

        public final void setTimestreamTableArn(String timestreamTableArn) {
            this.timestreamTableArn = timestreamTableArn;
        }

        @Override
        public final Builder timestreamTableArn(String timestreamTableArn) {
            this.timestreamTableArn = timestreamTableArn;
            return this;
        }

        public final String getRegistrationStatus() {
            return registrationStatus;
        }

        public final void setRegistrationStatus(String registrationStatus) {
            this.registrationStatus = registrationStatus;
        }

        @Override
        public final Builder registrationStatus(String registrationStatus) {
            this.registrationStatus = registrationStatus;
            return this;
        }

        @Override
        public final Builder registrationStatus(RegistrationStatus registrationStatus) {
            this.registrationStatus(registrationStatus == null ? null : registrationStatus.toString());
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        @Override
        public TimestreamRegistrationResponse build() {
            return new TimestreamRegistrationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
