/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The registered Amazon Timestream resources that Amazon Web Services IoT FleetWise edge agent software can transfer
 * your vehicle data to.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimestreamResources implements SdkPojo, Serializable,
        ToCopyableBuilder<TimestreamResources.Builder, TimestreamResources> {
    private static final SdkField<String> TIMESTREAM_DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("timestreamDatabaseName").getter(getter(TimestreamResources::timestreamDatabaseName))
            .setter(setter(Builder::timestreamDatabaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestreamDatabaseName").build())
            .build();

    private static final SdkField<String> TIMESTREAM_TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("timestreamTableName").getter(getter(TimestreamResources::timestreamTableName))
            .setter(setter(Builder::timestreamTableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestreamTableName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TIMESTREAM_DATABASE_NAME_FIELD, TIMESTREAM_TABLE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String timestreamDatabaseName;

    private final String timestreamTableName;

    private TimestreamResources(BuilderImpl builder) {
        this.timestreamDatabaseName = builder.timestreamDatabaseName;
        this.timestreamTableName = builder.timestreamTableName;
    }

    /**
     * <p>
     * The name of the registered Amazon Timestream database.
     * </p>
     * 
     * @return The name of the registered Amazon Timestream database.
     */
    public final String timestreamDatabaseName() {
        return timestreamDatabaseName;
    }

    /**
     * <p>
     * The name of the registered Amazon Timestream database table.
     * </p>
     * 
     * @return The name of the registered Amazon Timestream database table.
     */
    public final String timestreamTableName() {
        return timestreamTableName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timestreamDatabaseName());
        hashCode = 31 * hashCode + Objects.hashCode(timestreamTableName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimestreamResources)) {
            return false;
        }
        TimestreamResources other = (TimestreamResources) obj;
        return Objects.equals(timestreamDatabaseName(), other.timestreamDatabaseName())
                && Objects.equals(timestreamTableName(), other.timestreamTableName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TimestreamResources").add("TimestreamDatabaseName", timestreamDatabaseName())
                .add("TimestreamTableName", timestreamTableName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "timestreamDatabaseName":
            return Optional.ofNullable(clazz.cast(timestreamDatabaseName()));
        case "timestreamTableName":
            return Optional.ofNullable(clazz.cast(timestreamTableName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("timestreamDatabaseName", TIMESTREAM_DATABASE_NAME_FIELD);
        map.put("timestreamTableName", TIMESTREAM_TABLE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TimestreamResources, T> g) {
        return obj -> g.apply((TimestreamResources) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimestreamResources> {
        /**
         * <p>
         * The name of the registered Amazon Timestream database.
         * </p>
         * 
         * @param timestreamDatabaseName
         *        The name of the registered Amazon Timestream database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestreamDatabaseName(String timestreamDatabaseName);

        /**
         * <p>
         * The name of the registered Amazon Timestream database table.
         * </p>
         * 
         * @param timestreamTableName
         *        The name of the registered Amazon Timestream database table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestreamTableName(String timestreamTableName);
    }

    static final class BuilderImpl implements Builder {
        private String timestreamDatabaseName;

        private String timestreamTableName;

        private BuilderImpl() {
        }

        private BuilderImpl(TimestreamResources model) {
            timestreamDatabaseName(model.timestreamDatabaseName);
            timestreamTableName(model.timestreamTableName);
        }

        public final String getTimestreamDatabaseName() {
            return timestreamDatabaseName;
        }

        public final void setTimestreamDatabaseName(String timestreamDatabaseName) {
            this.timestreamDatabaseName = timestreamDatabaseName;
        }

        @Override
        public final Builder timestreamDatabaseName(String timestreamDatabaseName) {
            this.timestreamDatabaseName = timestreamDatabaseName;
            return this;
        }

        public final String getTimestreamTableName() {
            return timestreamTableName;
        }

        public final void setTimestreamTableName(String timestreamTableName) {
            this.timestreamTableName = timestreamTableName;
        }

        @Override
        public final Builder timestreamTableName(String timestreamTableName) {
            this.timestreamTableName = timestreamTableName;
            return this;
        }

        @Override
        public TimestreamResources build() {
            return new TimestreamResources(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
