/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateModelManifestRequest extends IoTFleetWiseRequest implements
        ToCopyableBuilder<UpdateModelManifestRequest.Builder, UpdateModelManifestRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateModelManifestRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateModelManifestRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<String>> NODES_TO_ADD_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("nodesToAdd")
            .getter(getter(UpdateModelManifestRequest::nodesToAdd))
            .setter(setter(Builder::nodesToAdd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodesToAdd").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> NODES_TO_REMOVE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("nodesToRemove")
            .getter(getter(UpdateModelManifestRequest::nodesToRemove))
            .setter(setter(Builder::nodesToRemove))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodesToRemove").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(UpdateModelManifestRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            NODES_TO_ADD_FIELD, NODES_TO_REMOVE_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String description;

    private final List<String> nodesToAdd;

    private final List<String> nodesToRemove;

    private final String status;

    private UpdateModelManifestRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.nodesToAdd = builder.nodesToAdd;
        this.nodesToRemove = builder.nodesToRemove;
        this.status = builder.status;
    }

    /**
     * <p>
     * The name of the vehicle model to update.
     * </p>
     * 
     * @return The name of the vehicle model to update.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A brief description of the vehicle model.
     * </p>
     * 
     * @return A brief description of the vehicle model.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the NodesToAdd property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasNodesToAdd() {
        return nodesToAdd != null && !(nodesToAdd instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>fullyQualifiedName</code> of nodes, which are a general abstraction of signals, to add to the
     * vehicle model.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNodesToAdd} method.
     * </p>
     * 
     * @return A list of <code>fullyQualifiedName</code> of nodes, which are a general abstraction of signals, to add to
     *         the vehicle model.
     */
    public final List<String> nodesToAdd() {
        return nodesToAdd;
    }

    /**
     * For responses, this returns true if the service returned a value for the NodesToRemove property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNodesToRemove() {
        return nodesToRemove != null && !(nodesToRemove instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>fullyQualifiedName</code> of nodes, which are a general abstraction of signals, to remove from
     * the vehicle model.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNodesToRemove} method.
     * </p>
     * 
     * @return A list of <code>fullyQualifiedName</code> of nodes, which are a general abstraction of signals, to remove
     *         from the vehicle model.
     */
    public final List<String> nodesToRemove() {
        return nodesToRemove;
    }

    /**
     * <p>
     * The state of the vehicle model. If the status is <code>ACTIVE</code>, the vehicle model can't be edited. If the
     * status is <code>DRAFT</code>, you can edit the vehicle model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ManifestStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The state of the vehicle model. If the status is <code>ACTIVE</code>, the vehicle model can't be edited.
     *         If the status is <code>DRAFT</code>, you can edit the vehicle model.
     * @see ManifestStatus
     */
    public final ManifestStatus status() {
        return ManifestStatus.fromValue(status);
    }

    /**
     * <p>
     * The state of the vehicle model. If the status is <code>ACTIVE</code>, the vehicle model can't be edited. If the
     * status is <code>DRAFT</code>, you can edit the vehicle model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ManifestStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The state of the vehicle model. If the status is <code>ACTIVE</code>, the vehicle model can't be edited.
     *         If the status is <code>DRAFT</code>, you can edit the vehicle model.
     * @see ManifestStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasNodesToAdd() ? nodesToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNodesToRemove() ? nodesToRemove() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateModelManifestRequest)) {
            return false;
        }
        UpdateModelManifestRequest other = (UpdateModelManifestRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && hasNodesToAdd() == other.hasNodesToAdd() && Objects.equals(nodesToAdd(), other.nodesToAdd())
                && hasNodesToRemove() == other.hasNodesToRemove() && Objects.equals(nodesToRemove(), other.nodesToRemove())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateModelManifestRequest").add("Name", name()).add("Description", description())
                .add("NodesToAdd", hasNodesToAdd() ? nodesToAdd() : null)
                .add("NodesToRemove", hasNodesToRemove() ? nodesToRemove() : null).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "nodesToAdd":
            return Optional.ofNullable(clazz.cast(nodesToAdd()));
        case "nodesToRemove":
            return Optional.ofNullable(clazz.cast(nodesToRemove()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("nodesToAdd", NODES_TO_ADD_FIELD);
        map.put("nodesToRemove", NODES_TO_REMOVE_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateModelManifestRequest, T> g) {
        return obj -> g.apply((UpdateModelManifestRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IoTFleetWiseRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateModelManifestRequest> {
        /**
         * <p>
         * The name of the vehicle model to update.
         * </p>
         * 
         * @param name
         *        The name of the vehicle model to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A brief description of the vehicle model.
         * </p>
         * 
         * @param description
         *        A brief description of the vehicle model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A list of <code>fullyQualifiedName</code> of nodes, which are a general abstraction of signals, to add to the
         * vehicle model.
         * </p>
         * 
         * @param nodesToAdd
         *        A list of <code>fullyQualifiedName</code> of nodes, which are a general abstraction of signals, to add
         *        to the vehicle model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodesToAdd(Collection<String> nodesToAdd);

        /**
         * <p>
         * A list of <code>fullyQualifiedName</code> of nodes, which are a general abstraction of signals, to add to the
         * vehicle model.
         * </p>
         * 
         * @param nodesToAdd
         *        A list of <code>fullyQualifiedName</code> of nodes, which are a general abstraction of signals, to add
         *        to the vehicle model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodesToAdd(String... nodesToAdd);

        /**
         * <p>
         * A list of <code>fullyQualifiedName</code> of nodes, which are a general abstraction of signals, to remove
         * from the vehicle model.
         * </p>
         * 
         * @param nodesToRemove
         *        A list of <code>fullyQualifiedName</code> of nodes, which are a general abstraction of signals, to
         *        remove from the vehicle model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodesToRemove(Collection<String> nodesToRemove);

        /**
         * <p>
         * A list of <code>fullyQualifiedName</code> of nodes, which are a general abstraction of signals, to remove
         * from the vehicle model.
         * </p>
         * 
         * @param nodesToRemove
         *        A list of <code>fullyQualifiedName</code> of nodes, which are a general abstraction of signals, to
         *        remove from the vehicle model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodesToRemove(String... nodesToRemove);

        /**
         * <p>
         * The state of the vehicle model. If the status is <code>ACTIVE</code>, the vehicle model can't be edited. If
         * the status is <code>DRAFT</code>, you can edit the vehicle model.
         * </p>
         * 
         * @param status
         *        The state of the vehicle model. If the status is <code>ACTIVE</code>, the vehicle model can't be
         *        edited. If the status is <code>DRAFT</code>, you can edit the vehicle model.
         * @see ManifestStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ManifestStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The state of the vehicle model. If the status is <code>ACTIVE</code>, the vehicle model can't be edited. If
         * the status is <code>DRAFT</code>, you can edit the vehicle model.
         * </p>
         * 
         * @param status
         *        The state of the vehicle model. If the status is <code>ACTIVE</code>, the vehicle model can't be
         *        edited. If the status is <code>DRAFT</code>, you can edit the vehicle model.
         * @see ManifestStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ManifestStatus
         */
        Builder status(ManifestStatus status);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTFleetWiseRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private List<String> nodesToAdd = DefaultSdkAutoConstructList.getInstance();

        private List<String> nodesToRemove = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateModelManifestRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            nodesToAdd(model.nodesToAdd);
            nodesToRemove(model.nodesToRemove);
            status(model.status);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getNodesToAdd() {
            if (nodesToAdd instanceof SdkAutoConstructList) {
                return null;
            }
            return nodesToAdd;
        }

        public final void setNodesToAdd(Collection<String> nodesToAdd) {
            this.nodesToAdd = NodePathsCopier.copy(nodesToAdd);
        }

        @Override
        public final Builder nodesToAdd(Collection<String> nodesToAdd) {
            this.nodesToAdd = NodePathsCopier.copy(nodesToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodesToAdd(String... nodesToAdd) {
            nodesToAdd(Arrays.asList(nodesToAdd));
            return this;
        }

        public final Collection<String> getNodesToRemove() {
            if (nodesToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return nodesToRemove;
        }

        public final void setNodesToRemove(Collection<String> nodesToRemove) {
            this.nodesToRemove = NodePathsCopier.copy(nodesToRemove);
        }

        @Override
        public final Builder nodesToRemove(Collection<String> nodesToRemove) {
            this.nodesToRemove = NodePathsCopier.copy(nodesToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodesToRemove(String... nodesToRemove) {
            nodesToRemove(Arrays.asList(nodesToRemove));
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ManifestStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateModelManifestRequest build() {
            return new UpdateModelManifestRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
